/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdEnumValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class XmlMap
extends HashMap {
    private static final SimpleDateFormat FDATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FTIME = new SimpleDateFormat("H:mm:ss");
    private static final SimpleDateFormat FTIMESTAMP = new SimpleDateFormat("yyyy-MM-dd'T'H:mm:ss.SSS");
    private boolean emptyTagLeadsToNull = true;
    private boolean formatErrorLeadsToNull = true;
    private boolean nullElementLeadsToNullObject = true;

    public boolean getLeadsEmptyTagToNull() {
        return this.emptyTagLeadsToNull;
    }

    public boolean getLeadsFormatErrorToNull() {
        return this.formatErrorLeadsToNull;
    }

    public boolean getLeadsNullElementToNullObject() {
        return this.nullElementLeadsToNullObject;
    }

    public void setEmptyTagLeadsToNull(boolean b) {
        this.emptyTagLeadsToNull = b;
    }

    public void setFormatErrorLeadsToNull(boolean b) {
        this.formatErrorLeadsToNull = b;
    }

    public void setNullElementLeadsToNullObject(boolean b) {
        this.nullElementLeadsToNullObject = b;
    }

    public XmlMap getXmlMap(String key) {
        Object object = this.get(key);
        if (object == null || !(object instanceof XmlMap)) {
            return new XmlMap();
        }
        return (XmlMap)object;
    }

    public XmlMap getXmlMap(String key, int i) {
        Object object = this.get(key + (i == 0 ? "" : "" + i));
        if (object == null || !(object instanceof XmlMap)) {
            return new XmlMap();
        }
        return (XmlMap)object;
    }

    public String getAuthenticString(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String getString(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        return text;
    }

    public ArrayList getStringList(String basicTag, String keyTag, String valueTag) {
        ArrayList<DdEnumValue> list = new ArrayList<DdEnumValue>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            String value = nextGroup.getString(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                list.add(new DdEnumValue(key, value));
            }
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public ArrayList getAuthenticStringList(String basicTag, String keyTag, String valueTag) {
        ArrayList<DdEnumValue> list = new ArrayList<DdEnumValue>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getAuthenticString(keyTag);
            String value = nextGroup.getAuthenticString(valueTag);
            list.add(new DdEnumValue(key, value));
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public HashMap getStringMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, String> map = new HashMap<String, String>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            String value = nextGroup.getString(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashMap getAuthenticStringMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, String> map = new HashMap<String, String>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getAuthenticString(keyTag);
            String value = nextGroup.getAuthenticString(valueTag);
            map.put(key, value);
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getStringSet(String basicTag, String valueTag) {
        HashSet<String> set = new HashSet<String>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String value = nextGroup.getString(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public HashSet getAuthenticStringSet(String basicTag, String valueTag) {
        HashSet<String> set = new HashSet<String>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String value = nextGroup.getAuthenticString(valueTag);
            set.add(value);
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public boolean getBoolean(String key) {
        Object object = this.get(key);
        if (object == null) {
            return false;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return false;
        }
        return new Boolean(text);
    }

    public Boolean getBooleanObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        return new Boolean(text);
    }

    public byte getByte(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0;
        }
        try {
            return new Byte(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0;
            }
            throw ex;
        }
    }

    public double getDouble(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0.0;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0.0;
        }
        try {
            return new Double(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0.0;
            }
            throw ex;
        }
    }

    public float getFloat(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0.0f;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0.0f;
        }
        try {
            return new Float(text).floatValue();
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0.0f;
            }
            throw ex;
        }
    }

    public int getInt(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0;
        }
        try {
            return new Integer(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0;
            }
            throw ex;
        }
    }

    public long getLong(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0L;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0L;
        }
        try {
            return new Long(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0L;
            }
            throw ex;
        }
    }

    public short getShort(String key) {
        Object object = this.get(key);
        if (object == null) {
            return 0;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return 0;
        }
        try {
            return new Short(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return 0;
            }
            throw ex;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getBigDecimalMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            BigDecimal value = nextGroup.getBigDecimal(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getBigDecimalSet(String basicTag, String valueTag) {
        HashSet<BigDecimal> set = new HashSet<BigDecimal>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            BigDecimal value = nextGroup.getBigDecimal(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public BigInteger getBigInteger(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new BigInteger(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getBigIntegerMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            BigInteger value = nextGroup.getBigInteger(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getBigIntegerSet(String basicTag, String valueTag) {
        HashSet<BigInteger> set = new HashSet<BigInteger>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            BigInteger value = nextGroup.getBigInteger(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Byte getByteObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Byte(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getByteMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Byte> map = new HashMap<String, Byte>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Byte value = nextGroup.getByteObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getByteSet(String basicTag, String valueTag) {
        HashSet<Byte> set = new HashSet<Byte>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Byte value = nextGroup.getByteObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Double getDoubleObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Double(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getDoubleMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Double value = nextGroup.getDoubleObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getDoubleSet(String basicTag, String valueTag) {
        HashSet<Double> set = new HashSet<Double>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Double value = nextGroup.getDoubleObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Float getFloatObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Float(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getFloatMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Float value = nextGroup.getFloatObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getFloatSet(String basicTag, String valueTag) {
        HashSet<Float> set = new HashSet<Float>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Float value = nextGroup.getFloatObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Integer getIntegerObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Integer(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getIntegerMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Integer value = nextGroup.getIntegerObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getIntegerSet(String basicTag, String valueTag) {
        HashSet<Integer> set = new HashSet<Integer>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Integer value = nextGroup.getIntegerObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Long getLongObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Long(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getLongMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Long value = nextGroup.getLongObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getLongSet(String basicTag, String valueTag) {
        HashSet<Long> set = new HashSet<Long>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Long value = nextGroup.getLongObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Short getShortObject(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Short(text);
        }
        catch (NumberFormatException ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw ex;
        }
    }

    public HashMap getShortMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Short> map = new HashMap<String, Short>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Short value = nextGroup.getShortObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getShortSet(String basicTag, String valueTag) {
        HashSet<Short> set = new HashSet<Short>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Short value = nextGroup.getShortObject(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Date getDate(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return FDATE.parse(text);
        }
        catch (Exception ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    public HashMap getDateMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Date value = nextGroup.getDate(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getDateSet(String basicTag, String valueTag) {
        HashSet<Date> set = new HashSet<Date>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Date value = nextGroup.getDate(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public java.sql.Date getSqlDate(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new java.sql.Date(FDATE.parse(text).getTime());
        }
        catch (Exception ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    public HashMap getSqlDateMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, java.sql.Date> map = new HashMap<String, java.sql.Date>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            java.sql.Date value = nextGroup.getSqlDate(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getSqlDateSet(String basicTag, String valueTag) {
        HashSet<java.sql.Date> set = new HashSet<java.sql.Date>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            java.sql.Date value = nextGroup.getSqlDate(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Time getTime(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Time(FTIME.parse(text).getTime());
        }
        catch (Exception ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    public HashMap getTimeMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Time> map = new HashMap<String, Time>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Time value = nextGroup.getTime(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getTimeSet(String basicTag, String valueTag) {
        HashSet<Time> set = new HashSet<Time>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Time value = nextGroup.getTime(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public Timestamp getTimestamp(String key) {
        Object object = this.get(key);
        if (object == null) {
            return null;
        }
        String text = ((String)object).trim();
        if (this.emptyTagLeadsToNull && text.length() == 0) {
            return null;
        }
        try {
            return new Timestamp(FTIMESTAMP.parse(text).getTime());
        }
        catch (Exception ex) {
            if (this.formatErrorLeadsToNull) {
                return null;
            }
            throw new IllegalArgumentException();
        }
    }

    public HashMap getTimestampMap(String basicTag, String keyTag, String valueTag) {
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            String key = nextGroup.getString(keyTag);
            Timestamp value = nextGroup.getTimestamp(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                map.put(key, value);
            }
            ++i;
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public HashSet getTimestampSet(String basicTag, String valueTag) {
        HashSet<Timestamp> set = new HashSet<Timestamp>();
        XmlMap nextGroup = null;
        int i = 0;
        while (!(nextGroup = this.getXmlMap(basicTag + (i == 0 ? "" : "" + i))).isEmpty()) {
            Timestamp value = nextGroup.getTimestamp(valueTag);
            if (value == null) {
                if (this.nullElementLeadsToNullObject) {
                    return null;
                }
            } else {
                set.add(value);
            }
            ++i;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }
}

