/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.tc.logging.Location;
import com.sap.typeservices.ISimpleValueServices;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DdTypeTimestamp
extends DdSimpleType
implements DdConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdTypeTimestamp == null ? (class$com$sap$dictionary$runtime$DdTypeTimestamp = DdTypeTimestamp.class$("com.sap.dictionary.runtime.DdTypeTimestamp")) : class$com$sap$dictionary$runtime$DdTypeTimestamp));
    private static final DateFormat XML_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'H:mm:ss.SSS", Locale.US);
    private static final Timestamp EXAMPLE = Timestamp.valueOf("1987-11-25 10:11:12.123000000");
    private Timestamp minInclusive = null;
    private Timestamp maxInclusive = null;
    private Timestamp minExclusive = null;
    private Timestamp maxExclusive = null;
    private Timestamp defaultValue = null;
    private XmlMap nextValue = null;
    private DateFormat formatter = null;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdTypeTimestamp;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public DdTypeTimestamp(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getTimestampSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getTimestamp("minInclusive");
        this.maxInclusive = smap.getTimestamp("maxInclusive");
        this.minExclusive = smap.getTimestamp("minExclusive");
        this.maxExclusive = smap.getTimestamp("maxExclusive");
        this.defaultValue = emap.getTimestamp("defaultValue");
        this.setFormatter();
    }

    public Class getAttributeClass() {
        return class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DdTypeTimestamp.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
    }

    public String getInitialFormat() {
        return ((SimpleDateFormat)XML_FORMATTER).toPattern();
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public String format(Object value) {
        if (loc.beInfo()) {
            loc.infoT("Format date-time {0} with Simple type {1}", new Object[]{value, this});
        }
        if (value == null) {
            return "";
        }
        if (!(value instanceof Date)) {
            return "";
        }
        String text = this.formatter.format(value);
        if (loc.beInfo()) {
            loc.infoT("Format result is {0}", new Object[]{text});
        }
        return text;
    }

    public String format(Timestamp value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public Object parse(String text) throws ParseException {
        if (loc.beInfo()) {
            loc.infoT("Parse timestamp {0} with Simple type {1}", new Object[]{text, this});
        }
        return this.parseTimestamp(text);
    }

    public Timestamp parse(Timestamp value, String text) throws ParseException {
        return this.parseTimestamp(text);
    }

    public Timestamp parseTimestamp(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        try {
            Date time = this.formatter.parse(text);
            return new Timestamp(time.getTime());
        }
        catch (ParseException ex) {
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.format(EXAMPLE)}), 0);
        }
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Timestamp) {
            return this.isValid((Timestamp)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Timestamp value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.minInclusive != null && ((Date)value).compareTo(this.minInclusive) < 0 || this.maxInclusive != null && ((Date)value).compareTo(this.maxInclusive) > 0 || this.minExclusive != null && ((Date)value).compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && ((Date)value).compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Timestamp)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        Timestamp timestamp = (Timestamp)value;
        if (this.minInclusive != null && ((Date)timestamp).compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{timestamp.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && ((Date)timestamp).compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{timestamp.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && ((Date)timestamp).compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{timestamp.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && ((Date)timestamp).compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{timestamp.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(timestamp)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{timestamp.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(timestamp)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{timestamp.toString()});
        }
    }

    private boolean matchesPattern(Timestamp value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Timestamp) {
            return this.matchesEnumeration((Timestamp)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(Timestamp value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate(XML_FORMATTER.format(value));
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object minInclusive) {
        if (this.isModifyAllowed()) {
            if (minInclusive instanceof Timestamp) {
                this.minInclusive = (Timestamp)minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object maxInclusive) {
        if (this.isModifyAllowed()) {
            if (maxInclusive instanceof Timestamp) {
                this.maxInclusive = (Timestamp)maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object minExclusive) {
        if (this.isModifyAllowed()) {
            if (minExclusive instanceof Timestamp) {
                this.minExclusive = (Timestamp)minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object maxExclusive) {
        if (this.isModifyAllowed()) {
            if (maxExclusive instanceof Timestamp) {
                this.maxExclusive = (Timestamp)maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(Timestamp value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    public void setFormatter() {
        Locale locale;
        String format;
        if (loc.beInfo()) {
            loc.infoT("TimeZone:", new Object[]{DdDictionaryPool.getDefaultTimeZone().toString()});
        }
        if ((format = this.getFormat()) == null) {
            format = this.getInitialFormat();
        }
        if ((locale = this.getLocale()) == null) {
            locale = Locale.getDefault();
        }
        this.formatter = locale.getLanguage().equalsIgnoreCase("xml") ? XML_FORMATTER : new SimpleDateFormat(format, locale);
        this.formatter.setLenient(false);
        this.formatter.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/DdTypeTimestamp.java#3 $");
    }
}

