/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.tc.logging.Location;
import com.sap.typeservices.ISimpleValueServices;
import java.sql.Time;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DdTypeTime
extends DdSimpleType
implements DdConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdTypeTime == null ? (class$com$sap$dictionary$runtime$DdTypeTime = DdTypeTime.class$("com.sap.dictionary.runtime.DdTypeTime")) : class$com$sap$dictionary$runtime$DdTypeTime));
    private static final DateFormat XML_FORMATTER = new SimpleDateFormat("H:mm:ss", Locale.US);
    private static long val24;
    private static long val00;
    private static Object timeExample;
    private DateFormat formatter24 = null;
    private DateFormat formatter = null;
    private DateFormat parserShort = null;
    private DateFormat parserShort24 = null;
    private DateFormat parserhhmmss = null;
    private DateFormat parserhhmmss24 = null;
    private DateFormat parserhhmm = null;
    private DateFormat parserhhmm24 = null;
    private Time minInclusive = null;
    private Time maxInclusive = null;
    private Time minExclusive = null;
    private Time maxExclusive = null;
    private Time defaultValue = null;
    private XmlMap nextValue = null;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdTypeTime;
    static /* synthetic */ Class class$java$sql$Time;

    public DdTypeTime(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getTimeSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getTime("minInclusive");
        this.maxInclusive = smap.getTime("maxInclusive");
        this.minExclusive = smap.getTime("minExclusive");
        this.maxExclusive = smap.getTime("maxExclusive");
        this.defaultValue = emap.getTime("defaultValue");
        this.setFormatter();
    }

    public Class getAttributeClass() {
        return class$java$sql$Time == null ? (class$java$sql$Time = DdTypeTime.class$("java.sql.Time")) : class$java$sql$Time;
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format((Object)this.defaultValue);
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        Time time = (Time)value;
        if (time.getTime() == val24) {
            String t24 = this.formatter24.format(time);
            return t24.replace('A', 'P');
        }
        return this.formatter.format(time);
    }

    public String format(Time value) {
        if (value == null) {
            return "";
        }
        if (value.getTime() == val24) {
            String t24 = this.formatter24.format(value);
            return t24.replace('A', 'P');
        }
        return this.formatter.format(value);
    }

    public Object parse(String text) throws ParseException {
        if (loc.beInfo()) {
            loc.infoT("Parse time {0} with Simple type {1}", new Object[]{text, this});
        }
        return this.parseTime(text);
    }

    public Time parseTime(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        Time value = null;
        value = text.length() > 3 && StringUtil.isNumericValue(text.substring(0, 4)) ? this.parseInTurn(text, this.parserhhmmss, this.parserhhmmss24, this.parserhhmm, this.parserhhmm24) : this.parseInTurn(text, this.formatter, this.formatter24, this.parserShort, this.parserShort24);
        this.checkAfterParse(value);
        if (loc.beInfo()) {
            loc.infoT("Parse result is {0}", new Object[]{value});
        }
        return value;
    }

    private Time parseInTurn(String text, DateFormat parserA, DateFormat parserA24, DateFormat parserB, DateFormat parserB24) throws ParseException {
        Time value = null;
        try {
            value = new Time(parserA.parse(text).getTime());
        }
        catch (ParseException ex1) {
            try {
                if (val00 != parserA24.parse(text).getTime()) {
                    throw ex1;
                }
                value = new Time(val24);
            }
            catch (ParseException ex2) {
                try {
                    value = new Time(parserB.parse(text).getTime());
                }
                catch (Exception ex3) {
                    try {
                        if (val00 != parserB24.parse(text).getTime()) {
                            throw ex3;
                        }
                        value = new Time(val24);
                    }
                    catch (Exception ex4) {
                        throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.format(timeExample)}), 0);
                    }
                }
            }
        }
        return value;
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Time)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        Time time = (Time)value;
        if (this.minInclusive != null && time.compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{time.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && time.compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{time.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && time.compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{time.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && time.compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{time.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(time)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{time.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(time)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{time.toString()});
        }
    }

    private boolean matchesPattern(Time value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Time) {
            return this.matchesEnumeration((Time)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(Time value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)value);
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object minInclusive) {
        if (this.isModifyAllowed()) {
            if (minInclusive instanceof Time) {
                this.minInclusive = (Time)minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object maxInclusive) {
        if (this.isModifyAllowed()) {
            if (maxInclusive instanceof Time) {
                this.maxInclusive = (Time)maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object minExclusive) {
        if (this.isModifyAllowed()) {
            if (minExclusive instanceof Time) {
                this.minExclusive = (Time)minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object maxExclusive) {
        if (this.isModifyAllowed()) {
            if (maxExclusive instanceof Time) {
                this.maxExclusive = (Time)maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(Time value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    public void setFormatter() {
        if (loc.beInfo()) {
            loc.infoT("TimeZone:", new Object[]{DdDictionaryPool.getDefaultTimeZone().toString()});
        }
        String format = this.getFormat();
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.formatter = locale.getLanguage().equalsIgnoreCase("xml") ? XML_FORMATTER : (format == null ? DateFormat.getTimeInstance(2, locale) : (format.equalsIgnoreCase("SHORT") ? DateFormat.getTimeInstance(3, locale) : (format.equalsIgnoreCase("MEDIUM") ? DateFormat.getTimeInstance(2, locale) : (format.equalsIgnoreCase("LONG") ? DateFormat.getTimeInstance(1, locale) : (format.equalsIgnoreCase("FULL") ? DateFormat.getTimeInstance(0, locale) : new SimpleDateFormat(format, locale))))));
        this.formatter.setLenient(false);
        this.formatter.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        this.formatter24 = this.copyFor24(this.formatter);
        this.parserShort = DateFormat.getTimeInstance(3, locale);
        this.parserShort.setLenient(false);
        this.parserShort.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        this.parserShort24 = this.copyFor24(this.parserShort);
        this.parserhhmm = this.copyWithoutDelimiter(this.parserShort);
        this.parserhhmm24 = this.copyFor24(this.parserhhmm);
        if (format == null || format.equalsIgnoreCase("SHORT") || format.equalsIgnoreCase("MEDIUM")) {
            this.parserhhmmss = this.copyWithoutDelimiter(this.formatter);
            this.parserhhmmss24 = this.copyFor24(this.parserhhmmss);
        }
    }

    private DateFormat copyFor24(DateFormat source) {
        SimpleDateFormat copyFor24 = (SimpleDateFormat)((SimpleDateFormat)source).clone();
        copyFor24.applyPattern(copyFor24.toPattern().replace('H', 'k'));
        copyFor24.applyPattern(copyFor24.toPattern().replace('h', 'k'));
        copyFor24.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        return copyFor24;
    }

    private DateFormat copyWithoutDelimiter(DateFormat source) {
        SimpleDateFormat copyWithoutDelimiter = null;
        char[] c = ((SimpleDateFormat)source).toPattern().toCharArray();
        char previous = ' ';
        String templatehhmm = "";
        int i = 0;
        while (i < c.length) {
            if (c[i] == 'h' && c[i] != previous) {
                templatehhmm = templatehhmm + "hh";
            } else if (c[i] == 'H' && c[i] != previous) {
                templatehhmm = templatehhmm + "HH";
            } else if (c[i] == 'm' && c[i] != previous) {
                templatehhmm = templatehhmm + "mm";
            } else if (c[i] == 's' && c[i] != previous) {
                templatehhmm = templatehhmm + "ss";
            }
            if (c[i] == 'a' && c[i] != previous) {
                templatehhmm = templatehhmm + "a";
            }
            previous = c[i];
            ++i;
        }
        copyWithoutDelimiter = new SimpleDateFormat(templatehhmm);
        copyWithoutDelimiter.setLenient(false);
        copyWithoutDelimiter.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        return copyWithoutDelimiter;
    }

    public Time parse(Time value, String text) throws ParseException {
        return this.parseTime(text);
    }

    public String getInitialFormat() {
        return "H:mm:ss.SSS";
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Time) {
            return this.isValid((Time)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Time value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public String getFormatTemplate() {
        SimpleDateFormat sDateFormat = (SimpleDateFormat)this.formatter;
        return sDateFormat.toPattern();
    }

    protected Object parseForEnum(String stringValue) throws ParseException {
        return XML_FORMATTER.parse(stringValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/DdTypeTime.java#7 $");
        val24 = Time.valueOf("24:00:00").getTime();
        val00 = Time.valueOf("00:00:00").getTime();
        timeExample = Time.valueOf("10:11:12");
    }
}

