/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeLongObject
extends DdTypeNumber
implements DdConstants {
    private Long minInclusive = null;
    private Long maxInclusive = null;
    private Long minExclusive = null;
    private Long maxExclusive = null;
    private Long defaultValue = null;
    static /* synthetic */ Class class$java$lang$Long;

    public DdTypeLongObject(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getLongSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getLongObject("minInclusive");
        this.maxInclusive = smap.getLongObject("maxInclusive");
        this.minExclusive = smap.getLongObject("minExclusive");
        this.maxExclusive = smap.getLongObject("maxExclusive");
        this.defaultValue = emap.getLongObject("defaultValue");
    }

    public Class getAttributeClass() {
        return class$java$lang$Long == null ? (class$java$lang$Long = DdTypeLongObject.class$("java.lang.Long")) : class$java$lang$Long;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        return this.parseLongObject(text);
    }

    public Long parse(Long value, String text) throws ParseException {
        return this.parseLongObject(text);
    }

    public Long parseLongObject(String text) throws ParseException {
        Long value = super.parseLongObject(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Long) {
            return this.isValid((Long)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Long value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        Long longValue = null;
        if (!(value instanceof Long)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        longValue = (Long)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && longValue.toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && longValue.compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && longValue.compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && longValue.compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && longValue.compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(longValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(longValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(Long value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (value instanceof Long) {
            return this.matchesEnumeration((Long)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(Long value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)value);
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Long) {
                this.minInclusive = (Long)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Long) {
                this.maxInclusive = (Long)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Long) {
                this.minExclusive = (Long)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Long) {
                this.maxExclusive = (Long)value;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + "    defaultValue         : " + this.defaultValue + "\n" + "  Enumeration" + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(Long value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

