/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeInt
extends DdTypeNumber
implements DdConstants {
    private Integer minInclusive = null;
    private Integer maxInclusive = null;
    private Integer minExclusive = null;
    private Integer maxExclusive = null;
    private int minInclusiveInt = 0;
    private int maxInclusiveInt = 0;
    private int minExclusiveInt = 0;
    private int maxExclusiveInt = 0;
    private Integer defaultValue = null;

    public DdTypeInt(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getIntegerSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getIntegerObject("minInclusive");
        this.maxInclusive = smap.getIntegerObject("maxInclusive");
        this.minExclusive = smap.getIntegerObject("minExclusive");
        this.maxExclusive = smap.getIntegerObject("maxExclusive");
        this.defaultValue = emap.getIntegerObject("defaultValue");
        if (this.minInclusive != null) {
            this.minInclusiveInt = this.minInclusive;
        }
        if (this.maxInclusive != null) {
            this.maxInclusiveInt = this.maxInclusive;
        }
        if (this.minExclusive != null) {
            this.minExclusiveInt = this.minExclusive;
        }
        if (this.maxExclusive != null) {
            this.maxExclusiveInt = this.maxExclusive;
        }
    }

    public Class getAttributeClass() {
        return Integer.TYPE;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        return new Integer(this.parseInt(text));
    }

    public int parse(int value, String text) throws ParseException {
        return this.parseInt(text);
    }

    public int parseInt(String text) throws ParseException {
        int value = super.parseInt(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Integer) {
            return this.isValid((int)((Integer)value));
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(int value) {
        return !(this.minInclusive != null && value < this.minInclusiveInt || this.maxInclusive != null && value > this.maxInclusiveInt || this.minExclusive != null && value >= this.minExclusiveInt || this.maxExclusive != null && value <= this.maxExclusiveInt || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Integer)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        int intValue = (Integer)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && new Integer(intValue).toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && intValue < this.minInclusiveInt) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && intValue > this.maxInclusiveInt) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && intValue <= this.minExclusiveInt) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && intValue >= this.maxExclusiveInt) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(intValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(intValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(int value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Integer) {
            return this.matchesEnumeration((Integer)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(int value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)new Integer(value));
        }
        return this.getEnum() == null || this.getEnum().contains(new Integer(value));
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Integer) {
                this.minInclusive = (Integer)value;
                this.minInclusiveInt = this.minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Integer) {
                this.maxInclusive = (Integer)value;
                this.maxInclusiveInt = this.maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Integer) {
                this.minExclusive = (Integer)value;
                this.minExclusiveInt = this.minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Integer) {
                this.maxExclusive = (Integer)value;
                this.maxExclusiveInt = this.maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(int value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

