/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeFloat
extends DdTypeNumber
implements DdConstants {
    private Float minInclusive = null;
    private Float maxInclusive = null;
    private Float minExclusive = null;
    private Float maxExclusive = null;
    private float minInclusiveFloat = 0.0f;
    private float maxInclusiveFloat = 0.0f;
    private float minExclusiveFloat = 0.0f;
    private float maxExclusiveFloat = 0.0f;
    private Float defaultValue = null;
    private static final DecimalFormat XML_FORMATTER = new DecimalFormat("0.###############E0");

    public DdTypeFloat(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getFloatSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getFloatObject("minInclusive");
        this.maxInclusive = smap.getFloatObject("maxInclusive");
        this.minExclusive = smap.getFloatObject("minExclusive");
        this.maxExclusive = smap.getFloatObject("maxExclusive");
        this.defaultValue = emap.getFloatObject("defaultValue");
        if (this.minInclusive != null) {
            this.minInclusiveFloat = this.minInclusive.floatValue();
        }
        if (this.maxInclusive != null) {
            this.maxInclusiveFloat = this.maxInclusive.floatValue();
        }
        if (this.minExclusive != null) {
            this.minExclusiveFloat = this.minExclusive.floatValue();
        }
        if (this.maxExclusive != null) {
            this.maxExclusiveFloat = this.maxExclusive.floatValue();
        }
    }

    public Class getAttributeClass() {
        return Float.TYPE;
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        return new Float(this.parseFloat(text));
    }

    public float parse(float value, String text) throws ParseException {
        return this.parseFloat(text);
    }

    public float parseFloat(String text) throws ParseException {
        float value = super.parseFloat(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Float) {
            return this.isValid(((Float)value).floatValue());
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(float value) {
        return !(this.minInclusive != null && !(value >= this.minInclusiveFloat) || this.maxInclusive != null && !(value <= this.maxInclusiveFloat) || this.minExclusive != null && !(value > this.minExclusiveFloat) || this.maxExclusive != null && !(value < this.maxExclusiveFloat) || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Float)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        float floatValue = ((Float)value).floatValue();
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && new Float(floatValue).toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && !(floatValue >= this.minInclusiveFloat)) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && !(floatValue <= this.maxInclusiveFloat)) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && !(floatValue > this.minExclusiveFloat)) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && !(floatValue < this.maxExclusiveFloat)) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(floatValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(floatValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(float value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Float) {
            return this.matchesEnumeration(((Float)value).floatValue());
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(float value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate(new Float(value).toString());
        }
        return this.getEnum() == null || this.getEnum().contains(new Float(value));
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Float) {
                this.minInclusive = (Float)value;
                this.minInclusiveFloat = this.minInclusive.floatValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Float) {
                this.maxInclusive = (Float)value;
                this.maxInclusiveFloat = this.maxInclusive.floatValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Float) {
                this.minExclusive = (Float)value;
                this.minExclusiveFloat = this.minExclusive.floatValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Float) {
                this.maxExclusive = (Float)value;
                this.maxExclusiveFloat = this.maxExclusive.floatValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(float value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

