/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.tc.logging.Location;
import com.sap.typeservices.ISimpleValueServices;
import java.sql.Date;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DdTypeDate
extends DdSimpleType
implements DdConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdTypeDate == null ? (class$com$sap$dictionary$runtime$DdTypeDate = DdTypeDate.class$("com.sap.dictionary.runtime.DdTypeDate")) : class$com$sap$dictionary$runtime$DdTypeDate));
    private static final DateFormat XML_FORMATTER = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final DateFormat XML_FORMATTER_FOR_PARSING = new SimpleDateFormat("yy-MM-dd", Locale.US);
    private static final Date EXAMPLE = Date.valueOf("1987-11-25");
    private Date minInclusive = null;
    private Date maxInclusive = null;
    private Date minExclusive = null;
    private Date maxExclusive = null;
    private Date defaultValue = null;
    private DateFormat formatterP = null;
    private DateFormat formatter = null;
    private DateFormat parserDdmmyyyy = null;
    private DateFormat parserDdmmyy = null;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdTypeDate;
    static /* synthetic */ Class class$java$sql$Date;

    public DdTypeDate(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getDateSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getSqlDate("minInclusive");
        this.maxInclusive = smap.getSqlDate("maxInclusive");
        this.minExclusive = smap.getSqlDate("minExclusive");
        this.maxExclusive = smap.getSqlDate("maxExclusive");
        this.defaultValue = emap.getSqlDate("defaultValue");
        this.setFormatter();
    }

    public Class getAttributeClass() {
        return class$java$sql$Date == null ? (class$java$sql$Date = DdTypeDate.class$("java.sql.Date")) : class$java$sql$Date;
    }

    public String getInitialFormat() {
        return "yyyy-MM-dd";
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public String format(Object value) {
        if (loc.beInfo()) {
            loc.infoT("Format date-time {0} with Simple type {1}", new Object[]{value, this});
        }
        if (value == null) {
            return "";
        }
        if (!(value instanceof java.util.Date)) {
            return "";
        }
        String text = this.formatter.format(value);
        if (loc.beInfo()) {
            loc.infoT("Format result is {0}", new Object[]{text});
        }
        return text;
    }

    public String format(java.util.Date value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public String format(Date value) {
        if (value == null) {
            return "";
        }
        return this.formatter.format(value);
    }

    public Object parse(String text) throws ParseException {
        if (loc.beInfo()) {
            loc.infoT("Parse date {0} with Simple type {1}", new Object[]{text, this});
        }
        return this.parseDate(text);
    }

    public Date parse(Date value, String text) throws ParseException {
        return this.parseDate(text);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date parseDate(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        Date value = null;
        if (StringUtil.isNumericValue(text)) {
            if (text.length() == 8) {
                value = new Date(this.parserDdmmyyyy.parse(text).getTime());
            } else {
                if (text.length() != 6) throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.format(EXAMPLE)}), 0);
                value = new Date(this.parserDdmmyy.parse(text).getTime());
            }
        } else {
            try {
                value = new Date(this.formatterP.parse(text).getTime());
            }
            catch (ParseException ex) {
                throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.format(EXAMPLE)}), 0);
            }
        }
        if (value.getTime() >= 253402297200000L) {
            throw new ParseException(DdMsgHandler.get(DdConstants.YEAR_WITH_WRONG_VALUE), 0);
        }
        this.checkAfterParse(value);
        if (!loc.beInfo()) return value;
        loc.infoT("Parse result is {0}", new Object[]{value});
        return value;
    }

    public java.util.Date parseUtilDate(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        java.util.Date value = null;
        try {
            value = new java.util.Date(this.formatterP.parse(text).getTime());
        }
        catch (ParseException ex) {
            throw new ParseException(DdMsgHandler.get(DdConstants.ERROR_DURING_PARSE, new Object[]{this.format(EXAMPLE)}), 0);
        }
        if (value.getTime() >= 253402297200000L) {
            throw new ParseException(DdMsgHandler.get(DdConstants.YEAR_WITH_WRONG_VALUE), 0);
        }
        if (loc.beInfo()) {
            loc.infoT("Parse result is {0}", new Object[]{value});
        }
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Date) {
            return this.isValid((Date)value);
        }
        if (value instanceof java.util.Date) {
            java.util.Date dateUtil = (java.util.Date)value;
            return this.isValid(new Date(dateUtil.getTime()));
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(Date value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        return !(this.minInclusive != null && value.compareTo(this.minInclusive) < 0 || this.maxInclusive != null && value.compareTo(this.maxInclusive) > 0 || this.minExclusive != null && value.compareTo(this.minExclusive) <= 0 || this.maxExclusive != null && value.compareTo(this.maxExclusive) >= 0 || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof java.util.Date) {
            java.util.Date dateUtil = (java.util.Date)value;
            date = new Date(dateUtil.getTime());
        } else {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        if (this.minInclusive != null && date.compareTo(this.minInclusive) < 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{date.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && date.compareTo(this.maxInclusive) > 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{date.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && date.compareTo(this.minExclusive) <= 0) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{date.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && date.compareTo(this.maxExclusive) >= 0) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{date.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(date)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{date.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(date)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{date.toString()});
        }
    }

    private boolean matchesPattern(Date value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Date) {
            return this.matchesEnumeration((Date)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(Date value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)value);
        }
        return this.getEnum() == null || this.getEnum().contains(value);
    }

    public void setMinInclusive(Object minInclusive) {
        java.util.Date dateUtil = null;
        if (this.isModifyAllowed()) {
            if (minInclusive instanceof Date) {
                this.minInclusive = (Date)minInclusive;
            } else if (minInclusive instanceof java.util.Date) {
                dateUtil = (java.util.Date)minInclusive;
                this.minInclusive = new Date(dateUtil.getTime());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object maxInclusive) {
        java.util.Date dateUtil = null;
        if (this.isModifyAllowed()) {
            if (maxInclusive instanceof Date) {
                this.maxInclusive = (Date)maxInclusive;
            } else if (maxInclusive instanceof java.util.Date) {
                dateUtil = (java.util.Date)maxInclusive;
                this.maxInclusive = new Date(dateUtil.getTime());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object minExclusive) {
        java.util.Date dateUtil = null;
        if (this.isModifyAllowed()) {
            if (minExclusive instanceof Date) {
                this.minExclusive = (Date)minExclusive;
            } else if (minExclusive instanceof java.util.Date) {
                dateUtil = (java.util.Date)minExclusive;
                this.minExclusive = new Date(dateUtil.getTime());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object maxExclusive) {
        java.util.Date dateUtil = null;
        if (this.isModifyAllowed()) {
            if (maxExclusive instanceof Date) {
                this.maxExclusive = (Date)maxExclusive;
            } else if (maxExclusive instanceof java.util.Date) {
                dateUtil = (java.util.Date)maxExclusive;
                this.maxExclusive = new Date(dateUtil.getTime());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(Date value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }

    public void setFormatter() {
        Locale locale;
        if (loc.beInfo()) {
            loc.infoT("TimeZone:", new Object[]{DdDictionaryPool.getDefaultTimeZone().toString()});
        }
        if ((locale = this.getLocale()) == null) {
            locale = Locale.getDefault();
        }
        if (locale.getLanguage().equalsIgnoreCase("xml")) {
            this.formatterP = XML_FORMATTER_FOR_PARSING;
            this.formatterP.setLenient(false);
            this.formatterP.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
            this.formatter = XML_FORMATTER;
            this.formatter.setLenient(false);
            this.formatter.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
            return;
        }
        String format = this.getFormat();
        this.formatter = format == null ? DateFormat.getDateInstance(3, locale) : (format.equalsIgnoreCase("SHORT") ? DateFormat.getDateInstance(3, locale) : (format.equalsIgnoreCase("MEDIUM") ? DateFormat.getDateInstance(2, locale) : (format.equalsIgnoreCase("LONG") ? DateFormat.getDateInstance(1, locale) : (format.equalsIgnoreCase("FULL") ? DateFormat.getDateInstance(0, locale) : new SimpleDateFormat(format, locale)))));
        this.formatter.setLenient(false);
        this.formatter.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        if (format == null || format.equalsIgnoreCase("SHORT")) {
            char[] c = this.getFormatTemplate().toCharArray();
            char previous = ' ';
            String templateDdmmyy = "";
            String templateDdmmyyyy = "";
            int i = 0;
            while (i < c.length) {
                if (c[i] == 'd' && c[i] != previous) {
                    templateDdmmyy = templateDdmmyy + "dd";
                    templateDdmmyyyy = templateDdmmyyyy + "dd";
                } else if (c[i] == 'M' && c[i] != previous) {
                    templateDdmmyy = templateDdmmyy + "MM";
                    templateDdmmyyyy = templateDdmmyyyy + "MM";
                }
                if (c[i] == 'y' && c[i] != previous) {
                    templateDdmmyy = templateDdmmyy + "yy";
                    templateDdmmyyyy = templateDdmmyyyy + "yyyy";
                }
                previous = c[i];
                ++i;
            }
            this.parserDdmmyy = new SimpleDateFormat(templateDdmmyy);
            this.parserDdmmyy.setLenient(false);
            this.parserDdmmyy.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
            this.parserDdmmyyyy = new SimpleDateFormat(templateDdmmyyyy);
            this.parserDdmmyyyy.setLenient(false);
            this.parserDdmmyyyy.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        }
        this.formatterP = (DateFormat)this.formatter.clone();
        this.formatterP.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
        if (format == null) {
            SimpleDateFormat sF = (SimpleDateFormat)this.formatter;
            sF.setTimeZone(DdDictionaryPool.getDefaultTimeZone());
            String pattern = sF.toPattern();
            int index = pattern.indexOf("yyyy");
            if (index == -1) {
                StringBuffer sBuffer;
                index = pattern.indexOf("yy");
                if (index > -1) {
                    sBuffer = new StringBuffer(pattern);
                    sF.applyPattern(sBuffer.insert(index, "yy").toString());
                } else {
                    index = pattern.indexOf("y");
                    if (index > -1) {
                        sBuffer = new StringBuffer(pattern);
                        sF.applyPattern(sBuffer.insert(index, "yyy").toString());
                    }
                }
            }
            return;
        }
    }

    public String getFormatTemplate() {
        return ((SimpleDateFormat)this.formatter).toPattern();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/DdTypeDate.java#5 $");
    }
}

