/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeByte
extends DdTypeNumber
implements DdConstants {
    private Byte minInclusive = null;
    private Byte maxInclusive = null;
    private Byte minExclusive = null;
    private Byte maxExclusive = null;
    private byte minInclusiveByte = 0;
    private byte maxInclusiveByte = 0;
    private byte minExclusiveByte = 0;
    private byte maxExclusiveByte = 0;
    private Byte defaultValue = null;

    public DdTypeByte(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getByteSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getByteObject("minInclusive");
        this.maxInclusive = smap.getByteObject("maxInclusive");
        this.minExclusive = smap.getByteObject("minExclusive");
        this.maxExclusive = smap.getByteObject("maxExclusive");
        this.defaultValue = emap.getByteObject("defaultValue");
        if (this.minInclusive != null) {
            this.minInclusiveByte = this.minInclusive;
        }
        if (this.maxInclusive != null) {
            this.maxInclusiveByte = this.maxInclusive;
        }
        if (this.minExclusive != null) {
            this.minExclusiveByte = this.minExclusive;
        }
        if (this.maxExclusive != null) {
            this.maxExclusiveByte = this.maxExclusive;
        }
    }

    public Class getAttributeClass() {
        return Byte.TYPE;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        return new Byte(this.parseByte(text));
    }

    public byte parse(byte value, String text) throws ParseException {
        return this.parseByte(text);
    }

    public byte parseByte(String text) throws ParseException {
        byte value = super.parseByte(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Byte) {
            return this.isValid((Byte)value);
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(byte value) {
        return !(this.minInclusive != null && value < this.minInclusiveByte || this.maxInclusive != null && value > this.maxInclusiveByte || this.minExclusive != null && value <= this.minExclusiveByte || this.maxExclusive != null && value >= this.maxExclusiveByte || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Byte)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        byte byteValue = (Byte)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && new Byte(byteValue).toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && byteValue < this.minInclusiveByte) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && byteValue > this.maxInclusiveByte) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && byteValue <= this.minExclusiveByte) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && byteValue >= this.maxExclusiveByte) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(byteValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(byteValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(byte value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Byte) {
            return this.matchesEnumeration((Byte)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(byte value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)new Byte(value));
        }
        return this.getEnum() == null || this.getEnum().contains(new Byte(value));
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Byte) {
                this.minInclusive = (Byte)value;
                this.minInclusiveByte = this.minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Byte) {
                this.maxInclusive = (Byte)value;
                this.maxInclusiveByte = this.maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Byte) {
                this.minExclusive = (Byte)value;
                this.minExclusiveByte = this.minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Byte) {
                this.maxExclusive = (Byte)value;
                this.maxExclusiveByte = this.maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(byte value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

