/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.ExType;
import java.util.Locale;

public class DdRuntimeException
extends RuntimeException {
    ExType exType = null;
    Exception exReal = null;
    Object msgCode = null;
    Object[] args = null;

    public DdRuntimeException() {
    }

    public DdRuntimeException(String message) {
        super(message);
    }

    public DdRuntimeException(ExType exType, String message) {
        super(message);
        this.exType = exType;
    }

    public DdRuntimeException(ExType exType, String message, Exception exReal) {
        super(message);
        this.exType = exType;
        this.exReal = exReal;
    }

    public DdRuntimeException(Object msgCode, Object[] args) {
        super(msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US));
        this.msgCode = msgCode;
        this.args = args;
    }

    public DdRuntimeException(ExType exType, Object msgCode, Object[] args) {
        super(msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US));
        this.exType = exType;
        this.msgCode = msgCode;
        this.args = args;
    }

    public DdRuntimeException(ExType exType, Throwable cause, Object msgCode, Object[] args) {
        super((msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US)) + (cause == null ? "" : " Caused by: " + cause.getMessage()));
        this.exType = exType;
        this.msgCode = msgCode;
        this.args = args;
    }

    public void printStackTrace() {
        if (this.exReal != null) {
            this.exReal.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public static DdRuntimeException createInstance(Exception ex) {
        if (ex instanceof DdRuntimeException) {
            return (DdRuntimeException)ex;
        }
        return new DdRuntimeException(ExType.OTHER, ex.getMessage(), ex);
    }

    public static DdRuntimeException createInstance(Exception ex, ExType exType) {
        if (ex instanceof DdRuntimeException) {
            return (DdRuntimeException)ex;
        }
        return new DdRuntimeException(exType, ex.getMessage(), ex);
    }

    public ExType getExType() {
        return this.exType;
    }

    public String getLocalizedMessage() {
        return this.msgCode == null ? "" : DdMsgHandler.get(this.msgCode, this.args, Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        return this.msgCode == null ? "" : DdMsgHandler.get(this.msgCode, this.args, locale);
    }
}

