/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdBroker;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdNameTranslator;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.DdStructure;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IConstants;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.IField;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.UnitServiceKind;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.tc.logging.Location;
import java.util.Locale;

public class DdField
implements IField,
DdConstants,
IConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdField == null ? (class$com$sap$dictionary$runtime$DdField = DdField.class$("com.sap.dictionary.runtime.DdField")) : class$com$sap$dictionary$runtime$DdField));
    String name = null;
    String backendName = null;
    IDataProvider provider = null;
    IStructure structure = null;
    Locale locale = null;
    String ddicNameOfType = "";
    String nameOfType = null;
    String backendNameOfType = null;
    IDataType embeddedType = null;
    int position = 0;
    boolean belongsToAppend = false;
    boolean isScalar = true;
    UnitServiceKind unitServiceKind = null;
    boolean hasReferenceField = false;
    String ddicNameOfReferenceStructure = "";
    String referenceStructureName = null;
    String referenceFieldName = null;
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdField;

    public DdField(IDataProvider provider, Locale locale, XmlMap fieldMap, DdStructure structure) throws DdException {
        XmlMap refFieldMap;
        XmlMap embeddedTypeMap;
        Object obj;
        this.locale = locale;
        XmlMap map1 = null;
        XmlMap map2 = null;
        this.provider = provider;
        this.structure = structure;
        this.name = fieldMap.getString("name");
        this.backendName = fieldMap.getString("backendName");
        this.position = fieldMap.getInt("position");
        this.belongsToAppend = fieldMap.getBoolean("belongsToAppend");
        if (fieldMap.get("isScalar") != null) {
            this.isScalar = fieldMap.getBoolean("isScalar");
        }
        if ((obj = fieldMap.get("unitServiceKind")) instanceof UnitServiceKind) {
            this.unitServiceKind = (UnitServiceKind)obj;
        }
        this.nameOfType = fieldMap.getString("typeName");
        this.backendNameOfType = fieldMap.getString("backendTypeName");
        if (this.unitServiceKind == null && this.nameOfType != null) {
            if (this.nameOfType.equals("com.sap.dictionary.predefined.currency.currency")) {
                this.unitServiceKind = UnitServiceKind.CURRENCY;
            } else if (this.nameOfType.equals("com.sap.dictionary.predefined.currency.currencyNormalized")) {
                this.unitServiceKind = UnitServiceKind.CURRENCY_NORMALIZED;
            } else if (this.nameOfType.equals("com.sap.dictionary.predefined.quantity.quantity")) {
                this.unitServiceKind = UnitServiceKind.QUANTITY;
            } else if (this.nameOfType.equals("com.sap.dictionary.predefined.quantity.quantityNormalized")) {
                this.unitServiceKind = UnitServiceKind.QUANTITY_NORMALIZED;
            }
        }
        if (!(embeddedTypeMap = fieldMap.getXmlMap("embeddedType")).isEmpty() && !(map1 = embeddedTypeMap.getXmlMap("SimpleType")).isEmpty()) {
            map1.put("name", "Embedded");
            this.embeddedType = DdSimpleType.makeNew(provider, locale, embeddedTypeMap);
        }
        if (this.embeddedType == null && this.nameOfType == null) {
            String builtInType = fieldMap.getString("builtIn-type");
            int length = fieldMap.getInt("length");
            map2 = new XmlMap();
            if (length > 0) {
                if (builtInType.equals("string")) {
                    map2.put("maxLength", fieldMap.getString("length"));
                }
                if (builtInType.equals("decimal")) {
                    map2.put("totalDigits", fieldMap.getString("length"));
                    map2.put("fractionDigits", fieldMap.getString("decimals"));
                }
            }
            map1 = new XmlMap();
            if (!map2.isEmpty()) {
                map1.put("SchemaType", map2);
            }
            map1.put("name", "Embedded");
            map1.put("builtInType", builtInType);
            embeddedTypeMap = new XmlMap();
            embeddedTypeMap.put("SimpleType", map1);
            this.embeddedType = DdSimpleType.makeNew(provider, locale, embeddedTypeMap);
        }
        if (!(refFieldMap = fieldMap.getXmlMap("referenceFieldInfo")).isEmpty() && structure.getName().equalsIgnoreCase(refFieldMap.getString("referenceStructureName"))) {
            this.referenceStructureName = refFieldMap.getString("referenceStructureName");
            this.referenceFieldName = refFieldMap.getString("referenceFieldName");
            this.hasReferenceField = true;
        }
    }

    public IDataProvider getProvider() {
        return this.provider;
    }

    public IStructure getStructure() {
        return this.structure;
    }

    public String getName() {
        return this.name;
    }

    public String getBackendName() {
        return this.backendName;
    }

    int getPosition() {
        return this.position;
    }

    public IDataType getEmbeddedType() {
        return this.embeddedType;
    }

    public boolean hasEmbeddedType() {
        return this.embeddedType != null;
    }

    public IDataType getDataType(IBroker broker) throws DdException {
        return ((DdBroker)broker).getDataType(this);
    }

    public IDataType getDataType() throws DdException {
        if (this.embeddedType != null) {
            return this.embeddedType;
        }
        if (loc.beInfo()) {
            loc.infoT("from field; search for {0} locale {1} thread {2}", new Object[]{this.nameOfType, this.locale, Thread.currentThread()});
        }
        if (StringUtil.isEmptyAfterTrim(this.ddicNameOfType)) {
            IDataType dataType = null;
            dataType = this.provider.getDataTypeFromCache(this.nameOfType, this.locale);
            if (dataType != null) {
                if (loc.beInfo()) {
                    loc.infoT("from field; found in cache {0} locale {1} thread {2}", new Object[]{this.nameOfType, this.locale, Thread.currentThread()});
                }
                return dataType;
            }
            dataType = this.provider.needsTranslator() ? this.provider.getDataType(this.nameOfType, this.locale, new DdNameTranslator(this.nameOfType, this.backendNameOfType)) : this.provider.getDataType(this.nameOfType, this.locale);
            if (loc.beInfo()) {
                loc.infoT("from field; found in backend {0} locale {1} thread {2}", new Object[]{this.nameOfType, this.locale, Thread.currentThread()});
            }
            return dataType;
        }
        throw new DdException(DdConstants.NO_DATATYPE_IN_FIELD, new Object[]{this.name});
    }

    public IField getReferenceField(IBroker broker) throws DdException {
        return this.getReferenceField();
    }

    public IField getReferenceField() throws DdException {
        if (!this.hasReferenceField()) {
            throw new DdException(DdConstants.REFERENCE_FIELD_DOES_NOT_EXIST, new Object[]{this.name});
        }
        return this.structure.getField(this.referenceFieldName);
    }

    public UnitServiceKind getUnitServiceKind() {
        return this.unitServiceKind;
    }

    public String getNameOfType() {
        return this.nameOfType;
    }

    public String getBackendNameOfType() {
        return this.backendNameOfType;
    }

    public String getDdicNameOfType() {
        return this.ddicNameOfType;
    }

    public String getDdicNameOfRefStructure() {
        return this.ddicNameOfReferenceStructure;
    }

    public boolean hasReferenceField() {
        return this.hasReferenceField;
    }

    public String getReferenceStructureName() {
        return this.referenceStructureName;
    }

    public String getReferenceFieldName() {
        return this.referenceFieldName;
    }

    public boolean belongsToAppend() {
        return this.belongsToAppend;
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public String toString() {
        String s = "Field = " + this.name + "\n" + "BackendName       : " + this.backendName + "\n" + "Type Name         : " + this.nameOfType + "\n" + "BackendNameOfType : " + this.backendNameOfType + "\n" + "Position          : " + this.position + "\n";
        if (this.hasReferenceField) {
            s = s + "referenceStructureName   :" + this.referenceStructureName + "\n" + "referenceFieldName       :" + this.referenceFieldName + "\n";
        }
        if (this.unitServiceKind != null) {
            s = s + "unitServiceKind = " + this.unitServiceKind + "\n";
        }
        if (this.embeddedType != null) {
            s = s + "embeddedType = " + this.embeddedType + "\n";
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/DdField.java#3 $");
    }
}

