/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DtHelper;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.ExType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IUnitService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;

public class DdCurrencyService
implements IUnitService {
    ISimpleType amountType = null;
    boolean normalized = true;
    IDataProvider provider = null;
    Locale locale = null;
    int amountScale = 0;
    IUnitService cloneForXml = null;
    public static final String XML = "xml";

    DdCurrencyService(ISimpleType amountType, boolean normalized, IDataProvider provider, Locale locale) {
        this.amountType = amountType;
        this.normalized = normalized;
        this.provider = provider;
        this.locale = locale;
        this.amountScale = amountType.getFractionDigits();
    }

    public String format(String unitKey, Object value) throws DdException {
        ISimpleType unitType = null;
        BigDecimal decimal = null;
        if (value == null) {
            return "";
        }
        if (value instanceof BigDecimal) {
            decimal = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            decimal = new BigDecimal((BigInteger)value);
        } else if (value instanceof Number) {
            decimal = BigDecimal.valueOf(((Number)value).longValue());
        } else {
            throw new DdException(ExType.FORMAT_ERROR, ExTexts.get("008"));
        }
        unitType = this.provider.getCurrencyUnitType(unitKey, this.locale);
        int unitScale = unitType.getFractionDigits();
        if (this.normalized && (decimal = decimal.movePointRight(this.amountScale).movePointLeft(unitScale)).scale() > unitScale) {
            decimal = decimal.setScale(unitScale, 6);
        }
        return unitType.format(decimal);
    }

    public Object parse(String unitKey, String text) throws ParseException {
        ISimpleType unitType = null;
        BigDecimal decimal = null;
        if (text.equals("")) {
            return null;
        }
        try {
            unitType = this.provider.getCurrencyUnitType(unitKey, this.locale);
        }
        catch (DdException ex) {
            throw new ParseException(ExTexts.get("007"), 0);
        }
        int unitScale = unitType.getFractionDigits();
        decimal = unitType.parseDecimal(text);
        if (decimal == null) {
            return null;
        }
        if (decimal.scale() > unitScale) {
            BigDecimal decimalOld = decimal;
            if ((decimal = decimal.setScale(unitScale, 6)).compareTo(decimalOld) != 0) {
                throw new ParseException(DtHelper.concat(ExTexts.get("010"), new Integer(unitScale).toString()), 0);
            }
        }
        if (this.normalized) {
            decimal = decimal.movePointRight(unitScale).movePointLeft(this.amountScale);
        }
        if (!this.amountType.isValid(decimal)) {
            throw new ParseException(ExTexts.get("003"), 0);
        }
        return decimal;
    }

    IUnitService getCloneForXml() {
        if (this.cloneForXml == null) {
            DdCurrencyService ddCurrencyService = this;
            synchronized (ddCurrencyService) {
                if (this.cloneForXml == null) {
                    this.cloneForXml = new DdCurrencyService(this.amountType, this.normalized, this.provider, new Locale(XML, ""));
                }
            }
        }
        return this.cloneForXml;
    }

    public String toString(String unitKey, Object obj) throws DdException {
        return this.getCloneForXml().format(unitKey, obj);
    }

    public Object valueOf(String unitKey, String text) throws ParseException {
        return this.getCloneForXml().parse(unitKey, text);
    }
}

