/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdCurrencyService;
import com.sap.dictionary.runtime.DdDictionary;
import com.sap.dictionary.runtime.DdDictionaryPool;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdField;
import com.sap.dictionary.runtime.DdJavaProvider;
import com.sap.dictionary.runtime.DdNameTranslator;
import com.sap.dictionary.runtime.DdQuantityService;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.IField;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.IUnitService;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.UnitServiceKind;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.services.IConfig;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class DdBroker
implements IBroker,
DdConstants {
    private final Map ddics = Collections.synchronizedMap(new HashMap());
    private final HashMap logicalSystemNames = new HashMap();
    private DdDictionaryPool ddicPool = null;
    private IConfig configuration = null;
    private Locale locale;
    private ClassLoader classLoader = null;
    private DdDictionary javaDictionary = null;
    IDataProvider javaProvider = null;
    private static final HashSet SPECIAL_PACKAGES = new HashSet<String>(Arrays.asList("com.sap.dictionary", "com.sap.dictionary.predefined.objecttypes", "com.sap.dictionary.predefined.currency"));
    private static final String BASIC_PREFIX = "com.sap.dictionary";
    private final HashMap predefinedSimpleTypes = new HashMap();
    private final HashMap predefinedSimpleTypesViaClass = new HashMap();
    protected static final String CURRENCY = "currency";
    protected static final String CURRENCY_NORMALIZED = "currencyNormalized";
    protected static final String QUANTITY = "quantity";
    protected static final String QUANTITY_NORMALIZED = "quantityNormalized";
    protected static final String CURR_PACKAGE = "com.sap.dictionary.predefined.currency";
    protected static final String QUAN_PACKAGE = "com.sap.dictionary.predefined.quantity";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    protected DdBroker(ClassLoader classLoader, Locale locale) throws DdException {
        this.ddicPool = DdDictionaryPool.getInstance();
        this.classLoader = classLoader;
        this.javaProvider = new DdJavaProvider(classLoader);
        this.javaDictionary = new DdDictionary("java", "java", this.javaProvider);
        this.ddics.put("java", this.javaDictionary);
        this.locale = locale;
        int i = 0;
        while (i < DdSimpleType.CONST.length) {
            Object[] line = DdSimpleType.CONST[i];
            String typeName = (String)line[0];
            String builtInType = (String)line[1];
            Class attrClass = (Class)line[2];
            Class typeClass = (Class)line[3];
            XmlMap map1 = new XmlMap();
            map1.put("name", typeName);
            map1.put("prefix", BASIC_PREFIX);
            map1.put("builtInType", builtInType);
            XmlMap map = new XmlMap();
            map.put("SimpleType", map1);
            HashMap hm = (HashMap)DdSimpleType.CONSTRUCTORS.get(builtInType);
            ISimpleType type = null;
            type = builtInType.equals(typeName) || typeName.equals("string") ? DdSimpleType.makeNew((Constructor)hm.get(null), null, locale, map) : DdSimpleType.makeNew((Constructor)hm.get(attrClass), null, locale, map);
            this.predefinedSimpleTypes.put(typeName, type);
            this.predefinedSimpleTypesViaClass.put(attrClass, type);
            ++i;
        }
        this.predefinedSimpleTypes.put(CURRENCY, DdJavaProvider.THIS_PROJECT_JAVA_PROVIDER.getDataType("com.sap.dictionary.predefined.currency.currency", locale));
        this.predefinedSimpleTypes.put(CURRENCY_NORMALIZED, DdJavaProvider.THIS_PROJECT_JAVA_PROVIDER.getDataType("com.sap.dictionary.predefined.currency.currencyNormalized", locale));
    }

    protected DdBroker(ClassLoader classLoader, Locale locale, IConfig configuration) throws DdException {
        this(classLoader, locale);
        this.configuration = configuration;
    }

    protected void putDictionary(String dictionaryName, String logSystemName, IDataProvider provider) {
        DdDictionary dictionary = new DdDictionary(dictionaryName, logSystemName, provider, this);
        this.ddics.put(dictionaryName, dictionary);
        this.logicalSystemNames.put(dictionaryName, logSystemName);
    }

    public void putDictionary(String dictionaryName, IDataProvider provider) {
        DdDictionary dictionary = new DdDictionary(dictionaryName, provider, this);
        this.ddics.put(dictionaryName, dictionary);
    }

    public void putJavaDictionary(ClassLoader classLoader) {
        this.javaProvider = new DdJavaProvider(classLoader);
        this.putDictionary("java", "java", this.javaProvider);
    }

    public DdDictionary getDictionary(String dictionaryName) {
        return (DdDictionary)this.ddics.get(dictionaryName);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DdDictionary removeDictionary(String dictionaryName) {
        return (DdDictionary)this.ddics.remove(dictionaryName);
    }

    public Iterator dictionaryIterator() {
        return this.ddics.values().iterator();
    }

    public boolean invalidateCache(String dictionaryName) {
        return ((DdDictionary)this.ddics.get(dictionaryName)).invalidateCache();
    }

    public IDataType getDataType(String dictionaryName, String name) throws DdException {
        IDataType dataType;
        DdDictionary ddic;
        String packageName = "";
        String localName = name;
        packageName = StringUtil.getPackageName(name);
        localName = StringUtil.getUnqualifiedClassName(name);
        if (SPECIAL_PACKAGES.contains(packageName) && this.predefinedSimpleTypes.containsKey(localName)) {
            return (IDataType)this.predefinedSimpleTypes.get(localName);
        }
        if (StringUtil.isEmptyAfterTrim(localName)) {
            throw new DdException(DdConstants.DDIC_TYPE_DOES_NOT_EXIST, new Object[]{name});
        }
        if (StringUtil.isEmptyAfterTrim(dictionaryName)) {
            dictionaryName = "java";
        }
        if ((ddic = (DdDictionary)this.ddics.get(dictionaryName)) == null) {
            ddic = this.ddicPool.getDictionary(dictionaryName, this.javaDictionary.getProvider().getClassLoader(), this.configuration);
            this.ddics.put(dictionaryName, ddic);
        }
        if ((dataType = ddic.getFromCache(name, this.locale)) != null) {
            return dataType;
        }
        DdNameTranslator translator = null;
        if (ddic.getProvider().needsTranslator() && (translator = ddic.getDefaultNameTranslator()) == null) {
            translator = new DdNameTranslator(name, this.locale, this.javaProvider);
        }
        return ddic.getDataType(name, this.locale, translator);
    }

    public ISimpleType getSimpleType(String dictionaryName, String name) throws DdException {
        IDataType dataType = this.getDataType(dictionaryName, name);
        if (dataType instanceof ISimpleType) {
            return (ISimpleType)dataType;
        }
        throw new DdException(DdConstants.SIMPLE_TYPE_DOES_NOT_EXIST, new Object[]{name});
    }

    public IStructure getStructure(String dictionaryName, String name) throws DdException {
        IDataType dataType = this.getDataType(dictionaryName, name);
        if (dataType instanceof IStructure) {
            return (IStructure)dataType;
        }
        throw new DdException(DdConstants.STRUCTURE_TYPE_DOES_NOT_EXIST, new Object[]{name});
    }

    public IDataType getDataType(String name) throws DdException {
        return this.getDataType(null, name);
    }

    public IUnitService getUnitService(IField amountField) throws DdException {
        ISimpleType amountType = (ISimpleType)amountField.getDataType();
        IDataProvider provider = amountType.getProvider();
        String amountPrefix = amountType.getPrefix();
        if (SPECIAL_PACKAGES.contains(amountPrefix)) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        if (!amountType.getBuiltInType().equalsIgnoreCase("decimal")) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        DdField unitKeyField = (DdField)amountField.getReferenceField();
        UnitServiceKind unitServiceKind = unitKeyField.getUnitServiceKind();
        if (unitServiceKind == UnitServiceKind.CURRENCY) {
            return new DdCurrencyService(amountType, false, provider, this.locale);
        }
        if (unitServiceKind == UnitServiceKind.CURRENCY_NORMALIZED) {
            return new DdCurrencyService(amountType, true, provider, this.locale);
        }
        if (unitServiceKind == UnitServiceKind.QUANTITY) {
            return new DdQuantityService(amountType, false, provider, this.locale);
        }
        if (unitServiceKind == UnitServiceKind.QUANTITY_NORMALIZED) {
            return new DdQuantityService(amountType, true, provider, this.locale);
        }
        throw new DdException(DdConstants.WRONG_UNIT_KEY_TYPE, new Object[0]);
    }

    public IUnitService getUnitService(IField amountField, boolean normalizingForced) throws DdException {
        if (!normalizingForced) {
            return this.getUnitService(amountField);
        }
        ISimpleType amountType = (ISimpleType)amountField.getDataType();
        IDataProvider provider = amountType.getProvider();
        String amountPrefix = amountType.getPrefix();
        if (SPECIAL_PACKAGES.contains(amountPrefix)) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        if (!amountType.getBuiltInType().equalsIgnoreCase("decimal")) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        DdField unitKeyField = (DdField)amountField.getReferenceField();
        UnitServiceKind unitServiceKind = unitKeyField.getUnitServiceKind();
        if (normalizingForced) {
            if (unitServiceKind == UnitServiceKind.CURRENCY) {
                return new DdCurrencyService(amountType, true, provider, this.locale);
            }
            if (unitServiceKind == UnitServiceKind.CURRENCY_NORMALIZED) {
                return new DdCurrencyService(amountType, true, provider, this.locale);
            }
            if (unitServiceKind == UnitServiceKind.QUANTITY) {
                return new DdQuantityService(amountType, true, provider, this.locale);
            }
            if (unitServiceKind == UnitServiceKind.QUANTITY_NORMALIZED) {
                return new DdQuantityService(amountType, true, provider, this.locale);
            }
            throw new DdException(DdConstants.WRONG_UNIT_KEY_TYPE, new Object[0]);
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ISimpleType getPredefinedSimpleType(Class attributeClass) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(attributeClass);
    }

    public ISimpleType getPredefinedSimpleTypeByName(String typeName) {
        return (ISimpleType)this.predefinedSimpleTypes.get(typeName);
    }

    public ISimpleType getPredefinedSimpleType(String value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$String == null ? (class$java$lang$String = DdBroker.class$("java.lang.String")) : class$java$lang$String);
    }

    public ISimpleType getPredefinedSimpleType(byte[] value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(array$B == null ? (array$B = DdBroker.class$("[B")) : array$B);
    }

    public ISimpleType getPredefinedSimpleType(Boolean value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DdBroker.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public ISimpleType getPredefinedSimpleType(boolean value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Boolean.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(BigDecimal value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = DdBroker.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    }

    public ISimpleType getPredefinedSimpleType(BigInteger value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DdBroker.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    }

    public ISimpleType getPredefinedSimpleType(Byte value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Byte == null ? (class$java$lang$Byte = DdBroker.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    public ISimpleType getPredefinedSimpleType(Double value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Double == null ? (class$java$lang$Double = DdBroker.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public ISimpleType getPredefinedSimpleType(Float value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Float == null ? (class$java$lang$Float = DdBroker.class$("java.lang.Float")) : class$java$lang$Float);
    }

    public ISimpleType getPredefinedSimpleType(Integer value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Integer == null ? (class$java$lang$Integer = DdBroker.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public ISimpleType getPredefinedSimpleType(Long value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Long == null ? (class$java$lang$Long = DdBroker.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public ISimpleType getPredefinedSimpleType(Short value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$lang$Short == null ? (class$java$lang$Short = DdBroker.class$("java.lang.Short")) : class$java$lang$Short);
    }

    public ISimpleType getPredefinedSimpleType(byte value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Byte.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(double value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Double.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(float value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Float.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(int value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Integer.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(long value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Long.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(short value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(Short.TYPE);
    }

    public ISimpleType getPredefinedSimpleType(Date value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$sql$Date == null ? (class$java$sql$Date = DdBroker.class$("java.sql.Date")) : class$java$sql$Date);
    }

    public ISimpleType getPredefinedSimpleType(java.util.Date value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$util$Date == null ? (class$java$util$Date = DdBroker.class$("java.util.Date")) : class$java$util$Date);
    }

    public ISimpleType getPredefinedSimpleType(Time value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$sql$Time == null ? (class$java$sql$Time = DdBroker.class$("java.sql.Time")) : class$java$sql$Time);
    }

    public ISimpleType getPredefinedSimpleType(Timestamp value) {
        return (ISimpleType)this.predefinedSimpleTypesViaClass.get(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DdBroker.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
    }

    public void prepare(String dictionaryName, String[] names) throws DdException {
        DdDictionary ddic;
        String packageName = "";
        String localName = null;
        HashMap<String, DdNameTranslator> searchNames = new HashMap<String, DdNameTranslator>();
        if (StringUtil.isEmptyAfterTrim(dictionaryName)) {
            dictionaryName = "java";
        }
        if ((ddic = (DdDictionary)this.ddics.get(dictionaryName)) == null) {
            ddic = this.ddicPool.getDictionary(dictionaryName, this.javaDictionary.getProvider().getClassLoader());
            this.ddics.put(dictionaryName, ddic);
        }
        DdNameTranslator translator = null;
        int i = 0;
        while (i < names.length) {
            packageName = StringUtil.getPackageName(names[i]);
            localName = StringUtil.getUnqualifiedClassName(names[i]);
            if (!(SPECIAL_PACKAGES.contains(packageName) && this.predefinedSimpleTypes.containsKey(localName) || StringUtil.isEmptyAfterTrim(localName))) {
                translator = null;
                if (ddic.getProvider().needsTranslator() && (translator = ddic.getDefaultNameTranslator()) == null) {
                    translator = new DdNameTranslator(names[i], this.locale, this.javaProvider);
                }
                searchNames.put(names[i], translator);
                ddic.prepare(searchNames, this.locale);
            }
            ++i;
        }
    }

    protected IDataType getDataType(IField field) throws DdException {
        DdField fld = (DdField)field;
        String typeName = fld.getNameOfType();
        String backendNameOfType = fld.getBackendNameOfType();
        String dictionaryName = fld.getDdicNameOfType();
        if (fld.hasEmbeddedType()) {
            IDataType embeddedType = fld.getEmbeddedType();
            if (embeddedType != null) {
                return embeddedType;
            }
            throw new DdException(DdConstants.NO_DATATYPE_IN_FIELD, new Object[]{field.getName()});
        }
        String packageName = StringUtil.getPackageName(typeName);
        if (StringUtil.isEmptyAfterTrim(dictionaryName)) {
            IDataProvider provider = fld.getProvider();
            IDataType dataType = provider.getDataTypeFromCache(typeName, this.locale);
            if (dataType != null) {
                return dataType;
            }
            if (provider.needsTranslator()) {
                return provider.getDataType(typeName, this.locale, new DdNameTranslator(typeName, backendNameOfType));
            }
            return provider.getDataType(typeName, this.locale);
        }
        return this.getDataType(dictionaryName, typeName);
    }

    public IUnitService getCurrencyService(ISimpleType amountType, boolean normalized, Locale locale) throws DdException {
        if (!amountType.getBuiltInType().equalsIgnoreCase("decimal")) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        return new DdCurrencyService(amountType, normalized, amountType.getProvider(), locale);
    }

    public IUnitService getQuantityService(ISimpleType amountType, boolean normalized, Locale locale) throws DdException {
        if (!amountType.getBuiltInType().equalsIgnoreCase("decimal")) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        return new DdQuantityService(amountType, normalized, amountType.getProvider(), locale);
    }

    public IUnitService getUnitService(ISimpleType amountType, ISimpleType unitKeyType) throws DdException {
        String localAmountName = amountType.getName();
        String amountPrefix = StringUtil.getPackageName(localAmountName);
        if (amountPrefix.equals(BASIC_PREFIX)) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        if (!amountType.getBuiltInType().equalsIgnoreCase("decimal")) {
            throw new DdException(DdConstants.WRONG_AMOUNT_TYPE, new Object[0]);
        }
        String name = unitKeyType.getName();
        String prefix = StringUtil.getPackageName(name);
        String localName = StringUtil.getUnqualifiedClassName(name);
        if (!prefix.equalsIgnoreCase(CURR_PACKAGE) && !prefix.equalsIgnoreCase(QUAN_PACKAGE)) {
            throw new DdException(DdConstants.WRONG_UNIT_KEY_TYPE, new Object[0]);
        }
        IDataProvider provider = amountType.getProvider();
        if (localName.equalsIgnoreCase(CURRENCY)) {
            return new DdCurrencyService(amountType, false, provider, this.locale);
        }
        if (localName.equalsIgnoreCase(CURRENCY_NORMALIZED)) {
            return new DdCurrencyService(amountType, true, provider, this.locale);
        }
        if (localName.equalsIgnoreCase(QUANTITY)) {
            return new DdQuantityService(amountType, false, provider, this.locale);
        }
        if (localName.equalsIgnoreCase(QUANTITY_NORMALIZED)) {
            return new DdQuantityService(amountType, true, provider, this.locale);
        }
        throw new DdException(DdConstants.WRONG_UNIT_KEY_TYPE, new Object[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

