/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.sdm.ui.preference;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.ide.eclipse.sdm.SDMPlugin;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SDMPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore myPrefStore;
    private Text host;
    private Text port;
    private Button sdmAutomatic;
    private Button sdmManually;
    private TextViewer outTextViewer;
    private Button pingButton;
    private ProgressIndicator pingIndicator;
    private static final String NOT_SUPPORTED = "Not suppported anymore !";

    public void init(IWorkbench workbench) {
        this.myPrefStore = SDMPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)2);
        mainPane.addTextLabel("Please specify the Software Deployment Manager (SDM) used for deployment.", mainPane.createGridLayoutData(1, 1, 2, 1));
        this.sdmAutomatic = mainPane.addRadioButton("Retrieve SDM automatically from the configured engine.", mainPane.createGridLayoutData(1, 1, 2, 1));
        this.sdmAutomatic.setEnabled(false);
        this.sdmManually = mainPane.addRadioButton("Configure SDM manually be specifing port and host.", mainPane.createGridLayoutData(1, 1, 2, 1));
        this.sdmManually.setEnabled(false);
        mainPane.addTextLabel("Server Host:");
        this.host = mainPane.addTextField(false, mainPane.createGridLayoutData(4, 1, true, false, 1, 1));
        mainPane.addTextLabel("Port Number:");
        this.port = mainPane.addTextField(false, mainPane.createGridLayoutData(4, 1, true, false, 1, 1));
        String toolTipText = "The port of the SDM be computed by \n50018 plus 100 times the instance number of the J2EE instance (not the SCS instance !).\n(e.g. 50118 for J2EE instance 01)";
        this.port.setToolTipText(toolTipText);
        this.port.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                try {
                    Integer.parseInt(SDMPreferencePage.this.port.getText());
                }
                catch (NumberFormatException e2) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Conversion error!", (String)"Could not convert port number!");
                    SDMPreferencePage.this.port.setText("0");
                }
            }
        });
        this.host.setText(NOT_SUPPORTED);
        this.host.setEnabled(false);
        this.port.setText(NOT_SUPPORTED);
        this.port.setEnabled(false);
        this.pingButton = mainPane.addPushButton("Check connection");
        ISimplePane simpleP = mainPane.addSimplePane(true, false, true, false);
        this.pingIndicator = new ProgressIndicator(simpleP.getComposite());
        this.outTextViewer = mainPane.addTextViewer(true, false, mainPane.createGridLayoutData(4, 4, true, true, 2, 1));
        this.outTextViewer.setEditable(false);
        InnerRadioButtonSelectionListener selListener = new InnerRadioButtonSelectionListener();
        this.sdmAutomatic.addSelectionListener((SelectionListener)selListener);
        this.sdmManually.addSelectionListener((SelectionListener)selListener);
        this.pingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDMPreferencePage.this.outTextViewer.getDocument().set("");
                ByteArrayOutputStream communicationStream = new ByteArrayOutputStream();
                String hostText = "";
                String portText = "";
                if (SDMPreferencePage.this.sdmManually.getSelection()) {
                    hostText = SDMPreferencePage.this.host.getText();
                    portText = SDMPreferencePage.this.port.getText();
                } else {
                    hostText = EnginePlugin.getDefault().getSDMHost();
                    portText = EnginePlugin.getDefault().getSdmPort();
                }
                InnerPingThread pingThread = new InnerPingThread(hostText, portText, communicationStream);
                pingThread.start();
                InnerPingThreadProgressMonitor pingThreadMonitor = new InnerPingThreadProgressMonitor(pingThread, SDMPreferencePage.this.pingIndicator, communicationStream, SDMPreferencePage.this.outTextViewer);
                Display.getCurrent().asyncExec((Runnable)pingThreadMonitor);
            }
        });
        this.sdmManually.setSelection(false);
        this.sdmAutomatic.setSelection(true);
        this.updatePage();
        return mainPane.getComposite();
    }

    private void initControl() {
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.sdmAutomatic.setSelection(true);
        this.sdmManually.setSelection(false);
        this.host.setText(NOT_SUPPORTED);
        this.port.setText(NOT_SUPPORTED);
        this.updatePage();
    }

    public boolean performOk() {
        return true;
    }

    private void updatePage() {
        this.host.setEditable(this.sdmManually.getSelection());
        this.port.setEditable(this.sdmManually.getSelection());
    }

    private static class InnerPingThreadProgressMonitor
    extends Thread {
        Thread monitorThread;
        ProgressIndicator indicator;
        ByteArrayOutputStream stream;
        TextViewer textViewer;
        static final int STEP_MAX = 60;
        static final int MILLIS_PER_STEP = 500;
        int resultingSecods = 30;

        public InnerPingThreadProgressMonitor(Thread pMonitorThread, ProgressIndicator pIndicator, ByteArrayOutputStream outStream, TextViewer tViewer) {
            super("Ping Thread Monitor");
            this.monitorThread = pMonitorThread;
            this.indicator = pIndicator;
            this.stream = outStream;
            this.textViewer = tViewer;
        }

        public void run() {
            this.indicator.beginTask(60);
            this.textViewer.getDocument().set(" working ... ");
            int p = 0;
            while (p < 60 && this.monitorThread.isAlive()) {
                long startTime;
                this.indicator.worked(1.0);
                long currentTime = startTime = System.currentTimeMillis();
                while (currentTime < startTime + 500L) {
                    currentTime = System.currentTimeMillis();
                }
                ++p;
            }
            String pingResult = "";
            pingResult = this.monitorThread.isAlive() ? MessageFormat.format("Server not reached in time ({0} seconds) !", new Integer(this.resultingSecods)) : this.stream.toString();
            this.indicator.sendRemainingWork();
            this.textViewer.getDocument().set(pingResult);
        }
    }

    private static class InnerPingThread
    extends Thread {
        String host;
        String port;
        ByteArrayOutputStream stream;

        public InnerPingThread(String pHost, String pPort, ByteArrayOutputStream outStream) {
            super("Ping Thread");
            this.host = pHost;
            this.port = pPort;
            this.stream = outStream;
        }

        public void run() {
            PrintStream out = new PrintStream(this.stream);
            SDMManager.getInstance().pingSDM(this.host, this.port, out);
        }
    }

    private class InnerRadioButtonSelectionListener
    implements SelectionListener {
        private InnerRadioButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        public void widgetSelected(SelectionEvent evt) {
            SDMPreferencePage.this.updatePage();
        }
    }
}

