/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.sdm.threading;

import com.sap.ide.eclipse.sdm.ISDMManagerListener;
import com.sap.ide.eclipse.sdm.internal.SDMConnector;
import com.sap.ide.eclipse.sdm.threading.DeployThread;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DeployThreadManager {
    private int globalDeployIDNum = 0;
    private static final TracerI dtTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$sdm$threading$DeployThreadManager == null ? (class$com$sap$ide$eclipse$sdm$threading$DeployThreadManager = DeployThreadManager.class$("com.sap.ide.eclipse.sdm.threading.DeployThreadManager")) : class$com$sap$ide$eclipse$sdm$threading$DeployThreadManager));
    private static DeployThreadManager instance;
    private Hashtable deployThreadTable = new Hashtable();
    private Vector listenerVector = new Vector();
    static /* synthetic */ Class class$com$sap$ide$eclipse$sdm$threading$DeployThreadManager;

    private DeployThreadManager() {
    }

    public static DeployThreadManager getInstance() {
        if (instance == null) {
            instance = new DeployThreadManager();
        }
        return instance;
    }

    public boolean addListener(ISDMManagerListener listener) {
        return this.listenerVector.add(listener);
    }

    public boolean removeListener(ISDMManagerListener listener) {
        return this.listenerVector.remove(listener);
    }

    public boolean canDeploy(File archiveFile) {
        this.cleanUpThreadTable();
        boolean canDeployFlag = !this.deployThreadTable.containsKey(archiveFile);
        return canDeployFlag;
    }

    public void deployAsync(File[] archives, SDMConnector sdmConn) {
        this.deploy(archives, dtTracer, sdmConn, true);
    }

    public void deployAsync(File archive, SDMConnector sdmConn) {
        this.deploy(archive, dtTracer, sdmConn, true);
    }

    public void deploy(File archive, TracerI tracer, SDMConnector sdmConn, boolean asynchronously) {
        this.deploy(new File[]{archive}, tracer, sdmConn, asynchronously);
    }

    public void deploy(File[] archives, TracerI tracer, SDMConnector sdmConn, boolean asynchronously) {
        ++this.globalDeployIDNum;
        String currentDeployID = "ID";
        currentDeployID = this.globalDeployIDNum < 10 ? "[00" + this.globalDeployIDNum + "]" : (this.globalDeployIDNum < 100 ? "[0" + this.globalDeployIDNum + "]" : "[" + this.globalDeployIDNum + "]");
        String userOut = "\n" + currentDeployID + "Start deployment ";
        int f = 0;
        while (f < archives.length) {
            userOut = userOut + "\n" + archives[f].getName() + " (" + archives[f].getPath() + ") ";
            ++f;
        }
        dtTracer.userOut("deploy", userOut);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                    try {
                        page.showView("com.sap.ide.eclipse.sdm.ui.DeployOutputView");
                    }
                    catch (PartInitException ex) {
                        dtTracer.error("Could not show deploy output view !", (Throwable)ex);
                    }
                }
            }
        });
        ArrayList<File> listOfDeployableFiles = new ArrayList<File>();
        int f2 = 0;
        while (f2 < archives.length) {
            if (this.canDeploy(archives[f2])) {
                listOfDeployableFiles.add(archives[f2]);
            } else {
                dtTracer.userOut("deploy", 3, "\n" + currentDeployID + "Deployment of archive is already running and will be skipped : " + archives[f2].getName());
            }
            ++f2;
        }
        File[] archiveFiles = listOfDeployableFiles.toArray(new File[0]);
        DeployThread dt = new DeployThread(currentDeployID, archiveFiles, sdmConn);
        dt.start();
        if (!asynchronously) {
            try {
                dt.join();
            }
            catch (InterruptedException e) {
                dtTracer.error("Deployment interrupted!", (Throwable)e);
            }
        }
    }

    public static TracerI getDtTracer() {
        return dtTracer;
    }

    public DeployThread getDeployThread(IFile archiveFile) {
        this.cleanUpThreadTable();
        DeployThread th = (DeployThread)this.deployThreadTable.get(archiveFile);
        return th;
    }

    public DeployThread[] getAllDeployThreads() {
        this.cleanUpThreadTable();
        DeployThread[] ths = new DeployThread[]{};
        ths = this.deployThreadTable.entrySet().toArray(ths);
        return ths;
    }

    void threadStarted(DeployThread thread) {
        this.cleanUpThreadTable();
        File[] deplFiles = thread.getDeployFiles();
        int f = 0;
        while (f < deplFiles.length) {
            this.deployThreadTable.put(deplFiles[f], thread);
            Vector listenerVectorClone = (Vector)this.listenerVector.clone();
            Iterator listenerIter = ((AbstractList)listenerVectorClone).iterator();
            while (listenerIter.hasNext()) {
                ISDMManagerListener listener = (ISDMManagerListener)listenerIter.next();
                listener.deploymentStarted(deplFiles[f]);
            }
            ++f;
        }
    }

    void threadFinished(DeployThread thread) {
        File[] deplFiles = thread.getDeployFiles();
        int f = 0;
        while (f < deplFiles.length) {
            DeployThread dt = (DeployThread)this.deployThreadTable.remove(deplFiles[f]);
            if (dt != null) {
                Vector listenerVectorClone = (Vector)this.listenerVector.clone();
                Iterator listenerIter = ((AbstractList)listenerVectorClone).iterator();
                while (listenerIter.hasNext()) {
                    ISDMManagerListener listener = (ISDMManagerListener)listenerIter.next();
                    listener.deploymentFinished(deplFiles[f], thread.getDeployException());
                }
            }
            ++f;
        }
    }

    void cleanUpThreadTable() {
        if (!this.deployThreadTable.isEmpty()) {
            DeployThread[] dts = new DeployThread[]{};
            dts = this.deployThreadTable.values().toArray(dts);
            int i = 0;
            while (i < dts.length) {
                DeployThread deplThread = dts[i];
                if (!deplThread.isAlive()) {
                    this.threadFinished(deplThread);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

