/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.sdm.threading;

import com.sap.ide.eclipse.sdm.internal.SDMConnector;
import com.sap.ide.eclipse.sdm.threading.DeployThreadManager;
import com.sap.ide.eclipse.sdm.threading.DeployURL;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.util.trace.TracerI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

class DeployThread
extends Thread {
    private File[] myDeployFiles;
    private DeploymentException myDeployException;
    private SDMConnector mySdmConnector;
    private String myDeployID;
    private static TracerI deployTracer = DeployThreadManager.getDtTracer();

    public DeployThread(String deployId, File[] files, SDMConnector sdmConn) {
        super("Deploy Thread");
        this.myDeployID = deployId;
        this.myDeployFiles = files;
        this.mySdmConnector = sdmConn;
    }

    public String getDeployID() {
        return this.myDeployID;
    }

    public File[] getDeployFiles() {
        return this.myDeployFiles;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block23: {
            block21: {
                block20: {
                    DeployThreadManager.getInstance().threadStarted(this);
                    outStream = new ByteArrayOutputStream();
                    out = new PrintStream(outStream);
                    logStream = new ByteArrayOutputStream();
                    log = new PrintStream(logStream);
                    deployUrlList = new ArrayList<DeployURL>();
                    f = 0;
                    while (f < this.myDeployFiles.length) {
                        deployURL = DeployThread.createDeployUrl(this.myDeployFiles[f], this.myDeployID);
                        deployUrlList.add(deployURL);
                        ++f;
                    }
                    this.setDeployException(null);
                    urls = new URL[deployUrlList.size()];
                    urlIter = deployUrlList.iterator();
                    cnt = 0;
                    while (urlIter.hasNext()) {
                        deplUrl = (DeployURL)urlIter.next();
                        urls[cnt++] = deplUrl.getURL();
                    }
                    if (urls.length > 0) {
                        this.mySdmConnector.deploySDAs(urls, out, log, DeployThread.deployTracer);
                        DeployThread.deployTracer.userOut("deploy", 4, "\n" + this.myDeployID + "Finished Deployment " + "\n\n" + outStream.toString());
                        break block20;
                    }
                    DeployThread.deployTracer.userOut("deploy", 3, "\n" + this.myDeployID + "Nothing to deploy");
                }
                var12_13 = null;
                if (logStream.size() <= 0) break block21;
                DeployThread.deployTracer.userOut("deploy", 4, "\n" + this.myDeployID + "Additional log information about the deployment " + "\n\n" + logStream.toString());
            }
            deployURLIter = deployUrlList.iterator();
            while (deployURLIter.hasNext()) {
                deployURL = (DeployURL)deployURLIter.next();
                if (deployURL == null || !deployURL.isTemporary() || !deployURL.getFile().exists()) continue;
                deployURL.getFile().delete();
            }
            try {
                outStream.close();
                logStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            DeployThreadManager.getInstance().threadFinished(this);
            {
                break block23;
                catch (DeploymentException ex) {
                    this.setDeployException(ex);
                    userOut = "\n" + this.myDeployID + (ex.isOnlyWarning() != false ? "Deployment finished with warning " : "Deployment aborted ") + outStream.toString();
                    if (ex.getMessage() != null && !ex.getMessage().equals("")) {
                        userOut = userOut + "\nDeployment exception : " + ex.getMessage();
                    }
                    if (ex.getInnerException() != null) {
                        userOut = userOut + "\nInner exception was : \n" + ex.getInnerException().getMessage();
                    }
                    if (ex.isOnlyWarning()) {
                        DeployThread.deployTracer.userOut("deploy", 3, userOut);
                    } else {
                        DeployThread.deployTracer.userOut("deploy", 2, userOut);
                    }
                    var12_14 = null;
                    if (logStream.size() > 0) {
                        DeployThread.deployTracer.userOut("deploy", 4, "\n" + this.myDeployID + "Additional log information about the deployment " + "\n\n" + logStream.toString());
                    }
                    deployURLIter = deployUrlList.iterator();
                    ** while (deployURLIter.hasNext())
                }
            }
lbl-1000:
            // 1 sources

            {
                deployURL = (DeployURL)deployURLIter.next();
                if (deployURL == null || !deployURL.isTemporary() || !deployURL.getFile().exists()) continue;
                deployURL.getFile().delete();
                continue;
            }
lbl73:
            // 1 sources

            try {
                outStream.close();
                logStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            DeployThreadManager.getInstance().threadFinished(this);
            {
                break block23;
            }
            catch (Throwable var11_22) {
                var12_15 = null;
                if (logStream.size() > 0) {
                    DeployThread.deployTracer.userOut("deploy", 4, "\n" + this.myDeployID + "Additional log information about the deployment " + "\n\n" + logStream.toString());
                }
                deployURLIter = deployUrlList.iterator();
                ** while (deployURLIter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                deployURL = (DeployURL)deployURLIter.next();
                if (deployURL == null || !deployURL.isTemporary() || !deployURL.getFile().exists()) continue;
                deployURL.getFile().delete();
                continue;
            }
lbl94:
            // 1 sources

            try {
                outStream.close();
                logStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            DeployThreadManager.getInstance().threadFinished(this);
            throw var11_22;
        }
    }

    public DeploymentException getDeployException() {
        return this.myDeployException;
    }

    protected void setDeployException(DeploymentException exception) {
        this.myDeployException = exception;
    }

    /*
     * Loose catch block
     */
    private static DeployURL createDeployUrl(File sourceFile, String deployId) throws DeploymentException {
        DeployURL deployURL;
        block27: {
            IOException e2222;
            FilterOutputStream fileOutStr;
            BufferedInputStream fileInStr;
            block25: {
                deployURL = null;
                try {
                    deployURL = new DeployURL(sourceFile.toURL(), false);
                }
                catch (MalformedURLException ex) {
                    throw new DeploymentException("Could not build deploy url (MalformeURLException) ", (Throwable)ex);
                }
                File tempFile = null;
                fileInStr = null;
                fileOutStr = null;
                tempFile = File.createTempFile("temp", sourceFile.getName());
                fileInStr = new BufferedInputStream(new FileInputStream(sourceFile));
                fileOutStr = new BufferedOutputStream(new FileOutputStream(tempFile));
                byte[] fileTransferBytes = new byte[4096];
                int readBytes = -1;
                while ((readBytes = fileInStr.read(fileTransferBytes)) > -1) {
                    ((BufferedOutputStream)fileOutStr).write(fileTransferBytes, 0, readBytes);
                }
                tempFile.deleteOnExit();
                deployURL.setURL(tempFile.toURL(), true);
                deployTracer.userOut("deploy", 4, "\n" + deployId + "Created a temporary copy : " + sourceFile.getName() + "\nThe url of the temporary copy (which will be deployed) is " + deployURL.getURL().toExternalForm() + "\nThe copy will be deleted again after deployment.");
                Object var9_11 = null;
                if (fileOutStr == null) break block25;
                try {
                    fileOutStr.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (fileInStr != null) {
                try {
                    fileInStr.close();
                }
                catch (IOException e2222) {}
            }
            break block27;
            {
                catch (FileNotFoundException ex) {
                    IOException e2222;
                    deployTracer.userOut("deploy", 3, "\n" + deployId + "Got a file not found exception when trying to create a temporary copy : " + sourceFile.getName() + "\nThe error log contains detailed information about the exception." + "\n --> Deploying the original archive now.");
                    deployTracer.error("Got an exception when creating the archive copy.", (Throwable)ex);
                    Object var9_12 = null;
                    if (fileOutStr != null) {
                        try {
                            fileOutStr.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fileInStr != null) {
                        try {
                            fileInStr.close();
                        }
                        catch (IOException e2222) {}
                    }
                    break block27;
                }
                catch (IOException ex) {
                    IOException e2222;
                    deployTracer.userOut("deploy", 3, "\n" + deployId + "Got an i/o exception when trying to create a temporary copy : " + sourceFile.getName() + "\nThe error log contains detailed information about the exception." + "\n --> Deploying the original archive now.");
                    deployTracer.error("Got an exception when creating the archive copy.", (Throwable)ex);
                    Object var9_13 = null;
                    if (fileOutStr != null) {
                        try {
                            fileOutStr.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (fileInStr != null) {
                        try {
                            fileInStr.close();
                        }
                        catch (IOException e2222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e2222;
                Object var9_14 = null;
                if (fileOutStr != null) {
                    try {
                        fileOutStr.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (fileInStr != null) {
                    try {
                        fileInStr.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return deployURL;
    }
}

