/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.sdm.internal;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.sdm.ISDMManagerCallback;
import com.sap.sdm.api.remote.Client;
import com.sap.sdm.api.remote.ClientSession;
import com.sap.sdm.api.remote.ClientSessionFactory;
import com.sap.sdm.api.remote.DeployItem;
import com.sap.sdm.api.remote.Param;
import com.sap.sdm.api.remote.RemoteException;
import com.sap.sdm.api.remote.SDMConfig;
import com.sap.sdm.api.remote.ServerType;
import com.sap.sdm.api.remote.TargetSystem;
import com.sap.sdm.api.remote.WrongPasswordException;
import com.sap.sdm.api.remote.deployresults.Aborted;
import com.sap.sdm.api.remote.deployresults.NotExecuted;
import com.sap.sdm.api.remote.deployresults.Success;
import com.sap.sdm.api.remote.deployresults.Warning;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.util.trace.TracerI;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SDMConnector {
    private ISDMManagerCallback sdmCallback;
    private PasswordHolder passwordHolder;

    public SDMConnector(ISDMManagerCallback callback) {
        this.sdmCallback = callback;
        this.passwordHolder = new PasswordHolder();
        EnginePlugin.getDefault().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("MsgSrvHost") || event.getProperty().equals("MsgSrvPort")) {
                    SDMConnector.this.passwordHolder.reset();
                }
            }
        });
    }

    public synchronized boolean pingSDM(PrintStream out) {
        String host = this.getHost();
        String port = this.getPort();
        out.println("Trying to call SDM ");
        out.println(" ==> Host is : " + host);
        out.println(" ==> Port is : " + port);
        int portNum = 0;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (NumberFormatException nex) {
            out.println(" ERROR: could not convert port number !");
            out.println(" ==> Message : " + nex.getMessage());
            return false;
        }
        ClientSession session = null;
        try {
            session = this.createClientSession(portNum, host, null);
            if (session == null) {
                out.println(" ERROR: session could not be created (due to incorrect sdm password) !");
                return false;
            }
        }
        catch (RemoteException apiE1) {
            out.println(" ERROR: got a remote exception when creating remote client session !");
            out.println(" ==> Message : " + apiE1.getMessage());
            return false;
        }
        out.println(" ==> Remote session succesfully created !");
        try {
            int target;
            Client client = null;
            try {
                client = session.getClient();
            }
            catch (RemoteException apiE2) {
                out.println(" ERROR: got a remote exception when retrieving client from session session !");
                out.println(" ==> Message : " + apiE2.getMessage());
                boolean bl = false;
                Object var13_17 = null;
                try {
                    session.closeSession();
                    out.println(" ==> Session was closed !");
                }
                catch (RemoteException apiE52) {
                    out.println(" ERROR: got a remote exception when closing session !");
                    out.println(" ==> Message : " + apiE52.getMessage());
                    return false;
                }
                return bl;
            }
            out.println(" ==> Client succesfully retrieved from session !");
            SDMConfig sdmConfig = null;
            try {
                sdmConfig = client.getSDMConfiguration();
            }
            catch (RemoteException apiE3) {
                out.println(" ERROR: got a remote exception when retrieving SDM configuration from client !");
                out.println(" ==> Message : " + apiE3.getMessage());
                boolean bl = false;
                Object var13_18 = null;
                try {
                    session.closeSession();
                    out.println(" ==> Session was closed !");
                }
                catch (RemoteException apiE52) {
                    out.println(" ERROR: got a remote exception when closing session !");
                    out.println(" ==> Message : " + apiE52.getMessage());
                    return false;
                }
                return bl;
            }
            out.println(" ==> SDM configuration succesfully retrieved from client !");
            out.println(" ==> server types of SDM configuration !");
            try {
                ServerType[] serverTypeArr = sdmConfig.getServerTypes();
                int server = 0;
                while (server < serverTypeArr.length) {
                    ServerType serverType = serverTypeArr[server];
                    out.println("    -> " + serverType.getName() + " (" + serverType.getDescription() + ")");
                    ++server;
                }
            }
            catch (RemoteException apiE4) {
                out.println(" ERROR: got a remote exception when retrieving server types from SDM configuration !");
                out.println(" ==> Message : " + apiE4.getMessage());
                boolean server = false;
                Object var13_19 = null;
                try {
                    session.closeSession();
                    out.println(" ==> Session was closed !");
                }
                catch (RemoteException apiE52) {
                    out.println(" ERROR: got a remote exception when closing session !");
                    out.println(" ==> Message : " + apiE52.getMessage());
                    return false;
                }
                return server;
            }
            out.println(" ==> target systems of SDM configuration !");
            try {
                TargetSystem[] targetSystemArr = sdmConfig.getTargetSystemContainer().getTargetSystems();
                target = 0;
                while (target < targetSystemArr.length) {
                    TargetSystem targetSystem = targetSystemArr[target];
                    out.println("    -> " + targetSystem.getID() + " (" + targetSystem.getDescription() + ")");
                    ServerType serverType = targetSystem.getType();
                    if (serverType != null) {
                        out.println("       " + serverType.getName() + " (" + serverType.getDescription() + ")");
                    }
                    ++target;
                }
            }
            catch (RemoteException apiE4) {
                out.println(" ERROR: got a remote exception when retrieving target system from SDM configuration !");
                out.println(" ==> Message : " + apiE4.getMessage());
                target = 0;
                Object var13_20 = null;
                try {
                    session.closeSession();
                    out.println(" ==> Session was closed !");
                }
                catch (RemoteException apiE52) {
                    out.println(" ERROR: got a remote exception when closing session !");
                    out.println(" ==> Message : " + apiE52.getMessage());
                    return false;
                }
                return target != 0;
            }
            out.println(" ==> substitution variables of SDM configuration !");
            try {
                Param[] params = sdmConfig.getSubstVarContainer().getParams();
                int par = 0;
                while (par < params.length) {
                    Param param = params[par];
                    out.println("    -> " + param.getName() + " (" + (param.getType() != null ? param.getType().getTypeAsString() : "type = null") + ") = " + (param.getValueObject() != null ? param.getValueObject().toString() : "null"));
                    ++par;
                }
            }
            catch (RemoteException apiE5) {
                out.println(" ERROR: got a remote exception when retrieving substitution variables from SDM configuration !");
                out.println(" ==> Message : " + apiE5.getMessage());
                boolean bl = false;
                Object var13_21 = null;
                try {
                    session.closeSession();
                    out.println(" ==> Session was closed !");
                }
                catch (RemoteException apiE52) {
                    out.println(" ERROR: got a remote exception when closing session !");
                    out.println(" ==> Message : " + apiE52.getMessage());
                    return false;
                }
                return bl;
            }
            Object var13_22 = null;
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            try {
                session.closeSession();
                out.println(" ==> Session was closed !");
            }
            catch (RemoteException apiE52) {
                out.println(" ERROR: got a remote exception when closing session !");
                out.println(" ==> Message : " + apiE52.getMessage());
                return false;
            }
            throw throwable;
        }
        try {
            session.closeSession();
            out.println(" ==> Session was closed !");
        }
        catch (RemoteException apiE52) {
            out.println(" ERROR: got a remote exception when closing session !");
            out.println(" ==> Message : " + apiE52.getMessage());
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deploySDAs(URL[] urls, PrintStream out, PrintStream log, TracerI tracer) throws DeploymentException {
        throwWarningException = false;
        if (this.getHost().equals("")) {
            throw new DeploymentException("Cannot determine sdm host (is empty). Please configure your engine/sdm correctly !");
        }
        if (this.getPort().equals("")) {
            throw new DeploymentException("Cannot determine sdm port (is empty). Please configure your engine/sdm correctly !");
        }
        heading = "\n\nSettings\nSDM host : " + this.getHost() + "\nSDM port : " + this.getPort();
        u = 0;
        while (true) {
            if (u >= urls.length) {
                tracer.info(heading);
                out.println(heading);
                portNum = 0;
                ** try [egrp 0[TRYBLOCK] [0 : 149->161)] { 
lbl14:
                // 1 sources

                break;
            }
            heading = heading + "\nURL to deploy : " + urls[u].toString();
            ++u;
        }
        {
            portNum = Integer.parseInt(this.getPort());
        }
lbl20:
        // 1 sources

        catch (NumberFormatException nex) {
            tracer.error("Cannot convert port number", (Throwable)nex);
            throw new DeploymentException("Cannot convert port number: " + nex.getMessage());
        }
        session = null;
        try {
            session = this.createClientSession(portNum, this.getHost(), tracer);
            if (session == null) {
                errorMessage = "Session could not be created due to incorrect sdm passwort !";
                tracer.error(errorMessage);
                throw new DeploymentException(errorMessage);
            }
        }
        catch (RemoteException ex) {
            tracer.error("Got remote exception when creating session", (Throwable)ex);
            throw new DeploymentException((Throwable)ex);
        }
        tracer.info(" ==> Remote session succesfully created !");
        try {
            block40: {
                client = null;
                try {
                    client = session.getClient();
                }
                catch (RemoteException ex) {
                    tracer.error("Got exception when retrieving client from session", (Throwable)ex);
                    throw new DeploymentException((Throwable)ex);
                }
                tracer.info(" ==> Client succesfully retrieved from session !");
                try {
                    helperFac = client.getHelperFactory();
                    deployProc = client.getDeployProcessor();
                    deployItems = new DeployItem[urls.length];
                    try {
                        u = 0;
                        while (u < urls.length) {
                            deployItems[u] = helperFac.createDeployItem(new File(urls[u].getFile()));
                            tracer.info("   --> Created deploy item for " + urls.toString());
                            ++u;
                        }
                    }
                    catch (IOException ex) {
                        tracer.error("Got an i/o exception when building the deploy item ", (Throwable)ex);
                        throw new DeploymentException((Throwable)ex);
                    }
                    deployProc.deploy(deployItems);
                    out.println("\nResult");
                    i = 0;
                    while (i < deployItems.length) {
                        deployResult = deployItems[i].getDeployResult();
                        if (deployResult.getType() instanceof Success) {
                            msg = "=> successfully deployed : " + urls[i].toString();
                            tracer.info(msg);
                            out.println(msg);
                        } else {
                            if (deployResult.getType() instanceof Aborted) {
                                msg = "=> deployment aborted : " + urls[i].toString() + "\n" + deployResult.getResultText();
                                tracer.warning(msg);
                                out.println(msg);
                                throw new DeploymentException("The deployment of at least one item aborted");
                            }
                            if (deployResult.getType() instanceof Warning) {
                                msg = "=> deployed with warning : " + urls[i].toString() + "\n" + deployResult.getResultText();
                                tracer.warning(msg);
                                out.println(msg);
                                throwWarningException = true;
                            } else if (deployResult.getType() instanceof NotExecuted) {
                                msg = "=> deployment not executed : " + urls[i].toString() + "\n" + deployResult.getResultText();
                                tracer.warning(msg);
                                out.println(msg);
                                throwWarningException = true;
                            }
                        }
                        ++i;
                    }
                }
                catch (RemoteException ex) {
                    tracer.error("Got exception when deploying items", (Throwable)ex);
                    throw new DeploymentException((Throwable)ex);
                }
                catch (RuntimeException ex) {
                    tracer.error("Got a runtime exception when deploying items", (Throwable)ex);
                    throw new DeploymentException((Throwable)ex);
                }
                var18_24 = null;
                if (log == null) break block40;
                {
                    catch (Throwable var17_36) {
                        var18_25 = null;
                        if (log == null) throw var17_36;
                        try {
                            clientLog = client.getLog();
                            logs = clientLog.getAsStrings();
                            i = 0;
                            while (true) {
                                if (i >= logs.length) {
                                    throw var17_36;
                                }
                                log.println(logs[i]);
                                ++i;
                            }
                        }
                        catch (RemoteException ex) {
                            tracer.error("Got remote exception when retrieving deploy log", (Throwable)ex);
                            throw var17_36;
                        }
                        catch (IOException ex) {
                            tracer.error("Got an i/o exception when retrieving deploy log", (Throwable)ex);
                            throw var17_36;
                        }
                    }
                    ** try [egrp 7[TRYBLOCK] [7, 8 : 851->898)] { 
lbl119:
                    // 1 sources

                    clientLog = client.getLog();
                    logs = clientLog.getAsStrings();
                    i = 0;
                    while (i < logs.length) {
                        log.println(logs[i]);
                        ++i;
                    }
lbl127:
                    // 1 sources

                    catch (RemoteException ex) {
                        tracer.error("Got remote exception when retrieving deploy log", (Throwable)ex);
                    }
lbl130:
                    // 1 sources

                    catch (IOException ex) {}
                    tracer.error("Got an i/o exception when retrieving deploy log", (Throwable)ex);
                }
            }
            if (throwWarningException) {
                ex = new DeploymentException("Got problems during deployment");
                ex.setOnlyWarning(true);
                throw ex;
            }
            var23_37 = null;
            if (session == null) return;
        }
        catch (Throwable var22_41) {
            var23_38 = null;
            if (session == null) throw var22_41;
            try {
                session.closeSession();
                tracer.info(" ==> Session was closed !");
                throw var22_41;
            }
            catch (RemoteException rex) {
                tracer.error("Got remote exception when closing session", (Throwable)rex);
            }
            throw var22_41;
        }
        try {}
        catch (RemoteException rex) {
            tracer.error("Got remote exception when closing session", (Throwable)rex);
            return;
        }
        session.closeSession();
        tracer.info(" ==> Session was closed !");
    }

    private ClientSession createClientSession(int sdmPort, String sdmHost, TracerI tracer) throws RemoteException {
        ClientSession session = null;
        while (session == null) {
            try {
                String sdmPassword;
                if (this.passwordHolder.isInitial()) {
                    sdmPassword = this.sdmCallback.getInitialPassword();
                    this.passwordHolder.setPassword(sdmPassword);
                } else {
                    sdmPassword = this.passwordHolder.getPassword();
                }
                session = ClientSessionFactory.createRemoteClientSessionIDE((int)sdmPort, (String)sdmHost, (String)sdmPassword);
            }
            catch (WrongPasswordException ex) {
                String newSdmPassword;
                if (tracer != null) {
                    tracer.userOut("deploy", 3, "\nWrong password for deployment : " + ex.getMessage());
                }
                if ((newSdmPassword = this.sdmCallback.getPassword(ex)) == null) {
                    return null;
                }
                this.passwordHolder.setPassword(newSdmPassword);
            }
        }
        return session;
    }

    private String getHost() {
        String host = EnginePlugin.getDefault().getSDMHost();
        return host;
    }

    private String getPort() {
        String port = EnginePlugin.getDefault().getSdmPort();
        return port;
    }

    private static class PasswordHolder {
        private String password = null;

        public boolean isInitial() {
            boolean initialFlag = this.password == null;
            return initialFlag;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public void reset() {
            this.password = null;
        }
    }
}

