/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.sdm;

import com.sap.ide.eclipse.sdm.DefaultCallback;
import com.sap.ide.eclipse.sdm.ISDMManagerCallback;
import com.sap.ide.eclipse.sdm.ISDMManagerListener;
import com.sap.ide.eclipse.sdm.internal.SDMConnector;
import com.sap.ide.eclipse.sdm.threading.DeployThreadManager;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.util.trace.TracerI;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;

public class SDMManager {
    public static final String DEPLOY_CATEGORY = "deploy";
    private SDMConnector sdmConnector;
    private static Hashtable instanceTable = new Hashtable();
    private static ISDMManagerCallback defaultCallback = new DefaultCallback();

    private SDMManager(ISDMManagerCallback callback) {
        this.sdmConnector = new SDMConnector(callback);
    }

    public static SDMManager getInstance() {
        return SDMManager.getInstance(defaultCallback);
    }

    public static SDMManager getInstance(ISDMManagerCallback callback) {
        SDMManager instance = (SDMManager)instanceTable.get(callback);
        if (instance == null) {
            instance = new SDMManager(callback);
            instanceTable.put(callback, instance);
        }
        return instance;
    }

    public boolean pingSDM(String host, String port, PrintStream out) {
        return this.sdmConnector.pingSDM(out);
    }

    public boolean pingSDM(PrintStream out) {
        return this.sdmConnector.pingSDM(out);
    }

    public void deployArchiveAsync(IFile archiveFile, TracerI tracer) throws DeploymentException {
        File realArchive = archiveFile.getLocation().toFile();
        this.deployArchiveAsync(realArchive, tracer);
    }

    public void deployArchivesAsync(IFile[] archiveFile, TracerI tracer) throws DeploymentException {
        File[] realArchives = new File[archiveFile.length];
        int a = 0;
        while (a < archiveFile.length) {
            realArchives[a] = archiveFile[a].getLocation().toFile();
            ++a;
        }
        this.deployArchivesAsync(realArchives, tracer);
    }

    public void deployArchiveAsync(File archiveFile, TracerI tracer) throws DeploymentException {
        DeployThreadManager dtm = DeployThreadManager.getInstance();
        if (!dtm.canDeploy(archiveFile)) {
            throw new DeploymentException("Deployment of archive file already running :" + archiveFile.getName());
        }
        dtm.deploy(archiveFile, tracer, this.sdmConnector, true);
    }

    public void deployArchivesAsync(File[] archiveFiles, TracerI tracer) throws DeploymentException {
        DeployThreadManager dtm = DeployThreadManager.getInstance();
        dtm.deploy(archiveFiles, tracer, this.sdmConnector, true);
    }

    public void deployArchive(IFile archiveFile, TracerI tracer) throws DeploymentException {
        File realArchive = archiveFile.getLocation().toFile();
        this.deployArchive(realArchive, tracer);
    }

    public void deployArchive(File archiveFile, TracerI tracer) throws DeploymentException {
        DeployThreadManager dtm = DeployThreadManager.getInstance();
        if (!dtm.canDeploy(archiveFile)) {
            throw new DeploymentException("Deployment of archive file already running :" + archiveFile.getName());
        }
        dtm.deploy(archiveFile, tracer, this.sdmConnector, false);
    }

    public boolean canDeployArchiveAsync(IFile archiveFile) {
        File realArchive = archiveFile.getLocation().toFile();
        return this.canDeployArchiveAsync(realArchive);
    }

    public boolean canDeployArchiveAsync(File archiveFile) {
        return DeployThreadManager.getInstance().canDeploy(archiveFile);
    }

    public boolean addListener(ISDMManagerListener listener) {
        return DeployThreadManager.getInstance().addListener(listener);
    }

    public boolean removeListener(ISDMManagerListener listener) {
        return DeployThreadManager.getInstance().removeListener(listener);
    }
}

