/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdGroup;
import com.sap.aii.util.xsd.api.XsdImport;
import com.sap.aii.util.xsd.api.XsdInclude;
import com.sap.aii.util.xsd.api.XsdNamespace;
import com.sap.aii.util.xsd.api.XsdNode;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XsdSchema
extends XsdNode {
    private static final long serialVersionUID = 42L;
    private static final String MSG_WRONG_VALUE_EFD = "MSG_WRONG_VALUE_EFD";
    private static final String MSG_WRONG_VALUE_AFD = "MSG_WRONG_VALUE_AFD";
    private boolean allNamespaceDeclarationsToSchema = false;
    private XsdNamespace targetNamespace = new XsdNamespace("", "");
    private String elementFormDefault = "unqualified";
    private String attributeFormDefault = "unqualified";
    private String version = null;
    private String language = null;
    private XNamespace languageNS = null;
    private List declaredNamespaces = new ArrayList();
    private List includes = new ArrayList();
    private List imports = new ArrayList();
    private List complexTypes = new ArrayList();
    private List simpleTypes = new ArrayList();
    private List elements = new ArrayList();
    private List attributes = new ArrayList();
    private List groups = new ArrayList();
    private List attributeGroups = new ArrayList();

    private void saveIncludes(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.includes.size()) {
            XsdInclude incl = (XsdInclude)this.includes.get(i);
            incl.save(parent);
            ++i;
        }
    }

    private void saveImports(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.imports.size()) {
            XsdImport imp = (XsdImport)this.imports.get(i);
            imp.save(parent);
            ++i;
        }
    }

    private void saveAttributes(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.attributes.size()) {
            XsdAttribute attr = (XsdAttribute)this.attributes.get(i);
            attr.save(parent);
            ++i;
        }
    }

    private void saveAttributeGroups(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.attributeGroups.size()) {
            XsdAttributeGroup attrGroup = (XsdAttributeGroup)this.attributeGroups.get(i);
            attrGroup.save(parent);
            ++i;
        }
    }

    private void saveElements(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.elements.size()) {
            XsdElement elem = (XsdElement)this.elements.get(i);
            elem.save(parent);
            ++i;
        }
    }

    private void saveGroups(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.groups.size()) {
            XsdGroup group = (XsdGroup)this.groups.get(i);
            group.save(parent);
            ++i;
        }
    }

    private void saveTypes(XElement parent) throws XsdException, XDOMException {
        int i = 0;
        while (i < this.simpleTypes.size()) {
            XsdSimpleType st = (XsdSimpleType)this.simpleTypes.get(i);
            st.save(parent);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.complexTypes.size()) {
            XsdComplexType ct = (XsdComplexType)this.complexTypes.get(i2);
            ct.save(parent);
            ++i2;
        }
    }

    protected XElement saveSpecificity(XElement parent) throws XsdException, XDOMException {
        XElement el = XsdNode.factory.newXElement(this.getXNameOfXsdNode("schema"));
        if (this.targetNamespace != null && !this.targetNamespace.getURI().equals("")) {
            XAttribute attrTargetNamespace = XsdNode.attributeFactory.newXAttribute("targetNamespace", this.targetNamespace.getURI());
            el.add(attrTargetNamespace);
        }
        if (!this.elementFormDefault.equals("unqualified")) {
            XAttribute attrElementFormDefault = XsdNode.attributeFactory.newXAttribute("elementFormDefault", this.elementFormDefault);
            el.add(attrElementFormDefault);
        }
        if (!this.attributeFormDefault.equals("unqualified")) {
            XAttribute attrAttributeFormDefault = XsdNode.attributeFactory.newXAttribute("attributeFormDefault", this.attributeFormDefault);
            el.add(attrAttributeFormDefault);
        }
        if (this.version != null) {
            XAttribute attrVersion = XsdNode.attributeFactory.newXAttribute("version", this.version);
            el.add(attrVersion);
        }
        if (this.language != null) {
            XAttribute attrLanguage = null;
            if (this.languageNS == null) {
                attrLanguage = XsdNode.attributeFactory.newXAttribute("lang", this.language);
            } else {
                XName xName = XsdNode.attributeFactory.newXName("lang", this.languageNS);
                attrLanguage = XsdNode.attributeFactory.newXAttribute(xName, this.language);
            }
            el.add(attrLanguage);
        }
        if (this.allNamespaceDeclarationsToSchema) {
            int i = 0;
            while (i < this.declaredNamespaces.size()) {
                XsdNamespace ns = (XsdNamespace)this.declaredNamespaces.get(i);
                XNamespace xNS = XsdNode.factory.newXNamespace(ns.getPrefix(), ns.getURI());
                el.add(xNS);
                ++i;
            }
        } else {
            this.addDefaultAndXsdMamespaces(el);
        }
        this.saveIncludes(el);
        this.saveImports(el);
        this.saveAttributes(el);
        this.saveElements(el);
        this.saveAttributeGroups(el);
        this.saveGroups(el);
        this.saveTypes(el);
        return el;
    }

    protected XElement addDefaultAndXsdMamespaces(XElement element) {
        XsdNamespace nsXSD;
        XsdNamespace nsDefault = this.getNamespaceByPrefix("");
        if (nsDefault != null) {
            XNamespace xNSDefault = XsdNode.factory.newXNamespace("", nsDefault.getURI());
            element.add(xNSDefault);
        }
        if ((nsXSD = this.getNamespaceDeclaration("xsd")) != null) {
            XNamespace xNSXSD = XsdNode.factory.newXNamespace("xsd", nsXSD.getURI());
            element.add(xNSXSD);
        }
        return element;
    }

    protected void loadSpecificity(XElement element, XsdSchema schema, XsdNode parent) throws XsdException {
        List allNs = element.getAllNamespaces();
        int i = 0;
        while (i < allNs.size()) {
            XNamespace ns = (XNamespace)allNs.get(i);
            if (ns != null) {
                this.addNamespace(new XsdQName("", ns.getURI(), ns.getPrefix()));
            }
            ++i;
        }
        List attributes = element.getAttributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            XNamespace xnsXML;
            XAttribute attribute = (XAttribute)iter.next();
            String localName = attribute.getLocalName();
            XNamespace xns = attribute.getName().getNamespace();
            if (xns.equals(xnsXML = XsdNode.factory.newXNamespace("http://www.w3.org/XML/1998/namespace")) && localName.equals("lang")) {
                this.setLanguage(attribute.getValue());
                this.languageNS = xns;
                continue;
            }
            if (!this.isSchemaNamespace(attribute)) continue;
            if (attribute.getLocalName().equals("id")) {
                this.setId(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("targetNamespace")) {
                this.setTargetNamespaceUri(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("elementFormDefault")) {
                this.setElementFormDefault(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("attributeFormDefault")) {
                this.setAttributeFormDefault(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("version")) {
                this.setVersion(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("lang")) {
                this.setLanguage(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("blockDefault")) {
                this.throwException(attribute, 1);
                continue;
            }
            if (attribute.getLocalName().equals("finalDefault")) {
                this.throwException(attribute, 1);
                continue;
            }
            this.throwNotAllowedAttributeException(attribute, 2);
        }
    }

    protected Set getAllowedParents() {
        return null;
    }

    public XsdSchema() {
        super(null);
        XsdNamespace schemaNamespace = new XsdNamespace();
        schemaNamespace.setPrefix("xsd");
        schemaNamespace.setURI("http://www.w3.org/2001/XMLSchema");
        this.addNamespace(schemaNamespace);
    }

    public XsdTypeDef getGlobalType(XsdQName typeName, boolean unused) {
        XsdTypeDef ret = null;
        return ret;
    }

    public void addTypeDef(XsdTypeDef typeDef) {
        if (typeDef instanceof XsdSimpleType) {
            typeDef.setParent(this);
            this.simpleTypes.add(typeDef);
        } else if (typeDef instanceof XsdComplexType) {
            this.complexTypes.add(typeDef);
            typeDef.setParent(this);
        }
    }

    public void removeTypeDef() {
        this.complexTypes.clear();
        this.simpleTypes.clear();
    }

    public List addElement(XsdElement element) {
        if (element == null) {
            return this.elements;
        }
        element.setParent(this);
        this.elements.add(element);
        return this.elements;
    }

    public List addImport(XsdImport imp) {
        String uri;
        if (imp == null) {
            return this.imports;
        }
        String schemaLocation = imp.getSchemaLocation();
        if (schemaLocation == null) {
            schemaLocation = "";
        }
        if ((uri = imp.getNamespaceUri()) == null) {
            uri = "";
        }
        boolean exists = false;
        int i = 0;
        while (i < this.imports.size()) {
            XsdImport item = (XsdImport)this.imports.get(i);
            if (uri.equals(item.getNamespaceUri()) && schemaLocation.equals(item.getSchemaLocation())) {
                exists = true;
            }
            ++i;
        }
        if (!exists) {
            imp.setParent(this);
            this.imports.add(imp);
            String prefix = this.addNamespace(imp.getNamespace());
            if (prefix != null && !imp.getNamespacePrefix().equals(prefix)) {
                imp.setNamespacePrefix(prefix);
            }
        }
        return this.imports;
    }

    public List getImportList() {
        return this.imports;
    }

    public List removeImport(XsdImport imp) {
        if (imp == null) {
            return this.imports;
        }
        int i = 0;
        while (i < this.imports.size()) {
            XsdImport item = (XsdImport)this.imports.get(i);
            if (item == imp) {
                this.imports.remove(i);
                break;
            }
            ++i;
        }
        return this.imports;
    }

    public List addInclude(XsdInclude incl) {
        String schemaLocation = incl.getSchemaLocation();
        if (schemaLocation == null) {
            schemaLocation = "";
        }
        boolean exists = false;
        int i = 0;
        while (i < this.includes.size()) {
            XsdInclude item = (XsdInclude)this.includes.get(i);
            if (item.getSchemaLocation().equals(schemaLocation)) {
                exists = true;
            }
            ++i;
        }
        if (!exists) {
            incl.setParent(this);
            this.includes.add(incl);
        }
        return this.includes;
    }

    public List getIncludeList() {
        return this.includes;
    }

    public List removeInclude(XsdInclude incl) {
        if (incl == null) {
            return this.includes;
        }
        int i = 0;
        while (i < this.includes.size()) {
            XsdInclude item = (XsdInclude)this.includes.get(i);
            if (item == incl) {
                this.includes.remove(i);
                break;
            }
            ++i;
        }
        return this.includes;
    }

    public List getComplexTypes() {
        return this.complexTypes;
    }

    public List getSimpleTypes() {
        return this.simpleTypes;
    }

    public List getElements() {
        return this.elements;
    }

    public List getAttributeGroups() {
        return this.attributeGroups;
    }

    public List getGroups() {
        return this.groups;
    }

    public void setTargetNamespaceUri(String targetNsUri) {
        if (targetNsUri == null) {
            return;
        }
        if (this.targetNamespace == null || this.targetNamespace.getURI().equals("")) {
            if (this.targetNamespace == null) {
                this.targetNamespace = new XsdNamespace();
            }
            if (targetNsUri.equals(this.targetNamespace.getURI())) {
                return;
            }
            this.targetNamespace.setURI(targetNsUri);
            this.targetNamespace.setPrefix("");
            String prefix = this.addNamespace(this.targetNamespace);
            if (prefix != null && !this.targetNamespace.getPrefix().equals(prefix)) {
                this.targetNamespace.setPrefix(prefix);
                return;
            }
            if (prefix != null && this.targetNamespace.getPrefix().equals(prefix)) {
                this.targetNamespace = this.getNamespaceByPrefix(prefix);
                return;
            }
        }
        this.targetNamespace.setURI(targetNsUri);
    }

    public XsdNamespace getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetNamespaceUri() {
        if (this.targetNamespace == null) {
            return "";
        }
        return this.targetNamespace.getURI();
    }

    public String getTargetNamespacePrefix() {
        if (this.targetNamespace == null) {
            return "";
        }
        return this.targetNamespace.getPrefix();
    }

    public void setLanguage(String language) {
        this.language = language;
        this.languageNS = XsdNode.factory.newXNamespace("http://www.w3.org/XML/1998/namespace");
    }

    public String getLanguage() {
        return this.language;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setElementFormDefault(String elementFormDefault) throws XsdException {
        if (!elementFormDefault.equals("qualified") && !elementFormDefault.equals("unqualified")) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_EFD", (Object)elementFormDefault));
        }
        this.elementFormDefault = elementFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setAttributeFormDefault(String attributeFormDefault) throws XsdException {
        if (!attributeFormDefault.equals("qualified") && !attributeFormDefault.equals("unqualified")) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_AFD", (Object)attributeFormDefault));
        }
        this.attributeFormDefault = attributeFormDefault;
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public List addGroup(XsdParticle group) {
        if (group == null) {
            return this.groups;
        }
        group.setParent(this);
        this.groups.add(group);
        return this.groups;
    }

    public List addAttributeGroup(XsdAttributeGroup attributeGroup) {
        if (attributeGroup == null) {
            return this.attributeGroups;
        }
        attributeGroup.setParent(this);
        this.attributeGroups.add(attributeGroup);
        return this.attributeGroups;
    }

    public List addAttribute(XsdAttribute attribute) {
        if (attribute == null) {
            return this.attributes;
        }
        attribute.setParent(this);
        this.attributes.add(attribute);
        return this.attributes;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public String addNamespace(XsdQName qName) {
        if (qName == null) {
            return null;
        }
        return this.addNamespace(qName.getNamespace());
    }

    public void setDefaultNamespace(String uri) {
        if (uri == null) {
            return;
        }
        XsdNamespace ns = this.getNamespaceByPrefix("");
        if (ns == null) {
            ns = new XsdNamespace("", uri);
            this.addNamespace(ns);
            return;
        }
        ns.setURI(uri);
    }

    public String addNamespace(XsdNamespace namespace) {
        String uri;
        if (namespace == null) {
            return null;
        }
        String prefix = namespace.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = namespace.getURI()) == null) {
            uri = "";
        }
        if (uri.equals("")) {
            return prefix;
        }
        int i = 0;
        while (i < this.declaredNamespaces.size()) {
            if (((XsdNamespace)this.declaredNamespaces.get(i)).getURI().equals(uri)) {
                return ((XsdNamespace)this.declaredNamespaces.get(i)).getPrefix();
            }
            ++i;
        }
        if (this.declaredNamespaces.size() > 0) {
            boolean exist;
            int count = 0;
            block1: do {
                exist = false;
                int i2 = 0;
                while (i2 < this.declaredNamespaces.size()) {
                    if (((XsdNamespace)this.declaredNamespaces.get(i2)).getPrefix().equals(prefix)) {
                        prefix = "p" + count;
                        ++count;
                        exist = true;
                        continue block1;
                    }
                    ++i2;
                }
            } while (exist);
        }
        namespace.setPrefix(prefix);
        this.declaredNamespaces.add(namespace);
        return prefix;
    }

    public List getNamespaceDeclarations() {
        return this.declaredNamespaces;
    }

    public XsdNamespace getNamespaceDeclaration(String uri) {
        if (uri == null) {
            uri = "";
        }
        int i = 0;
        while (i < this.declaredNamespaces.size()) {
            if (((XsdNamespace)this.declaredNamespaces.get(i)).getURI().equals(uri)) {
                return (XsdNamespace)this.declaredNamespaces.get(i);
            }
            ++i;
        }
        return null;
    }

    public XsdNamespace getNamespaceByPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        int i = 0;
        while (i < this.declaredNamespaces.size()) {
            if (((XsdNamespace)this.declaredNamespaces.get(i)).getPrefix().equals(prefix)) {
                return (XsdNamespace)this.declaredNamespaces.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isAllNamespaceDeclarationsToSchema() {
        return this.allNamespaceDeclarationsToSchema;
    }

    public void setAllNamespaceDeclarationsToSchema(boolean allNamespaceDeclarationsToSchema) {
        this.allNamespaceDeclarationsToSchema = allNamespaceDeclarationsToSchema;
    }
}

