/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xsd.api.IXsdConstants;
import com.sap.aii.util.xsd.api.XsdNamespace;
import java.io.Serializable;

public class XsdQName
implements IXsdConstants,
Serializable {
    private static final long serialVersionUID = 42L;
    private XsdNamespace namespace = new XsdNamespace();
    private String localName = "";

    public XsdQName(String localName, XsdNamespace namespace) {
        this.localName = localName;
        this.namespace = namespace;
    }

    public XsdQName(String localName, String namespaceUri, String prefix) {
        this(localName, namespaceUri);
        this.namespace.setPrefix(prefix);
    }

    public XsdQName(String localName, String namespaceUri) {
        this.localName = localName;
        this.namespace.setURI(namespaceUri);
    }

    public XsdQName(String prefixedName, XElement element) {
        this.localName = XsdQName.getLocalName(prefixedName);
        this.namespace.setURI(XsdQName.getNamespace(prefixedName, element));
        this.namespace.setPrefix(XsdQName.getPrefix(prefixedName));
    }

    public void setNamespaceUri(String namespaceUri) {
        if (this.namespace == null) {
            return;
        }
        this.namespace.setURI(namespaceUri);
    }

    public String getNamespaceUri() {
        return this.namespace.getURI();
    }

    public XsdNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(XsdNamespace ns) {
        this.namespace = ns;
    }

    public void setLocalname(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setPrefix(String prefix) {
        if (this.namespace == null) {
            return;
        }
        this.namespace.setPrefix(prefix);
    }

    public String getPrefix() {
        return this.namespace.getPrefix();
    }

    public String toString() {
        StringBuffer string;
        if (this.namespace.getURI() == null || this.namespace.getURI().equals("")) {
            string = new StringBuffer();
        } else {
            string = new StringBuffer(this.namespace.getURI());
            string.append(":");
        }
        string.append(this.localName);
        return string.toString();
    }

    public String getResolvedName() {
        StringBuffer string = new StringBuffer(this.namespace.getURI());
        if (string != null) {
            string.append(":");
        }
        string.append(this.localName);
        return string.toString();
    }

    public String getPrefixedName() {
        StringBuffer string = new StringBuffer();
        if (this.namespace == null) {
            return null;
        }
        if (this.namespace.getPrefix() != null && !this.namespace.getPrefix().equals("")) {
            string.append(this.namespace.getPrefix());
            string.append(":");
        }
        string.append(this.localName);
        return string.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XsdQName) {
            XsdQName qName = (XsdQName)o;
            boolean b_Name = this.compareString(qName.getLocalName(), this.localName);
            boolean b_Namespace = this.compareString(qName.getNamespaceUri(), this.namespace.getURI());
            return b_Name && b_Namespace;
        }
        return false;
    }

    private boolean compareString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public int hashCode() {
        return (this.localName + this.namespace.getURI()).hashCode();
    }

    public static String getLocalName(String prefixedName) {
        int colon = prefixedName.indexOf(":");
        if (colon == -1) {
            return prefixedName;
        }
        return prefixedName.substring(colon + 1);
    }

    public static String getNamespace(String prefixedName, XElement element) {
        XNamespace ns = element.getNamespace(XsdQName.getPrefix(prefixedName));
        if (ns != null) {
            return ns.getURI();
        }
        return null;
    }

    public static String getPrefix(String prefixedName) {
        int colon = prefixedName.indexOf(":");
        if (colon == -1) {
            return "";
        }
        return prefixedName.substring(0, colon);
    }

    public boolean isInSchemaNamespace() {
        boolean result = this.namespace.getURI().equals("http://www.w3.org/2000/10/XMLSchema");
        if (!result) {
            result = this.namespace.getURI().equals("http://www.w3.org/2001/XMLSchema");
        }
        return result;
    }
}

