/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xsd.api.IXsdConstants;
import com.sap.aii.util.xsd.api.XsdAdditionalAttribute;
import com.sap.aii.util.xsd.api.XsdAnnotation;
import com.sap.aii.util.xsd.api.XsdAppinfo;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdDocumentation;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdExtension;
import com.sap.aii.util.xsd.api.XsdGroup;
import com.sap.aii.util.xsd.api.XsdNamespace;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class XsdNode
implements IXsdConstants,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final String MSG_NODE_PARSING_ERROR = "MSG_NODE_PARSING_ERROR";
    private static final String MSG_XSD_NAMESPACE = "MSG_XSD_NAMESPACE";
    private static final String MSG_EMPTY_URI = "MSG_EMPTY_URI";
    private static final String MSG_TAG_EXPECTED = "MSG_TAG_EXPECTED";
    private static final String MSG_TAG_NOT_ALLOWED = "MSG_TAG_NOT_ALLOWED";
    private static final String MSG_TAG_NOT_SUPPORTED = "MSG_TAG_NOT_SUPPORTED";
    private static final String MSG_ATTRIBUTE_EXPECTED = "MSG_ATTRIBUTE_EXPECTED";
    private static final String MSG_ATTRIBUTE_NOT_ALLOWED = "MSG_ATTRIBUTE_NOT_ALLOWED";
    private static final String MSG_ATTRIBUTE_NOT_SUPPORTED = "MSG_ATTRIBUTE_NOT_SUPPORTED";
    private XsdSchema schema = null;
    private XsdAnnotation annotation = null;
    private String id = null;
    private String name = "";
    private List additionalAttributes = new ArrayList();
    private XsdNode parent = null;
    private static final String classPath = "com.sap.aii.util.xsd.api.";
    protected static XDOMFactory factory = new XDOMFactory("http://www.w3.org/2001/XMLSchema");
    protected static XDOMFactory attributeFactory = new XDOMFactory("");
    protected static XNamespace xmlns = factory.newXNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static Map namespaceMap = null;
    private static Map tagMap = new TreeMap();
    private boolean stackExceptions = false;
    private List messageStack = new LinkedList();

    protected final XName getXNameOfXsdNode(String tag) {
        return factory.newXName(tag, xmlns);
    }

    protected XElement save(XElement parent) throws XsdException, XDOMException {
        XsdSchema s;
        XElement el = this.saveSpecificity(parent);
        if (this.id != null) {
            XAttribute attrId = attributeFactory.newXAttribute("id", this.id);
            el.add(attrId);
        }
        if (this.name != null && !this.name.equals("")) {
            XAttribute attrName = attributeFactory.newXAttribute("name", this.name);
            el.getAttributes().add(0, attrName);
        }
        int i = 0;
        while (i < this.additionalAttributes.size()) {
            if (this.additionalAttributes.get(i) instanceof XsdAdditionalAttribute) {
                XsdAdditionalAttribute addAttr = (XsdAdditionalAttribute)this.additionalAttributes.get(i);
                XNamespace xNs = factory.newXNamespace(addAttr.getNamespacePrefix(), addAttr.getNamespaceUri());
                XName xName = factory.newXName(addAttr.getLocalName(), xNs);
                XAttribute xAttr = factory.newXAttribute(xName, addAttr.getValue());
                el.add(xAttr);
            }
            ++i;
        }
        if (this.annotation != null) {
            this.annotation.save(el);
        }
        if (parent != null) {
            if (this instanceof XsdAnnotation) {
                parent.getMixedContent().add(0, el);
            } else {
                parent.add(el);
            }
        }
        if ((s = this.getSchema()) != null && !s.isAllNamespaceDeclarationsToSchema() && this.isGlobal()) {
            this.addCommonMamespaces(el);
        }
        return el;
    }

    protected abstract XElement saveSpecificity(XElement var1) throws XsdException, XDOMException;

    private XElement addCommonMamespaces(XElement element) {
        if (!(this instanceof XsdAttributeGroup || this instanceof XsdGroup || this instanceof XsdComplexType)) {
            return element;
        }
        if (this.schema == null) {
            return element;
        }
        int i = 0;
        while (i < this.schema.getNamespaceDeclarations().size()) {
            XsdNamespace ns = (XsdNamespace)this.schema.getNamespaceDeclarations().get(i);
            String prefix = ns.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (!prefix.equals("") && !prefix.equals("xsd")) {
                XNamespace xNS = factory.newXNamespace(ns.getPrefix(), ns.getURI());
                element.add(xNS);
            }
            ++i;
        }
        return element;
    }

    protected final XsdQName getQNameForRef(String typeName, XElement element) throws XsdException {
        XsdNamespace ns;
        if (typeName == null) {
            return new XsdQName("", "");
        }
        XsdQName qn = new XsdQName(typeName, element);
        String prefix = this.schema.addNamespace(qn);
        if (prefix != null && !qn.getPrefix().equals(prefix)) {
            qn.setPrefix(prefix);
        }
        if (prefix != null && this.getSchema() != null && (ns = this.getSchema().getNamespaceByPrefix(prefix)) != null) {
            qn.setNamespace(ns);
        }
        return qn;
    }

    protected String getPrefixedTypeName(XsdQName qName) throws XsdException {
        if (qName == null) {
            return "";
        }
        if (this.schema == null) {
            return null;
        }
        String prefix = this.schema.addNamespace(qName);
        if (prefix == null) {
            prefix = "";
        }
        qName.setPrefix(prefix);
        return qName.getPrefixedName();
    }

    protected boolean isSchemaNamespace(XAttribute attribute) throws XsdException {
        String uri = attribute.getName().getNamespace().getURI();
        if (uri == null) {
            uri = "";
        }
        if (uri.equals("http://www.w3.org/2000/10/XMLSchema") || uri.equals("http://www.w3.org/2001/XMLSchema")) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_XSD_NAMESPACE", (Object)attribute.getLocalName(), (Object)uri));
        }
        return uri.equals("") || uri.endsWith("http://www.w3.org/XML/1998/namespace");
    }

    protected void load(XElement element, XsdSchema schema, XsdNode parent) throws XsdException {
        if (!this.checkParent(parent)) {
            this.throwException(element, 2);
        }
        if (this instanceof XsdSchema) {
            schema = (XsdSchema)this;
        }
        this.schema = schema;
        this.parent = parent;
        List attributes = element.getAttributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            XAttribute attribute = (XAttribute)iter.next();
            if (this.isSchemaNamespace(attribute)) continue;
            this.addAdditionalAttribute(attribute);
        }
        this.loadSpecificity(element, schema, parent);
        XElement[] subElements = element.getSubElements();
        int i = 0;
        while (i < subElements.length) {
            String uri = subElements[i].getNamespace().getURI();
            if (uri == null || !uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2000/10/XMLSchema")) {
                this.loadNonXsdElement(subElements[i]);
            } else {
                XsdNode node = XsdNode.getXsdNodeFromXdomElement(subElements[i], schema, this);
            }
            ++i;
        }
    }

    private void loadNonXsdElement(XElement element) {
        if (!(this instanceof XsdAppinfo) && !(this instanceof XsdDocumentation)) {
            return;
        }
    }

    protected abstract Set getAllowedParents();

    private boolean checkParent(XsdNode parent) {
        Set allowedParents = this.getAllowedParents();
        if (this instanceof XsdSchema) {
            return parent == null;
        }
        return allowedParents.contains(parent.getClass());
    }

    protected abstract void loadSpecificity(XElement var1, XsdSchema var2, XsdNode var3) throws XsdException;

    protected static XsdNode getXsdNodeFromXdomElement(XElement element, XsdSchema schema, XsdNode parent) throws XsdException {
        String tag = element.getLocalName();
        String nodeClassName = classPath + (String)tagMap.get(tag);
        if (nodeClassName.equals(classPath)) {
            if (parent != null) {
                parent.throwException(element, 1);
            } else {
                new XsdElement().throwException(element, 1);
            }
        }
        XsdNode xsdNode = null;
        try {
            xsdNode = (XsdNode)Class.forName(nodeClassName).newInstance();
        }
        catch (Exception ex) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_NODE_PARSING_ERROR", (Object)nodeClassName, (Object)tag));
        }
        xsdNode.load(element, schema, parent);
        return xsdNode;
    }

    public void setStackException(boolean stackThem) {
        this.stackExceptions = stackThem;
    }

    public String[] getExceptionMessages(boolean print) {
        String[] ret = this.messageStack.toArray(new String[0]);
        if (print) {
            int i = 0;
            while (i < ret.length) {
                System.out.println(ret[i]);
                ++i;
            }
        }
        return ret;
    }

    protected void throwNotAllowedAttributeException(XAttribute attr, int errorMode) throws XsdException {
        this.throwException(attr, 2);
    }

    protected void throwException(XAttribute attr, int errorMode) throws XsdException {
        String location = this.getLocation(attr);
        BabelMessage babelMessage = null;
        switch (errorMode) {
            case 3: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_ATTRIBUTE_EXPECTED", (Object)attr.getLocalName(), (Object)location);
                break;
            }
            case 1: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_ATTRIBUTE_NOT_SUPPORTED", (Object)attr.getLocalName(), (Object)attr.getValue(), (Object)location);
                break;
            }
            case 2: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_ATTRIBUTE_NOT_ALLOWED", (Object)attr.getLocalName(), (Object)attr.getValue(), (Object)location);
            }
        }
        this.throwOrStackException(babelMessage);
    }

    private void throwOrStackException(BabelMessage babelMmessage) throws XsdException {
        if (!this.stackExceptions) {
            throw new XsdException(babelMmessage);
        }
        this.messageStack.add(babelMmessage.toString());
    }

    private String getLocation(XAttribute attr) {
        return this.getLocation(attr.getParent());
    }

    private String getLocation(XElement el) {
        if (el == null) {
            return "";
        }
        XElement parent = el.getParent();
        String elTag = "" + el.getName() + "";
        if (parent == null) {
            return elTag;
        }
        return this.getLocation(parent) + elTag;
    }

    protected void throwException(XElement el, int errorMode) throws XsdException {
        String location = this.getLocation(el);
        BabelMessage babelMessage = null;
        switch (errorMode) {
            case 3: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_TAG_EXPECTED", (Object)el.getLocalName(), (Object)location);
                break;
            }
            case 1: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_TAG_NOT_SUPPORTED", (Object)el.getLocalName(), (Object)location);
                break;
            }
            case 2: {
                babelMessage = new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_TAG_NOT_ALLOWED", (Object)el.getLocalName(), (Object)location);
            }
        }
        this.throwOrStackException(babelMessage);
    }

    protected XsdNode() {
    }

    public XsdNode(XsdSchema schema) {
        this.schema = schema;
    }

    public final List addAdditionalAttribute(XAttribute xAttribute) {
        if (xAttribute == null) {
            return this.additionalAttributes;
        }
        String name = xAttribute.getLocalName();
        XsdAdditionalAttribute attr = new XsdAdditionalAttribute(name, xAttribute.getName().getNamespace().getPrefix(), xAttribute.getName().getNamespace().getURI(), xAttribute.getValue());
        this.additionalAttributes.add(attr);
        return this.additionalAttributes;
    }

    protected final void setAdditionalAttributes(List additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public final List getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public final boolean isGlobal() {
        if (this.parent == null) {
            return false;
        }
        if (this.schema == null) {
            return false;
        }
        return this.parent.equals(this.schema);
    }

    public final XsdNode getParent() {
        return this.parent;
    }

    public final void setParent(XsdNode parent) {
        this.parent = parent;
    }

    public final XsdQName getQName() {
        XsdNamespace tns = null;
        if (this.schema != null) {
            tns = this.schema.getTargetNamespace();
        }
        if (tns == null) {
            tns = new XsdNamespace();
        }
        if (this.name == null) {
            this.name = "";
        }
        return new XsdQName(this.name, tns);
    }

    public final String getName() {
        return this.name;
    }

    public void setName(String localName) {
        if (localName == null) {
            localName = "";
        }
        this.name = localName;
    }

    public final XsdSchema getSchema() {
        return this.schema;
    }

    public final void setSchema(XsdSchema schema) {
        this.schema = schema;
    }

    public final XsdNamespace getNamespace() {
        if (this.schema != null) {
            return this.schema.getTargetNamespace();
        }
        return new XsdNamespace();
    }

    public void setAnnotation(XsdAnnotation annotation) {
        if (annotation != null) {
            annotation.setParent(this);
        }
        this.annotation = annotation;
    }

    public XsdAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getName();
    }

    protected XsdNode getGlobalParent(XsdNode node) {
        if (node == null) {
            return null;
        }
        if (node.isGlobal()) {
            return node;
        }
        XsdNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof XsdSchema) {
            return node;
        }
        return this.getGlobalParent(parent);
    }

    protected void processType(XsdNode node, XAttribute attribute, XElement element) throws XsdException {
        XsdQName qName = this.getQNameForRef(attribute.getValue(), element);
        if (node instanceof XsdElement) {
            ((XsdElement)node).setGlobalTypeName(qName);
        }
        if (node instanceof XsdAttribute) {
            ((XsdAttribute)node).setGlobalTypeName(qName);
        }
    }

    protected void processRef(XsdNode node, XAttribute attribute, XElement element) throws XsdException {
        XsdQName qName = this.getQNameForRef(attribute.getValue(), element);
        if (node instanceof XsdElement) {
            ((XsdElement)node).setRef(qName);
        }
        if (node instanceof XsdAttribute) {
            ((XsdAttribute)node).setRef(qName);
        }
        if (node instanceof XsdGroup) {
            ((XsdGroup)node).setRef(qName);
        }
        if (node instanceof XsdAttributeGroup) {
            ((XsdAttributeGroup)node).setRef(qName);
        }
    }

    protected void processBase(XsdNode node, XAttribute attribute, XElement element) throws XsdException {
        XsdQName qName = this.getQNameForRef(attribute.getValue(), element);
        if (node instanceof XsdExtension) {
            ((XsdExtension)node).setBaseType(qName);
        }
        if (node instanceof XsdRestriction) {
            ((XsdRestriction)node).setBaseType(qName);
        }
    }

    protected void processSubstitutionGroup(XsdNode node, XAttribute attribute, XElement element) throws XsdException {
        XsdQName qName = this.getQNameForRef(attribute.getValue(), element);
        if (node instanceof XsdElement) {
            ((XsdElement)node).setSubstitutionGroup(qName);
        }
    }

    protected void processTypeReference(XsdNode node, XAttribute attribute, XElement element) {
    }

    static {
        tagMap.put("schema", "XsdSchema");
        tagMap.put("include", "XsdInclude");
        tagMap.put("import", "XsdImport");
        tagMap.put("redefine", "");
        tagMap.put("simpleType", "XsdSimpleType");
        tagMap.put("complexType", "XsdComplexType");
        tagMap.put("group", "XsdGroup");
        tagMap.put("attributeGroup", "XsdAttributeGroup");
        tagMap.put("element", "XsdElement");
        tagMap.put("attribute", "XsdAttribute");
        tagMap.put("notation", "");
        tagMap.put("annotation", "XsdAnnotation");
        tagMap.put("sequence", "XsdSequence");
        tagMap.put("choice", "XsdChoice");
        tagMap.put("all", "XsdAll");
        tagMap.put("list", "");
        tagMap.put("union", "XsdUnion");
        tagMap.put("simpleContent", "XsdSimpleContent");
        tagMap.put("complexContent", "XsdComplexContent");
        tagMap.put("restriction", "XsdRestriction");
        tagMap.put("extension", "XsdExtension");
        tagMap.put("pattern", "XsdFacet");
        tagMap.put("maxExclusive", "XsdFacet");
        tagMap.put("minExclusive", "XsdFacet");
        tagMap.put("maxInclusive", "XsdFacet");
        tagMap.put("minInclusive", "XsdFacet");
        tagMap.put("length", "XsdFacet");
        tagMap.put("maxLength", "XsdFacet");
        tagMap.put("minLength", "XsdFacet");
        tagMap.put("precision", "XsdFacet");
        tagMap.put("scale", "XsdFacet");
        tagMap.put("enumeration", "XsdFacet");
        tagMap.put("totalDigits", "XsdFacet");
        tagMap.put("fractionDigits", "XsdFacet");
        tagMap.put("whiteSpace", "XsdFacet");
        tagMap.put("anyAttribute", "XsdAnyAttribute");
        tagMap.put("any", "XsdAny");
        tagMap.put("appinfo", "XsdAppinfo");
        tagMap.put("documentation", "XsdDocumentation");
        tagMap.put("unique", "");
        tagMap.put("key", "");
        tagMap.put("keyref", "");
    }
}

