/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.io.XDOMOutputter;
import com.sap.aii.util.xsd.api.IXsdConstants;
import com.sap.aii.util.xsd.api.XsdException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XsdHelper
implements IXsdConstants {
    private static final String MSG_WRONG_VALUE_OCCUARANCE = "MSG_WRONG_VALUE_OCCUARANCE";
    private static final String[] allFacets = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace", "maxInclusive", "maxExclusive", "minExclusive", "minInclusive", "totalDigits", "fractionDigits"};
    private static final String[] facetSet1 = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace"};
    private static final String[] facetSet5 = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace"};
    private static final String[] facetSet2 = new String[]{"pattern", "whiteSpace"};
    private static final String[] facetSet3 = new String[]{"pattern", "whiteSpace", "maxInclusive", "maxExclusive", "minExclusive", "minInclusive", "enumeration", "totalDigits", "fractionDigits"};
    private static final String[] facetSet4 = new String[]{"pattern", "enumeration", "whiteSpace", "maxInclusive", "maxExclusive", "minExclusive", "minInclusive"};
    private static final Map primitiveTypesFacetMap = new Hashtable();
    private static final List primitiveTypesList = new ArrayList();
    private static final Map derivedTypesFacetMap;
    private static final List derivedTypesList;
    private static final Set typeSet;

    public static int setOccurence(String value, boolean allowUnbounded) throws XsdException {
        int retVal;
        if (allowUnbounded && value.equals("unbounded")) {
            return -1;
        }
        try {
            Integer i = new Integer(value);
            retVal = i;
        }
        catch (NumberFormatException nfEx) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_OCCUARANCE", (Object)value));
        }
        return retVal;
    }

    public static String getOccurence(int value) {
        String ret = "";
        ret = value >= 0 ? Integer.toString(value) : "unbounded";
        return ret;
    }

    private static final void putPrimitiveType(String typeName, String[] facets) {
        primitiveTypesFacetMap.put(typeName, facets);
        primitiveTypesList.add(typeName);
    }

    private static final void putDerivedType(String typeName, String[] facets) {
        derivedTypesFacetMap.put(typeName, facets);
        derivedTypesList.add(typeName);
    }

    public static void setRestriction(Map facets, String name, String value) {
        facets.put(name, value);
    }

    public static String getRestriction(Map facets, String name) {
        return (String)facets.get(name);
    }

    public static String[] getAllowedFacets(String localXsdTypeName) {
        if (localXsdTypeName == null) {
            return allFacets;
        }
        String[] facetNames = (String[])primitiveTypesFacetMap.get(localXsdTypeName);
        if (facetNames == null) {
            facetNames = (String[])derivedTypesFacetMap.get(localXsdTypeName);
        }
        if (facetNames == null) {
            facetNames = new String[]{};
        }
        return facetNames;
    }

    private static final List getPrimitiveTypesList() {
        return Collections.unmodifiableList(primitiveTypesList);
    }

    private static final List getDerivedTypesList() {
        return Collections.unmodifiableList(derivedTypesList);
    }

    public static String[] getPrimitiveTypes() {
        return XsdHelper.getPrimitiveTypesList().toArray(new String[0]);
    }

    public static String[] getDerivedTypes() {
        return XsdHelper.getDerivedTypesList().toArray(new String[0]);
    }

    public static boolean isBaseType(String typeName) {
        return typeSet.contains(typeName);
    }

    private static final Set getTypeSet(boolean primitive, boolean derived) {
        HashSet ret = new HashSet();
        if (primitive) {
            ret.addAll(primitiveTypesList);
        }
        if (derived) {
            ret.addAll(derivedTypesList);
        }
        return ret;
    }

    private static String findSubstring(String data, String firstSeparator, String lastSeparator) {
        int pos1 = data.indexOf(firstSeparator);
        if (pos1 == -1) {
            return "";
        }
        int pos2 = data.indexOf(lastSeparator);
        if (pos2 == -1 || pos1 > pos2) {
            return null;
        }
        return data.substring(pos1, pos2 + 1);
    }

    protected static String getAnyContentAsString(XElement element) {
        if (element == null) {
            return "";
        }
        String name = element.getLocalName();
        if (!name.equals("appinfo") && !name.equals("documentation")) {
            return "";
        }
        try {
            XDOMOutputter builder = new XDOMOutputter("  ", true);
            String content = builder.write(element);
            return content;
        }
        catch (Exception ex) {
            return "";
        }
    }

    static {
        XsdHelper.putPrimitiveType("string", facetSet1);
        XsdHelper.putPrimitiveType("boolean", facetSet2);
        XsdHelper.putPrimitiveType("decimal", facetSet3);
        XsdHelper.putPrimitiveType("float", facetSet4);
        XsdHelper.putPrimitiveType("double", facetSet4);
        XsdHelper.putPrimitiveType("duration", facetSet4);
        XsdHelper.putPrimitiveType("dateTime", facetSet4);
        XsdHelper.putPrimitiveType("time", facetSet4);
        XsdHelper.putPrimitiveType("date", facetSet4);
        XsdHelper.putPrimitiveType("gYearMonth", facetSet4);
        XsdHelper.putPrimitiveType("gYear", facetSet4);
        XsdHelper.putPrimitiveType("gMonthDay", facetSet4);
        XsdHelper.putPrimitiveType("gDay", facetSet4);
        XsdHelper.putPrimitiveType("gMonth", facetSet4);
        XsdHelper.putPrimitiveType("hexBinary", facetSet1);
        XsdHelper.putPrimitiveType("base64Binary", facetSet1);
        XsdHelper.putPrimitiveType("anyURI", facetSet1);
        XsdHelper.putPrimitiveType("QName", facetSet1);
        XsdHelper.putPrimitiveType("NOTATION", facetSet1);
        derivedTypesFacetMap = new HashMap();
        derivedTypesList = new ArrayList();
        XsdHelper.putDerivedType("normalizedString", facetSet1);
        XsdHelper.putDerivedType("token", facetSet1);
        XsdHelper.putDerivedType("language", facetSet1);
        XsdHelper.putDerivedType("NMTOKEN", facetSet1);
        XsdHelper.putDerivedType("NMTOKENS", facetSet5);
        XsdHelper.putDerivedType("Name", facetSet1);
        XsdHelper.putDerivedType("NCName", facetSet1);
        XsdHelper.putDerivedType("ID", facetSet1);
        XsdHelper.putDerivedType("IDREF", facetSet1);
        XsdHelper.putDerivedType("IDREFS", facetSet5);
        XsdHelper.putDerivedType("ENTITY", facetSet1);
        XsdHelper.putDerivedType("ENTITIES", facetSet5);
        XsdHelper.putDerivedType("integer", facetSet3);
        XsdHelper.putDerivedType("nonPositiveInteger", facetSet3);
        XsdHelper.putDerivedType("negativeInteger", facetSet3);
        XsdHelper.putDerivedType("long", facetSet3);
        XsdHelper.putDerivedType("int", facetSet3);
        XsdHelper.putDerivedType("short", facetSet3);
        XsdHelper.putDerivedType("byte", facetSet3);
        XsdHelper.putDerivedType("nonNegativeInteger", facetSet3);
        XsdHelper.putDerivedType("unsignedLong", facetSet3);
        XsdHelper.putDerivedType("unsignedInt", facetSet3);
        XsdHelper.putDerivedType("unsignedShort", facetSet3);
        XsdHelper.putDerivedType("unsignedByte", facetSet3);
        XsdHelper.putDerivedType("positiveInteger", facetSet3);
        typeSet = XsdHelper.getTypeSet(true, true);
    }
}

