/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdHelper;
import com.sap.aii.util.xsd.api.XsdNode;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XsdElement
extends XsdNode {
    private static final long serialVersionUID = 42L;
    private static final String MSG_WRONG_VALUE_FORM = "MSG_WRONG_VALUE_FORM";
    public static final int REF_TO_GLOBAL_ELEMENT = 1;
    public static final int REF_TO_GLOBAL_TYPE = 2;
    public static final int LOCAL_SIMPLE_TYPE = 3;
    public static final int LOCAL_COMPLEX_TYPE = 4;
    private int typeRefKind = -1;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private XsdTypeDef typeDef = null;
    private XsdQName type = null;
    private String fixed = null;
    private String form = "unqualified";
    private String defaultValue = null;
    private XsdQName ref = null;
    private boolean _abstract = false;
    private String block = null;
    private String _final = null;
    private boolean nillable = false;
    private XsdQName substitutionGroup = null;
    private static Set parents = new HashSet();
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdSchema;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdAll;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdSequence;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdChoice;

    protected Set getAllowedParents() {
        return parents;
    }

    protected XElement saveSpecificity(XElement parent) throws XsdException, XDOMException {
        XElement el = XsdNode.factory.newXElement(this.getXNameOfXsdNode("element"));
        if (this.type != null) {
            XAttribute attrType = XsdNode.attributeFactory.newXAttribute("type", this.getPrefixedTypeName(this.type));
            el.add(attrType);
        }
        if (this.ref != null) {
            XAttribute attrRef = XsdNode.attributeFactory.newXAttribute("ref", this.ref.getPrefixedName());
            el.add(attrRef);
        }
        if (!this.isGlobal()) {
            if (this.minOccurs != 1) {
                XAttribute attrMinOccurs = XsdNode.attributeFactory.newXAttribute("minOccurs", XsdHelper.getOccurence(this.minOccurs));
                el.add(attrMinOccurs);
            }
            if (this.maxOccurs != 1) {
                XAttribute attrMaxOccurs = XsdNode.attributeFactory.newXAttribute("maxOccurs", XsdHelper.getOccurence(this.maxOccurs));
                el.add(attrMaxOccurs);
            }
        }
        if (this._abstract) {
            XAttribute attrAbstract = XsdNode.attributeFactory.newXAttribute("abstract", "true");
            el.add(attrAbstract);
        }
        if (this.defaultValue != null) {
            XAttribute attrDefault = XsdNode.attributeFactory.newXAttribute("default", this.defaultValue);
            el.add(attrDefault);
        }
        if (this.fixed != null) {
            XAttribute attrFixed = XsdNode.attributeFactory.newXAttribute("fixed", this.fixed);
            el.add(attrFixed);
        }
        if (this.form != null && !this.form.equals(this.getSchema().getElementFormDefault())) {
            XAttribute attrForm = XsdNode.attributeFactory.newXAttribute("form", this.form);
            el.add(attrForm);
        }
        if (this.nillable) {
            XAttribute attrNillable = XsdNode.attributeFactory.newXAttribute("nillable", "true");
            el.add(attrNillable);
        }
        if (this.substitutionGroup != null) {
            XAttribute attrSubstitutionGroup = XsdNode.attributeFactory.newXAttribute("substitutionGroup", this.substitutionGroup.getPrefixedName());
            el.add(attrSubstitutionGroup);
        }
        if (this.typeDef != null) {
            this.typeDef.save(el);
        }
        return el;
    }

    protected void loadSpecificity(XElement element, XsdSchema schema, XsdNode parent) throws XsdException {
        this.form = this.getSchema().getElementFormDefault();
        List att = element.getAttributes();
        Iterator iter = att.iterator();
        while (iter.hasNext()) {
            XAttribute a = (XAttribute)iter.next();
            if (!this.isSchemaNamespace(a)) continue;
            if (a.getLocalName().equals("id")) {
                this.setId(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("name")) {
                this.setName(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("type")) {
                this.processType(this, a, element);
                continue;
            }
            if (a.getLocalName().equals("ref")) {
                this.processRef(this, a, element);
                continue;
            }
            if (a.getLocalName().equals("minOccurs")) {
                this.setMinOccurs(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("maxOccurs")) {
                this.setMaxOccurs(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("abstract")) {
                this.setAbstract(a.getValue().equals("true"));
                continue;
            }
            if (a.getLocalName().equals("block")) {
                this.throwException(a, 1);
                continue;
            }
            if (a.getLocalName().equals("default")) {
                this.setDefault(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("final")) {
                this.throwException(a, 1);
                continue;
            }
            if (a.getLocalName().equals("fixed")) {
                this.setFixed(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("form")) {
                this.setForm(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("nillable")) {
                this.setNillable(a.getValue().equals("true"));
                continue;
            }
            if (a.getLocalName().equals("substitutionGroup")) {
                this.processSubstitutionGroup(this, a, element);
                continue;
            }
            this.throwNotAllowedAttributeException(a, 2);
        }
        if (parent instanceof XsdSchema) {
            ((XsdSchema)parent).addElement(this);
        } else if (parent instanceof XsdParticle) {
            ((XsdParticle)parent).addElement(this);
        } else {
            this.throwException(element, 2);
        }
    }

    protected XsdElement() {
    }

    public XsdElement(XsdSchema schema) throws XsdException {
        super(schema);
    }

    public void setAbstract(boolean _abstract) {
        this._abstract = _abstract;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public String getFixed() {
        return this.fixed;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public void setForm(String form) throws XsdException {
        if (!form.equals("qualified") && !form.equals("unqualified")) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_FORM", (Object)form));
        }
        this.form = form;
    }

    public void setSubstitutionGroup(XsdQName substitutionGroup) {
        this.substitutionGroup = substitutionGroup;
    }

    public XsdQName getSubstitutionGroup() {
        return this.substitutionGroup;
    }

    public String getForm() {
        return this.form;
    }

    public void setLocalTypeDef(XsdTypeDef typeDef) {
        if (typeDef != null) {
            typeDef.setParent(this);
            this.typeRefKind = typeDef instanceof XsdComplexType ? 4 : 3;
            this.type = null;
        }
        this.typeDef = typeDef;
    }

    public XsdTypeDef getLocalTypeDef() {
        return this.typeDef;
    }

    public void setGlobalTypeName(XsdQName typeName) {
        this.type = typeName;
        this.typeRefKind = 2;
        this.typeDef = null;
    }

    public XsdQName getGlobalTypeName() {
        return this.type;
    }

    public void setRef(XsdQName elementName) {
        this.ref = elementName;
        this.typeRefKind = 1;
    }

    public XsdQName getRef() {
        return this.ref;
    }

    public int getTypeRefKind() {
        return this.typeRefKind;
    }

    public XsdTypeDef getTypeDef() throws XsdException {
        return this.typeDef;
    }

    public void setMinOccurs(String value) throws XsdException {
        this.minOccurs = XsdHelper.setOccurence(value, false);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMaxOccurs(String value) throws XsdException {
        this.maxOccurs = XsdHelper.setOccurence(value, true);
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        parents.add(class$com$sap$aii$util$xsd$api$XsdSchema == null ? (class$com$sap$aii$util$xsd$api$XsdSchema = XsdElement.class$("com.sap.aii.util.xsd.api.XsdSchema")) : class$com$sap$aii$util$xsd$api$XsdSchema);
        parents.add(class$com$sap$aii$util$xsd$api$XsdAll == null ? (class$com$sap$aii$util$xsd$api$XsdAll = XsdElement.class$("com.sap.aii.util.xsd.api.XsdAll")) : class$com$sap$aii$util$xsd$api$XsdAll);
        parents.add(class$com$sap$aii$util$xsd$api$XsdSequence == null ? (class$com$sap$aii$util$xsd$api$XsdSequence = XsdElement.class$("com.sap.aii.util.xsd.api.XsdSequence")) : class$com$sap$aii$util$xsd$api$XsdSequence);
        parents.add(class$com$sap$aii$util$xsd$api$XsdChoice == null ? (class$com$sap$aii$util$xsd$api$XsdChoice = XsdElement.class$("com.sap.aii.util.xsd.api.XsdChoice")) : class$com$sap$aii$util$xsd$api$XsdChoice);
    }
}

