/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.Message;
import com.sap.aii.util.misc.api.MessageList;
import com.sap.aii.util.xsd.api.IXsdConstants;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdHelper;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class XsdChecker
implements IXsdConstants {
    private Properties configuration = new Properties();

    public void configure(int checkNum, int severity) {
        this.configuration.setProperty(Integer.toString(checkNum), Integer.toString(severity));
    }

    private boolean configuredForCheck(int checkNum) {
        int severity = this.getSeverityOfCheck(checkNum);
        return severity != 0;
    }

    private int getSeverityOfCheck(int checkNum) {
        String severity = this.configuration.getProperty(Integer.toString(checkNum));
        if (severity == null) {
            return 1;
        }
        return Integer.parseInt(severity);
    }

    public Result checkSchema(XsdSchema schema) throws XsdException {
        List gEl;
        Result result = new Result();
        List ctl = schema.getComplexTypes();
        List stl = schema.getSimpleTypes();
        int cCount = ctl.size();
        int sCount = stl.size();
        if (this.configuredForCheck(1) && cCount + sCount != 1) {
            this.addMessage(1, result, "The schema must contain exactly one type definition.");
        }
        if (this.configuredForCheck(2) && (gEl = schema.getElements()).size() > 1) {
            this.addMessage(2, result, "Definition of global Elements is not supported");
        }
        int i = 0;
        while (i < ctl.size()) {
            XsdComplexType ct = (XsdComplexType)ctl.get(i);
            this.checkComplexType(result, ct);
            ++i;
        }
        int i2 = 0;
        while (i2 < stl.size()) {
            XsdSimpleType st = (XsdSimpleType)stl.get(i2);
            this.checkSimpleType(result, st);
            ++i2;
        }
        return result;
    }

    public Result checkFacets(Map facets, String xsdBaseType) {
        Result result = new Result();
        this.checkFacets(result, facets, xsdBaseType);
        return result;
    }

    private void checkSimpleType(Result result, XsdSimpleType tDef) throws XsdException {
        this.checkTypeDef(result, tDef);
    }

    private void checkComplexType(Result result, XsdComplexType tDef) throws XsdException {
        this.checkTypeDef(result, tDef);
    }

    private void checkTypeDef(Result result, XsdTypeDef tDef) throws XsdException {
        XsdQName baseTypeQName = tDef.getBaseTypeName();
        String baseTypeName = null;
        if (baseTypeQName != null) {
            baseTypeName = baseTypeQName.getLocalName();
        }
    }

    private void checkFacets(Result result, Map facets, String xsdBaseType) {
        this.checkFacetIsAllowedForType(result, facets, xsdBaseType);
        this.checkLengths(result, facets, xsdBaseType);
        this.checkMutualExlcusiveLengths(result, facets, xsdBaseType);
    }

    private void checkFacetIsAllowedForType(Result result, Map facets, String localXsdTypeName) {
        String[] a = XsdHelper.getAllowedFacets(localXsdTypeName);
        HashSet<String> allowed = new HashSet<String>(Arrays.asList(a));
        Iterator current = facets.keySet().iterator();
        while (current.hasNext()) {
            String fName = (String)current.next();
            if (allowed.contains(fName)) continue;
            this.addMessage(201, result, "Facet " + fName + " is not allowed for type " + localXsdTypeName + ".");
        }
    }

    private void checkLengths(Result result, Map facets, String localXsdTypeName) {
        int checkNum = 202;
        this.checkInteger(checkNum, result, facets, "length", true);
        this.checkInteger(checkNum, result, facets, "minLength", false);
        this.checkInteger(checkNum, result, facets, "maxLength", true);
        this.checkInteger(checkNum, result, facets, "fractionDigits", false);
        this.checkInteger(checkNum, result, facets, "totalDigits", true);
        this.checkGreaterEqual(checkNum, result, facets, "minLength", "maxLength");
        this.checkGreaterEqual(checkNum, result, facets, "fractionDigits", "totalDigits");
    }

    private void checkMutualExlcusiveLengths(Result result, Map facets, String localXsdTypeName) {
        int checkNum = 203;
        boolean checkOK = false;
        String l = XsdHelper.getRestriction(facets, "length");
        if (l == null) {
            checkOK = true;
        }
        if (!checkOK) {
            String minL = XsdHelper.getRestriction(facets, "minLength");
            String maxL = XsdHelper.getRestriction(facets, "maxLength");
            if (minL == null && maxL == null) {
                checkOK = true;
            }
        }
        if (!checkOK) {
            this.addMessage(checkNum, result, "Specification of length and min/maxLength are mutual exclusive. Please specify only one of them.");
        }
    }

    private void checkInteger(int checkNum, Result result, Map facets, String lengthFacetName, boolean positive) {
        try {
            String res = XsdHelper.getRestriction(facets, lengthFacetName);
            if (res == null) {
                return;
            }
            BigInteger bi = new BigInteger(res);
            long i = bi.longValue();
            if (i <= 0L && positive) {
                this.addMessage(checkNum, result, "Value of " + lengthFacetName + " must be a positive integer.");
            }
            if (i < 0L && !positive) {
                this.addMessage(checkNum, result, "Value of " + lengthFacetName + " must be a non negative integer.");
            }
        }
        catch (NumberFormatException nfEx) {
            this.addMessage(checkNum, result, "Value of " + lengthFacetName + " is no valid integer.");
        }
    }

    private void checkGreaterEqual(int checkNum, Result result, Map facets, String minLengthFacetName, String maxLengthFacetName) {
        try {
            long iMax;
            String min = XsdHelper.getRestriction(facets, minLengthFacetName);
            if (min == null) {
                return;
            }
            String max = XsdHelper.getRestriction(facets, maxLengthFacetName);
            if (max == null) {
                return;
            }
            long iMin = new BigInteger(min).longValue();
            if (iMin > (iMax = new BigInteger(max).longValue())) {
                this.addMessage(checkNum, result, "Value of " + minLengthFacetName + " must be less than value of " + maxLengthFacetName + ".");
            }
        }
        catch (NumberFormatException nfEx) {
            return;
        }
    }

    private void addMessage(int checkNum, Result result, String message) {
        int severity = this.getSeverityOfCheck(checkNum);
        result.add(severity, message);
    }

    public Message check(Map facets, String xsdBaseType) {
        MessageList ml = new MessageList();
        Result result = this.checkFacets(facets, xsdBaseType);
        int i = 0;
        while (i < result.size()) {
            ml.add(result.getMessage(i));
            ++i;
        }
        if (ml.toString().trim().equals("")) {
            return null;
        }
        return ml;
    }

    public class ResultEntry {
        public int severity;
        public Message message;
    }

    public class Result {
        private List entries = new ArrayList();

        public int size() {
            return this.entries.size();
        }

        public int getSeverity(int index) {
            ResultEntry entry = this.getEntry(index);
            return entry.severity;
        }

        public Message getMessage(int index) {
            ResultEntry entry = this.getEntry(index);
            return entry.message;
        }

        public ResultEntry getEntry(int index) {
            return (ResultEntry)this.entries.get(index);
        }

        void add(int severity, String message) {
            ResultEntry entry = new ResultEntry();
            entry.severity = severity;
            entry.message = BabelMessage.createFromString((String)message);
            this.entries.add(entry);
        }
    }
}

