/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xsd.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdExtension;
import com.sap.aii.util.xsd.api.XsdNode;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XsdAttribute
extends XsdNode {
    private static final long serialVersionUID = 42L;
    private static final String MSG_WRONG_VALUE_FORM = "MSG_WRONG_VALUE_FORM";
    private static final String MSG_WRONG_VALUE_USE = "MSG_WRONG_VALUE_USE";
    private XsdSimpleType typeDef = null;
    private XsdQName type = null;
    private String use = "optional";
    private String fixed = null;
    private String form = "unqualified";
    private String defaultValue = null;
    private XsdQName ref = null;
    private static Set parents = new HashSet();
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdSchema;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdAttributeGroup;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdComplexType;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdExtension;
    static /* synthetic */ Class class$com$sap$aii$util$xsd$api$XsdRestriction;

    protected Set getAllowedParents() {
        return parents;
    }

    protected XElement saveSpecificity(XElement parent) throws XsdException, XDOMException {
        XElement el = XsdNode.factory.newXElement(this.getXNameOfXsdNode("attribute"));
        if (this.type != null) {
            XAttribute attrType = XsdNode.attributeFactory.newXAttribute("type", this.getPrefixedTypeName(this.type));
            el.add(attrType);
        }
        if (this.fixed != null) {
            XAttribute attrFixed = XsdNode.attributeFactory.newXAttribute("fixed", this.fixed);
            el.add(attrFixed);
        }
        if (this.defaultValue != null) {
            XAttribute attrDefault = XsdNode.attributeFactory.newXAttribute("default", this.defaultValue);
            el.add(attrDefault);
        }
        if (this.form != null && !this.form.equals(this.getSchema().getAttributeFormDefault())) {
            XAttribute attrForm = XsdNode.attributeFactory.newXAttribute("form", this.form);
            el.add(attrForm);
        }
        if (this.use != null && !this.use.equals("optional")) {
            XAttribute attrUse = XsdNode.attributeFactory.newXAttribute("use", this.use);
            el.add(attrUse);
        }
        if (this.ref != null) {
            XAttribute attrRef = XsdNode.attributeFactory.newXAttribute("ref", this.getPrefixedTypeName(this.ref));
            el.add(attrRef);
        }
        if (this.typeDef != null) {
            this.typeDef.save(el);
        }
        return el;
    }

    protected void loadSpecificity(XElement element, XsdSchema schema, XsdNode parent) throws XsdException {
        this.form = this.getSchema().getAttributeFormDefault();
        List att = element.getAttributes();
        Iterator iter = att.iterator();
        while (iter.hasNext()) {
            XAttribute a = (XAttribute)iter.next();
            if (!this.isSchemaNamespace(a)) continue;
            if (a.getLocalName().equals("id")) {
                this.setId(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("name")) {
                this.setName(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("type")) {
                this.processType(this, a, element);
                continue;
            }
            if (a.getLocalName().equals("use")) {
                this.setUse(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("fixed")) {
                this.setFixed(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("default")) {
                this.setDefault(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("form")) {
                this.setForm(a.getValue());
                continue;
            }
            if (a.getLocalName().equals("ref")) {
                this.processRef(this, a, element);
                continue;
            }
            this.throwNotAllowedAttributeException(a, 2);
        }
        if (parent instanceof XsdSchema) {
            ((XsdSchema)parent).addAttribute(this);
        } else if (parent instanceof XsdComplexType) {
            ((XsdComplexType)parent).addAttribute(this);
        } else if (parent instanceof XsdAttributeGroup) {
            ((XsdAttributeGroup)parent).addAttribute(this);
        } else if (parent instanceof XsdExtension) {
            ((XsdExtension)parent).addAttribute(this);
        } else if (parent instanceof XsdRestriction) {
            ((XsdRestriction)parent).addAttribute(this);
        } else {
            this.throwException(element, 2);
        }
    }

    protected XsdAttribute() {
    }

    public XsdAttribute(XsdSchema schema) throws XsdException {
        super(schema);
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    public String getFixed() {
        return this.fixed;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setRef(XsdQName ref) {
        this.ref = ref;
    }

    public XsdQName getRef() {
        return this.ref;
    }

    public void setForm(String form) throws XsdException {
        if (!form.equals("qualified") && !form.equals("unqualified")) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_FORM", (Object)form));
        }
        this.form = form;
    }

    public String getForm() {
        return this.form;
    }

    public void setLocalTypeDef(XsdSimpleType typeDef) {
        this.typeDef = typeDef;
        this.type = null;
    }

    public XsdTypeDef getLocalTypeDef() {
        return this.typeDef;
    }

    public void setGlobalTypeName(XsdQName typeName) {
        this.type = typeName;
        this.typeDef = null;
    }

    public XsdQName getGlobalTypeName() {
        return this.type;
    }

    public XsdSimpleType getTypeDef() throws XsdException {
        return this.typeDef;
    }

    public void setUse(String use) throws XsdException {
        if (!(use.equals("optional") || use.equals("required") || use.equals("prohibited"))) {
            throw new XsdException(new BabelMessage("com.sap.aii.util.xsd.api.rb_XsdParsing.MSG_WRONG_VALUE_USE", (Object)use));
        }
        this.use = use;
    }

    public String getUse() {
        return this.use;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        parents.add(class$com$sap$aii$util$xsd$api$XsdSchema == null ? (class$com$sap$aii$util$xsd$api$XsdSchema = XsdAttribute.class$("com.sap.aii.util.xsd.api.XsdSchema")) : class$com$sap$aii$util$xsd$api$XsdSchema);
        parents.add(class$com$sap$aii$util$xsd$api$XsdAttributeGroup == null ? (class$com$sap$aii$util$xsd$api$XsdAttributeGroup = XsdAttribute.class$("com.sap.aii.util.xsd.api.XsdAttributeGroup")) : class$com$sap$aii$util$xsd$api$XsdAttributeGroup);
        parents.add(class$com$sap$aii$util$xsd$api$XsdComplexType == null ? (class$com$sap$aii$util$xsd$api$XsdComplexType = XsdAttribute.class$("com.sap.aii.util.xsd.api.XsdComplexType")) : class$com$sap$aii$util$xsd$api$XsdComplexType);
        parents.add(class$com$sap$aii$util$xsd$api$XsdExtension == null ? (class$com$sap$aii$util$xsd$api$XsdExtension = XsdAttribute.class$("com.sap.aii.util.xsd.api.XsdExtension")) : class$com$sap$aii$util$xsd$api$XsdExtension);
        parents.add(class$com$sap$aii$util$xsd$api$XsdRestriction == null ? (class$com$sap$aii$util$xsd$api$XsdRestriction = XsdAttribute.class$("com.sap.aii.util.xsd.api.XsdRestriction")) : class$com$sap$aii$util$xsd$api$XsdRestriction);
    }
}

