/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.shell;

import com.sap.tc.cbstool.impl.CBSToolUtil;
import com.sap.tc.cbstool.shell.InputException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public class CommandParser {
    private static final int READ_MODE = 0;
    private static final int QUOTE_MODE = 1;
    private static final int SKIP_MODE = 2;
    private static final int ESCAPE_MODE = 3;
    protected BufferedReader inputReader;
    protected String contLine = null;

    private CommandParser() {
    }

    public CommandParser(BufferedReader br) {
        this.inputReader = br;
    }

    public CommandParser(String str) {
        this.inputReader = new BufferedReader(new StringReader(str));
    }

    public boolean moreCommands() {
        return this.contLine != null;
    }

    public String[] parse() throws IOException, InputException {
        String line;
        int mode = 2;
        Vector<String> arguments = new Vector<String>();
        StringBuffer current = new StringBuffer();
        if (this.inputReader == null) {
            throw new InputException();
        }
        if (this.contLine == null) {
            line = this.inputReader.readLine();
        } else {
            line = this.contLine;
            this.contLine = null;
        }
        if (line == null) {
            this.inputReader = null;
            return null;
        }
        int position = 0;
        while (position < line.length()) {
            int ch = line.charAt(position);
            switch (mode) {
                case 0: {
                    if (ch == 34) {
                        mode = 1;
                    } else if (ch == 59) {
                        --position;
                        mode = 2;
                    } else if (ch == 32 || ch == 9) {
                        mode = 2;
                    } else {
                        current.append((char)ch);
                    }
                    if (mode == 0) break;
                    arguments.addElement(current.toString());
                    current = new StringBuffer();
                    break;
                }
                case 2: {
                    if (ch == 32 || ch == 9) break;
                    if (ch == 34) {
                        mode = 1;
                        break;
                    }
                    if (ch == 59) {
                        this.contLine = line.substring(position + 1);
                        position = line.length();
                        break;
                    }
                    mode = 0;
                    --position;
                    break;
                }
                case 1: {
                    if (ch == 34) {
                        mode = 0;
                        break;
                    }
                    if (ch == 92) {
                        mode = 3;
                        break;
                    }
                    current.append((char)ch);
                    break;
                }
                default: {
                    if (ch == 110) {
                        ch = 10;
                    } else if (ch == 114) {
                        ch = 13;
                    } else if (ch == 116) {
                        ch = 9;
                    } else if (ch == 98) {
                        ch = 8;
                    } else if (ch == 102) {
                        ch = 12;
                    } else {
                        current.append('\\');
                    }
                    mode = 1;
                    current.append((char)ch);
                }
            }
            ++position;
        }
        if (current.length() > 0) {
            arguments.addElement(current.toString());
        }
        return CBSToolUtil.vectorToArray(arguments);
    }
}

