/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.shell;

import com.sap.tc.cbs.client.IBuildServer;
import com.sap.tc.cbstool.impl.CBSToolFactory;
import com.sap.tc.cbstool.impl.CBSToolUtil;
import com.sap.tc.cbstool.impl.ICBSTool;
import com.sap.tc.cbstool.shell.CBSToolCmdLine;
import com.sap.tc.cbstool.shell.CommandParser;
import com.sap.tc.cbstool.shell.Help;
import com.sap.tc.cbstool.shell.InputException;
import com.sap.tc.cbstool.shell.ReturnCodes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CBSToolShell {
    private boolean batch = false;
    private boolean exitCommandLoop = false;
    private boolean stopOnError = false;
    private boolean showReturnCode = false;
    private BufferedReader consoleReader;
    private CommandParser parser;
    private ICBSTool cbsTool;
    private IBuildServer cbsProxy;
    private String ls = System.getProperty("line.separator");
    private int rc;
    private Help myHelp;

    public CBSToolShell() {
        if (this.ls.equals("")) {
            this.ls = "\r\n";
        }
        this.consoleReader = new BufferedReader(new InputStreamReader(System.in));
        this.parser = new CommandParser(this.consoleReader);
        this.cbsTool = CBSToolFactory.getInstance();
        this.rc = 0;
        this.myHelp = new Help();
    }

    public int run(String[] args) {
        if (args.length > 0) {
            this.runBatch(args);
        } else {
            this.runInteractive();
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runInteractive() {
        this.batch = false;
        this.cbsTool.setMode(true);
        this.exitCommandLoop = false;
        try {
            block3: do {
                System.out.print(this.ls + ":cbs>");
                System.out.flush();
                String[] args = this.parser.parse();
                while (args != null) {
                    this.executeCommand(args);
                    if (!this.parser.moreCommands()) continue block3;
                    args = this.parser.parse();
                }
            } while (!this.exitCommandLoop);
            return;
        }
        catch (InputException e) {
            this.cbsTool.println("Input terminated abrupt!");
            return;
        }
        catch (Exception e) {
            this.cbsTool.println("Internal error while reading commands!");
            this.cbsTool.println("Stack trace:");
            e.printStackTrace();
            return;
        }
    }

    private void runBatch(String[] args) {
        this.batch = true;
        this.cbsTool.setMode(false);
        StringBuffer sb = new StringBuffer();
        String input = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("@")) {
                String filename = args[i].substring(1);
                try {
                    input = this.readInputFile(filename);
                }
                catch (IOException e) {
                    this.cbsTool.println("Error while reading input file: " + e.getMessage());
                    this.cbsTool.println("Exceution was stopped");
                    this.rc = 107;
                    return;
                }
            } else {
                input = args[i];
            }
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(input);
            ++i;
        }
        String str = sb.toString();
        CommandParser parser = new CommandParser(str);
        try {
            String[] cmdArgs = parser.parse();
            while (true) {
                if (cmdArgs == null) {
                    return;
                }
                String cmd = "";
                int i2 = 0;
                while (i2 < cmdArgs.length) {
                    cmd = cmd + cmdArgs[i2] + " ";
                    ++i2;
                }
                if (cmdArgs != null && cmdArgs.length > 0) {
                    this.executeCommand(cmdArgs);
                }
                if (parser.moreCommands() && !this.exitCommandLoop) {
                    cmdArgs = parser.parse();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.cbsTool.println("Internal error while reading commands!");
            this.cbsTool.println("Stack trace:");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String readInputFile(String filename) throws IOException {
        String str;
        StringBuffer sb = new StringBuffer();
        File f = new File(filename);
        if (!f.exists()) {
            throw new IOException("Can't open input file '" + filename + "'");
        }
        Vector v = new Vector();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((str = in.readLine()) != null) {
            void var6_6;
            str = var6_6.trim();
            int index = str.indexOf("#");
            if (index >= 0) {
                str = str.substring(0, index);
                sb.append(str);
                continue;
            }
            sb.append(str);
        }
        in.close();
        return sb.toString();
    }

    private void executeCommand(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        CBSToolCmdLine cmdLine = new CBSToolCmdLine();
        String cmdStr = new String();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-p")) {
                cmdStr = cmdStr + args[i] + " ***** ";
                ++i;
            } else {
                cmdStr = cmdStr + args[i] + " ";
            }
            ++i;
        }
        if (this.batch) {
            this.cbsTool.println(this.ls + "Executing command: " + cmdStr);
        }
        this.cbsTool.setCommandString(cmdStr);
        List errors = cmdLine.processCmdLine(args);
        if (errors.size() > 0) {
            this.cbsTool.println("Command line contains invalid entries:");
            Iterator it = errors.iterator();
            while (it.hasNext()) {
                String msg = (String)it.next();
                this.cbsTool.println("Error: " + msg);
            }
            this.cbsTool.println("Enter help to get information on correct usage.");
            this.rc = 100;
            if (this.stopOnError && this.rc != 0) {
                this.cbsTool.println("Error occured while executing command: " + cmdStr);
                this.cbsTool.println("Return code: " + this.rc);
                this.cbsTool.println("The tool will terminatate due to this error.");
                this.exitCommandLoop = true;
            }
            return;
        }
        Params p = new Params(cmdLine);
        if (args[0].equalsIgnoreCase("activate")) {
            this.rc = this.cbsTool.activate(this.cbsProxy, p.buildSpace, p.compartment, p.usr, p.ignoreintersection, p.forceintegrate, p.mode, p.activityList, p.confirm);
        } else if (args[0].equalsIgnoreCase("bsstate")) {
            this.rc = this.cbsTool.bsState(this.cbsProxy, p.buildSpace);
        } else if (args[0].equalsIgnoreCase("buildall")) {
            this.rc = this.cbsTool.buildAll(this.cbsProxy, p.buildSpace, p.compartment, p.buildVariant);
        } else if (args[0].equalsIgnoreCase("builddc")) {
            this.rc = this.cbsTool.buildDC(this.cbsProxy, p.buildSpace, p.compartment, p.name, p.vendor, p.buildVariant);
        } else if (args[0].equalsIgnoreCase("connect")) {
            this.cbsProxy = this.cbsTool.connect(p.cbs, p.usr, p.pwd, p.timeout, p.filePath);
            this.rc = this.cbsProxy != null ? 0 : 102;
        } else if (args[0].equalsIgnoreCase("createbs")) {
            this.rc = this.cbsTool.createbs(this.cbsProxy, p.filePath, p.usr, p.pwd);
        } else if (args[0].equalsIgnoreCase("deletedcs")) {
            this.rc = this.cbsTool.deleteDCs(this.cbsProxy, p.buildSpace, p.compartment);
        } else if (args[0].equalsIgnoreCase("downloadconfig")) {
            this.rc = this.cbsTool.downloadConfiguration(this.cbsProxy, p.buildSpace, p.filePath);
        } else if (args[0].equalsIgnoreCase("downloaddcarc")) {
            this.rc = this.cbsTool.downloadDCArchive(this.cbsProxy, p.buildSpace, p.compartment, p.name, p.vendor, p.buildVariant, p.filePath, p.mode);
        } else if (args[0].equalsIgnoreCase("downloadsca")) {
            this.rc = this.cbsTool.downloadSca(this.cbsProxy, p.buildSpace, p.compartment, p.filePath, p.buildVariant, p.mode);
        } else if (args[0].equalsIgnoreCase("exit")) {
            this.exitCommandLoop = true;
        } else if (args[0].equalsIgnoreCase("help")) {
            if (args.length > 1) {
                this.cbsTool.println(this.myHelp.help(args[1]));
            } else {
                this.cbsTool.println(this.myHelp.help());
            }
            this.rc = 0;
        } else if (args[0].equalsIgnoreCase("initcompartment")) {
            this.rc = this.cbsTool.initCompartment(this.cbsProxy, p.buildSpace, p.compartment, p.confirm);
        } else if (args[0].equalsIgnoreCase("latestbn")) {
            this.rc = this.cbsTool.latestBuildNumber(this.cbsProxy, p.buildSpace, p.compartment, p.name, p.vendor, p.buildVariant);
        } else if (args[0].equalsIgnoreCase("listbuildspaces")) {
            this.rc = this.cbsTool.listBuildSpaces(this.cbsProxy);
        } else if (args[0].equalsIgnoreCase("listbuildvariants")) {
            this.rc = this.cbsTool.listBuildVariants(this.cbsProxy, p.buildSpace, p.compartment);
        } else if (args[0].equalsIgnoreCase("listcompartments")) {
            this.rc = this.cbsTool.listCompartments(this.cbsProxy, p.buildSpace);
        } else if (args[0].equalsIgnoreCase("listdcs")) {
            this.rc = this.cbsTool.listDCs(this.cbsProxy, p.buildSpace, p.compartment, p.mode);
        } else if (args[0].equalsIgnoreCase("listopenrequests")) {
            this.rc = this.cbsTool.listOpenRequests(this.cbsProxy, p.buildSpace);
        } else if (args[0].equalsIgnoreCase("listpendingactivities")) {
            this.rc = this.cbsTool.listPendingActivities(this.cbsProxy, p.buildSpace, p.compartment, p.usr);
        } else if (args[0].equalsIgnoreCase("logfile")) {
            this.rc = this.cbsTool.logfile(p.filePath, p.mode);
        } else if (args[0].equalsIgnoreCase("removebs")) {
            this.rc = this.cbsTool.removebs(this.cbsProxy, p.buildSpace);
        } else if (args[0].equalsIgnoreCase("requeststate")) {
            this.rc = this.cbsTool.requestState(this.cbsProxy, p.buildSpace, p.requestNumber);
        } else if (args[0].equalsIgnoreCase("returncode")) {
            this.returnCode(p.requestNumber, p.mode);
            this.rc = 0;
        } else if (args[0].equalsIgnoreCase("setinputmode")) {
            this.rc = this.cbsTool.setInputMode(this.cbsProxy, p.buildSpace, p.mode);
        } else if (args[0].equalsIgnoreCase("stoponerror")) {
            this.stopOnError(p.mode);
            this.rc = 0;
        } else if (args[0].equalsIgnoreCase("switchoff")) {
            this.rc = this.cbsTool.switchOff(this.cbsProxy, p.buildSpace, p.mode);
        } else if (args[0].equalsIgnoreCase("switchon")) {
            this.rc = this.cbsTool.switchOn(this.cbsProxy, p.buildSpace, p.mode);
        } else if (args[0].equalsIgnoreCase("tracefile")) {
            this.rc = this.cbsTool.tracefile(p.filePath, p.mode);
        } else if (args[0].equalsIgnoreCase("updatebs")) {
            this.rc = this.cbsTool.updatebs(this.cbsProxy, p.buildSpace, p.filePath);
        } else if (args[0].equalsIgnoreCase("uploaddcarc")) {
            this.rc = this.cbsTool.uploadDCArchive(this.cbsProxy, p.buildSpace, p.compartment, p.name, p.vendor, p.buildVariant, p.filePath, p.mode);
        } else if (args[0].equalsIgnoreCase("uploadsca")) {
            this.rc = this.cbsTool.uploadSca(this.cbsProxy, p.buildSpace, p.compartment, p.filePath, p.buildVariant, p.mode, p.mirror);
        } else if (args[0].equalsIgnoreCase("verbosity")) {
            this.rc = this.cbsTool.verbosity(p.mode);
        } else if (args[0].equalsIgnoreCase("version")) {
            this.cbsTool.println("CBS commandline client Version : 1.00");
        } else {
            this.cbsTool.println("Unknown command " + args[0]);
            this.cbsTool.println("Enter help to get information on correct usage.");
            this.rc = 100;
        }
        if (this.showReturnCode) {
            this.cbsTool.println("Return code: " + this.rc);
        }
        if (this.stopOnError && this.rc != 0) {
            this.cbsTool.println("Error occured while executing command: " + cmdStr);
            this.cbsTool.println("Return code: " + this.rc);
            this.cbsTool.println("The tool will terminatate due to this error.");
            this.exitCommandLoop = true;
        }
    }

    private void returnCode(String rc, String mode) {
        if (rc == null && mode == null) {
            this.cbsTool.println(ReturnCodes.rc);
        } else {
            if (rc != null) {
                this.cbsTool.println(ReturnCodes.returnCode(rc));
            }
            if (mode != null) {
                if (mode.equalsIgnoreCase("on")) {
                    this.showReturnCode = true;
                } else if (mode.equalsIgnoreCase("off")) {
                    this.showReturnCode = false;
                } else {
                    this.cbsTool.println("Illegal mode value '" + mode + "', mode = (on|off).");
                }
            }
        }
    }

    private void stopOnError(String mode) {
        if (mode == null) {
            return;
        }
        if (mode.equalsIgnoreCase("on")) {
            this.stopOnError = true;
        } else if (mode.equalsIgnoreCase("off")) {
            this.stopOnError = false;
        } else {
            this.cbsTool.println("Illegal mode value '" + mode + "', mode = (on|off).");
        }
    }

    class Params {
        private static final String PWDSTR = "*****";
        public String timeout;
        public String usr;
        public String pwd;
        public String filePath;
        public String cbs;
        public String name;
        public String vendor;
        public String compartment;
        public String buildVariant;
        public String severity;
        public String buildSpace;
        public String mode;
        public String activityList;
        public String requestNumber;
        public boolean forceintegrate;
        public boolean ignoreintersection;
        public boolean mirror;
        public boolean confirm;

        private Params() {
        }

        public Params(CBSToolCmdLine cmdline) {
            this.reset();
            this.assignParams(cmdline);
        }

        public void reset() {
            this.timeout = null;
            this.usr = null;
            this.pwd = null;
            this.filePath = null;
            this.cbs = null;
            this.name = null;
            this.vendor = null;
            this.buildVariant = null;
            this.compartment = null;
            this.severity = null;
            this.buildSpace = null;
            this.mode = null;
            this.activityList = null;
            this.requestNumber = null;
            this.forceintegrate = false;
            this.ignoreintersection = false;
            this.mirror = false;
            this.confirm = false;
        }

        public void assignParams(CBSToolCmdLine cmdLine) {
            this.cbs = cmdLine.getArgument("-c");
            this.usr = cmdLine.getArgument("-u");
            this.pwd = cmdLine.getArgument("-p");
            if (this.pwd != null) {
                this.pwd = CBSToolUtil.stripQuotes(this.pwd);
            }
            this.vendor = cmdLine.getArgument("-v");
            this.name = cmdLine.getArgument("-n");
            this.compartment = cmdLine.getArgument("-s");
            this.filePath = cmdLine.getArgument("-f");
            this.buildVariant = cmdLine.getArgument("-o");
            this.severity = cmdLine.getArgument("-d");
            this.timeout = cmdLine.getArgument("-t");
            this.buildSpace = cmdLine.getArgument("-b");
            this.mode = cmdLine.getArgument("-m");
            this.activityList = cmdLine.getArgument("-a");
            this.requestNumber = cmdLine.getArgument("-r");
            if (cmdLine.optionDefined("--ignoreintersection")) {
                this.ignoreintersection = true;
            }
            if (cmdLine.optionDefined("--ignorebuilderrors")) {
                this.forceintegrate = true;
            }
            if (cmdLine.optionDefined("--mirror")) {
                this.mirror = true;
            }
            if (cmdLine.optionDefined("-y")) {
                this.confirm = true;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("cbs: " + this.objVal(this.cbs) + CBSToolShell.this.ls);
            sb.append("usr: " + this.objVal(this.usr) + CBSToolShell.this.ls);
            sb.append("pwd: *****" + CBSToolShell.this.ls);
            sb.append("vendor: " + this.objVal(this.vendor) + CBSToolShell.this.ls);
            sb.append("name: " + this.objVal(this.name) + CBSToolShell.this.ls);
            sb.append("compartment: " + this.objVal(this.compartment) + CBSToolShell.this.ls);
            sb.append("filePath: " + this.objVal(this.filePath) + CBSToolShell.this.ls);
            sb.append("buildVariant: " + this.objVal(this.buildVariant) + CBSToolShell.this.ls);
            sb.append("buildSpace: " + this.objVal(this.buildSpace) + CBSToolShell.this.ls);
            sb.append("severity: " + this.objVal(this.severity) + CBSToolShell.this.ls);
            sb.append("timeout: " + this.objVal(this.timeout) + CBSToolShell.this.ls);
            sb.append("mode: " + this.objVal(this.mode) + CBSToolShell.this.ls);
            sb.append("activityList: " + this.objVal(this.activityList) + CBSToolShell.this.ls);
            sb.append("requestNumber: " + this.objVal(this.requestNumber) + CBSToolShell.this.ls);
            sb.append("forceintegrate: " + this.boolVal(this.forceintegrate) + CBSToolShell.this.ls);
            sb.append("ignoreintersection: " + this.boolVal(this.ignoreintersection) + CBSToolShell.this.ls);
            sb.append("mirror: " + this.boolVal(this.mirror) + CBSToolShell.this.ls);
            sb.append("confirm: " + this.boolVal(this.confirm) + CBSToolShell.this.ls);
            return sb.toString();
        }

        private String boolVal(boolean b) {
            Boolean b2 = new Boolean(b);
            return b2.toString();
        }

        private String intVal(int i) {
            Integer i2 = new Integer(i);
            return i2.toString();
        }

        private String objVal(Object o) {
            if (o == null) {
                return new String("<null>");
            }
            return o.toString();
        }
    }
}

