/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.impl;

import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.cbstool.impl.CBSToolUtil;
import com.sap.tc.cbstool.impl.PropertyReader;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;

public class LogHandler {
    public static final int INFO_DEBUG = 3;
    public static final int INFO_HIGH = 2;
    public static final int INFO_NORMAL = 1;
    public static final int INFO_LOW = 0;
    private static String ls = System.getProperty("line.separator");
    private Location myLocation = Location.getLocation((String)"");
    private PrintStream userLogStream = System.out;
    private SimpleDateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
    private int verbosity = 1;
    private String logfile = null;
    private String tracefile;
    private int severity = 500;
    private String commandString;
    private PropertyReader propertyReader = new PropertyReader();

    public void setCommandString(String command) {
        this.commandString = command;
        this.myLocation.infoT("Executing command: " + command);
    }

    public void msg(int infoLevel, String message) {
        if (infoLevel <= this.verbosity) {
            if (this.verbosity > 1) {
                String dateTime = Util.normalDateFormat();
                this.userLogStream.println(dateTime);
            }
            this.userLogStream.println(message);
        }
        this.myLocation.infoT(message);
    }

    public void msg(int infoLevel, String messagePattern, Object[] params) {
        this.msg(infoLevel, MessageFormat.format(messagePattern, params));
    }

    public void msg(int infoLevel, String text, String messagePattern, Object[] params) {
        String message = text + MessageFormat.format(messagePattern, params);
        this.msg(infoLevel, message);
    }

    public void reportException(Exception e, String message, String thisMethod) {
        CommunicationException ce;
        Throwable th;
        int oldSeverity = this.severity;
        this.myLocation.setEffectiveSeverity(0);
        this.msg(0, message + ls + e.getMessage());
        String stackTrace = Util.printStackTraceToString((Throwable)e);
        if (this.commandString != null) {
            this.myLocation.infoT("Exception occured while executing command: " + this.commandString);
        }
        this.myLocation.infoT(stackTrace);
        if (e instanceof CommunicationException && (th = (ce = (CommunicationException)((Object)e)).getPreviousException()) != null) {
            String stackTrace2 = Util.printStackTraceToString((Throwable)th);
            this.myLocation.infoT("Previous Exception: " + ls + stackTrace2);
        }
        if (e instanceof CBSServerException) {
            ce = (CBSServerException)e;
            String s = ce.getServerTrace();
            this.myLocation.infoT("Server trace that belongs to exception: " + ls + s);
        }
        this.myLocation.setEffectiveSeverity(oldSeverity);
    }

    public void reportException(Exception e, String message) {
        CommunicationException ce;
        Throwable th;
        int oldSeverity = this.severity;
        this.myLocation.setEffectiveSeverity(0);
        this.msg(0, message + ls + e.getMessage());
        String stackTrace = Util.printStackTraceToString((Throwable)e);
        if (this.commandString != null) {
            this.myLocation.infoT("Exception occured while executing command: " + this.commandString);
        }
        this.myLocation.infoT(stackTrace);
        if (e instanceof CommunicationException && (th = (ce = (CommunicationException)((Object)e)).getPreviousException()) != null) {
            String stackTrace2 = Util.printStackTraceToString((Throwable)th);
            this.myLocation.infoT("Previous Exception: " + ls + stackTrace2);
        }
        if (e instanceof CBSServerException) {
            ce = (CBSServerException)e;
            String s = ce.getServerTrace();
            this.myLocation.infoT("Server trace that belongs to exception: " + ls + s);
        }
        this.myLocation.setEffectiveSeverity(oldSeverity);
    }

    public void setVerbosity(int i) {
        if (i < 0 || i > 3) {
            return;
        }
        this.verbosity = i;
    }

    public void setLogfile(String filename, String mode) {
        boolean append;
        boolean bl = append = mode != null ? mode.equalsIgnoreCase("append") : false;
        if (filename == null) {
            if (this.logfile != null) {
                this.userLogStream.close();
            }
            this.userLogStream = System.out;
            this.logfile = filename;
        } else {
            try {
                PrintStream ps;
                CBSToolUtil.createFile(filename);
                if (this.logfile != null) {
                    this.userLogStream.close();
                }
                FileOutputStream os = new FileOutputStream(filename, append);
                this.userLogStream = ps = new PrintStream(os);
                this.logfile = filename;
            }
            catch (FileNotFoundException e) {
                this.msg(0, e.getMessage());
                this.userLogStream = System.out;
            }
        }
    }

    public void setTracefile(String filename, String sev) {
        CBSToolUtil.createFile(filename);
        FileLog fl = new FileLog(filename);
        String traceformat = this.propertyReader.getTraceformat();
        if (traceformat == null || traceformat.length() == 0) {
            traceformat = "[severity: %s] %24d [thread:%t]  [loc: %l]  \r\n [msg: \r\n %m \r\n";
        }
        TraceFormatter tf = new TraceFormatter(traceformat);
        fl.setFormatter((Formatter)tf);
        this.severity = sev != null && sev.equalsIgnoreCase("debug") ? 100 : (sev != null && sev.equalsIgnoreCase("info") ? 300 : (sev != null && sev.equalsIgnoreCase("error") ? 500 : 700));
        this.myLocation.setEffectiveSeverity(this.severity);
        this.myLocation.removeLogs();
        this.myLocation.addLog((Log)fl);
    }

    public void println(String message) {
        if (this.verbosity > 1) {
            String dateTime = Util.normalDateFormat();
            this.userLogStream.println(dateTime);
        }
        this.userLogStream.println(message);
    }

    static {
        if (ls.equals("")) {
            ls = "\r\n";
        }
    }
}

