/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.impl;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class DevConfigHandler {
    private ConfigurationInputProvider cip;
    private DevelopmentConfiguration devconf;

    private DevConfigHandler() {
    }

    public DevConfigHandler(ConfigurationInputProvider provider) throws IOException, XMLException, ProviderException, ValidationException {
        this.cip = provider;
        this.devconf = ConfigurationFactory.createDevelopmentConfiguration();
        this.devconf.initialize(this.cip);
    }

    /*
     * WARNING - void declaration
     */
    public String configAsString() {
        try {
            int c;
            InputStream is = this.cip.getStreamForConfiguration();
            is.reset();
            StringBuffer sb = new StringBuffer();
            while ((c = is.read()) != -1) {
                void var3_5;
                sb.append((char)var3_5);
            }
            is.close();
            return sb.toString();
        }
        catch (ProviderException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Compartment[] getCompartments() {
        Map m = this.devconf.getCompartments();
        Collection c = m.values();
        Compartment[] compartments = new Compartment[c.size()];
        compartments = c.toArray(compartments);
        return compartments;
    }

    public Compartment getCompartment(String compartmentName) {
        if (compartmentName == null) {
            return null;
        }
        Map m = this.devconf.getCompartments();
        Collection c = m.values();
        Compartment[] compartments = new Compartment[c.size()];
        compartments = c.toArray(compartments);
        int i = 0;
        while (i < compartments.length) {
            if (compartments[i].getName().equals(compartmentName)) {
                return compartments[i];
            }
            ++i;
        }
        return null;
    }

    public BuildVariant[] getBuildVariants(String compartmentName) {
        Compartment c = this.getCompartment(compartmentName);
        if (c == null) {
            return new BuildVariant[0];
        }
        Map m = c.getBuildVariants();
        Collection coll = m.values();
        BuildVariant[] bvars = new BuildVariant[coll.size()];
        bvars = coll.toArray(bvars);
        return bvars;
    }

    public String[] getUsedCompartments(String compartmentName) {
        Compartment c = this.getCompartment(compartmentName);
        if (c == null) {
            return new String[0];
        }
        Set s = c.getUsedCompartments();
        if (s == null) {
            return new String[0];
        }
        String[] usedcomp = new String[s.size()];
        usedcomp = s.toArray(usedcomp);
        return usedcomp;
    }
}

