/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.impl;

import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

class DCFileInputProvider
implements DCInputProvider {
    private File m_defConfFile;
    private File m_defFolder;
    private boolean m_loadPublicParts = true;

    private DCFileInputProvider() {
    }

    public DCFileInputProvider(File defConfFile, File defFolder, boolean loadPublicParts) {
        this.m_defConfFile = defConfFile;
        this.m_defFolder = defFolder;
        this.m_loadPublicParts = loadPublicParts;
    }

    public void releaseStream(InputStream reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String[] getPublicParts() throws ProviderException {
        if (this.m_loadPublicParts) {
            if (this.m_defFolder.exists()) {
                String[] files = this.m_defFolder.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pp");
                    }
                });
                int length = files == null ? 0 : files.length;
                String[] res = new String[length];
                int i = 0;
                while (i < length) {
                    int n = files[i].lastIndexOf(".");
                    res[i] = files[i].substring(0, n);
                    ++i;
                }
                return res;
            }
            return new String[0];
        }
        return new String[0];
    }

    public InputStream getStreamForDC() throws ProviderException {
        if (this.m_defConfFile.exists()) {
            return this.getStream(this.m_defConfFile);
        }
        String m = "Cannot read component definition. File does not exist: " + this.m_defConfFile.getAbsolutePath();
        ProviderException pe = new ProviderException(m);
        throw pe;
    }

    public PPInputProvider getPPInputProvider(String publicPartName) {
        return new PPFileInputProvider(this.m_defFolder, publicPartName);
    }

    public void hidePublicParts(boolean doHide) {
        this.m_loadPublicParts = !doHide;
    }

    private InputStream getStream(File file) throws ProviderException {
        FileInputStream reader = null;
        if (file.exists()) {
            try {
                reader = new FileInputStream(file);
            }
            catch (Exception ex) {
                String m = "Error reading component definition file: " + file.getAbsolutePath() + " (" + ex.getMessage() + ").";
                ProviderException pe = new ProviderException(m, (Throwable)ex);
                throw pe;
            }
        }
        return reader;
    }

    public static class PPFileInputProvider
    implements PPInputProvider {
        private String m_ppName;
        private File m_defFolder;

        private PPFileInputProvider() {
        }

        public PPFileInputProvider(File defFolder, String ppName) {
            this.m_defFolder = defFolder;
            this.m_ppName = ppName;
        }

        public void releaseStream(InputStream reader) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public InputStream getStreamForPublicPart() throws ProviderException {
            File file = new File(this.m_defFolder.getAbsolutePath() + File.separator + this.m_ppName);
            return this.getStream(file);
        }

        private InputStream getStream(File file) throws ProviderException {
            FileInputStream reader = null;
            if (file.exists()) {
                try {
                    reader = new FileInputStream(file);
                }
                catch (Exception ex) {
                    String msg = "Cannot open file for read access: " + file.getAbsolutePath() + "(" + ex.getMessage() + ").";
                    ProviderException pex = new ProviderException(msg, (Throwable)ex);
                    throw pex;
                }
            }
            return reader;
        }
    }
}

