/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.impl;

import com.sap.cms.tcs.anttask.Component;
import com.sap.cms.tcs.anttask.TcsPra;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.tc.cbs.client.ActivationCheckMode;
import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.HTTPConnectionSettings;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildServer;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.IImportRequest;
import com.sap.tc.cbs.client.InputMode;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.impl.DCRef;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.cbstool.impl.CBSToolUtil;
import com.sap.tc.cbstool.impl.ComponentFactory2;
import com.sap.tc.cbstool.impl.DevConfigHandler;
import com.sap.tc.cbstool.impl.DevConfigHandlerFactory;
import com.sap.tc.cbstool.impl.ICBSTool;
import com.sap.tc.cbstool.impl.LogHandler;
import com.sap.tc.cbstool.impl.PasswordReader;
import com.sap.tc.cbstool.impl.PropertyReader;
import com.sap.tc.cbstool.shell.CBSToolCmdLine;
import com.sap.tc.cbstool.shell.ReturnCodes;
import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.ssl.util.PKCS7CertificateImport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class CBSTool
implements ICBSTool {
    private static String ls = System.getProperty("line.separator");
    private CBSToolCmdLine cmdLine;
    private boolean interactiveMode = true;
    private int verbosity = 1;
    private String logfile = null;
    private LogHandler logHandler = new LogHandler();
    private String commandString = null;
    private PropertyReader propertyReader = new PropertyReader();

    public IBuildServer connect(String serverURL, String user, String password, String readTimeout, String keyStoreFile) {
        HTTPConnectionSettings connectionSettings;
        String connTimeout = null;
        String proxy = null;
        String proxyport = null;
        String localPassword = null;
        String thisMethod = "CBSTool.connect";
        if (serverURL == null) {
            serverURL = this.propertyReader.getCbsUrl();
        }
        if (user == null) {
            user = this.propertyReader.getCbsUsr();
        }
        if (password == null) {
            password = this.propertyReader.getCbsPwd();
        }
        if (readTimeout == null) {
            readTimeout = this.propertyReader.getReadTimeout();
        }
        if (keyStoreFile == null) {
            keyStoreFile = this.propertyReader.getKeystoreFile();
        }
        proxy = this.propertyReader.getProxy();
        proxyport = this.propertyReader.getProxyPort();
        connTimeout = this.propertyReader.getConnectionTimeout();
        this.logHandler.msg(3, thisMethod, " method parameters - CBS URL: {0}, user: {1}, password: *****, read timeout: {3}, keystore file: {4}", new Object[]{serverURL, user, password, readTimeout, keyStoreFile});
        try {
            this.checkArguments(new String[]{"CBS URL", "user name"}, new String[]{serverURL, user});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return null;
        }
        int rtimeout = 0;
        if (readTimeout != null && readTimeout.length() > 0) {
            int i = 0;
            try {
                i = Integer.parseInt(readTimeout);
            }
            catch (NumberFormatException e) {
                this.logHandler.msg(0, "Parameter '" + readTimeout + "' for read timeout is not a valid integer.");
                return null;
            }
            rtimeout = i;
        }
        int ctimeout = 0;
        if (connTimeout != null && connTimeout.length() > 0) {
            int i = 0;
            try {
                i = Integer.parseInt(connTimeout);
            }
            catch (NumberFormatException e) {
                this.logHandler.msg(0, "Parameter '" + connTimeout + "' for connection timeout is not a valid integer.");
                return null;
            }
            ctimeout = i;
        }
        if (password == null || password.length() == 0) {
            PasswordReader pr = new PasswordReader();
            localPassword = pr.enterPassword("Enter CBS password: ");
        } else {
            localPassword = password;
        }
        try {
            if (proxy != null && proxy.length() > 0) {
                int port = 8080;
                if (proxyport != null && proxyport.length() > 0) {
                    port = Integer.parseInt(proxyport);
                }
                connectionSettings = new HTTPConnectionSettings(serverURL, user, password, proxy, port);
            } else {
                connectionSettings = new HTTPConnectionSettings(serverURL, user, localPassword);
            }
        }
        catch (Exception e) {
            this.logHandler.reportException(e, "Error while creating connection settings", thisMethod);
            return null;
        }
        connectionSettings.setSocketConnectTimeout(ctimeout);
        connectionSettings.setSocketReadTimeout(rtimeout);
        if (keyStoreFile != null && keyStoreFile.length() > 0) {
            try {
                PKCS7CertificateImport importer = new PKCS7CertificateImport();
                KeyStore ks = importer.importCertificates((InputStream)new FileInputStream(keyStoreFile), null);
                Certificates certs = connectionSettings.getSessionContext().certificates();
                certs.setAuthenticateThem(true);
                certs.setServerCertificates(ks);
            }
            catch (Exception e) {
                this.logHandler.reportException(e, "Error while importing certificate via keystore file '" + keyStoreFile + "'", thisMethod);
                return null;
            }
        }
        CBSFactory factory = new CBSFactory();
        IBuildServer cbsProxy = null;
        try {
            cbsProxy = factory.getBuildServer((IConnectionTemplate)connectionSettings);
        }
        catch (CommunicationException e) {
            this.logHandler.reportException((Exception)((Object)e), "Error while creating CBS proxy", thisMethod);
            return null;
        }
        try {
            cbsProxy.ping();
        }
        catch (AuthorizationException e) {
            this.logHandler.reportException((Exception)((Object)e), "Error while checking connection", thisMethod);
            return null;
        }
        catch (CommunicationException e) {
            this.logHandler.reportException((Exception)((Object)e), "Error while checking connection", thisMethod);
            return null;
        }
        this.logHandler.msg(0, "CBS proxy successfully created");
        return cbsProxy;
    }

    public int listBuildSpaces(IBuildServer cbsProxy) {
        String thisMethod = "CBSTool.buildspaces";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}", new Object[]{cbsProxy});
        try {
            this.checkArguments(cbsProxy, new String[0], new String[0]);
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        StringBuffer sb = new StringBuffer();
        try {
            IBuildSpace[] buildSpaces = cbsProxy.listBuildSpaces();
            int counter = buildSpaces != null ? buildSpaces.length : 0;
            int j = 0;
            while (j < counter) {
                sb.append(buildSpaces[j].getName() + ls);
                ++j;
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while retrieving build spaces", thisMethod);
        }
        this.logHandler.msg(1, "Build spaces of CBS " + cbsProxy.getURL() + " :" + ls);
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int createbs(IBuildServer cbsProxy, String configFilePath, String user, String password) {
        String localPassword = null;
        String thisMethod = "CBSTool.createbuildspace";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, development configuration: {1}, DTR user: {2}, password: ***** ", new Object[]{cbsProxy, configFilePath, user});
        try {
            this.checkArguments(cbsProxy, new String[]{"development configuration file", "DTR user"}, new String[]{configFilePath, user});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        File confFile = new File(configFilePath);
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(confFile);
        }
        catch (FileNotFoundException e) {
            return this.handleException(e, "File " + confFile.getAbsolutePath() + " cannot be found.", thisMethod);
        }
        if (password == null) {
            PasswordReader pr = new PasswordReader();
            localPassword = pr.enterPassword("Enter DTR password: ");
        } else {
            localPassword = password;
        }
        try {
            try {
                IBuildSpace bsProxy = cbsProxy.createBuildSpace((InputStream)configStream, confFile.length(), user, localPassword);
                bsProxy.setBuildProcessingEnabled(true);
                bsProxy.setInputMode(InputMode.OPEN);
            }
            catch (Exception e) {
                int n = this.handleException(e, "Error while creating build space.", thisMethod);
                Object var12_14 = null;
                this.closeInputStream(configStream);
                return n;
            }
            Object var12_13 = null;
            this.closeInputStream(configStream);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.closeInputStream(configStream);
            throw throwable;
        }
        this.logHandler.msg(0, "Build space successfully created.");
        return 0;
    }

    public int removebs(IBuildServer cbsProxy, String buildSpace) {
        String thisMethod = "CBSTool.removebuildspace";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}", new Object[]{cbsProxy, buildSpace});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        try {
            bsProxy.remove();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while removing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, "Build space '" + buildSpace + "' successfully removed.");
        return 0;
    }

    public int listPendingActivities(IBuildServer cbsProxy, String buildSpace, String compartment, String user) {
        String thisMethod = "CBSTool.pendingActivities";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, user: {3}", new Object[]{cbsProxy, buildSpace, compartment, user});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        String[] activities = null;
        StringBuffer sb = new StringBuffer();
        try {
            if (compartment != null) {
                activities = bsProxy.listPendingActivities(compartment, user);
                this.getActivityInfo(sb, user, activities, compartment, buildSpace);
            } else {
                int counter;
                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                Compartment[] compartments = dch.getCompartments();
                int n = counter = compartments != null ? compartments.length : 0;
                if (counter == 0) {
                    this.logHandler.msg(0, ls + "No compartments found in build space '" + buildSpace + "'");
                }
                int i = 0;
                while (i < counter) {
                    Compartment c = compartments[i];
                    if (c.hasSourceState()) {
                        activities = bsProxy.listPendingActivities(c.getName(), user);
                        this.getActivityInfo(sb, user, activities, c.getName(), buildSpace);
                    } else {
                        this.logHandler.msg(0, ls + "Compartment '" + c.getName() + "' of build space '" + buildSpace + "' has not source state");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while retrieving pending activities.", thisMethod);
        }
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int activate(IBuildServer cbsProxy, String buildSpace, String compartment, String user, boolean ignoreComponentLevelIntersection, boolean activateIfBuildFails, String modeStr, String activityList, boolean confirm) {
        IActivitySet activitySet;
        String thisMethod = "CBSTool.activate";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, user: {3}, ignoreComponentLevelIntersection: {4}, activateIfBuildFails: {5}, modeStr: {6}, activity list: {7}", new Object[]{cbsProxy, buildSpace, compartment, user, new Boolean(ignoreComponentLevelIntersection), new Boolean(activateIfBuildFails), modeStr, activityList});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment", "activation mode"}, new String[]{buildSpace, compartment, modeStr});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        ActivationCheckMode mode = ActivationCheckMode.FORCE;
        if (modeStr.equalsIgnoreCase("force")) {
            mode = ActivationCheckMode.FORCE;
        } else if (modeStr.equalsIgnoreCase("reject")) {
            mode = ActivationCheckMode.REJECT;
        } else {
            String message = "Invalid activation mode '" + modeStr + "', allowed values: (force|reject)";
            this.logHandler.msg(0, message);
            return 100;
        }
        HashSet<String> set = new HashSet<String>();
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        String[] activities = null;
        try {
            activities = bsProxy.listPendingActivities(compartment, user);
        }
        catch (Exception e) {
            return this.handleException(e, "Error while retrieving pending activities.", thisMethod);
        }
        if (activities == null || activities.length == 0) {
            this.logHandler.msg(0, "No pending activities were found.");
            return 0;
        }
        IActivitySet[] activitySetArray = new IActivitySet[1];
        CBSFactory factory = new CBSFactory();
        activitySetArray[0] = activitySet = factory.createEmptyActivitySet();
        if (activityList == null) {
            if (!confirm) {
                String msg = "Do you really want to activate all pending activities of the specified user (y/n)? ";
                System.out.print(msg);
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                String str = "";
                try {
                    str = in.readLine();
                }
                catch (IOException e) {
                    return this.handleException(e, "Error while reading user input.", thisMethod);
                }
                if (!str.equalsIgnoreCase("y")) {
                    this.logHandler.msg(0, "User decided to abort activation of pending activities.");
                    return 0;
                }
            }
            int c = 0;
            while (c < activities.length) {
                set.add(activities[c]);
                ++c;
            }
        } else {
            activityList = CBSToolUtil.stripQuotes(activityList);
            String[] args = CBSToolUtil.str2Array(activityList, ",");
            int i = 0;
            while (i < args.length) {
                set.add(args[i]);
                ++i;
            }
        }
        String[] activityIDs = new String[set.size()];
        Iterator it = set.iterator();
        int counter = 0;
        while (it.hasNext()) {
            String str;
            activityIDs[counter] = str = (String)it.next();
            this.logHandler.msg(1, "Take activity " + str + " for activation.");
            ++counter;
        }
        activitySet.setActivityUIDs(activityIDs);
        activitySet.setCompartmentName(compartment);
        IBuildRequest request = null;
        try {
            request = bsProxy.activate(activitySetArray, ignoreComponentLevelIntersection, false, activateIfBuildFails, mode);
        }
        catch (Exception e) {
            return this.handleException(e, "Error while triggering activation.", thisMethod);
        }
        long reqID = request.getRequestID();
        this.logHandler.msg(0, "Activation request " + reqID + " has been triggered.");
        return 0;
    }

    public int bsState(IBuildServer cbsProxy, String buildSpace) {
        String thisMethod = "CBSTool.buildSpaceStatus";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}", new Object[]{cbsProxy, buildSpace});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        StringBuffer sb = new StringBuffer();
        sb.append("Information on build space '" + buildSpace + "'" + ls);
        try {
            boolean bool1 = bsProxy.isBuildProcessingEnabled();
            sb.append("   build processing enabled: " + new Boolean(bool1) + ls);
            boolean bool2 = bsProxy.isOutputLocked();
            sb.append("   output locked           : " + new Boolean(bool2) + ls);
            boolean bool3 = bsProxy.isOutputQueueingEnabled();
            sb.append("   output queueing enabled : " + new Boolean(bool3) + ls);
            InputMode mode = bsProxy.getInputMode();
            sb.append("   input mode              : " + mode + ls);
            long[] l1 = bsProxy.listQueuedResults();
            sb.append("   number of queued results: " + l1.length + ls);
            long[] l2 = bsProxy.listOpenRequests();
            sb.append("   number of open requests : " + l2.length + ls);
            DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
            Compartment[] compartments = dch.getCompartments();
            if (compartments != null) {
                int i = 0;
                while (i < compartments.length) {
                    Compartment c = compartments[i];
                    sb.append("   Compartment #" + (i + 1) + ls);
                    sb.append("      compartment name         : " + c.getName() + ls);
                    sb.append("      software component name  : " + c.getScName() + ls);
                    sb.append("      software component vendor: " + c.getScVendor() + ls);
                    sb.append("      has archive state        : " + new Boolean(c.getHasArchiveState()) + ls);
                    sb.append("      has source state         : " + new Boolean(c.hasSourceState()) + ls);
                    sb.append("      build variants           : ");
                    BuildVariant[] bvars = dch.getBuildVariants(c.getName());
                    int j = 0;
                    while (j < bvars.length) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(bvars[j].getName());
                        ++j;
                    }
                    sb.append(ls);
                    sb.append("      used compartments        : ");
                    String[] usedcomp = dch.getUsedCompartments(c.getName());
                    int k = 0;
                    while (k < usedcomp.length) {
                        if (k > 0) {
                            sb.append(", ");
                        }
                        sb.append(usedcomp[k].toString());
                        ++k;
                    }
                    sb.append(ls);
                    IDCRef[] refs = bsProxy.listDCs(c.getName());
                    int counter = refs != null ? refs.length : 0;
                    sb.append("      number of DCs            : " + counter);
                    sb.append(ls);
                    IDCRef[] refs2 = bsProxy.listProblemDCs(c.getName());
                    int counter2 = refs2 != null ? refs2.length : 0;
                    sb.append("      number of problem DCs    : " + counter2);
                    sb.append(ls);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int buildAll(IBuildServer cbsProxy, String buildSpace, String compartment, String buildVariant) {
        String thisMethod = "CBSTool.buildAll";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, build variant: {3}", new Object[]{cbsProxy, buildSpace, compartment, buildVariant});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment"}, new String[]{buildSpace, compartment});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        String[] bvars = null;
        if (buildVariant == null) {
            try {
                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                BuildVariant[] variants = dch.getBuildVariants(compartment);
                int counter = variants != null ? variants.length : 0;
                bvars = new String[counter];
                int j = 0;
                while (j < counter) {
                    bvars[j] = variants[j].getName();
                    ++j;
                }
            }
            catch (Exception e) {
                return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
            }
        } else {
            bvars = new String[]{buildVariant};
        }
        IBuildRequest ibr = null;
        try {
            ibr = bsProxy.buildAll(compartment, bvars);
        }
        catch (Exception e) {
            return this.handleException(e, "Error while triggering build for all DCs of compartment '" + compartment + "' of build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, "Build request " + ibr.getRequestID() + " has been triggered.");
        return 0;
    }

    public int buildDC(IBuildServer cbsProxy, String buildSpace, String compartment, String dcName, String dcVendor, String buildVariant) {
        String thisMethod = "CBSTool.buildDC";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, DC name: {3}, DC vendor: {4}, build variant: {5}", new Object[]{cbsProxy, buildSpace, compartment, dcName, dcVendor, buildVariant});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment", "DC name", "DC vendor"}, new String[]{buildSpace, compartment, dcName, dcVendor});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        String[] bvars = null;
        if (buildVariant == null) {
            try {
                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                BuildVariant[] variants = dch.getBuildVariants(compartment);
                int counter = variants != null ? variants.length : 0;
                bvars = new String[counter];
                int j = 0;
                while (j < counter) {
                    bvars[j] = variants[j].getName();
                    ++j;
                }
            }
            catch (Exception e) {
                return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
            }
        } else {
            bvars = new String[]{buildVariant};
        }
        IBuildRequest ibr = null;
        try {
            ibr = bsProxy.buildDC(compartment, dcVendor, dcName, bvars);
        }
        catch (Exception e) {
            return this.handleException(e, "Error while triggering build for DCs '" + dcName + "' in compartment '" + compartment + "' of build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, "Build request " + ibr.getRequestID() + " has been triggered.");
        return 0;
    }

    public int latestBuildNumber(IBuildServer cbsProxy, String buildSpace, String compartment, String dcName, String dcVendor, String buildVariant) {
        String thisMethod = "CBSTool.latestBuildNumber";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, DC name: {3}, DC vendor: {4}, build variant: {5}", new Object[]{cbsProxy, buildSpace, compartment, dcName, dcVendor, buildVariant});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment", "DC name", "DC vendor", "build variant"}, new String[]{buildSpace, compartment, dcName, dcVendor, buildVariant});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        String[] bvars = new String[]{buildVariant};
        long buildNumber = 0L;
        try {
            buildNumber = bsProxy.getLatestBuildNumber(compartment, dcVendor, dcName, buildVariant);
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(1, "Latest build number is: ");
        this.logHandler.msg(0, Long.toString(buildNumber));
        return 0;
    }

    public int listBuildVariants(IBuildServer cbsProxy, String buildSpace, String compartment) {
        String thisMethod = "CBSTool.listBuildVariants";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}", new Object[]{cbsProxy, buildSpace, compartment});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment"}, new String[]{buildSpace, compartment});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(1, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        StringBuffer sb = new StringBuffer();
        try {
            DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
            BuildVariant[] bvars = dch.getBuildVariants(compartment);
            int counter = bvars != null ? bvars.length : 0;
            int j = 0;
            while (j < counter) {
                sb.append(bvars[j].getName() + ls);
                ++j;
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(1, "Build variants of compartment '" + compartment + "' in build space '" + buildSpace + "':" + ls);
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int listCompartments(IBuildServer cbsProxy, String buildSpace) {
        String thisMethod = "CBSTool.listCompartments";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}", new Object[]{cbsProxy, buildSpace});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        StringBuffer sb = new StringBuffer();
        try {
            DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
            Compartment[] compartments = dch.getCompartments();
            int counter = compartments != null ? compartments.length : 0;
            int i = 0;
            while (i < counter) {
                Compartment c = compartments[i];
                sb.append(c.getName() + ls);
                ++i;
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(1, "Compartments of build space '" + buildSpace + "':" + ls);
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int listDCs(IBuildServer cbsProxy, String buildSpace, String compartment, String mode) {
        String thisMethod = "CBSTool.listDCs";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}", new Object[]{cbsProxy, buildSpace, compartment});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment"}, new String[]{buildSpace, compartment});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        String imode = "all";
        if (mode != null) {
            imode = mode;
        }
        if (!(imode.equalsIgnoreCase("all") || imode.equalsIgnoreCase("problem") || imode.equalsIgnoreCase("dirty") || imode.equalsIgnoreCase("broken"))) {
            this.logHandler.msg(0, "Invalid mode '" + imode + "' used, allowed values: (all | problem | dirty | broken)");
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        IDCRef[] refs = null;
        StringBuffer sb = new StringBuffer();
        try {
            DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
            if (imode.equalsIgnoreCase("all")) {
                refs = bsProxy.listDCs(compartment);
                this.writeOutput(refs, sb, "", "", compartment, buildSpace);
            } else if (imode.equalsIgnoreCase("problem")) {
                refs = bsProxy.listProblemDCs(compartment);
                this.writeOutput(refs, sb, imode, "", compartment, buildSpace);
            } else if (imode.equalsIgnoreCase("dirty")) {
                BuildVariant[] bvars = dch.getBuildVariants(compartment);
                int i = 0;
                while (i < bvars.length) {
                    String bvar = bvars[i].getName();
                    refs = bsProxy.listDirtyDCs(compartment, bvar);
                    String bvarStr = " with build variant '" + bvar + "'";
                    this.writeOutput(refs, sb, imode, bvarStr, compartment, buildSpace);
                    ++i;
                }
            } else if (imode.equalsIgnoreCase("broken")) {
                BuildVariant[] bvars = dch.getBuildVariants(compartment);
                int i = 0;
                while (i < bvars.length) {
                    String bvar = bvars[i].getName();
                    refs = bsProxy.listBrokenDCs(compartment, bvar);
                    String bvarStr = " with build variant '" + bvar + "'";
                    this.writeOutput(refs, sb, imode, bvarStr, compartment, buildSpace);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int requestState(IBuildServer cbsProxy, String buildSpace, String requestNumber) {
        String thisMethod = "CBSTool.requestState";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, request number: {2}", new Object[]{cbsProxy, buildSpace, requestNumber});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "request number"}, new String[]{buildSpace, requestNumber});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        long l = 0L;
        try {
            l = Long.parseLong(requestNumber);
        }
        catch (NumberFormatException e) {
            this.logHandler.msg(0, "Parameter '" + requestNumber + "' for request number is not a valid number.");
            return 106;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("Information on request number " + requestNumber + ls);
            IBuildRequest ibr = bsProxy.getBuildRequest(l);
            BuildRequestStatus stat = ibr.getStatus();
            sb.append("   request state: " + stat + ls);
            if (!stat.isTransientState()) {
                sb.append("   follow up requests: ");
                long[] l2 = ibr.listFollowUpRequests();
                int j = 0;
                while (j < l2.length) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(l2[j]);
                    ++j;
                }
                sb.append(ls + ls);
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "' for build request '" + requestNumber + "'", thisMethod);
        }
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public int listOpenRequests(IBuildServer cbsProxy, String buildSpace) {
        String thisMethod = "CBSTool.openRequests";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}", new Object[]{cbsProxy, buildSpace});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        StringBuffer sb = new StringBuffer();
        try {
            long[] l = bsProxy.listOpenRequests();
            if (l == null || l.length == 0) {
                sb.append("No open requests on build space '" + buildSpace + "'" + ls);
            } else {
                sb.append("Open requests on build space '" + buildSpace + "'" + ls);
                int i = 0;
                while (i < l.length) {
                    sb.append("Request " + (i + 1) + ls);
                    sb.append("   request number: " + l[i] + ls);
                    IBuildRequest ibr = bsProxy.getBuildRequest(l[i]);
                    BuildRequestStatus stat = ibr.getStatus();
                    sb.append("   request state: " + stat + ls);
                    if (!stat.isTransientState()) {
                        sb.append("   follow up requests: ");
                        long[] l2 = ibr.listFollowUpRequests();
                        int j = 0;
                        while (j < l2.length) {
                            if (j > 0) {
                                sb.append(", ");
                            }
                            sb.append(l2[j]);
                            ++j;
                        }
                        sb.append(ls + ls);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        this.logHandler.msg(0, sb.toString());
        return 0;
    }

    public void println(String message) {
        this.logHandler.println(message);
    }

    public void setCommandString(String s) {
        this.commandString = s;
        this.logHandler.setCommandString(s);
    }

    /*
     * WARNING - void declaration
     */
    public int uploadSca(IBuildServer cbsProxy, String buildSpace, String compartment, String scaFile, String buildVariant, String mode, boolean mirror) {
        File dir2;
        String thisMethod = "CBSTool.uploadSca";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, sca file: {3}, build variant: {4}, mode: {5}, mirror: {6}", new Object[]{cbsProxy, buildSpace, compartment, scaFile, buildVariant, mode, new Boolean(mirror)});
        try {
            this.checkArguments(cbsProxy, new String[]{"scaFile", "build space", "compartment", "build variant"}, new String[]{scaFile, buildSpace, compartment, buildVariant});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        String iMode = mode;
        if (iMode == null) {
            iMode = "stoponerror";
        }
        if (!iMode.equalsIgnoreCase("stoponerror") && !iMode.equalsIgnoreCase("ignoreerror")) {
            this.logHandler.msg(0, "Invalid mode '" + mode + "' used, allowed values: (stoponerror | ignoreerror)");
            return 100;
        }
        IDCRef[] dcRefs = null;
        HashSet<DCRef> dcRefSet = new HashSet<DCRef>();
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        IImportRequest request = null;
        try {
            request = bsProxy.createImportRequest();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while creating import request on build space '" + buildSpace + "'", thisMethod);
        }
        String tempDir = null;
        ZipInputStream in = null;
        try {
            block30: {
                try {
                    tempDir = System.getProperty("java.io.tmpdir");
                    String timestamp = Util.getTimeStamp();
                    Random rand = new Random();
                    int ri = rand.nextInt(1000000);
                    if (tempDir == null || tempDir.length() == 0) {
                        tempDir = "." + File.separator + "uploadsca" + timestamp + "_" + ri + File.separator;
                    } else {
                        tempDir = Util.concatenatePath((String)tempDir, (String)"uploadsca", (char)File.separatorChar);
                        tempDir = tempDir + timestamp + "_" + ri + File.separator;
                    }
                    this.logHandler.msg(2, "Create temporary directoy " + tempDir);
                    CBSToolUtil.mkdirs(tempDir);
                    if (mirror) {
                        dcRefs = bsProxy.listDCs(compartment);
                    }
                    in = new ZipInputStream(new FileInputStream(scaFile));
                    ZipEntry zipEntry = in.getNextEntry();
                    while (zipEntry != null) {
                        String folderName;
                        String zipEntryName = zipEntry.getName();
                        this.logHandler.msg(2, "Current zip entry: " + zipEntryName);
                        int index = zipEntryName.indexOf("/");
                        if (index >= 0 && !zipEntry.isDirectory() && ((folderName = zipEntryName.substring(0, index)).equalsIgnoreCase("buildarchives") || folderName.equalsIgnoreCase("deployarchives"))) {
                            index = zipEntryName.lastIndexOf("/");
                            String archiveFile = zipEntryName.substring(index);
                            if (index >= 0) {
                                DCRef ref;
                                int rc;
                                int len;
                                archiveFile = tempDir + archiveFile;
                                File f = new File(archiveFile);
                                FileOutputStream out = new FileOutputStream(archiveFile);
                                byte[] buf = new byte[1024];
                                while ((len = in.read(buf)) > 0) {
                                    void var27_37;
                                    ((OutputStream)out).write(buf, 0, (int)var27_37);
                                }
                                ((OutputStream)out).close();
                                if (folderName.equalsIgnoreCase("buildarchives")) {
                                    String dcdefFile = tempDir + ".dcdef";
                                    boolean success = this.extractFileFromArchive(archiveFile, dcdefFile, ".dcdef");
                                    if (success) {
                                        com.sap.tc.complib.Component comp = ComponentFactory2.getInstance(dcdefFile);
                                        rc = this.uploadDCIA(request, compartment, comp.getVendor(), comp.getName(), buildVariant, archiveFile);
                                        ref = new DCRef(comp.getVendor(), comp.getName());
                                        dcRefSet.add(ref);
                                        File f1 = new File(dcdefFile);
                                        f1.delete();
                                        if (rc != 0 && iMode.equalsIgnoreCase("stoponerror")) {
                                            f.delete();
                                            throw new Exception("SCA upload aborted as upload of DCIA '" + archiveFile + "' failed.");
                                        }
                                    } else if (iMode.equalsIgnoreCase("stoponerror")) {
                                        f.delete();
                                        throw new Exception("SCA upload aborted as .dcdef file cannot be extracted from DCIA '" + archiveFile + "'");
                                    }
                                }
                                if (folderName.equalsIgnoreCase("deployarchives")) {
                                    JarSL sl = new JarSL(archiveFile, tempDir);
                                    String dcname = sl.readAttribute("", "keyname");
                                    String vendor = sl.readAttribute("", "keyvendor");
                                    rc = this.uploadDCA(request, compartment, vendor, dcname, buildVariant, archiveFile);
                                    ref = new DCRef(vendor, dcname);
                                    dcRefSet.add(ref);
                                    if (rc != 0 && iMode.equalsIgnoreCase("stoponerror")) {
                                        f.delete();
                                        throw new Exception("SCA upload aborted as upload of DCA '" + archiveFile + "' failed.");
                                    }
                                }
                                f.delete();
                            }
                        }
                        zipEntry = in.getNextEntry();
                    }
                    if (!mirror) break block30;
                    int counter = dcRefs != null ? dcRefs.length : 0;
                    int i = 0;
                    while (i < counter) {
                        if (!dcRefSet.contains(dcRefs[i])) {
                            request.addDCDeletion(compartment, dcRefs[i].getVendor(), dcRefs[i].getName());
                            this.logHandler.msg(1, "Deletion of DC " + dcRefs[i].getName() + " with vendor " + dcRefs[i].getVendor() + " in compartment " + compartment + " has been added to request.");
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    int rc = this.handleException(e, "Error while trying to upload software component archive '" + scaFile + "'", thisMethod);
                    try {
                        request.cancel();
                    }
                    catch (Exception e1) {
                        int n = this.handleException(e1, "Error while cancelling import request", thisMethod);
                        Object var35_46 = null;
                        File dir2 = new File(tempDir);
                        this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                        Util.deleteDirRecursively((File)dir2);
                        this.closeInputStream(in);
                        return n;
                    }
                    int n = rc;
                    Object var35_47 = null;
                    File dir2 = new File(tempDir);
                    this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                    Util.deleteDirRecursively((File)dir2);
                    this.closeInputStream(in);
                    return n;
                }
            }
            Object var35_45 = null;
            dir2 = new File(tempDir);
            this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
        }
        catch (Throwable throwable) {
            Object var35_48 = null;
            File dir2 = new File(tempDir);
            this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
            Util.deleteDirRecursively((File)dir2);
            this.closeInputStream(in);
            throw throwable;
        }
        Util.deleteDirRecursively((File)dir2);
        this.closeInputStream(in);
        try {
            request.commit();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while commiting import request", thisMethod);
        }
        long reqID = request.getRequestID();
        this.logHandler.msg(0, "Import request " + reqID + " has been triggered to upload software component archive.");
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int downloadSca(IBuildServer cbsProxy, String buildSpace, String compartment, String scaFile, String buildVariant, String mode) {
        String tempDir;
        File f;
        block22: {
            int n;
            block24: {
                int n2;
                block23: {
                    int n3;
                    block21: {
                        int n4;
                        block20: {
                            File dir2;
                            int n5;
                            block19: {
                                String thisMethod = "CBSTool.downloadSca";
                                this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, sca file: {3}, build variant: {4}, mode: {5}", new Object[]{cbsProxy, buildSpace, compartment, scaFile, buildVariant, mode});
                                try {
                                    this.checkArguments(cbsProxy, new String[]{"scaFile", "build space", "compartment", "build variant"}, new String[]{scaFile, buildSpace, compartment, buildVariant});
                                }
                                catch (IllegalArgumentException e) {
                                    this.logHandler.msg(0, e.getMessage());
                                    return 100;
                                }
                                String iMode = mode;
                                if (iMode == null) {
                                    iMode = "stoponerror";
                                }
                                if (!(iMode.equalsIgnoreCase("stoponerror") || iMode.equalsIgnoreCase("stopondirtydc") || iMode.equalsIgnoreCase("stoponbrokendc") || iMode.equalsIgnoreCase("ignoreerror"))) {
                                    this.logHandler.msg(0, "Invalid mode '" + mode + "' used, allowed values: (stoponerror | stopondirtydc | stoponbrokendc | ignoreerror)");
                                    return 100;
                                }
                                IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
                                IDCRef[] refs = null;
                                IDCVariantState[] variants = null;
                                f = new File(scaFile);
                                tempDir = null;
                                try {
                                    try {
                                        tempDir = System.getProperty("java.io.tmpdir");
                                        String timestamp = Util.getTimeStamp();
                                        Random rand = new Random();
                                        int ri = rand.nextInt(1000000);
                                        if (tempDir == null || tempDir.length() == 0) {
                                            tempDir = "." + File.separator + "downloadsca" + timestamp + "_" + ri + File.separator;
                                        } else {
                                            tempDir = Util.concatenatePath((String)tempDir, (String)"downloadsca", (char)File.separatorChar);
                                            tempDir = tempDir + timestamp + "_" + ri + File.separator;
                                        }
                                        String dciaDir = tempDir + "buildarchives" + File.separator;
                                        this.logHandler.msg(2, "Create temporary directoy " + dciaDir);
                                        CBSToolUtil.mkdirs(dciaDir);
                                        String dcaDir = tempDir + "deployarchives" + File.separator;
                                        this.logHandler.msg(2, "Create temporary directoy " + dcaDir);
                                        CBSToolUtil.mkdirs(dcaDir);
                                        int rc = 0;
                                        int counter = 0;
                                        refs = bsProxy.listDirtyDCs(compartment, buildVariant);
                                        int n6 = counter = refs != null ? refs.length : 0;
                                        if (counter > 0 && iMode.equalsIgnoreCase("stopondirtydc")) {
                                            this.logHandler.msg(0, "Dirty DCs have been detected for build variant '" + buildVariant + "' in compartment '" + compartment + "'. Download has been aborted.");
                                            n5 = 111;
                                            Object var29_28 = null;
                                            dir2 = new File(tempDir);
                                            this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                                            break block19;
                                        }
                                        refs = bsProxy.listBrokenDCs(compartment, buildVariant);
                                        int n7 = counter = refs != null ? refs.length : 0;
                                        if (counter > 0 && iMode.equalsIgnoreCase("stoponbrokendc")) {
                                            this.logHandler.msg(0, "Broken DCs have been detected for build variant '" + buildVariant + "' in compartment '" + compartment + "'. Download has been aborted.");
                                            n4 = 111;
                                            break block20;
                                        }
                                        refs = bsProxy.listDCs(compartment);
                                        variants = bsProxy.listDCVariantStates(compartment, buildVariant, refs);
                                        if (!CBSToolUtil.createFile(scaFile)) {
                                            this.logHandler.msg(0, "Can't create software component archive file '" + f.getAbsolutePath() + "'");
                                            n3 = 107;
                                            break block21;
                                        }
                                        int i = 0;
                                        while (true) {
                                            boolean loadDCA;
                                            if (i >= refs.length) {
                                                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                                                Compartment theCompartment = dch.getCompartment(compartment);
                                                this.createPra(dcaDir, dciaDir, scaFile, theCompartment);
                                                break block22;
                                            }
                                            String dcName = refs[i].getName();
                                            String dcVendor = refs[i].getVendor();
                                            String dcaFileName = dcVendor + "#" + dcName + "#dca.zip";
                                            dcaFileName = dcaFileName.replace('/', '#');
                                            boolean bl = loadDCA = variants[i] != null ? variants[i].isDeployable() : false;
                                            if (loadDCA && (rc = this.downloadDCA(bsProxy, compartment, dcVendor, dcName, buildVariant, dcaDir + dcaFileName)) != 0) {
                                                this.logHandler.msg(0, "Download of archive failed.");
                                                if (!iMode.equalsIgnoreCase("ignoreerror")) {
                                                    this.logHandler.msg(0, "Download aborted due to error(s)");
                                                    this.logHandler.msg(0, "Error while filling software component archive file '" + f.getAbsolutePath() + "' for compartment '" + compartment + "' of build space '" + buildSpace + "'");
                                                    n2 = rc;
                                                    break block23;
                                                }
                                            }
                                            String dciaFileName = dcVendor + "#" + dcName + "#dcia.zip";
                                            dciaFileName = dciaFileName.replace('/', '#');
                                            rc = this.downloadDCIA(bsProxy, compartment, dcVendor, dcName, buildVariant, dciaDir + dciaFileName);
                                            if (rc != 0) {
                                                this.logHandler.msg(0, "Download of archive failed.");
                                                if (!iMode.equalsIgnoreCase("ignoreerror")) {
                                                    this.logHandler.msg(0, "Download aborted due to error(s)");
                                                    this.logHandler.msg(0, "Error while filling software component archive file '" + f.getAbsolutePath() + "' for compartment '" + compartment + "' of build space '" + buildSpace + "'");
                                                    n = rc;
                                                    break block24;
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    catch (Exception e) {
                                        int n8 = this.handleException(e, "Error while filling software component archive file '" + f.getAbsolutePath() + "' for compartment '" + compartment + "' of build space '" + buildSpace + "'", thisMethod);
                                        Object var29_34 = null;
                                        File dir2 = new File(tempDir);
                                        this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                                        Util.deleteDirRecursively((File)dir2);
                                        return n8;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var29_35 = null;
                                    File dir2 = new File(tempDir);
                                    this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                                    Util.deleteDirRecursively((File)dir2);
                                    throw throwable;
                                }
                            }
                            Util.deleteDirRecursively((File)dir2);
                            return n5;
                        }
                        Object var29_29 = null;
                        File dir2 = new File(tempDir);
                        this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                        Util.deleteDirRecursively((File)dir2);
                        return n4;
                    }
                    Object var29_30 = null;
                    File dir2 = new File(tempDir);
                    this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                    Util.deleteDirRecursively((File)dir2);
                    return n3;
                }
                Object var29_31 = null;
                File dir2 = new File(tempDir);
                this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
                Util.deleteDirRecursively((File)dir2);
                return n2;
            }
            Object var29_32 = null;
            File dir2 = new File(tempDir);
            this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
            Util.deleteDirRecursively((File)dir2);
            return n;
        }
        Object var29_33 = null;
        File dir2 = new File(tempDir);
        this.logHandler.msg(2, "Delete temporary directoy " + dir2.getAbsolutePath());
        Util.deleteDirRecursively((File)dir2);
        this.logHandler.msg(0, "Created software component archive file '" + f.getAbsolutePath() + "' for compartment '" + compartment + "' of build space '" + buildSpace + "'");
        return 0;
    }

    public void setMode(boolean interactive) {
        this.interactiveMode = interactive;
    }

    public int verbosity(String infoLevel) {
        String thisMethod = "CBSTool.verbosity";
        this.logHandler.msg(3, thisMethod, " method parameters - info level: {0}", new Object[]{infoLevel});
        if (infoLevel == null) {
            String message = "Invalid info level '" + infoLevel + "' allowed values: (low | normal | high | debug)";
            this.logHandler.msg(0, message);
            return 100;
        }
        if (!infoLevel.equalsIgnoreCase("low")) {
            if (infoLevel.equalsIgnoreCase("normal")) {
                this.verbosity = 1;
                this.logHandler.setVerbosity(this.verbosity);
            } else if (infoLevel.equalsIgnoreCase("high")) {
                this.verbosity = 2;
                this.logHandler.setVerbosity(this.verbosity);
            } else if (infoLevel.equalsIgnoreCase("debug")) {
                this.verbosity = 3;
                this.logHandler.setVerbosity(this.verbosity);
            } else {
                String message = "Invalid info level '" + infoLevel + "' allowed values: (low | normal | high | debug)";
                this.logHandler.msg(0, message);
                return 100;
            }
        }
        this.logHandler.msg(0, "Set verbosity to '" + infoLevel + "'");
        return 0;
    }

    public int logfile(String filename, String mode) {
        String thisMethod = "CBSTool.logfile";
        this.logHandler.msg(3, thisMethod, " method parameters - log file: {0}, mode: {1}", new Object[]{filename, mode});
        this.logfile = filename;
        if (mode != null && !mode.equalsIgnoreCase("append") && !mode.equalsIgnoreCase("override")) {
            String message = "Invalid mode '" + mode + "' allowed values: (append | overwrite)";
            this.logHandler.msg(0, message);
            return 100;
        }
        this.logHandler.setLogfile(filename, mode);
        return 0;
    }

    public int tracefile(String filename, String severity) {
        String thisMethod = "CBSTool.tracefile";
        this.logHandler.msg(3, thisMethod, " method parameters - trace file: {0}, severity: {1}", new Object[]{filename, severity});
        try {
            this.checkArguments(new String[]{"trace file"}, new String[]{filename});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        this.logHandler.setTracefile(filename, severity);
        return 0;
    }

    public int downloadConfiguration(IBuildServer cbsProxy, String buildSpace, String filename) {
        File f;
        block7: {
            String thisMethod = "CBSTool.downloadConfiguration";
            this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, file name: {2}", new Object[]{cbsProxy, buildSpace, filename});
            try {
                this.checkArguments(cbsProxy, new String[]{"build space", "filename"}, new String[]{buildSpace, filename});
            }
            catch (IllegalArgumentException e) {
                this.logHandler.msg(0, e.getMessage());
                return 100;
            }
            IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
            f = new File(filename);
            try {
                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                String configStr = dch.configAsString();
                if (CBSToolUtil.createFile(filename)) {
                    try {
                        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
                        out.write(configStr);
                        out.close();
                    }
                    catch (IOException e) {
                        this.logHandler.reportException(e, "Error while writing development configuration file '" + f.getAbsolutePath() + "'", thisMethod);
                    }
                    break block7;
                }
                this.logHandler.msg(0, "Can't create development configuration file '" + f.getAbsolutePath() + "'");
                return 107;
            }
            catch (Exception e) {
                return this.handleException(e, "Error while reading development configuration", thisMethod);
            }
        }
        this.logHandler.msg(0, "Downloaded development configuration into file '" + f.getAbsolutePath() + "'.");
        return 0;
    }

    public int updatebs(IBuildServer cbsProxy, String buildSpace, String filename) {
        String thisMethod = "CBSTool.updatebs";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, file name: {2} ", new Object[]{cbsProxy, buildSpace, filename});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "DC archive file"}, new String[]{buildSpace, filename});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        File confFile = new File(filename);
        FileInputStream configStream = null;
        try {
            configStream = new FileInputStream(confFile);
        }
        catch (FileNotFoundException e) {
            this.logHandler.reportException(e, "File " + confFile.getAbsolutePath() + " could not be found.", thisMethod);
            return 104;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        try {
            try {
                bsProxy.updateConfiguration((InputStream)configStream, confFile.length());
            }
            catch (Exception e) {
                int n = this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
                Object var11_11 = null;
                this.closeInputStream(configStream);
                return n;
            }
            Object var11_10 = null;
            this.closeInputStream(configStream);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeInputStream(configStream);
            throw throwable;
        }
        this.logHandler.msg(0, "Updated build space '" + buildSpace + "' with development configuration file '" + confFile.getAbsolutePath() + "'.");
        return 0;
    }

    public int uploadDCArchive(IBuildServer cbsProxy, String buildSpace, String compartment, String dcName, String dcVendor, String buildVariant, String filename, String mode) {
        String thisMethod = "CBSTool.uploadDCArchive";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, DC name: {3}, DC vendor: {4}, build variant: {5} file name: {6} , mode: {7}", new Object[]{cbsProxy, buildSpace, compartment, dcName, dcVendor, buildVariant, filename, mode});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment", "DC name", "DC vendor", "build variant", "file name", "mode"}, new String[]{buildSpace, compartment, dcName, dcVendor, buildVariant, filename, mode});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        if (!mode.equalsIgnoreCase("dcia") && !mode.equalsIgnoreCase("dca")) {
            String message = "Invalid mode '" + mode + "', allowed values: ((dca | dcia))";
            this.logHandler.msg(0, message);
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        IImportRequest request = null;
        int rc = 0;
        try {
            request = bsProxy.createImportRequest();
            if (mode.equalsIgnoreCase("dcia")) {
                rc = this.uploadDCIA(request, compartment, dcVendor, dcName, buildVariant, filename);
            } else if (mode.equalsIgnoreCase("dca")) {
                rc = this.uploadDCA(request, compartment, dcVendor, dcName, buildVariant, filename);
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while creating import request", thisMethod);
        }
        if (rc != 0) {
            try {
                request.cancel();
            }
            catch (Exception e1) {
                return this.handleException(e1, "Error while cancelling import request", thisMethod);
            }
            return rc;
        }
        try {
            request.commit();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while commiting import request", thisMethod);
        }
        long reqID = request.getRequestID();
        this.logHandler.msg(0, "Upload request " + reqID + " has been triggered.");
        return 0;
    }

    public int downloadDCArchive(IBuildServer cbsProxy, String buildSpace, String compartment, String dcName, String dcVendor, String buildVariant, String filename, String mode) {
        String thisMethod = "CBSTool.downloadDCArchive";
        int rc = 0;
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2}, DC name: {3}, DC vendor: {4}, build variant: {5} file name: {6} , mode: {7}", new Object[]{cbsProxy, buildSpace, compartment, dcName, dcVendor, buildVariant, filename, mode});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment", "DC name", "DC vendor", "build variant", "file name", "mode"}, new String[]{buildSpace, compartment, dcName, dcVendor, buildVariant, filename, mode});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        if (!mode.equalsIgnoreCase("dcia") && !mode.equalsIgnoreCase("dca")) {
            String message = "Invalid mode '" + mode + "', allowed values: ((dca | dcia))";
            this.logHandler.msg(0, message);
            return 100;
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        if (mode.equalsIgnoreCase("dcia")) {
            rc = this.downloadDCIA(bsProxy, compartment, dcVendor, dcName, buildVariant, filename);
        } else if (mode.equalsIgnoreCase("dca")) {
            rc = this.downloadDCA(bsProxy, compartment, dcVendor, dcName, buildVariant, filename);
        }
        return rc;
    }

    public int deleteDCs(IBuildServer cbsProxy, String buildSpace, String compartment) {
        String thisMethod = "CBSTool.deleteDCs";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2} ", new Object[]{cbsProxy, buildSpace, compartment});
        boolean rc = false;
        try {
            this.checkArguments(cbsProxy, new String[]{"build space", "compartment"}, new String[]{buildSpace, compartment});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        IImportRequest request = null;
        IDCRef[] dcRefs = null;
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        try {
            request = bsProxy.createImportRequest();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while creating deletion request on build space '" + buildSpace + "'", thisMethod);
        }
        try {
            dcRefs = bsProxy.listDCs(compartment);
            if (dcRefs != null) {
                int i = 0;
                while (i < dcRefs.length) {
                    request.addDCDeletion(compartment, dcRefs[i].getVendor(), dcRefs[i].getName());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing compartment '" + compartment + "' of build space '" + buildSpace + "'", thisMethod);
        }
        try {
            request.commit();
        }
        catch (Exception e) {
            return this.handleException(e, "Error while commiting deletion request", thisMethod);
        }
        long reqID = request.getRequestID();
        this.logHandler.msg(0, "Deletion request " + reqID + " has been triggered");
        return 0;
    }

    public int switchOn(IBuildServer cbsProxy, String buildSpace, String mode) {
        block7: {
            String thisMethod = "CBSTool.switchOn";
            this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, mode: {2} ", new Object[]{cbsProxy, buildSpace, mode});
            boolean rc = false;
            try {
                this.checkArguments(cbsProxy, new String[]{"build space", "mode"}, new String[]{buildSpace, mode});
            }
            catch (IllegalArgumentException e) {
                this.logHandler.msg(0, e.getMessage());
                return 100;
            }
            IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
            try {
                if (mode.equalsIgnoreCase("buildprocessing")) {
                    bsProxy.setBuildProcessingEnabled(true);
                    this.logHandler.msg(0, "Enabled switch buildprocessing.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("outputqueuing")) {
                    bsProxy.setOutputQueueingEnabled(true);
                    this.logHandler.msg(0, "Enabled switch outputqueuing.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("outputlock")) {
                    bsProxy.setOutputLockState(true);
                    this.logHandler.msg(0, "Enabled switch outputlock.");
                    break block7;
                }
                String message = "Invalid mode '" + mode + "', allowed values: (buildprocessing | outputqueuing | outputlock)";
                this.logHandler.msg(0, message);
                return 100;
            }
            catch (Exception e) {
                return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
            }
        }
        return 0;
    }

    public int switchOff(IBuildServer cbsProxy, String buildSpace, String mode) {
        block7: {
            String thisMethod = "CBSTool.switchOff";
            this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, mode: {2} ", new Object[]{cbsProxy, buildSpace, mode});
            try {
                this.checkArguments(cbsProxy, new String[]{"build space", "mode"}, new String[]{buildSpace, mode});
            }
            catch (IllegalArgumentException e) {
                this.logHandler.msg(0, e.getMessage());
                return 100;
            }
            IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
            try {
                if (mode.equalsIgnoreCase("buildprocessing")) {
                    bsProxy.setBuildProcessingEnabled(false);
                    this.logHandler.msg(0, "Disabled switch buildprocessing.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("outputqueuing")) {
                    bsProxy.setOutputQueueingEnabled(false);
                    this.logHandler.msg(0, "Disabled switch outputqueuing.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("outputlock")) {
                    bsProxy.setOutputLockState(false);
                    this.logHandler.msg(0, "Disabled switch outputlock.");
                    break block7;
                }
                String message = "Invalid mode '" + mode + "', allowed values: (buildprocessing | outputqueuing | outputlock)";
                this.logHandler.msg(0, message);
                return 100;
            }
            catch (Exception e) {
                return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
            }
        }
        return 0;
    }

    public int setInputMode(IBuildServer cbsProxy, String buildSpace, String mode) {
        block7: {
            String thisMethod = "CBSTool.setInputMode";
            this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, mode: {2} ", new Object[]{cbsProxy, buildSpace, mode});
            try {
                this.checkArguments(cbsProxy, new String[]{"build space", "mode"}, new String[]{buildSpace, mode});
            }
            catch (IllegalArgumentException e) {
                this.logHandler.msg(0, e.getMessage());
                return 100;
            }
            IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
            try {
                if (mode.equalsIgnoreCase("open")) {
                    bsProxy.setInputMode(InputMode.OPEN);
                    this.logHandler.msg(0, "Set input mode to open.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("closed")) {
                    bsProxy.setInputMode(InputMode.CLOSED);
                    this.logHandler.msg(0, "Set input mode to closed.");
                    break block7;
                }
                if (mode.equalsIgnoreCase("privileged")) {
                    bsProxy.setInputMode(InputMode.PRIVILEGED);
                    this.logHandler.msg(0, "Set input mode to privileged.");
                    break block7;
                }
                String message = "Invalid mode '" + mode + "', allowed values: (open | closed | privileged)";
                this.logHandler.msg(0, message);
                return 100;
            }
            catch (Exception e) {
                return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
            }
        }
        return 0;
    }

    public int initCompartment(IBuildServer cbsProxy, String buildSpace, String compartment, boolean confirm) {
        String thisMethod = "CBSTool.initCompartment";
        this.logHandler.msg(3, thisMethod, " method parameters - CBS proxy: {0}, build space: {1}, compartment: {2} ", new Object[]{cbsProxy, buildSpace, compartment});
        try {
            this.checkArguments(cbsProxy, new String[]{"build space"}, new String[]{buildSpace});
        }
        catch (IllegalArgumentException e) {
            this.logHandler.msg(0, e.getMessage());
            return 100;
        }
        if (!confirm) {
            String msg = "Do you really want to initialize the compartment(s) (y/n)? ";
            System.out.print(msg);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String str = "";
            try {
                str = in.readLine();
            }
            catch (IOException e) {
                return this.handleException(e, "Error while reading user input.", thisMethod);
            }
            if (!str.equalsIgnoreCase("y")) {
                this.logHandler.msg(0, "User decided to abort initialization of compartments.");
                return 0;
            }
        }
        IBuildSpace bsProxy = cbsProxy.getBuildSpace(buildSpace);
        try {
            if (compartment != null) {
                this.logHandler.msg(0, ls + "Initialize compartment '" + compartment + "' of build space '" + buildSpace + "'");
                bsProxy.initializeCompartment(compartment);
            } else {
                int counter;
                DevConfigHandler dch = DevConfigHandlerFactory.getInstance(cbsProxy, buildSpace);
                Compartment[] compartments = dch.getCompartments();
                int n = counter = compartments != null ? compartments.length : 0;
                if (counter == 0) {
                    this.logHandler.msg(0, ls + "No compartments found in build space '" + buildSpace + "'");
                }
                int i = 0;
                while (i < counter) {
                    Compartment c = compartments[i];
                    if (c.hasSourceState()) {
                        this.logHandler.msg(0, ls + "Initialize compartment '" + c.getName() + "' of build space '" + buildSpace + "'");
                        bsProxy.initializeCompartment(c.getName());
                    } else {
                        this.logHandler.msg(0, ls + "Compartment '" + c.getName() + "' of build space '" + buildSpace + "' has not been initialized, as it is not of source state");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return this.handleException(e, "Error while accessing build space '" + buildSpace + "'", thisMethod);
        }
        return 0;
    }

    private void checkArguments(String[] names, String[] params) throws IllegalArgumentException {
        if (names == null || params == null) {
            throw new IllegalArgumentException("At least one input array is null");
        }
        if (names.length != params.length) {
            throw new IllegalArgumentException("Input array don't have the same size");
        }
        boolean isOk = true;
        StringBuffer sb = new StringBuffer();
        sb.append("Invalid command usage:").append(ls);
        int i = 0;
        while (i < names.length) {
            if (params[i] == null) {
                sb.append("Requested parameter '").append(names[i]);
                sb.append("' has not been specified.").append(ls);
                isOk = false;
            }
            ++i;
        }
        sb.append("Enter 'help <command>' to get information on correct command usage.");
        sb.append(ls);
        if (!isOk) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private void checkArguments(IBuildServer cbsProxy, String[] names, String[] params) throws IllegalArgumentException {
        if (names == null || params == null) {
            throw new IllegalArgumentException("At least one input array is null");
        }
        if (names.length != params.length) {
            throw new IllegalArgumentException("Input arrays don't have the same size");
        }
        boolean isOk = true;
        StringBuffer sb = new StringBuffer();
        sb.append("Invalid command usage:").append(ls);
        if (cbsProxy == null) {
            sb.append("There is no valid connection. ");
            sb.append("Please connect first before executing this command.");
            sb.append(ls);
            isOk = false;
        }
        int i = 0;
        while (i < names.length) {
            if (params[i] == null) {
                sb.append("Requested parameter '").append(names[i]);
                sb.append("' has not been specified.").append(ls);
                isOk = false;
            }
            ++i;
        }
        sb.append("Enter 'help <command name>' to get information on correct command usage.");
        sb.append(ls);
        if (!isOk) {
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private void getActivityInfo(StringBuffer sb, String user, String[] activities, String compartment, String buildSpace) {
        int counter;
        sb.append(ls);
        int n = counter = activities != null ? activities.length : 0;
        if (user == null) {
            sb.append(counter + " pending activities were found");
        } else {
            sb.append(counter + " pending activities were found for user ").append(user);
        }
        sb.append(" in compartment ").append(compartment);
        sb.append(" of build space ").append(buildSpace).append(ls);
        int maxLength = Integer.toString(counter).length();
        int i = 0;
        while (i < counter) {
            String numberStr = CBSToolUtil.getSpaces(Integer.toString(i + 1), maxLength, true);
            sb.append(numberStr).append(": ").append(activities[i] + ls);
            ++i;
        }
    }

    private void getDCInfo(IDCRef[] refs, StringBuffer sb) {
        int maxLength = Integer.toString(refs.length).length();
        int i = 0;
        while (i < refs.length) {
            String numberStr = CBSToolUtil.getSpaces(Integer.toString(i + 1), maxLength, true);
            String nameStr = CBSToolUtil.getSpaces(refs[i].getName(), 40, true);
            String vendorStr = CBSToolUtil.getSpaces(refs[i].getVendor(), 20, true);
            Object[] params = new Object[]{numberStr, nameStr, vendorStr};
            String msg = MessageFormat.format("{0} DC name: {1} DC vendor: {2}", params);
            sb.append(msg).append(ls);
            ++i;
        }
    }

    private void writeOutput(IDCRef[] refs, StringBuffer sb, String mode, String bvarStr, String compartment, String buildSpace) {
        if (refs != null) {
            sb.append(refs.length + " " + mode + " DCs" + bvarStr + " in compartment '" + compartment + "' of build space '" + buildSpace + "'" + ls);
            this.getDCInfo(refs, sb);
        } else {
            sb.append("No " + mode + " DCs" + bvarStr + "in compartment '" + compartment + "' of build space '" + buildSpace + "'" + ls);
        }
    }

    private int uploadDCA(IImportRequest request, String compartment, String dcVendor, String dcName, String variant, String filename) {
        String thisMethod = "CBSTool.uploadDCA";
        this.logHandler.msg(3, thisMethod, " method parameters - Import request: {0}, compartment: {1}, DC vendor: {2} , DC name: {3}, build variant: {4}, file name: {5}", new Object[]{request, compartment, dcVendor, dcName, variant, filename});
        File f = new File(filename);
        if (!f.exists()) {
            this.logHandler.msg(0, "File '" + f.getAbsolutePath() + "' does not exist");
            return 104;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return this.handleException(e, "Error while accesing file '" + f.getAbsolutePath() + "'", thisMethod);
        }
        try {
            request.addDCArchive(compartment, dcVendor, dcName, variant, (InputStream)is, f.length());
        }
        catch (Exception e) {
            this.logHandler.msg(1, "Adding content of file '" + f.getAbsolutePath() + "', to request failed, try it again");
            try {
                request.addDCArchive(compartment, dcVendor, dcName, variant, (InputStream)is, f.length());
            }
            catch (Exception e1) {
                this.closeInputStream(is);
                return this.handleException(e, "Error while adding file '" + f.getAbsolutePath() + "' to request", thisMethod);
            }
        }
        this.closeInputStream(is);
        this.logHandler.msg(1, "Added content of file '" + f.getAbsolutePath() + "', to request. (DC: " + dcName + ", vendor: " + dcVendor + ")");
        return 0;
    }

    private int uploadDCIA(IImportRequest request, String compartment, String dcVendor, String dcName, String variant, String filename) {
        String thisMethod = "CBSTool.uploadDCIA";
        this.logHandler.msg(3, thisMethod, " method parameters - Import request: {0}, compartment: {1}, DC vendor: {2} , DC name: {3}, build variant: {4}, file name: {5}", new Object[]{request, compartment, dcVendor, dcName, variant, filename});
        File f = new File(filename);
        if (!f.exists()) {
            this.logHandler.msg(0, "File '" + f.getAbsolutePath() + "' does not exist");
            return 104;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            return this.handleException(e, "Error while accesing file '" + f.getAbsolutePath() + "'", thisMethod);
        }
        try {
            request.addDCInterfaceArchive(compartment, dcVendor, dcName, variant, (InputStream)is, f.length());
        }
        catch (Exception e) {
            this.logHandler.msg(1, "Adding content of file '" + f.getAbsolutePath() + "', to request failed, try it again");
            try {
                request.addDCInterfaceArchive(compartment, dcVendor, dcName, variant, (InputStream)is, f.length());
            }
            catch (Exception e1) {
                this.closeInputStream(is);
                return this.handleException(e, "Error while adding file '" + f.getAbsolutePath() + "' to request", thisMethod);
            }
        }
        this.closeInputStream(is);
        this.logHandler.msg(1, "Added content of file '" + f.getAbsolutePath() + "', to request. (DC: " + dcName + ", vendor: " + dcVendor + ")");
        return 0;
    }

    private int downloadDCA(IBuildSpace bsProxy, String compartment, String dcVendor, String dcName, String variant, String filename) {
        String thisMethod = "CBSTool.downloadDCA";
        this.logHandler.msg(3, thisMethod, " method parameters - build space proxy: {0}, compartment: {1}, DC vendor: {2} , DC name: {3}, build variant: {4}, file name: {5}", new Object[]{bsProxy, compartment, dcVendor, dcName, variant, filename});
        File f = new File(filename);
        if (!CBSToolUtil.createFile(filename)) {
            this.logHandler.msg(0, "Can't create file '" + f.getAbsolutePath() + "'");
            return 107;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            return this.handleException(e, "File '" + f.getAbsolutePath() + "' not found.", thisMethod);
        }
        try {
            bsProxy.getDCArchive(compartment, dcVendor, dcName, variant, (OutputStream)os);
            this.logHandler.msg(1, "Downloaded archive into file '" + f.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            this.closeOutputStream(os);
            f.delete();
            return this.handleException(e, "Download of archive of DC '" + dcName + "' failed.", thisMethod);
        }
        this.closeOutputStream(os);
        return 0;
    }

    private int downloadDCIA(IBuildSpace bsProxy, String compartment, String dcVendor, String dcName, String variant, String filename) {
        String thisMethod = "CBSTool.downloadDCIA";
        this.logHandler.msg(3, thisMethod, " method parameters - build space proxy: {0}, compartment: {1}, DC vendor: {2} , DC name: {3}, build variant: {4}, file name: {5}", new Object[]{bsProxy, compartment, dcVendor, dcName, variant, filename});
        File f = new File(filename);
        if (!CBSToolUtil.createFile(filename)) {
            this.logHandler.msg(0, "Can't create file '" + f.getAbsolutePath() + "'");
            return 107;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            return this.handleException(e, "File '" + f.getAbsolutePath() + "' not found.", thisMethod);
        }
        try {
            bsProxy.getDCInterfaceArchive(compartment, dcVendor, dcName, variant, (OutputStream)os);
            this.logHandler.msg(1, "Downloaded archive into file '" + f.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            this.closeOutputStream(os);
            f.delete();
            return this.handleException(e, "Download of interface archive of DC '" + dcName + "' failed.", thisMethod);
        }
        this.closeOutputStream(os);
        return 0;
    }

    private void closeOutputStream(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException e) {
            this.logHandler.reportException(e, "Error while closing output stream");
        }
    }

    private void closeInputStream(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            this.logHandler.reportException(e, "Error while closing input stream");
        }
    }

    private void createPra(String dcaDir, String dciaDir, String praFile, Compartment compartment) {
        String thisMethod = "CBSTool.createPra";
        this.logHandler.msg(3, thisMethod, " method parameters - dca directory: {0}, dcia directory: {1}, PRA file: {2} , compartment: {3}", new Object[]{dcaDir, dciaDir, praFile, compartment});
        String release = "6.30";
        String spnumber = "SP7";
        TcsPra pra = new TcsPra();
        Project project = new Project();
        project.setProperty("dcrelease", release);
        project.setProperty("SP-Number", spnumber);
        project.setProperty("extendfilename", "true");
        pra.setProject(project);
        pra.setPrafile(praFile);
        Component comp = pra.createComponent();
        comp.setName(compartment.getScName());
        comp.setVendor(compartment.getScVendor());
        comp.setCounter(Util.getTimeStamp());
        comp.setLocation("EXPORT_FROM_CBS");
        FileSet dciaFileset = new FileSet();
        FileSet dcaFileset = new FileSet();
        dcaFileset.setDir(new File(dcaDir));
        dcaFileset.setIncludes("**/*");
        dciaFileset.setDir(new File(dciaDir));
        dciaFileset.setIncludes("**/*");
        pra.addBuildArchivesFileset(dciaFileset);
        pra.addDeployArchivesFileset(dcaFileset);
        this.logHandler.msg(1, "Start creation of software component archive ...");
        pra.execute();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean extractFileFromArchive(String archiveFile, String target, String entry) {
        String thisMethod = "CBSTool.extractFileFromArchive";
        this.logHandler.msg(3, thisMethod, " method parameters - archive file: {0}, target: {1}, entry: {2} ", new Object[]{archiveFile, target, entry});
        ZipInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = new ZipInputStream(new FileInputStream(archiveFile));
                ZipEntry zipEntry = in.getNextEntry();
                while (zipEntry != null) {
                    String name = zipEntry.getName();
                    if (name.equalsIgnoreCase(entry)) {
                        out = new FileOutputStream(target);
                        byte[] buf = new byte[1024];
                        while (true) {
                            void var10_11;
                            int len;
                            if ((len = in.read(buf)) <= 0) {
                                ((OutputStream)out).close();
                                boolean bl = true;
                                Object var13_13 = null;
                                this.closeInputStream(in);
                                this.closeOutputStream(out);
                                return bl;
                            }
                            ((OutputStream)out).write(buf, 0, (int)var10_11);
                        }
                    }
                    zipEntry = in.getNextEntry();
                }
            }
            catch (Exception e) {
                this.logHandler.reportException(e, "Error while extracting file from archive '" + archiveFile + "'");
                Object var13_15 = null;
                this.closeInputStream(in);
                this.closeOutputStream(out);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.closeInputStream(in);
            this.closeOutputStream(out);
            throw throwable;
        }
        Object var13_14 = null;
        this.closeInputStream(in);
        this.closeOutputStream(out);
        return false;
    }

    private int handleException(Exception e, String message, String location) {
        this.logHandler.reportException(e, message, location);
        return ReturnCodes.getReturnCode(e);
    }

    private int handleException(Exception e, String message) {
        this.logHandler.reportException(e, message);
        return ReturnCodes.getReturnCode(e);
    }

    static {
        if (ls.equals("")) {
            ls = "\r\n";
        }
    }
}

