/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.validation;

import com.sap.s2x.validation.ValidationException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class SourceValidator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.validation.SourceValidatorRes");
    private MessageFormat _mf;
    private Object[] obj;
    private String _source;
    private ArrayList _warnings = new ArrayList();
    private ArrayList _htmlEntities;
    private ArrayList _htmlTags;
    private ArrayList _allowedEntities;
    private ArrayList _allowedHTMLTags;
    private final String _specialCharacters = "^\u00c2\u00b0!\"\u00c2\u00b2\u00c2\u00a7\u00c2\u00b3$%&/{([)]=}?\\\u00c2\u00b4`+ +~#',;.:-_<>|@1234567890";
    private boolean _performEntityCheck = true;
    private boolean _performCRCheck = true;
    private boolean _performLeadingTrailingBlankCheck = true;
    private boolean _performSpecialCharacterCheck = true;
    private boolean _performHTMLTagCheck = true;

    public SourceValidator() throws ValidationException {
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() throws ValidationException {
        String line;
        BufferedReader br;
        this._allowedEntities = new ArrayList();
        this._allowedEntities.add("&amp;");
        this._allowedEntities.add("&gt;");
        this._allowedEntities.add("&quot;");
        this._allowedEntities.add("&lt;");
        this._htmlEntities = new ArrayList();
        try {
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("exceptions/HTMLEntities.txt")));
            while ((line = br.readLine()) != null) {
                void var1_2;
                this._htmlEntities.add(var1_2);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ValidationException(res.getString("ymsg_fileEntNotExist"));
        }
        catch (IOException ioe) {
            throw new ValidationException(res.getString("ymsg_readHTMLEntities"));
        }
        this._htmlTags = new ArrayList();
        try {
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("exceptions/HTMLTags.txt")));
            while ((line = br.readLine()) != null) {
                this._htmlTags.add(line);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ValidationException(res.getString("ymsg_fileTagNotExist"));
        }
        catch (IOException ioe) {
            throw new ValidationException(res.getString("ymsg_readHTMLTags"));
        }
        this._allowedHTMLTags = new ArrayList();
        try {
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("exceptions/allowedHTMLTags.txt")));
            while ((line = br.readLine()) != null) {
                this._allowedHTMLTags.add(line);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new ValidationException(res.getString("ymsg_fileTagNotExist"));
        }
        catch (IOException ioe) {
            throw new ValidationException(res.getString("ymsg_readHTMLTags"));
        }
    }

    public boolean isValid(String source) {
        boolean ret = true;
        this._warnings.clear();
        this._source = source;
        if (this._source == null) {
            this._warnings.add(res.getString("ymsg_null"));
            return false;
        }
        if (this._source.equals("")) {
            this._warnings.add(res.getString("ymsg_empty"));
            return false;
        }
        if (this._performLeadingTrailingBlankCheck && !this.checkForLeadingTrailingBlanks(this._source)) {
            ret = false;
        }
        this._source = this._source.trim();
        if (this._performEntityCheck && !this.checkForEntities(this._source)) {
            ret = false;
        }
        if (this._performCRCheck && !this.checkForCR(this._source)) {
            ret = false;
        }
        if (this._performSpecialCharacterCheck && !this.checkForSpecialCharacters(this._source, true)) {
            ret = false;
        }
        if (this._performHTMLTagCheck && !this.checkForTags(this._source)) {
            ret = false;
        }
        return ret;
    }

    public ArrayList getWarnings() {
        return this._warnings;
    }

    private boolean checkForEntities(String pSource) {
        boolean ret = true;
        int pos_amp = 0;
        int pos_sem = 0;
        while ((pos_amp = pSource.indexOf("&", pos_amp)) >= 0) {
            pos_sem = pSource.indexOf(";", pos_amp);
            if (pos_sem > 0 && pSource.substring(pos_amp + 1, pos_sem).indexOf("&") == -1 && pos_amp + 1 != pos_sem) {
                String entity = pSource.substring(pos_amp, pos_sem + 1);
                if (this._htmlEntities.contains(entity)) {
                    this._mf = new MessageFormat(res.getString("ymsg_containHTMLEnt"));
                    this.obj = new Object[1];
                    this.obj[0] = entity;
                    this._warnings.add(this._mf.format(this.obj));
                    ret = false;
                } else if (entity.indexOf(" ") < 0 && !this._allowedEntities.contains(entity) && this.checkForSpecialCharacters(entity.substring(1, entity.length() - 1), false)) {
                    this._mf = new MessageFormat(res.getString("ymsg_containEnt"));
                    this.obj = new Object[1];
                    this.obj[0] = entity;
                    this._warnings.add(this._mf.format(this.obj));
                    ret = false;
                }
            }
            ++pos_amp;
        }
        return ret;
    }

    private boolean checkForCR(String pSource) {
        boolean ret = true;
        MessageFormat mf = new MessageFormat(res.getString("ymsg_CR"));
        if (pSource.indexOf("\n") >= 0) {
            this._warnings.add(mf.format(new Object[]{"\\n"}));
            ret = false;
        }
        if (pSource.indexOf("\r") >= 0) {
            this._warnings.add(mf.format(new Object[]{"\\r"}));
            ret = false;
        }
        if (pSource.indexOf("\t") >= 0) {
            this._warnings.add(mf.format(new Object[]{"\\t"}));
            ret = false;
        }
        if (pSource.indexOf("\f") >= 0) {
            this._warnings.add(mf.format(new Object[]{"\\f"}));
            ret = false;
        }
        return ret;
    }

    private boolean checkForLeadingTrailingBlanks(String pSource) {
        MessageFormat mf;
        boolean ret = true;
        if (pSource.startsWith(" ")) {
            this._warnings.add(res.getString("ymsg_leadblanks"));
            ret = false;
        }
        if (pSource.endsWith(" ")) {
            this._warnings.add(res.getString("ymsg_trailblanks"));
            ret = false;
        }
        if (pSource.startsWith("\n")) {
            mf = new MessageFormat(res.getString("ymsg_lead"));
            this._warnings.add(mf.format(new Object[]{"\\n"}));
            ret = false;
        }
        if (pSource.endsWith("\n")) {
            mf = new MessageFormat(res.getString("ymsg_trail"));
            this._warnings.add(mf.format(new Object[]{"\\n"}));
            ret = false;
        }
        if (pSource.startsWith("\r")) {
            mf = new MessageFormat(res.getString("ymsg_lead"));
            this._warnings.add(mf.format(new Object[]{"\\r"}));
            ret = false;
        }
        if (pSource.endsWith("\r")) {
            mf = new MessageFormat(res.getString("ymsg_trail"));
            this._warnings.add(mf.format(new Object[]{"\\r"}));
            ret = false;
        }
        if (pSource.startsWith("\t")) {
            mf = new MessageFormat(res.getString("ymsg_lead"));
            this._warnings.add(mf.format(new Object[]{"\\t"}));
            ret = false;
        }
        if (pSource.endsWith("\t")) {
            mf = new MessageFormat(res.getString("ymsg_trail"));
            this._warnings.add(mf.format(new Object[]{"\\t"}));
            ret = false;
        }
        if (pSource.startsWith("\f")) {
            mf = new MessageFormat(res.getString("ymsg_lead"));
            this._warnings.add(mf.format(new Object[]{"\\f"}));
            ret = false;
        }
        if (pSource.endsWith("\f")) {
            mf = new MessageFormat(res.getString("ymsg_trail"));
            this._warnings.add(mf.format(new Object[]{"\\f"}));
            ret = false;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkForSpecialCharacters(String pSource, boolean pAddWarnings) {
        ret = false;
        pos = 0;
        adjustedSource = this.adjust(pSource);
        length = adjustedSource.length();
        if (length != 0 || !pAddWarnings) ** GOTO lbl14
        this._warnings.add(SourceValidator.res.getString("ymsg_empty"));
        return false;
lbl-1000:
        // 1 sources

        {
            c = adjustedSource.substring(pos, pos + 1);
            if ("^\u00c2\u00b0!\"\u00c2\u00b2\u00c2\u00a7\u00c2\u00b3$%&/{([)]=}?\\\u00c2\u00b4`+ +~#',;.:-_<>|@1234567890".indexOf(c) < 0) {
                ret = true;
                break;
            }
            ++pos;
lbl14:
            // 2 sources

            ** while (pos < length)
        }
lbl15:
        // 2 sources

        if (!ret && pAddWarnings) {
            this._warnings.add(SourceValidator.res.getString("ymsg_specialChars"));
        }
        return ret;
    }

    private boolean checkForTags(String pSource) {
        boolean ret = true;
        int pos_start = 0;
        int pos_end = 0;
        while ((pos_start = pSource.indexOf("<", pos_start)) >= 0 && pos_start < pSource.length() - 1) {
            if (!pSource.substring(pos_start + 1, pos_start + 2).equals("/")) {
                int pos_start_next = pSource.indexOf("<", pos_start + 1);
                pos_end = pSource.indexOf(">", pos_start);
                if (pos_end > 0) {
                    String tag;
                    boolean bl = pos_start_next > 0 ? pos_end < pos_start_next : true;
                    if (bl && (tag = pSource.substring(pos_start + 1, pos_end)).indexOf(" ") != 0) {
                        if (tag.indexOf(" ") > 1) {
                            tag = tag.substring(0, tag.indexOf(" "));
                        }
                        if (this._htmlTags.contains(tag)) {
                            this._mf = new MessageFormat(res.getString("ymsg_containHTMLTag"));
                            this.obj = new Object[1];
                            this.obj[0] = tag;
                            this._warnings.add(this._mf.format(this.obj));
                            ret = false;
                        } else if (!this._allowedHTMLTags.contains(tag)) {
                            this._mf = new MessageFormat(res.getString("ymsg_containsUnknownTag"));
                            this.obj = new Object[1];
                            tag = "<" + tag + ">";
                            this.obj[0] = tag;
                            this._warnings.add(this._mf.format(this.obj));
                            ret = false;
                        }
                    }
                }
            }
            ++pos_start;
        }
        return ret;
    }

    private String adjust(String pSource) {
        String adjustedSource = new String(pSource);
        int pos_start = 0;
        int pos_end = 0;
        while (pos_start < adjustedSource.length() && (pos_start = adjustedSource.indexOf("<", pos_start)) >= 0) {
            pos_end = adjustedSource.indexOf(">", pos_start);
            if (pos_end > 0) {
                while (adjustedSource.indexOf("<", pos_start + 1) >= 0 && adjustedSource.indexOf("<", pos_start + 1) < pos_end) {
                    ++pos_start;
                }
                String tag = adjustedSource.substring(pos_start, pos_end + 1);
                int pos_blank = tag.indexOf(" ");
                if (pos_blank > 1) {
                    if (pos_blank == tag.length() - 2) {
                        adjustedSource = adjustedSource.substring(0, pos_start) + adjustedSource.substring(pos_end + 1, adjustedSource.length());
                        continue;
                    }
                    if (tag.indexOf("=", pos_blank) > 0) {
                        adjustedSource = adjustedSource.substring(0, pos_start) + adjustedSource.substring(pos_end + 1, adjustedSource.length());
                        continue;
                    }
                    ++pos_start;
                    continue;
                }
                if (pos_blank == -1) {
                    adjustedSource = adjustedSource.substring(0, pos_start) + adjustedSource.substring(pos_end + 1, adjustedSource.length());
                    continue;
                }
                ++pos_start;
                continue;
            }
            ++pos_start;
        }
        int pos_amp = 0;
        int pos_sem = 0;
        while (pos_amp < adjustedSource.length() && (pos_amp = adjustedSource.indexOf("&", pos_amp)) >= 0) {
            pos_sem = adjustedSource.indexOf(";", pos_amp);
            if (pos_sem > 0 && pSource.substring(pos_amp + 1, pos_sem).indexOf("&") == -1 && pos_amp + 1 != pos_sem) {
                String entity = adjustedSource.substring(pos_amp, pos_sem + 1);
                if (this._htmlEntities.contains(entity)) {
                    if (!this._allowedEntities.contains(entity)) {
                        adjustedSource = adjustedSource.substring(0, pos_amp) + adjustedSource.substring(pos_sem + 1, adjustedSource.length());
                        continue;
                    }
                    ++pos_amp;
                    continue;
                }
                if (entity.indexOf(" ") < 0 && !this._allowedEntities.contains(entity)) {
                    adjustedSource = adjustedSource.substring(0, pos_amp) + adjustedSource.substring(pos_sem + 1, adjustedSource.length());
                    continue;
                }
                ++pos_amp;
                continue;
            }
            ++pos_amp;
        }
        int pos = 0;
        while ((pos = adjustedSource.indexOf("\\n")) >= 0) {
            adjustedSource = adjustedSource.substring(0, pos) + adjustedSource.substring(pos + 2, adjustedSource.length());
        }
        return adjustedSource;
    }

    public void performEntityCheck(boolean pBool) {
        this._performEntityCheck = pBool;
    }

    public void performCRCheck(boolean pBool) {
        this._performCRCheck = pBool;
    }

    public void performLeadingTrailingBlankCheck(boolean pBool) {
        this._performLeadingTrailingBlankCheck = pBool;
    }

    public void performSpecialCharacterCheck(boolean pBool) {
        this._performSpecialCharacterCheck = pBool;
    }

    public void performHTMLTagCheck(boolean pBool) {
        this._performHTMLTagCheck = pBool;
    }
}

