/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.validation;

import com.sap.s2x.S2XErrorHandler;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.core.types.DatatypeValue;
import com.sap.s2x.core.types.DomainType;
import com.sap.s2x.core.types.LangType;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.validation.Constraint;
import com.sap.s2x.validation.DataConverter;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchemaParser {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.validation.SchemaParserRes");
    private String SCHEMA_S2X;
    private String SCHEMA_S2XCORE;
    private String SCHEMA_S2XDATATYPES;
    private String SCHEMA_S2XVALUES;
    private String SCHEMA_S2XVALUESEXTENSIONS;
    private Document s2x;
    private Document s2xCore;
    private Document s2xDatatypes;
    private Document s2xValues;
    private Document s2xValuesExtensions;
    private NodeList elements;
    private NodeList attributes;
    private NodeList complexTypes;
    private NodeList simpleTypes;
    private NodeList values;
    private NodeList valuesExtensions;
    private Map constraints;

    public SchemaParser() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        URL url = null;
        this.constraints = new HashMap();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new S2XErrorHandler(this));
        Thread.currentThread().setContextClassLoader(cl);
        url = this.getClass().getResource("schema/s2x.xsd");
        if (url == null) {
            throw new ParserConfigurationException("Couldn't load s2x.xsd");
        }
        this.s2x = builder.parse(url.toString());
        url = this.getClass().getResource("schema/s2xCore.xsd");
        if (url == null) {
            throw new ParserConfigurationException("Couldn't load s2xCore.xsd");
        }
        this.s2xCore = builder.parse(url.toString());
        url = this.getClass().getResource("schema/s2xDatatypes.xsd");
        if (url == null) {
            throw new ParserConfigurationException("Couldn't load s2xDatatypes.xsd");
        }
        this.s2xDatatypes = builder.parse(url.toString());
        url = this.getClass().getResource("schema/s2xValues.xsd");
        if (url == null) {
            throw new ParserConfigurationException("Couldn't load s2xValues.xsd");
        }
        this.s2xValues = builder.parse(url.toString());
        url = this.getClass().getResource("schema/s2xValuesExtensions.xsd");
        if (url == null) {
            throw new ParserConfigurationException("Couldn't load s2xValuesExtensions.xsd");
        }
        this.s2xValuesExtensions = builder.parse(url.toString());
        this.initConstraints();
        this.initS2XTypes();
    }

    public Map getConstraints() {
        return this.constraints;
    }

    private void initConstraints() throws IOException {
        Element root = this.s2x.getDocumentElement();
        this.elements = root.getElementsByTagName("xsd:element");
        this.attributes = root.getElementsByTagName("xsd:attribute");
        root = this.s2xDatatypes.getDocumentElement();
        this.simpleTypes = root.getElementsByTagName("xsd:simpleType");
        this.complexTypes = root.getElementsByTagName("xsd:complexType");
        root = this.s2xValues.getDocumentElement();
        this.values = root.getElementsByTagName("xsd:simpleType");
        root = this.s2xValuesExtensions.getDocumentElement();
        this.valuesExtensions = root.getElementsByTagName("xsd:simpleType");
        int i = 0;
        while (i < this.elements.getLength()) {
            this.handleAttribute((Element)this.elements.item(i));
            ++i;
        }
        i = 0;
        while (i < this.attributes.getLength()) {
            this.handleAttribute((Element)this.attributes.item(i));
            ++i;
        }
        root = this.s2xCore.getDocumentElement();
        this.elements = root.getElementsByTagName("xsd:element");
        this.attributes = root.getElementsByTagName("xsd:attribute");
        i = 0;
        while (i < this.elements.getLength()) {
            this.handleAttribute((Element)this.elements.item(i));
            ++i;
        }
        i = 0;
        while (i < this.attributes.getLength()) {
            this.handleAttribute((Element)this.attributes.item(i));
            ++i;
        }
        i = 0;
        while (i < this.complexTypes.getLength()) {
            root = (Element)this.complexTypes.item(i);
            this.elements = root.getElementsByTagName("xsd:element");
            this.attributes = root.getElementsByTagName("xsd:attribute");
            int j = 0;
            while (j < this.elements.getLength()) {
                this.handleAttribute((Element)this.elements.item(j));
                ++j;
            }
            j = 0;
            while (j < this.attributes.getLength()) {
                this.handleAttribute((Element)this.attributes.item(j));
                ++j;
            }
            ++i;
        }
    }

    private void initS2XTypes() throws IOException {
        String docu;
        String xliffValue;
        String extValue;
        String intValue;
        Element type;
        NodeList types = this.s2xDatatypes.getDocumentElement().getElementsByTagName("s2xAPI:iniInfo");
        int noTypes = types.getLength();
        int i = 0;
        while (i < noTypes) {
            type = (Element)types.item(i);
            if (type.getAttribute("group").equals("domaintype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                DomainType domain = new DomainType(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getDomainTypes().add(domain);
            }
            if (type.getAttribute("group").equals("langtype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                LangType lang = new LangType(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getLangTypes().add(lang);
            }
            ++i;
        }
        types = this.s2xValues.getDocumentElement().getElementsByTagName("s2xAPI:iniInfo");
        noTypes = types.getLength();
        int i2 = 0;
        while (i2 < noTypes) {
            type = (Element)types.item(i2);
            if (type.getAttribute("group").equals("datatype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                DatatypeValue datatype = new DatatypeValue(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getDatatypeValueList().add(datatype);
            }
            if (type.getAttribute("group").equals("restype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                RestypeValue restype = new RestypeValue(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getRestypes().add(restype);
            }
            ++i2;
        }
        types = this.s2xValuesExtensions.getDocumentElement().getElementsByTagName("s2xAPI:iniInfo");
        noTypes = types.getLength();
        int i3 = 0;
        while (i3 < noTypes) {
            type = (Element)types.item(i3);
            if (type.getAttribute("group").equals("datatype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                DatatypeValue datatype = new DatatypeValue(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getDatatypeValueList().add(datatype);
            }
            if (type.getAttribute("group").equals("restype")) {
                intValue = type.getAttribute("valueInternal");
                extValue = type.getAttribute("valueExternal");
                xliffValue = ((Element)type.getParentNode().getParentNode().getParentNode()).getAttribute("value");
                docu = type.getParentNode().getParentNode().getChildNodes().item(3).getFirstChild().getNodeValue();
                RestypeValue restype = new RestypeValue(xliffValue, intValue, extValue, docu);
                S2XTypes.getInstance().getRestypes().add(restype);
            }
            ++i3;
        }
    }

    private void handleAttribute(Element attribute) throws IOException {
        Element restriction = null;
        boolean check_EXT = false;
        String name = attribute.getAttribute("name");
        if ((name == null || name.equals("")) && ((name = attribute.getAttribute("ref")) == null || name.equals(""))) {
            throw new IOException(res.getString("ymsg_SchemaParser"));
        }
        Constraint constraint = new Constraint(name);
        String schemaType = attribute.getAttribute("type");
        if (schemaType != null && !schemaType.equals("")) {
            int i = 0;
            while (i < this.simpleTypes.getLength()) {
                if (((Element)this.simpleTypes.item(i)).getAttribute("name").equals(schemaType)) {
                    restriction = (Element)((Element)this.simpleTypes.item(i)).getElementsByTagName("xsd:restriction").item(0);
                    break;
                }
                ++i;
            }
            if (restriction == null) {
                i = 0;
                while (i < this.values.getLength()) {
                    if (((Element)this.values.item(i)).getAttribute("name").equals(schemaType + "Std")) {
                        restriction = (Element)((Element)this.values.item(i)).getElementsByTagName("xsd:restriction").item(0);
                        check_EXT = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!check_EXT && restriction == null) {
                i = 0;
                while (i < this.valuesExtensions.getLength()) {
                    if (((Element)this.valuesExtensions.item(i)).getAttribute("name").equals(schemaType + "Ext")) {
                        restriction = (Element)((Element)this.valuesExtensions.item(i)).getElementsByTagName("xsd:restriction").item(0);
                        break;
                    }
                    ++i;
                }
            }
            if (restriction != null) {
                Integer iValue;
                Double dValue;
                Element boundary;
                Element allowedValue;
                String type = restriction.getAttribute("base");
                if (type.startsWith("xsd:")) {
                    type = type.substring(4, type.length());
                }
                if (type == null || type.equals("")) {
                    throw new IOException("No data type specified for constraint " + name);
                }
                constraint.setDataType(DataConverter.getInstance().getJavaType(type));
                NodeList allowedValues = restriction.getElementsByTagName("xsd:enumeration");
                if (allowedValues != null && allowedValues.getLength() > 0) {
                    i = 0;
                    while (i < allowedValues.getLength()) {
                        allowedValue = (Element)allowedValues.item(i);
                        constraint.addAllowedValue(allowedValue.getAttribute("value"));
                        ++i;
                    }
                }
                if (check_EXT) {
                    i = 0;
                    while (i < this.valuesExtensions.getLength()) {
                        if (((Element)this.valuesExtensions.item(i)).getAttribute("name").equals(schemaType + "Ext") && (allowedValues = (restriction = (Element)((Element)this.valuesExtensions.item(i)).getElementsByTagName("xsd:restriction").item(0)).getElementsByTagName("xsd:enumeration")) != null && allowedValues.getLength() > 0) {
                            i = 0;
                            while (i < allowedValues.getLength()) {
                                allowedValue = (Element)allowedValues.item(i);
                                constraint.addAllowedValue(allowedValue.getAttribute("value"));
                                ++i;
                            }
                        }
                        ++i;
                    }
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:minExclusive").item(0)) != null) {
                    dValue = new Double(boundary.getAttribute("value"));
                    constraint.setMinExclusive(dValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:minInclusive").item(0)) != null) {
                    dValue = new Double(boundary.getAttribute("value"));
                    constraint.setMinInclusive(dValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:minLength").item(0)) != null) {
                    iValue = new Integer(boundary.getAttribute("value"));
                    constraint.setMinLength(iValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:maxExclusive").item(0)) != null) {
                    dValue = new Double(boundary.getAttribute("value"));
                    constraint.setMaxExclusive(dValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:maxInclusive").item(0)) != null) {
                    dValue = new Double(boundary.getAttribute("value"));
                    constraint.setMaxInclusive(dValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:maxLength").item(0)) != null) {
                    iValue = new Integer(boundary.getAttribute("value"));
                    constraint.setMaxLength(iValue);
                }
                if ((boundary = (Element)restriction.getElementsByTagName("xsd:pattern").item(0)) != null) {
                    constraint.setPattern(boundary.getAttribute("value"));
                }
                this.constraints.put(name, constraint);
            }
        }
    }
}

