/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.validation;

import java.util.LinkedList;
import java.util.List;

public class Constraint {
    private String identifier;
    private String dataType;
    private double minInclusive;
    private double minExclusive;
    private int minLength;
    private double maxInclusive;
    private double maxExclusive;
    private int maxLength;
    private String pattern;
    private List allowedValues;

    public Constraint(String identifier) {
        this.identifier = identifier;
        this.minInclusive = Double.NaN;
        this.minExclusive = Double.NaN;
        this.minLength = -1;
        this.maxInclusive = Double.NaN;
        this.maxExclusive = Double.NaN;
        this.maxLength = -1;
        this.pattern = new String();
        this.allowedValues = new LinkedList();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setMinInclusive(double minInclusive) {
        this.minInclusive = minInclusive;
    }

    public double getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMinInclusive() {
        return !new Double(this.minInclusive).isNaN();
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public boolean hasMinLength() {
        return this.minLength > -1;
    }

    public void setMinExclusive(double minExclusive) {
        this.minExclusive = minExclusive;
    }

    public double getMinExclusive() {
        return this.minExclusive;
    }

    public boolean hasMinExclusive() {
        return !new Double(this.minExclusive).isNaN();
    }

    public void setMaxInclusive(double maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public double getMaxInclusive() {
        return this.maxInclusive;
    }

    public boolean hasMaxInclusive() {
        return !new Double(this.maxInclusive).isNaN();
    }

    public void setMaxExclusive(double maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public double getMaxExclusive() {
        return this.maxExclusive;
    }

    public boolean hasMaxExclusive() {
        return !new Double(this.maxExclusive).isNaN();
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean hasMaxLength() {
        return this.maxLength > -1;
    }

    public void addAllowedValue(String value) {
        this.allowedValues.add(value);
    }

    public List getAllowedValues() {
        return this.allowedValues;
    }

    public boolean hasAllowedValues() {
        return this.allowedValues.size() > 0;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean hasPattern() {
        return this.pattern != null && !this.pattern.equals("");
    }
}

