/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.MarshalException;
import com.sap.s2x.core.XliffType;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Xliff
extends XliffType
implements Serializable {
    private ArrayList errors = new ArrayList();
    private boolean valid = false;

    public ArrayList getErrorMessages() {
        this.errors.addAll(this.getFile().getErrorMessages());
        return this.errors;
    }

    public boolean isValid() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validate();
        return this.getFile().isValid() && this.valid;
    }

    public boolean isValidRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validate();
        return this.getFile().isValidRSX() && this.valid;
    }

    public boolean isValidISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validate();
        return this.getFile().isValidISX() && this.valid;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<xliff version=\"";
        xml = xml + this.getVersion();
        xml = xml + "\" xmlns=\"urn:oasis:names:tc:xliff:document:1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getFile().marshal(out);
        xml = "</xliff>";
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalMSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<xliff version=\"";
        xml = xml + this.getVersion();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getFile().marshalMSX(out);
        xml = "</xliff>";
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalRSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<xliff version=\"";
        xml = xml + this.getVersion();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getFile().marshalRSX(out);
        xml = "</xliff>";
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalISX(OutputStream out) throws IOException, MarshalException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<xliff version=\"";
        xml = xml + this.getVersion();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getFile().marshalISX(out);
        xml = "</xliff>";
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    private void validate() {
        this.errors.clear();
        if (!this.getVersion().equals("1.1")) {
            MessageFormat mf = new MessageFormat("Die XLIFF Versionsnummer \"{0}\" ist ung\u00c3\u00bcltig. Die derzeit g\u00c3\u00bcltige XLIFF Versionsnummer ist \"{1}\". Die XLIFF Versionsnummer wurde automatisch korrigiert.");
            Object[] obj = new Object[]{this.getVersion(), "1.1"};
            this.valid = false;
            this.errors.add(mf.format(obj));
            this.setVersion("1.1");
        } else {
            this.valid = true;
        }
    }
}

