/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.MarshalException;
import com.sap.s2x.core.TransUnitType;
import com.sap.s2x.tools.EscapeHandler;
import com.sap.s2x.validation.ValidationException;
import com.sap.s2x.validation.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TransUnit
extends TransUnitType
implements Serializable {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.core.TransUnitRes");
    private ArrayList errors = new ArrayList();
    private boolean valid;

    public ArrayList getErrorMessages() {
        return this.errors;
    }

    public boolean isValid(int maxLength, String textType) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validate(maxLength, textType);
        return this.valid;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        String xml = "<trans-unit id=\"";
        xml = xml + this.getId();
        xml = xml + "\" resname=\"";
        xml = xml + this.getResname();
        xml = xml + "\" maxwidth=\"";
        xml = xml + this.getMaxwidth();
        xml = xml + "\" translate=\"";
        xml = xml + this.getTranslate();
        xml = xml + "\">";
        xml = xml + "<source>";
        xml = xml + esc.escape(this.getSource());
        xml = xml + "</source>";
        xml = xml + "</trans-unit>";
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalMSX(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        if (this.getTranslate().toLowerCase().equals("yes")) {
            String xml = "<trans-unit id=\"";
            xml = xml + this.getId();
            xml = xml + "\" maxwidth=\"";
            xml = xml + this.getMaxwidth();
            xml = xml + "\" translate=\"";
            xml = xml + this.getTranslate();
            xml = xml + "\">";
            xml = xml + System.getProperty("line.separator");
            xml = xml + "<source>";
            xml = xml + esc.escape(this.getSource());
            xml = xml + "</source>";
            xml = xml + System.getProperty("line.separator");
            xml = xml + "</trans-unit>";
            xml = xml + System.getProperty("line.separator");
            try {
                out.write(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new MarshalException(MarshalException.ERROR_UTF8);
            }
        }
    }

    public void validate(int maxLength, String textType) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.valid = true;
        this.errors.clear();
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("id", this.getId());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongID") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("maxwidth", new Integer(this.getMaxwidth()).toString())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongMaxwidth") + " " + str);
            str = new String();
            this.valid = false;
        }
        if (this.getMaxwidth() > 0) {
            Object[] obj;
            MessageFormat mf;
            if (textType.equals("X") && this.getMaxwidth() > 255) {
                mf = new MessageFormat(res.getString("ymsg_XTextTooLong"));
                obj = new Object[]{new Integer(this.getMaxwidth()), "maxwidth", new Integer(255)};
                this.errors.add(mf.format(obj));
                this.valid = false;
            }
            if (this.getSource().length() > this.getMaxwidth()) {
                mf = new MessageFormat(res.getString("ymsg_TextLongerThanMaxwidth"));
                obj = new Object[]{this.getSource(), new Integer(this.getSource().length()), new Integer(this.getMaxwidth())};
                this.errors.add(mf.format(obj));
                this.valid = false;
            }
        } else if (textType.equals("X")) {
            if (maxLength > 0) {
                if (this.getSource().length() > maxLength) {
                    MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                    Object[] obj = new Object[]{this.getSource(), new Integer(this.getSource().length()), new Integer(maxLength)};
                    this.errors.add(mf.format(obj));
                    this.valid = false;
                }
            } else if (this.getSource().length() > 255) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                Object[] obj = new Object[]{this.getSource(), new Integer(this.getSource().length()), new Integer(255)};
                this.errors.add(mf.format(obj));
                this.valid = false;
            }
        } else if (this.getSource().length() > 16384) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_YTextLongerThanDefault"));
            Object[] obj = new Object[]{new Integer(this.getSource().length()), new Integer(16384)};
            this.errors.add(mf.format(obj));
            this.valid = false;
        }
    }
}

