/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.MarshalException;
import com.sap.s2x.core.S2xType;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class S2x
extends S2xType
implements Serializable {
    public ArrayList getErrorMessages() {
        ArrayList errors = this.getDtr().getErrorMessages();
        errors.addAll(this.getGiltDirectives().getErrorMessages());
        return errors;
    }

    public boolean isValid() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean valid = this.getDtr().isValid();
        return this.getGiltDirectives().isValid() && valid;
    }

    public boolean isValidRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean valid = this.getDtr().isValidRSX();
        return this.getGiltDirectives().isValidRSX() && valid;
    }

    public boolean isValidISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean valid = this.getDtr().isValidRSX();
        return this.getGiltDirectives().isValidISX() && valid;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        String xml = "<s2x xmlns=\"http://www.sap.com\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getDtr().marshal(out);
        this.getGiltDirectives().marshal(out);
        xml = "</s2x>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalMSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<s2x xmlns=\"http://www.sap.com\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getDtr().marshalMSX(out);
        this.getGiltDirectives().marshalMSX(out);
        xml = "</s2x>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalRSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<s2x xmlns=\"http://www.sap.com\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getDtr().marshalRSX(out);
        this.getGiltDirectives().marshalRSX(out);
        xml = "</s2x>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }
}

