/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.MarshalException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class PhaseTypeItem
implements Serializable {
    private ArrayList _noteList = new ArrayList();

    public void addNote(String vNote) throws IndexOutOfBoundsException {
        this._noteList.add(vNote);
    }

    public void addNote(int index, String vNote) throws IndexOutOfBoundsException {
        this._noteList.add(index, vNote);
    }

    public void clearNote() {
        this._noteList.clear();
    }

    public String getNote(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._noteList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._noteList.get(index);
    }

    public String[] getNote() {
        int size = this._noteList.size();
        String[] mArray = new String[size];
        int index = 0;
        while (index < size) {
            mArray[index] = (String)this._noteList.get(index);
            ++index;
        }
        return mArray;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        String xml = new String();
        int i = 0;
        while (i < this.getNoteCount()) {
            if (this.getNote(i) != null && !this.getNote(i).equals("")) {
                xml = xml + "<note>";
                xml = xml + this.getNote(i);
                xml = xml + "</note>";
                xml = xml + System.getProperty("line.separator");
            }
            ++i;
        }
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public int getNoteCount() {
        return this._noteList.size();
    }

    public boolean removeNote(String vNote) {
        boolean removed = ((AbstractCollection)this._noteList).remove(vNote);
        return removed;
    }

    public void setNote(int index, String vNote) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._noteList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._noteList.set(index, vNote);
    }

    public void setNote(String[] noteArray) {
        this._noteList.clear();
        int i = 0;
        while (i < noteArray.length) {
            this._noteList.add(noteArray[i]);
            ++i;
        }
    }
}

