/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.FileType;
import com.sap.s2x.core.MarshalException;
import com.sap.s2x.tools.EscapeHandler;
import com.sap.s2x.validation.ValidationException;
import com.sap.s2x.validation.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class File
extends FileType
implements Serializable {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.core.FileRes");
    private ArrayList errors = new ArrayList();
    private boolean valid;

    public ArrayList getErrorMessages() {
        this.errors.addAll(this.getHeader().getErrorMessages());
        this.errors.addAll(this.getBody().getErrorMessages());
        return this.errors;
    }

    public boolean isValid() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean maxLengthValid = true;
        this.validate();
        boolean validHeader = this.getHeader().isValid();
        if (!validHeader) {
            this.valid = validHeader;
        }
        int i = 0;
        while (i < this.getHeader().getS2x().getGiltDirectives().getErrorMessages().size()) {
            if (((String)this.getHeader().getS2x().getGiltDirectives().getErrorMessages().get(i)).startsWith("MAXLENGTH")) {
                maxLengthValid = false;
            }
            ++i;
        }
        int maxLength = maxLengthValid ? new Integer(this.getHeader().getS2x().getGiltDirectives().getMaxLength()) : 255;
        return this.getBody().isValid(maxLength) && this.valid;
    }

    public boolean isValidRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean maxLengthValid = true;
        this.validateRSX();
        boolean validHeader = this.getHeader().isValidRSX();
        if (!validHeader) {
            this.valid = validHeader;
        }
        int i = 0;
        while (i < this.getHeader().getS2x().getGiltDirectives().getErrorMessages().size()) {
            if (((String)this.getHeader().getS2x().getGiltDirectives().getErrorMessages().get(i)).startsWith("MAXLENGTH")) {
                maxLengthValid = false;
            }
            ++i;
        }
        int maxLength = maxLengthValid ? new Integer(this.getHeader().getS2x().getGiltDirectives().getMaxLength()) : 255;
        return this.getBody().isValid(maxLength) && this.valid;
    }

    public boolean isValidISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        boolean validHeader;
        boolean maxLengthValid = true;
        this.validateRSX();
        String str = new String();
        this.errors.clear();
        boolean valid = true;
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("original", this.getOriginal());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongOriginal3") + " " + str);
            str = new String();
            valid = false;
        }
        if (!(validHeader = this.getHeader().isValidISX())) {
            valid = validHeader;
        }
        int i = 0;
        while (i < this.getHeader().getS2x().getGiltDirectives().getErrorMessages().size()) {
            if (((String)this.getHeader().getS2x().getGiltDirectives().getErrorMessages().get(i)).startsWith("MAXLENGTH")) {
                maxLengthValid = false;
            }
            ++i;
        }
        int maxLength = maxLengthValid ? new Integer(this.getHeader().getS2x().getGiltDirectives().getMaxLength()) : 255;
        return this.getBody().isValid(maxLength) && valid;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        String xml = "<file tool=\"";
        xml = xml + this.getTool();
        xml = xml + "\" original=\"";
        xml = xml + this.getOriginal();
        xml = xml + "\" source-language=\"";
        xml = xml + this.getSourceLanguage().getXLIFFValue();
        xml = xml + "\" product-name=\"";
        xml = xml + esc.escape(this.getProductname());
        xml = xml + "\" datatype=\"";
        xml = xml + this.getDatatype().getXLIFFValue();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getHeader().marshal(out);
        this.getBody().marshal(out);
        xml = "</file>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalMSX(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        String xml = "<file original=\"";
        xml = xml + this.getOriginal();
        xml = xml + "\" source-language=\"";
        xml = xml + this.getSourceLanguage().getSAPInternalValue();
        xml = xml + "\" product-name=\"";
        xml = xml + esc.escape(this.getProductname());
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getHeader().marshalMSX(out);
        this.getBody().marshalMSX(out);
        xml = "</file>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalISX(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        String xml = "<file source-language=\"";
        xml = xml + this.getSourceLanguage().getXLIFFValue();
        xml = xml + "\" tool=\"";
        xml = xml + this.getTool();
        xml = xml + "\" product-name=\"";
        xml = xml + esc.escape(this.getProductname());
        xml = xml + "\" datatype=\"";
        xml = xml + this.getDatatype().getXLIFFValue();
        xml = xml + "\" original=\"";
        xml = xml + this.getOriginal();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getHeader().marshalRSX(out);
        this.getBody().marshal(out);
        xml = "</file>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalRSX(OutputStream out) throws IOException, MarshalException {
        EscapeHandler esc = new EscapeHandler();
        String xml = "<file source-language=\"";
        xml = xml + this.getSourceLanguage().getXLIFFValue();
        xml = xml + "\" product-name=\"";
        xml = xml + esc.escape(this.getProductname());
        xml = xml + "\" datatype=\"";
        xml = xml + this.getDatatype().getXLIFFValue();
        xml = xml + "\">";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
        this.getHeader().marshalRSX(out);
        this.getBody().marshal(out);
        xml = "</file>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    private void validate() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.errors.clear();
        this.valid = true;
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("original", this.getOriginal());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongOriginal") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("datatype", this.getDatatype().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongDatatype1") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("source-language", this.getSourceLanguage().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongSourceLangu1") + " " + str);
            this.valid = false;
        }
        EscapeHandler esc = new EscapeHandler();
        str = v.checkAgainstSchema("product-name", this.getProductname());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongProductname1") + " " + str);
            this.valid = false;
        }
    }

    private void validateRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.errors.clear();
        this.valid = true;
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("datatype", this.getDatatype().getXLIFFValue());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongDatatype2") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("source-language", this.getSourceLanguage().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongSourceLangu2") + " " + str);
            this.valid = false;
        }
        EscapeHandler esc = new EscapeHandler();
        str = v.checkAgainstSchema("product-name", this.getProductname());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongProductname2") + " " + str);
            this.valid = false;
        }
    }
}

