/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x;

import com.sap.s2x.core.types.DatatypeValue;
import com.sap.s2x.core.types.DomainType;
import com.sap.s2x.core.types.LangType;
import com.sap.s2x.core.types.RestypeValue;
import java.util.ArrayList;

public class S2XTypes {
    private static S2XTypes instance;
    public static final String XLIFFVALUE = "XLIFF";
    public static final String SAPVALUE = "SAP";
    private ArrayList datatypeValueList = new ArrayList();
    private ArrayList domaintypeValueList = new ArrayList();
    private ArrayList langtypeValueList = new ArrayList();
    private ArrayList restypeValueList = new ArrayList();
    public static final int MAXLENGTH_XTYPE_TEXTS = 255;
    public static final int MAXLENGTH_YTYPE_TEXTS = 16384;

    private S2XTypes() {
    }

    public static S2XTypes getInstance() {
        if (instance == null) {
            instance = new S2XTypes();
        }
        return instance;
    }

    public ArrayList getDomainTypes() {
        return this.domaintypeValueList;
    }

    public ArrayList getLangTypes() {
        return this.langtypeValueList;
    }

    public ArrayList getDatatypeValueList() {
        return this.datatypeValueList;
    }

    public ArrayList getRestypes() {
        return this.restypeValueList;
    }

    public RestypeValue getRestype(String restype, String valType) {
        int len = this.restypeValueList.size();
        int i = 0;
        while (i < len) {
            RestypeValue type = (RestypeValue)this.restypeValueList.get(i);
            if (valType.equals(XLIFFVALUE) ? type.getXLIFFValue().equals(restype) : type.getSAPInternalValue().equals(restype)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public DatatypeValue getDatatype(String datatype, String valType) {
        int len = this.datatypeValueList.size();
        int i = 0;
        while (i < len) {
            DatatypeValue type = (DatatypeValue)this.datatypeValueList.get(i);
            if (valType.equals(XLIFFVALUE) ? type.getXLIFFValue().equals(datatype) : type.getSAPInternalValue().equals(datatype)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public DomainType getDomaintype(String domaintype, String valType) {
        int len = this.domaintypeValueList.size();
        int i = 0;
        while (i < len) {
            DomainType type = (DomainType)this.domaintypeValueList.get(i);
            if (valType.equals(XLIFFVALUE) ? type.getXLIFFValue().equals(domaintype) : type.getSAPInternalValue().equals(domaintype)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public LangType getLangtype(String langtype, String valType) {
        int len = this.langtypeValueList.size();
        int i = 0;
        while (i < len) {
            LangType type = (LangType)this.langtypeValueList.get(i);
            if (valType.equals(XLIFFVALUE) ? type.getXLIFFValue().equals(langtype) : type.getSAPInternalValue().equals(langtype)) {
                return type;
            }
            ++i;
        }
        return null;
    }
}

