/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.shellcommands;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class ServletAndJspSessions
implements Command {
    private SimpleDateFormat date = new SimpleDateFormat("HH:mm dd/MM/yy", Locale.US);
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$shellcommands$ServletAndJspSessions == null ? (class$com$sap$engine$services$servlets_jsp$server$shellcommands$ServletAndJspSessions = ServletAndJspSessions.class$("com.sap.engine.services.servlets_jsp.server.shellcommands.ServletAndJspSessions")) : class$com$sap$engine$services$servlets_jsp$server$shellcommands$ServletAndJspSessions));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$shellcommands$ServletAndJspSessions;

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        int count = params.length;
        if (count > 0 && (params[0].toUpperCase().equals("-H") || params[0].equals("-?"))) {
            pw.println(this.getHelpMessage());
        } else {
            int sessCount = 0;
            try {
                if (count == 0) {
                    pw.println("UserName | Expire | Application");
                    pw.println("-------------------------------");
                    Enumeration en = SBasic.startedWebApplications.elements();
                    while (en.hasMoreElements()) {
                        sessCount += this.listApplicationSessions(pw, (ApplicationContext)en.nextElement(), false);
                    }
                } else if (count > 0 && params[0].toUpperCase().equals("FULL")) {
                    pw.println("UserName | SessionId | Created | LastAccessed | Expire | Application");
                    pw.println("-------------------------------");
                    Enumeration en = SBasic.startedWebApplications.elements();
                    while (en.hasMoreElements()) {
                        sessCount += this.listApplicationSessions(pw, (ApplicationContext)en.nextElement(), true);
                    }
                } else if (count > 0 && params[0].toUpperCase().equals("COUNT")) {
                    Enumeration en = SBasic.startedWebApplications.elements();
                    while (en.hasMoreElements()) {
                        sessCount += ((ApplicationContext)en.nextElement()).getSessionServletContext().getSession().size();
                    }
                } else {
                    pw.println(this.getHelpMessage());
                    return;
                }
                pw.println("\n-------------------------------");
                pw.println("Total number of http sessions: " + sessCount);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(4).logError(this.currentLocation, "Cannot execute the http telnet command [" + this.getName() + "].", e, "");
                pw.println("ERROR: " + e.getMessage());
                e.printStackTrace(pw);
                pw.println("--------------------------------------");
                pw.println(this.getHelpMessage());
                return;
            }
        }
    }

    public String getName() {
        return "HTTP_SESSIONS";
    }

    public String getGroup() {
        return "servlet_jsp";
    }

    public String getHelpMessage() {
        return "Prints a list of HTTP sessions for users that are currently logged in to" + Constants.lineSeparator + "SAP J2EE Engine. Displays the sessions in all started applications" + Constants.lineSeparator + "in the Web container." + Constants.lineSeparator + "Usage: " + this.getName() + " [full | count]" + Constants.lineSeparator + Constants.lineSeparator + "Parameters:" + Constants.lineSeparator + "  [full] - Provides the following details:" + Constants.lineSeparator + "           UserName, HttpSessionId, Creation date, Expiration date, and date of last access to it." + Constants.lineSeparator + "           Otherwise only userName and expiration date are displayed." + Constants.lineSeparator + "  [count] - Displays the total number of the sessions in all started applications in the Web container." + Constants.lineSeparator;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    private int listApplicationSessions(PrintWriter pw, ApplicationContext applicationContext, boolean full) {
        int sessCount = 0;
        Hashtable hash = applicationContext.getSessionServletContext().getSession();
        Enumeration enumeration = hash.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ApplicationSession tempSession = (ApplicationSession)enumeration.nextElement();
                if (!tempSession.isValid()) continue;
                String name = "user not logged in";
                if (applicationContext.getSessionServletContext().getPolicyDomain().getSecuritySession(tempSession) != null) {
                    name = applicationContext.getSessionServletContext().getPolicyDomain().getSecuritySession(tempSession).getUserName();
                }
                String expire = "never";
                if (tempSession.getMaxInactiveInterval() != -1) {
                    expire = this.date.format(new Date(tempSession.getLastAccessedTime() + (long)(tempSession.getMaxInactiveInterval() * 1000)));
                }
                if (full) {
                    pw.println(name + " | " + tempSession.getId() + " | " + this.date.format(new Date(tempSession.getCreationTime())) + " | " + this.date.format(new Date(tempSession.getLastAccessedTime())) + " | " + expire + " | " + applicationContext.getApplicationName());
                } else {
                    pw.println(name + "   | " + expire + " | " + applicationContext.getApplicationName());
                }
                ++sessCount;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(4).logWarning(this.currentLocation, "Cannot execute the http telnet command [" + this.getName() + "].", e, "");
            }
        }
        return sessCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

