/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.services.httpserver.interfaces.HttpProvider;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebServletException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnavailableException;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ServletContextImpl;
import com.sap.engine.services.servlets_jsp.server.servlet.FileDeployer;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PutServlet
extends HttpServlet {
    private static final byte[] response_body_beg = "The file ".getBytes();
    private static final byte[] response_body_end = " has been successfully uploaded!".getBytes();
    private static final String web_inf = "/WEB-INF";
    private static final String meta_inf = "/META-INF";
    private static final String UPLOAD_ENABLED = "Upload Enabled";
    private FileDeployer fileDeployer = null;
    private HttpProvider httpProvider = null;
    private ApplicationContext applicationContext = null;
    private String appName = null;
    private String rootDir = null;
    private boolean uploadAllowed = true;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$servlet$PutServlet == null ? (class$com$sap$engine$services$servlets_jsp$server$servlet$PutServlet = PutServlet.class$("com.sap.engine.services.servlets_jsp.server.servlet.PutServlet")) : class$com$sap$engine$services$servlets_jsp$server$servlet$PutServlet));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$servlet$PutServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.applicationContext = ((ServletContextImpl)config.getServletContext()).getApplicationContext();
        try {
            this.fileDeployer = new FileDeployer(SBasic.persistentStorage.getConfigurationHandler());
        }
        catch (IOException io) {
            throw new WebUnavailableException("servlet_jsp_0278", io);
        }
        this.httpProvider = this.applicationContext.getHttpProvider();
        this.appName = this.applicationContext.getApplicationName();
        this.rootDir = '/' + this.appName.replace('/', '/') + '/' + "servlet_jsp" + '/';
        String uploadAllowedStr = config.getInitParameter(UPLOAD_ENABLED);
        if (uploadAllowedStr != null) {
            this.uploadAllowed = uploadAllowedStr.equalsIgnoreCase("true");
        }
        if (!this.uploadAllowed) {
            Log.getCategory(2).logWarning(this.currentLocation, "HTTP upload of static files will not be allowed. To enable file upload in your application you can use the standard HTTP 1.1 implementation of the PUT method provided by the Web Container. To enable it you need to set the property \"Upload Allowed\" of the servlet " + this.getServletName() + " to \"true\" into the global-web.xml file!", this.applicationContext.getAliasName());
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.uploadAllowed) {
            throw new WebServletException("servlet_jsp_0279");
        }
        HttpServletRequestFacade unwrappedRequest = FilterUtils.unWrapRequest((ServletRequest)request);
        String contextPath = request.getContextPath();
        String root = new File(this.applicationContext.getWebApplicationRootDir()).getCanonicalPath().replace(File.separatorChar, '/');
        String realPath = new File(unwrappedRequest.getRealPathLocal("/") + File.separator).getCanonicalPath().replace(File.separatorChar, '/');
        String fileName = null;
        boolean isHttpAlias = false;
        if (contextPath.equals("") && !realPath.startsWith(root)) {
            isHttpAlias = true;
            root = realPath;
            fileName = unwrappedRequest.getRealPathLocal(unwrappedRequest.getRequestURIinternal()).trim();
        } else {
            String requestURI = unwrappedRequest.getRequestURIinternal();
            int beginIndex = requestURI.indexOf(contextPath);
            int endIndex = beginIndex + contextPath.length();
            requestURI = requestURI.substring(endIndex);
            fileName = (root + requestURI).replace('/', '/').replace('\\', '/').trim();
        }
        String fileNameCanonical = new File(fileName).getCanonicalPath().replace(File.separatorChar, '/');
        if (!this.isFileUploadAllowed(fileNameCanonical, root, unwrappedRequest, response)) {
            return;
        }
        if (!this.writeLocalFile(fileNameCanonical, (InputStream)request.getInputStream(), response)) {
            return;
        }
        boolean isNew = false;
        try {
            if (isHttpAlias) {
                isNew = this.fileDeployer.uploadFileInAlias(fileNameCanonical, fileNameCanonical.substring(fileNameCanonical.indexOf(root) + root.length()), unwrappedRequest.getHttpParameters().getHostProperties().getHostName(), unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasName().toString());
            } else {
                int i = root.lastIndexOf(this.rootDir);
                if (i == -1) {
                    throw new WebServletException("servlet_jsp_0138", new Object[]{this.rootDir});
                }
                i = i + this.rootDir.length() - 1;
                isNew = this.fileDeployer.uploadFileInApplication(fileNameCanonical, fileNameCanonical.substring(i), this.appName);
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(err));
            Log.getCategory(2).logError(this.currentLocation, "Error storing file into database.", e, this.applicationContext.getAliasName());
            FilterUtils.unWrapResponse((ServletResponse)response).sendError(500, "Error storing file into database.", err.toString(), true);
            return;
        }
        this.httpProvider.clearCacheByAlias(this.applicationContext.getAliasName());
        if (isNew) {
            this.generateResponse(unwrappedRequest.getRequestURIinternal(), 201, response);
        } else {
            this.generateResponse(unwrappedRequest.getRequestURIinternal(), 200, response);
        }
    }

    private boolean isFileUploadAllowed(String fileNameCanonical, String root, HttpServletRequestFacade unwrappedRequest, HttpServletResponse response) throws IOException {
        String canonicalURI = "";
        if (fileNameCanonical.length() > root.length()) {
            canonicalURI = fileNameCanonical.substring(root.length());
        }
        if (fileNameCanonical.indexOf(root) < 0) {
            FilterUtils.unWrapResponse((ServletResponse)response).sendError(403, "The file is not uploaded.", "PUT method is not allowed in this directory!", true);
            return false;
        }
        if (canonicalURI.startsWith(web_inf.replace('/', '/').replace('\\', '/')) || canonicalURI.startsWith(meta_inf.replace('/', '/').replace('\\', '/'))) {
            FilterUtils.unWrapResponse((ServletResponse)response).sendError(403, "The file is not uploaded.", "PUT method is not allowed in this directory!", true);
            return false;
        }
        if (unwrappedRequest.getRequestURIinternal().endsWith(".") && !fileNameCanonical.endsWith(".")) {
            FilterUtils.unWrapResponse((ServletResponse)response).sendError(403, "The file is not uploaded.", "PUT method is not allowed for dot ending filename!", true);
            return false;
        }
        if (fileNameCanonical.toLowerCase().endsWith(".jsp")) {
            FilterUtils.unWrapResponse((ServletResponse)response).sendError(403, "The file is not uploaded.", "PUT method is not allowed for dynamic contents!", true);
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeLocalFile(String fileName, InputStream in, HttpServletResponse response) throws IOException {
        int c;
        RandomAccessFile outFile = null;
        new File(fileName).getParentFile().mkdirs();
        outFile = new RandomAccessFile(fileName, "rw");
        outFile.seek(0L);
        byte[] buffer = new byte[4096];
        while ((c = in.read(buffer)) > 0) {
            void var5_7;
            outFile.write(buffer, 0, (int)var5_7);
        }
        outFile.close();
        Object var9_9 = null;
        if (outFile == null) return true;
        try {
            outFile.close();
            return true;
        }
        catch (IOException e2) {
            Log.getCategory(2).logError(this.currentLocation, "Cannot close the file [" + fileName + "].", e2, this.applicationContext.getAliasName(), FilterUtils.unWrapResponse((ServletResponse)response).getHttpParameters().getRequest().getClientIP());
        }
        return true;
        {
            catch (IOException e) {
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(err));
                FilterUtils.unWrapResponse((ServletResponse)response).sendError(500, "Cannot write the uploaded file " + fileName + " to the local disk. The file will not be updated in the application configuration!", err.toString(), true);
                Log.getCategory(2).logWarning(this.currentLocation, "Error uploading a file. Cannot write the uploaded file " + fileName + " to the local disk.", e, this.applicationContext.getAliasName(), FilterUtils.unWrapResponse((ServletResponse)response).getHttpParameters().getRequest().getClientIP());
                boolean bl = false;
                Object var9_10 = null;
                if (outFile == null) return bl;
                try {
                    outFile.close();
                    return bl;
                }
                catch (IOException e2) {
                    Log.getCategory(2).logError(this.currentLocation, "Cannot close the file [" + fileName + "].", e2, this.applicationContext.getAliasName(), FilterUtils.unWrapResponse((ServletResponse)response).getHttpParameters().getRequest().getClientIP());
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (outFile == null) throw throwable;
            try {
                outFile.close();
                throw throwable;
            }
            catch (IOException e2) {
                Log.getCategory(2).logError(this.currentLocation, "Cannot close the file [" + fileName + "].", e2, this.applicationContext.getAliasName(), FilterUtils.unWrapResponse((ServletResponse)response).getHttpParameters().getRequest().getClientIP());
            }
            throw throwable;
        }
    }

    private void generateResponse(String fileName, int statusCode, HttpServletResponse response) throws IOException {
        response.setStatus(statusCode);
        response.addHeader("Content-Type", "text/html");
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        response.addIntHeader("Expires", 0);
        response.getOutputStream().write(response_body_beg);
        response.getOutputStream().write(fileName.getBytes());
        response.getOutputStream().write(response_body_end);
        response.getOutputStream().close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

