/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentReadLRUSet;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.ServletNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnavailableException;
import com.sap.engine.services.servlets_jsp.server.jsp.JSPParser;
import com.sap.engine.services.servlets_jsp.server.jsp.exceptions.ParseException;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ServletContextImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.context.WebComponents;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.HttpJspPage;

public class JSPServlet
extends HttpServlet {
    private ApplicationContext applicationContext = null;
    private ServletContext context;
    private WebComponents webComponents = null;
    private String alias = null;
    private String workDir = null;
    private ConcurrentHashMapIntObject compile = new ConcurrentHashMapIntObject();
    private static final Exception syncExc = new Exception();
    private ConcurrentReadLRUSet cannonicalPath = new ConcurrentReadLRUSet(100, 800);
    private JSPParser jspParser = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$servlet$JSPServlet == null ? (class$com$sap$engine$services$servlets_jsp$server$servlet$JSPServlet = JSPServlet.class$("com.sap.engine.services.servlets_jsp.server.servlet.JSPServlet")) : class$com$sap$engine$services$servlets_jsp$server$servlet$JSPServlet));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$servlet$JSPServlet;

    public void init(ServletConfig con) throws ServletException {
        super.init(con);
        this.context = con.getServletContext();
        this.applicationContext = ((ServletContextImpl)this.context).getApplicationContext();
        this.webComponents = this.applicationContext.getWebComponents();
        this.alias = this.applicationContext.getAliasName();
        this.workDir = this.applicationContext.getWorkingDir();
        this.jspParser = new JSPParser(this.applicationContext);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean fromRequestDispatcher;
        String className = null;
        String jspFile = null;
        String requestedResource = null;
        HttpServletRequestFacade unwrappedRequest = FilterUtils.unWrapRequest((ServletRequest)request);
        HttpServletResponseFacade unwrappedResponse = FilterUtils.unWrapResponse((ServletResponse)response);
        String request_uri = (String)request.getAttribute("com.sap.engine.include.request_uri");
        request.removeAttribute("com.sap.engine.include.request_uri");
        boolean bl = fromRequestDispatcher = request_uri != null;
        if (request_uri == null) {
            jspFile = unwrappedRequest.getRealPathLocal(request.getServletPath());
            requestedResource = request.getServletPath();
        } else {
            jspFile = request.getContextPath().equals("/" + this.alias) || "/".equals(this.alias) ? unwrappedRequest.getRealPathLocal(request_uri) : this.context.getRealPath(request_uri).replace(File.separatorChar, '/');
            requestedResource = request_uri;
        }
        if (this.isUnavailable(jspFile, requestedResource, unwrappedResponse)) {
            return;
        }
        File f = new File(jspFile);
        if (!this.fileExists(f, unwrappedRequest, unwrappedResponse)) {
            return;
        }
        if (this.inWebInf(requestedResource, unwrappedResponse, fromRequestDispatcher)) {
            return;
        }
        long fLastModified = f.lastModified();
        String encoding = unwrappedResponse.getCharacterEncoding();
        boolean isIncluded = unwrappedResponse.getIncluded();
        unwrappedRequest.setJspFlag(true);
        int hash = jspFile.hashCode();
        if (this.isJspPrecompileRequest(jspFile, encoding, isIncluded, unwrappedRequest, unwrappedResponse)) {
            return;
        }
        if (!this.checkCannonicalPath(jspFile, f, unwrappedRequest, unwrappedResponse)) {
            return;
        }
        Object obj = null;
        JSPServlet jSPServlet = this;
        synchronized (jSPServlet) {
            obj = this.compile.get(hash);
        }
        if (obj != null) {
            Object object = obj;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (obj != null && delta < 60000L) {
                    try {
                        if (Log.isTracing()) {
                            Log.getLocation(4).traceInfo("The requested JSP File <" + jspFile + "> is compiling by another client!\r\n" + "Waiting while the file is compiled.", this.applicationContext.getAliasName());
                        }
                        obj.wait(60000L);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Log.getCategory(2).logError(this.currentLocation, "Thread interrupted while waiting for the jsp to be compiled. Synchronization may fail.", e, this.alias, unwrappedRequest.getHttpParameters().getRequest().getClientIP());
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
            }
        }
        className = this.compileAndGetClassName(jspFile, hash, fLastModified, encoding, isIncluded, unwrappedRequest);
        HttpJspPage jsp = null;
        jsp = request_uri != null ? this.webComponents.getJSP(className, request_uri) : this.webComponents.getJSP(className, request.getServletPath().substring(1));
        if (jsp == null && (jsp = this.reCompileAndGetClassName(jspFile, hash, request_uri, encoding, isIncluded, unwrappedRequest, unwrappedResponse)) == null) {
            return;
        }
        if (Log.isTracing()) {
            Log.getLocation(4).traceInfo("Invoking JSP <" + requestedResource + ">", this.alias);
        }
        this.service(jsp, jspFile, request, response);
    }

    private String getClassName(HttpServletRequestFacade unwrappedRequest, ApplicationContext context, String jspFile, String encoding, boolean isIncluded, boolean needCompiling) throws ServletException, ServletNotFoundException, IOException {
        String newClass = null;
        String classNamesKey = null;
        boolean isAlias = false;
        if (unwrappedRequest != null) {
            int ind;
            String aliasName = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasName().toString();
            String aliasValue = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasValue().toString();
            if (context.isDefault() && aliasValue != null && aliasName != null && !aliasValue.equals("/") && !aliasName.equals("/") && (ind = jspFile.indexOf(aliasValue)) != -1) {
                classNamesKey = "@" + jspFile;
                isAlias = true;
            }
        }
        if (classNamesKey == null) {
            classNamesKey = jspFile.substring(context.getWebApplicationRootDir().length() - 1);
        }
        if (!needCompiling) {
            newClass = (String)context.getClassNamesHashtable().get(classNamesKey);
            if (newClass == null) {
                throw new ParseException("servlet_jsp_0055");
            }
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("The JSP file <" + jspFile + "> will not be recompiled!\r\n" + "The servlet class is: " + newClass, this.alias);
            }
        } else {
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("The JSP file <" + jspFile + "> will be recompiled!\r\n", this.alias);
            }
            newClass = isIncluded ? (isAlias ? this.jspParser.parse(jspFile, encoding, true, unwrappedRequest.getThreadClassLoader(), unwrappedRequest) : this.jspParser.parse(jspFile, encoding, true, unwrappedRequest.getThreadClassLoader(), null)) : (isAlias ? this.jspParser.parse(jspFile, null, true, unwrappedRequest.getThreadClassLoader(), unwrappedRequest) : this.jspParser.parse(jspFile, null, true, unwrappedRequest.getThreadClassLoader(), null));
        }
        return newClass;
    }

    private void sendError(int err, String mess, String details, HttpServletResponseFacade unwrappedResponse) throws IOException {
        try {
            unwrappedResponse.sendError(err, mess, details, true);
        }
        catch (IllegalArgumentException e) {
            unwrappedResponse.writeError(err, mess, details, true);
        }
    }

    private boolean isUnavailable(String jspFile, String requestedResource, HttpServletResponseFacade unwrappedResponse) throws IOException {
        if (!this.webComponents.isUnavailableJsp(jspFile)) {
            return false;
        }
        long unavailableTime = -1L;
        try {
            unavailableTime = this.webComponents.getUnavailableJspSeconds(jspFile);
        }
        catch (NoSuchElementException ne) {
            return false;
        }
        if (unavailableTime == -1L) {
            this.sendError(503, "The requested resource " + requestedResource + " is unavailable!", "The jsp is permanently unavailable. Try again after the application or the servlet container is restarted or contact the server administrator.", unwrappedResponse);
            return true;
        }
        long uj = (unavailableTime - System.currentTimeMillis()) / 1000L;
        if (uj > 0L) {
            unwrappedResponse.setHeader("Retry-After", "" + uj);
            this.sendError(503, "The requested resource " + requestedResource + " is temporary unavailable!", "JSP page " + requestedResource + " is unavailable. Try again after " + uj + " seconds.", unwrappedResponse);
            return true;
        }
        return false;
    }

    private boolean fileExists(File f, HttpServletRequestFacade unwrappedRequest, HttpServletResponseFacade response) throws IOException {
        if (f.exists()) {
            return true;
        }
        if (Log.isTracing()) {
            Log.getLocation(4).traceInfo("JSP file <" + f + "> Not found!", this.alias);
        }
        if (unwrappedRequest.getMethod().equals("PUT")) {
            response.sendError(403, "PUT method is not allowed for dynamic contents!");
        } else {
            response.sendError(404, "The requested resource " + unwrappedRequest.getContextPath() + unwrappedRequest.getServletPath() + " is not available", "File " + f + " does not exist.", true);
        }
        return false;
    }

    private boolean inWebInf(String requestedResource, HttpServletResponseFacade response, boolean fromRequestDispatcher) throws IOException {
        byte[] requestedResourceBytes = requestedResource.getBytes();
        if (ByteArrayUtils.startsWithIgnoreCase((byte[])requestedResourceBytes, (int)0, (int)requestedResourceBytes.length, (byte[])"/web-inf".getBytes()) || ByteArrayUtils.startsWithIgnoreCase((byte[])requestedResourceBytes, (int)0, (int)requestedResourceBytes.length, (byte[])"/meta-inf".getBytes())) {
            if (fromRequestDispatcher) {
                Log.getLocation(4).traceWarning("Including a file from [META-INF] or [WEB-INF] directories in include directive. The file is: [" + requestedResource + "].", null);
                return false;
            }
            response.sendError(404, "Directory web-inf is not accessible for browsing.");
            return true;
        }
        return false;
    }

    private boolean isJspPrecompileRequest(String jspFile, String encoding, boolean isIncluded, HttpServletRequestFacade unwrappedRequest, HttpServletResponseFacade unwrappedResponse) throws IOException, ServletException {
        String prStr = unwrappedRequest.getJspPrecompile();
        if (prStr == null) {
            return false;
        }
        if (prStr.equals("") || prStr.equals("true") || prStr.equals("\"true\"")) {
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("A \"jsp_precompile\" Parameter with value \"true\" found in the request for the JSP file <" + jspFile + "> !\r\nThe JSP file will be recompiled in the following requests!\r\nThe request will not be delivered to the page.", this.alias);
            }
            this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, true);
        } else if (prStr.equals("false") || prStr.equals("\"false\"")) {
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("A \"jsp_precompile\" parameter with value \"false\" found in the request for the JSP File <" + jspFile + "> !\r\n" + "The JSP file will not be recompiled in the following requests!\r\nThe request will not be delivered to the page.", this.alias);
            }
        } else {
            unwrappedResponse.sendError(500, "Illegal value of the jsp_precompile parameter in the request: " + prStr, "Use \"true\" or \"false\".", true);
        }
        return true;
    }

    private boolean checkCannonicalPath(String jspFile, File f, HttpServletRequestFacade unwrappedRequest, HttpServletResponseFacade unwrappedResponse) throws IOException {
        if (this.cannonicalPath.contains((Object)jspFile)) {
            return true;
        }
        if (!ParseUtils.canonicalize((String)jspFile).startsWith(f.getCanonicalPath().replace(File.separatorChar, '/'))) {
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("The requested JSP file <" + jspFile + "> Not found!\r\nWrong file name syntax.", this.alias);
            }
        } else {
            this.cannonicalPath.add((Object)jspFile);
            return true;
        }
        unwrappedResponse.sendError(404, "Incorrect request URL: " + unwrappedRequest.getRequestURI(), "Use case sensitive URL and do not request a file outside the root directory of the server.", true);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String compileAndGetClassName(String jspFile, int hash, long fLastModified, String encoding, boolean isIncluded, HttpServletRequestFacade unwrappedRequest) throws ServletException, ServletNotFoundException, IOException {
        try {
            Object objectJspFile;
            File file = null;
            String classNamesKey = null;
            if (unwrappedRequest == null) {
                classNamesKey = jspFile.substring(this.applicationContext.getWebApplicationRootDir().length() - 1);
            } else {
                int ind;
                String aliasName = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasName().toString();
                String aliasValue = unwrappedRequest.getHttpParameters().getRequestPathMappings().getAliasValue().toString();
                if (this.applicationContext.isDefault() && aliasValue != null && aliasName != null && !aliasValue.equals("/") && !aliasName.equals("/") && (ind = jspFile.indexOf(aliasValue)) != -1) {
                    classNamesKey = "@" + jspFile;
                }
            }
            if (classNamesKey == null) {
                classNamesKey = jspFile.substring(this.applicationContext.getWebApplicationRootDir().length() - 1);
            }
            if ((objectJspFile = this.applicationContext.getClassNamesHashtable().get(classNamesKey)) != null) {
                String pathname = this.workDir + objectJspFile + ".java";
                file = new File(pathname);
            }
            if (file == null || file.lastModified() < fLastModified) throw syncExc;
            return this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, objectJspFile == null);
        }
        catch (Exception e) {
            boolean fl = false;
            Object obj = null;
            JSPServlet jSPServlet = this;
            synchronized (jSPServlet) {
                obj = this.compile.get(hash);
                if (obj == null) {
                    this.compile.put(hash, new Object());
                    fl = true;
                }
            }
            if (fl) {
                JSPServlet jSPServlet2;
                String string;
                try {
                    string = this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, true);
                    Object var15_19 = null;
                    jSPServlet2 = this;
                }
                catch (Throwable throwable) {
                    Object var15_20 = null;
                    JSPServlet jSPServlet3 = this;
                    synchronized (jSPServlet3) {
                        obj = this.compile.get(hash);
                    }
                    if (obj == null) throw throwable;
                    Object object = obj;
                    synchronized (object) {
                        this.compile.remove(hash);
                        obj.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (jSPServlet2) {
                    obj = this.compile.get(hash);
                }
                if (obj == null) return string;
                Object object = obj;
                synchronized (object) {
                    this.compile.remove(hash);
                    obj.notifyAll();
                    return string;
                }
            }
            JSPServlet jSPServlet4 = this;
            synchronized (jSPServlet4) {
                obj = this.compile.get(hash);
            }
            if (obj == null) return this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, false);
            Object object = obj;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (obj != null && delta < 60000L) {
                    try {
                        if (Log.isTracing()) {
                            Log.getLocation(4).traceInfo("The requested JSP file <" + jspFile + "> is compiling by another client!\r\n" + "Waiting while the file is compiled.", this.alias);
                        }
                        obj.wait(60000L);
                    }
                    catch (OutOfMemoryError ex) {
                        throw ex;
                    }
                    catch (ThreadDeath ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        Log.getCategory(2).logError(this.currentLocation, "Thread interrupted while waiting for the jsp to be compiled. Synchronization may fail.", ex, this.alias, unwrappedRequest.getHttpParameters().getRequest().getClientIP());
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
                return this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, false);
            }
        }
    }

    private HttpJspPage reCompileAndGetClassName(String jspFile, int hash, String request_uri, String encoding, boolean isIncluded, HttpServletRequestFacade unwrappedRequest, HttpServletResponseFacade unwrappedResponse) throws IOException, ServletException {
        HttpJspPage jsp = null;
        Object obj = null;
        JSPServlet jSPServlet = this;
        synchronized (jSPServlet) {
            obj = this.compile.get(hash);
        }
        if (obj != null) {
            Object object = obj;
            synchronized (object) {
                if (Log.isTracing()) {
                    Log.getLocation(4).traceInfo("The requested JSP file <" + jspFile + "> is compiling by another client!\r\n" + "Waiting while the file is compiled.", this.alias);
                }
                long startTime = System.currentTimeMillis();
                long delta = 0L;
                while (obj != null && delta < 60000L) {
                    try {
                        obj.wait(60000L);
                    }
                    catch (InterruptedException ie) {
                        Log.getCategory(2).logError(this.currentLocation, "Thread interrupted while waiting for the jsp to be compiled. Synchronization will fail.", ie, this.alias, unwrappedRequest.getHttpParameters().getRequest().getClientIP());
                    }
                    delta = System.currentTimeMillis() - startTime;
                }
            }
            String className = this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, false);
            jsp = request_uri != null ? this.webComponents.getJSP(className, request_uri) : this.webComponents.getJSP(className, unwrappedRequest.getServletPath().substring(1));
        } else {
            Object object;
            this.compile.put(hash, new Object());
            String className = null;
            try {
                className = this.getClassName(unwrappedRequest, this.applicationContext, jspFile, encoding, isIncluded, true);
                Object var19_19 = null;
                object = obj;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                Object object2 = obj;
                synchronized (object2) {
                    this.compile.remove(hash);
                    obj.notifyAll();
                }
                throw throwable;
            }
            synchronized (object) {
                this.compile.remove(hash);
                obj.notifyAll();
            }
            jsp = request_uri != null ? this.webComponents.getJSP(className, request_uri) : this.webComponents.getJSP(className, unwrappedRequest.getServletPath().substring(1));
        }
        if (jsp == null) {
            unwrappedResponse.sendError(500, "Cannot find or initialize jsp instance.");
        }
        return jsp;
    }

    private void service(HttpJspPage jsp, String jspFile, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            try {
                if (jsp instanceof SingleThreadModel) {
                    HttpJspPage httpJspPage = jsp;
                    synchronized (httpJspPage) {
                        jsp._jspService(request, response);
                        break block12;
                    }
                }
                jsp._jspService(request, response);
            }
            catch (UnavailableException t) {
                if (t.isPermanent()) {
                    this.webComponents.setJspUnavailable(jspFile, -1L);
                } else {
                    this.webComponents.setJspUnavailable(jspFile, System.currentTimeMillis() + (long)(t.getUnavailableSeconds() * 1000));
                }
                throw new WebUnavailableException("servlet_jsp_0046", t.getUnavailableSeconds(), (Throwable)t);
            }
            catch (ServletException t) {
                if (t.getRootCause() instanceof UnavailableException) {
                    UnavailableException ex = (UnavailableException)t.getRootCause();
                    if (ex.isPermanent()) {
                        this.webComponents.setJspUnavailable(jspFile, -1L);
                    } else {
                        this.webComponents.setJspUnavailable(jspFile, System.currentTimeMillis() + (long)(ex.getUnavailableSeconds() * 1000));
                    }
                    throw new WebUnavailableException("servlet_jsp_0046", ex.getUnavailableSeconds(), (Throwable)t);
                }
                throw t;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

