/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security.policy;

import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.servlets_jsp.server.exceptions.SecuritySessionException;
import com.sap.engine.services.servlets_jsp.server.security.policy.SecuritySessionWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PolicyDomain {
    private static final byte DOMAIN_NAMES_SEPARATOR = 47;
    private String name = null;
    private ArrayObject applicationNames = new ArrayObject(2, 2);
    private PolicyDomain[] subPolicyDomains = new PolicyDomain[0];
    private SecuritySessionException sessionAlreadyExistsException = new SecuritySessionException(SecuritySessionException.SESSION_ALREADY_EXISTS);
    private ConcurrentHashMapObjectObject securitySessions = new ConcurrentHashMapObjectObject();

    protected PolicyDomain(String name, String appName) {
        this.name = name;
        this.applicationNames.add((Object)appName);
    }

    private String getName() {
        return this.name;
    }

    private void addApplication(String appName) {
        if (!this.applicationNames.contains((Object)appName)) {
            this.applicationNames.add((Object)appName);
        }
    }

    public void registerNewSession(HttpSession appSession) throws SecuritySessionException {
        if (this.securitySessions.contains((Object)appSession.getId())) {
            throw this.sessionAlreadyExistsException;
        }
        SecuritySessionWrapper securitySession = new SecuritySessionWrapper();
        securitySession.registerListener((SessionListener)appSession);
        this.securitySessions.put((Object)appSession.getId(), (Object)securitySession);
    }

    public void registerNewSessionIfExist(HttpSession appSession, HttpServletRequest sreq) {
        SecuritySessionWrapper securitySession = SecuritySessionWrapper.getSecuritySessionIfAny();
        if (securitySession == null) {
            return;
        }
        if (appSession == null) {
            appSession = sreq.getSession(true);
        }
        if (this.containsSecuritySession(appSession)) {
            return;
        }
        securitySession.registerListener((SessionListener)appSession);
        this.securitySessions.put((Object)appSession.getId(), (Object)securitySession);
    }

    public SecuritySessionWrapper getSecuritySession(HttpSession appSession) {
        SecuritySessionWrapper session = (SecuritySessionWrapper)this.securitySessions.get((Object)appSession.getId());
        int i = 0;
        while (session == null && i < this.subPolicyDomains.length) {
            session = this.subPolicyDomains[i].getSecuritySession(appSession);
            ++i;
        }
        if (session != null) {
            session.registerListener((SessionListener)appSession);
        }
        return session;
    }

    public boolean canJoinSession(String sessionId) {
        return this.securitySessions.get((Object)sessionId) != null || this.canJoinSessionInSubDomains(sessionId);
    }

    public boolean joinSession(HttpSession appSession) {
        SecuritySessionWrapper securitySession = (SecuritySessionWrapper)this.securitySessions.get((Object)appSession.getId());
        if (securitySession == null) {
            return this.joinSessionInSubDomains(appSession);
        }
        securitySession.joinThread();
        securitySession.registerListener((SessionListener)appSession);
        return true;
    }

    public boolean removeMe(HttpSession appSession) {
        HttpSession httpSession = appSession;
        synchronized (httpSession) {
            SecuritySessionWrapper securitySession = this.getSecuritySession(appSession);
            if (securitySession == null) {
                boolean bl = false;
                return bl;
            }
            securitySession.unregisterListener((SessionListener)appSession);
            if (securitySession.isExpired()) {
                this.removeSecuritySession(appSession);
                securitySession.logout();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public ConcurrentHashMapObjectObject getSecuritySessions() {
        return this.securitySessions;
    }

    synchronized PolicyDomain createDomain(String newPolicyDomainName, String appName) {
        int domainSeparator = newPolicyDomainName.indexOf(47);
        while (domainSeparator == 0) {
            newPolicyDomainName = newPolicyDomainName.substring(1);
            domainSeparator = newPolicyDomainName.indexOf(47);
        }
        if (domainSeparator > -1) {
            PolicyDomain newDomainRoot = this.create(newPolicyDomainName.substring(0, domainSeparator), appName, false);
            return newDomainRoot.createDomain(newPolicyDomainName.substring(domainSeparator), appName);
        }
        if (newPolicyDomainName.length() == 0) {
            this.addApplication(appName);
            return this;
        }
        return this.create(newPolicyDomainName, appName, true);
    }

    synchronized void destroyDomain(String oldDomainName, String appName) throws SecuritySessionException {
        int domainSeparator = oldDomainName.indexOf(47);
        while (domainSeparator == 0) {
            oldDomainName = oldDomainName.substring(1);
            domainSeparator = oldDomainName.indexOf(47);
        }
        if (domainSeparator > -1) {
            PolicyDomain newDomainRoot = this.find(oldDomainName.substring(0, domainSeparator));
            if (newDomainRoot != null) {
                newDomainRoot.destroyDomain(oldDomainName.substring(domainSeparator), appName);
            }
        } else if (oldDomainName.length() == 0) {
            this.destroyDomain(appName);
        } else {
            PolicyDomain domain = this.find(oldDomainName);
            if (domain == null) {
                throw new SecuritySessionException(SecuritySessionException.CANNOT_DESTROY_NOT_EXISTING_DOMAIN, new Object[]{oldDomainName});
            }
            domain.destroyDomain(appName);
        }
    }

    private synchronized void destroyDomain(String appName) {
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            this.subPolicyDomains[i].destroyDomain(appName);
            ++i;
        }
        this.applicationNames.remove((Object)appName);
    }

    synchronized void clear() {
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].isEmpty()) {
                PolicyDomain[] tmpSubPolicyDomains = new PolicyDomain[this.subPolicyDomains.length - 1];
                System.arraycopy(this.subPolicyDomains, 0, tmpSubPolicyDomains, 0, i);
                if (i < this.subPolicyDomains.length - 1) {
                    System.arraycopy(this.subPolicyDomains, i + 1, tmpSubPolicyDomains, i, tmpSubPolicyDomains.length - i);
                }
                this.subPolicyDomains = tmpSubPolicyDomains;
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.subPolicyDomains.length) {
            this.subPolicyDomains[i2].clear();
            ++i2;
        }
    }

    synchronized String dump(String tab, boolean full, String nl) {
        StringBuffer result = new StringBuffer();
        result.append(nl);
        result.append(tab + "[" + this.name + "]");
        result.append(nl);
        if (full) {
            if (this.applicationNames.size() > 0) {
                result.append(tab + "Web Applications: ");
                boolean first = true;
                int i = 0;
                while (i < this.applicationNames.size()) {
                    if (((String)this.applicationNames.elementAt(i)).length() != 0) {
                        if (first) {
                            result.append(this.applicationNames.elementAt(i));
                            first = false;
                        } else {
                            result.append(", " + this.applicationNames.elementAt(i));
                        }
                    }
                    ++i;
                }
                result.append(nl);
            }
            result.append(tab + "Security Sessions: " + this.securitySessions.size());
            result.append(nl);
        }
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            result.append(this.subPolicyDomains[i].dump(tab + "\t", full, nl));
            ++i;
        }
        return result.toString();
    }

    private void add(PolicyDomain newDomain) {
        PolicyDomain[] tmpSubPolicyDomains = new PolicyDomain[this.subPolicyDomains.length + 1];
        System.arraycopy(this.subPolicyDomains, 0, tmpSubPolicyDomains, 0, this.subPolicyDomains.length);
        tmpSubPolicyDomains[this.subPolicyDomains.length] = newDomain;
        this.subPolicyDomains = tmpSubPolicyDomains;
    }

    private PolicyDomain find(String name) {
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].getName().equals(name)) {
                return this.subPolicyDomains[i];
            }
            ++i;
        }
        return null;
    }

    private PolicyDomain create(String name, String appName, boolean isLeaf) {
        PolicyDomain newDomainRoot = this.find(name);
        if (newDomainRoot == null) {
            newDomainRoot = isLeaf ? new PolicyDomain(name, appName) : new PolicyDomain(name, "");
            this.add(newDomainRoot);
        } else if (isLeaf) {
            newDomainRoot.addApplication(appName);
        }
        return newDomainRoot;
    }

    private boolean canJoinSessionInSubDomains(String sessionId) {
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].canJoinSession(sessionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean joinSessionInSubDomains(HttpSession appSession) {
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].joinSession(appSession)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean removeSecuritySession(HttpSession appSession) {
        if (this.securitySessions.containsKey((Object)appSession.getId())) {
            this.securitySessions.remove((Object)appSession.getId());
            return true;
        }
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].removeSecuritySession(appSession)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsSecuritySession(HttpSession appSession) {
        if (this.securitySessions.containsKey((Object)appSession.getId())) {
            return true;
        }
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (this.subPolicyDomains[i].containsSecuritySession(appSession)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEmpty() {
        if (this.applicationNames.size() > 1 || this.applicationNames.size() == 1 && ((String)this.applicationNames.elementAt(0)).length() != 0) {
            return false;
        }
        int i = 0;
        while (i < this.subPolicyDomains.length) {
            if (!this.subPolicyDomains[i].isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

