/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.security.http.DigestCredentials;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.servlets_jsp.security.HttpRequestClientInfo;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.runtime.context.SessionServletContext;
import com.sap.engine.services.servlets_jsp.server.security.HttpRequestClientInfoImpl;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class OriginalRequestClientInfoImpl
implements HttpRequestClientInfo {
    private SessionServletContext application = null;
    private X509Certificate[] certificates = null;
    private Cookie[] cookies = null;
    private HashMapObjectObject headers = new HashMapObjectObject();
    private HashMapObjectObject parameters = new HashMapObjectObject();
    private String clientIP = null;
    private String method = null;
    private boolean isSecure = false;
    private HttpSession httpSession = null;
    private HttpRequestClientInfoImpl newRequest = null;
    private char[] newPassword = null;
    private char[] password = null;
    private boolean isSetPassword = false;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$security$OriginalRequestClientInfoImpl == null ? (class$com$sap$engine$services$servlets_jsp$server$security$OriginalRequestClientInfoImpl = OriginalRequestClientInfoImpl.class$("com.sap.engine.services.servlets_jsp.server.security.OriginalRequestClientInfoImpl")) : class$com$sap$engine$services$servlets_jsp$server$security$OriginalRequestClientInfoImpl));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$security$OriginalRequestClientInfoImpl;

    public OriginalRequestClientInfoImpl(HttpRequestClientInfoImpl originalRequest, SessionServletContext application) {
        this.application = application;
        this.certificates = originalRequest.getCertificateChain();
        this.cookies = originalRequest.getAllCookies();
        MimeHeaders mimeHeaders = originalRequest.getAllHeaders();
        int headersCount = mimeHeaders.size();
        int i = 0;
        while (i < headersCount) {
            this.headers.put((Object)mimeHeaders.getHeaderName(i), (Object)mimeHeaders.getHeader(i));
            ++i;
        }
        this.parameters = originalRequest.getAllParameters();
        this.clientIP = originalRequest.getClientIp();
        this.method = originalRequest.getMethod();
        this.isSecure = originalRequest.isSecure();
        this.httpSession = originalRequest.getHttpSession();
    }

    public void setNewRequest(HttpRequestClientInfoImpl newRequest) {
        this.newRequest = newRequest;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificates;
    }

    public void requireCertificateChain() {
        this.newRequest.requireCertificateChain();
    }

    public String getHttpCookie(String name) {
        if (this.cookies == null) {
            return null;
        }
        int i = 0;
        while (i < this.cookies.length) {
            if (this.cookies[i].getName().equals(name)) {
                return this.cookies[i].getValue();
            }
            ++i;
        }
        return null;
    }

    public String getHttpHeader(String name) {
        return (String)this.headers.get((Object)name);
    }

    public String[] getHttpParameterValues(String name) {
        return (String[])this.parameters.get((Object)name);
    }

    public void removeRequestHeader(String name, String value) {
        this.headers.remove((Object)name);
    }

    public char[] getPassword() {
        if (this.isSetPassword) {
            return this.password;
        }
        if ("BASIC".equalsIgnoreCase(this.application.getAuthType())) {
            try {
                String authHeaderValue = this.decode(this.getHttpHeader("Authorization"));
                return this.getPasswordBasic(authHeaderValue);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logWarning("Incorrect Basic authorization header.", e);
                return null;
            }
        }
        if ("FORM".equalsIgnoreCase(this.application.getAuthType())) {
            return this.getParameter("j_password").toCharArray();
        }
        return null;
    }

    public void setNewPassword(char[] newPassword) {
        this.newPassword = newPassword;
    }

    public void setPassword(char[] password) {
        this.password = password;
        this.isSetPassword = true;
    }

    public char[] getNewPassword() {
        return this.newPassword;
    }

    public String getUserName() {
        if ("BASIC".equalsIgnoreCase(this.application.getAuthType())) {
            try {
                String authHeaderValue = this.decode(this.getHttpHeader("Authorization"));
                return this.getNameBasic(authHeaderValue);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logWarning("Incorrect Basic authorization header.", e);
                return null;
            }
        }
        if ("DIGEST".equalsIgnoreCase(this.application.getAuthType())) {
            DigestCredentials digestCredentials = this.getDigestCredentials();
            return digestCredentials.getUsername();
        }
        if ("FORM".equalsIgnoreCase(this.application.getAuthType())) {
            return this.getParameter("j_username");
        }
        return null;
    }

    public String getClientIp() {
        return this.clientIP;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public InputStream getBody() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public Object getSessionAttribute(String name) {
        return this.httpSession.getAttribute(name);
    }

    public String[] getSessionAttributesNames() {
        return this.httpSession.getValueNames();
    }

    public void setResponseStatusCode(int code) {
        this.newRequest.setResponseStatusCode(code);
    }

    public void addResponseCookie(String name, String value) {
        this.newRequest.addResponseCookie(name, value);
    }

    public void addResponseHeader(String name, String value) {
        this.newRequest.addResponseHeader(name, value);
    }

    public void setResponseHeader(String name, String value) {
        this.newRequest.setResponseHeader(name, value);
    }

    public void setHttpBody(byte[] body) {
        this.newRequest.setHttpBody(body);
    }

    public void setSessionAttribute(String name, Object value) {
        this.newRequest.setSessionAttribute(name, value);
    }

    public void removeSessionAttribute(String name) {
        this.newRequest.removeSessionAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.newRequest.setRequestAttribute(name, value);
    }

    public void generate(boolean isError) {
    }

    private String getNameBasic(String decoded) {
        if (decoded == null) {
            return null;
        }
        return decoded.substring(0, decoded.indexOf(58));
    }

    private char[] getPasswordBasic(String decoded) {
        return decoded.substring(decoded.indexOf(58) + 1).toCharArray();
    }

    private String decode(String coded) throws Exception {
        if (coded == null || coded.indexOf("Basic") == -1) {
            return null;
        }
        coded = coded.substring(coded.indexOf(" ", coded.indexOf("Basic")) + 1);
        return new String(Base64.decode((byte[])coded.getBytes()));
    }

    public String getParameter(String key) {
        String[] allValues = this.getHttpParameterValues(key);
        if (allValues != null) {
            return allValues[0];
        }
        return null;
    }

    private void logWarning(String msg, Throwable t) {
        Log.getCategory(2).logWarning(this.currentLocation, msg, t, this.application.getAliasName());
    }

    private DigestCredentials getDigestCredentials() {
        String authHeader = this.getHttpHeader("Authorization");
        if (authHeader == null || authHeader.indexOf("Digest") == -1) {
            return null;
        }
        DigestCredentials digestCredentials = new DigestCredentials();
        digestCredentials.setURI(this.getClientIp());
        digestCredentials.setDirectivesValues(authHeader);
        digestCredentials.setMethod(this.getMethod());
        return digestCredentials;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

