/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.security.http.DigestAuthenticationInfo;
import com.sap.engine.lib.security.http.DigestChallenge;
import com.sap.engine.lib.security.http.DigestCredentials;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.interfaces.ErrorData;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.interfaces.client.SslAttributes;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.CookieUtils;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.headers.MimeHeaders;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.security.HttpRequestClientInfo;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.lib.WebParseUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.security.ChangePasswordModule;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class HttpRequestClientInfoImpl
implements HttpRequestClientInfo {
    private WebCookieConfig defaultCookieConfig = null;
    private HttpParameters httpRequest = null;
    private ApplicationContext application = null;
    private ChangePasswordModule changePasswordModule = null;
    private HashMapObjectObject parameters = new HashMapObjectObject();
    private String characterEncoding = "ISO-8859-1";
    private boolean parametersParsed = false;
    private boolean requireCertificateChain = false;
    private int responseCode = 401;
    private byte[] body = "Unauthorized".getBytes();
    private boolean setAnything = false;
    private boolean passwordExpired = false;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$security$HttpRequestClientInfoImpl == null ? (class$com$sap$engine$services$servlets_jsp$server$security$HttpRequestClientInfoImpl = HttpRequestClientInfoImpl.class$("com.sap.engine.services.servlets_jsp.server.security.HttpRequestClientInfoImpl")) : class$com$sap$engine$services$servlets_jsp$server$security$HttpRequestClientInfoImpl));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$security$HttpRequestClientInfoImpl;

    public HttpRequestClientInfoImpl(HttpParameters httpRequest, ApplicationContext application) {
        this.httpRequest = httpRequest;
        this.application = application;
        this.defaultCookieConfig = new WebCookieConfig(application.getAliasName(), 1);
        this.defaultCookieConfig.setPath((byte)8, "/");
    }

    public X509Certificate[] getCertificateChain() {
        this.requireCertificateChain();
        SslAttributes sslAttributes = this.httpRequest.getRequest().getSslAttributes();
        if (sslAttributes == null) {
            return null;
        }
        return sslAttributes.getCertificates();
    }

    public void requireCertificateChain() {
        this.requireCertificateChain = true;
    }

    public String getHttpCookie(String name) {
        ArrayObject cookies = this.httpRequest.getRequest().getCookies(this.application.getWebApplicationConfiguration().isURLSessionTracking());
        if (cookies == null || cookies.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < cookies.size()) {
            HttpCookie httpCookie = (HttpCookie)cookies.elementAt(i);
            if (httpCookie.getName().equals(name)) {
                return httpCookie.getValue();
            }
            ++i;
        }
        return null;
    }

    protected Cookie[] getAllCookies() {
        ArrayObject cookies = this.httpRequest.getRequest().getCookies(this.application.getWebApplicationConfiguration().isURLSessionTracking());
        if (cookies == null || cookies.size() == 0) {
            return null;
        }
        Cookie[] res = new Cookie[cookies.size()];
        int resPtr = 0;
        int i = 0;
        while (i < res.length) {
            HttpCookie httpCookie = (HttpCookie)cookies.elementAt(i);
            try {
                res[resPtr] = httpCookie.toCookie();
            }
            catch (IllegalArgumentException e) {
                --resPtr;
            }
            ++i;
            ++resPtr;
        }
        if (resPtr < res.length) {
            Cookie[] resTmp = new Cookie[resPtr];
            System.arraycopy(res, 0, resTmp, 0, resTmp.length);
            res = resTmp;
        }
        return res;
    }

    public String getHttpHeader(String name) {
        return this.httpRequest.getRequest().getHeaders().getHeader(name);
    }

    protected MimeHeaders getAllHeaders() {
        return this.httpRequest.getRequest().getHeaders();
    }

    public void removeRequestHeader(String name, String value) {
        if (value == null) {
            this.httpRequest.getRequest().getHeaders().removeHeader(name);
        } else {
            this.httpRequest.getRequest().getHeaders().removeHeader(name, value);
        }
    }

    public String[] getHttpParameterValues(String name) {
        if (!this.parametersParsed) {
            try {
                this.parseEncoding();
            }
            catch (UnsupportedEncodingException e) {
                this.logWarning("Unsupported encoding found in the request.", e);
            }
            this.parseParameters();
        }
        return (String[])this.parameters.get((Object)name);
    }

    protected HashMapObjectObject getAllParameters() {
        if (!this.parametersParsed) {
            try {
                this.parseEncoding();
            }
            catch (UnsupportedEncodingException e) {
                this.logWarning("Unsupported encoding found in the request.", e);
            }
            this.parseParameters();
        }
        return this.parameters;
    }

    private void parseEncoding() throws UnsupportedEncodingException {
        String characterEncoding = null;
        characterEncoding = WebParseUtils.parseEncoding(this.httpRequest);
        if (characterEncoding == null || characterEncoding.equals("")) {
            characterEncoding = "ISO-8859-1";
        }
        this.setCharacterEncoding(characterEncoding);
    }

    public char[] getPassword() {
        if ("BASIC".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
            try {
                String authHeaderValue = this.decode(this.getHttpHeader("Authorization"));
                return this.getPasswordBasic(authHeaderValue);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logWarning("Incorrect Basic authorization header.", e);
                return null;
            }
        }
        if ("FORM".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType()) && this.httpRequest.getRequest().getRequestLine().getUrlDecoded().endsWith(Constants.j_security_check)) {
            return this.getParameterCharArray("j_password");
        }
        return null;
    }

    public char[] getNewPassword() {
        this.passwordExpired = true;
        if (this.changePasswordModule == null) {
            this.changePasswordModule = new ChangePasswordModule();
        }
        return null;
    }

    public String getUserName() {
        if ("BASIC".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
            try {
                String authHeaderValue = this.decode(this.getHttpHeader("Authorization"));
                return this.getNameBasic(authHeaderValue);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.logWarning("Incorrect Basic authorization header.", e);
                return null;
            }
        }
        if ("DIGEST".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
            DigestCredentials digestCredentials = this.getDigestCredentials();
            return digestCredentials.getUsername();
        }
        if ("FORM".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType()) && this.httpRequest.getRequest().getRequestLine().getUrlDecoded().endsWith(Constants.j_security_check)) {
            return this.getParameter("j_username");
        }
        return null;
    }

    public String getClientIp() {
        return new String(ParseUtils.inetAddressByteToString((byte[])this.httpRequest.getRequest().getClientIP()));
    }

    public String getMethod() {
        return new String(this.httpRequest.getRequest().getRequestLine().getMethod());
    }

    public boolean isSecure() {
        return this.httpRequest.getRequest().getRequestLine().isSecure();
    }

    public InputStream getBody() {
        return this.httpRequest.getRequest().getBody();
    }

    public Object getSessionAttribute(String name) {
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
        }
        return applicationSession.getAttribute(name);
    }

    public String[] getSessionAttributesNames() {
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
        }
        return applicationSession.getValueNames();
    }

    public void setResponseStatusCode(int code) {
        this.responseCode = code;
        this.setAnything = true;
    }

    public void addResponseCookie(String name, String value) {
        HttpCookie cok = CookieParser.createCookie((String)name, (String)value, (String)this.httpRequest.getRequest().getHost(), (WebCookieConfig)this.defaultCookieConfig);
        MessageBytes cook = new MessageBytes(CookieUtils.getCookieHeader((HttpCookie)cok));
        int index = cook.indexOf(':');
        this.httpRequest.getResponse().getHeaders().addHeader(cook.getBytes(0, index), cook.getBytes(index + 2));
    }

    public void addResponseHeader(String name, String value) {
        this.httpRequest.getResponse().getHeaders().addHeader(name.getBytes(), value.getBytes());
    }

    public void setResponseHeader(String name, String value) {
        this.httpRequest.getResponse().getHeaders().putHeader(name.getBytes(), value.getBytes());
    }

    public void setHttpBody(byte[] body) {
        this.body = body;
        this.setAnything = true;
    }

    public void setSessionAttribute(String name, Object value) {
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
        }
        applicationSession.setAttribute(name, value);
    }

    public void removeSessionAttribute(String name) {
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
        }
        applicationSession.removeAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.httpRequest.setRequestAttribute(name, value);
    }

    public boolean isRequiredCertificateChain() {
        return this.requireCertificateChain;
    }

    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public String getPasswordChangeLoginPage() {
        return this.changePasswordModule.getLoginPage();
    }

    public boolean generate(boolean isError, String errorMessage) throws IOException {
        if (isError) {
            if (!this.setAnything) {
                if (this.passwordExpired) {
                    this.changePasswordModule.prepareChangePassword(this, this.httpRequest, this.application);
                    return false;
                }
                if (this.requireCertificateChain) {
                    if (!this.httpRequest.getRequest().getRequestLine().isSecure()) {
                        this.httpRequest.getResponse().setSchemeHttps();
                        return false;
                    }
                    this.requireCertificateChain = false;
                }
                this.body = errorMessage.getBytes();
                if ("BASIC".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
                    this.httpRequest.getResponse().getHeaders().addHeader(HeaderNames.response_header_www_authenticate_, ("Basic realm=\"" + this.application.getSessionServletContext().getLoginRealmName() + "\"").getBytes());
                } else if ("DIGEST".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
                    this.setDigestUnAuthHeader();
                } else if ("FORM".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
                    byte[] newUrl = null;
                    MessageBytes aliasUsed = this.httpRequest.getRequestPathMappings().getAliasName();
                    if (this.httpRequest.getRequestPathMappings().getZoneName() != null && !this.httpRequest.getRequestPathMappings().isZoneExactAlias()) {
                        aliasUsed.appendAfter(this.httpRequest.getHttpProperties().getZoneSeparator().getBytes());
                        aliasUsed.appendAfter(this.httpRequest.getRequestPathMappings().getZoneName().getBytes());
                    }
                    if (this.httpRequest.getRequest().getRequestLine().getUrlDecoded().endsWith(Constants.j_security_check)) {
                        newUrl = ("/" + aliasUsed + this.application.getSessionServletContext().getFormLoginErrorPage()).getBytes();
                    } else {
                        newUrl = ("/" + aliasUsed + this.application.getSessionServletContext().getFormLoginLoginPage()).getBytes();
                        this.createSessionFormLogin();
                    }
                    ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
                    if (applicationSession == null) {
                        applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
                    }
                    newUrl = this.application.getSessionServletContext().encodeURL(new String(newUrl), aliasUsed, this.httpRequest, applicationSession).getBytes();
                    this.responseCode = 302;
                    this.httpRequest.getResponse().getHeaders().addHeader(HeaderNames.response_header_location_, newUrl);
                }
            }
            this.httpRequest.setErrorData(new ErrorData(this.responseCode, new String(this.body), "No details available"));
            return true;
        }
        if (!this.setAnything && !"BASIC".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
            if ("DIGEST".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
                this.setDigestAuthHeader();
            } else if ("FORM".equalsIgnoreCase(this.application.getSessionServletContext().getAuthType())) {
                String url;
                ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
                if (applicationSession == null) {
                    applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
                }
                if ((url = (String)applicationSession.removeSecurityValue("j_security_check")) != null) {
                    applicationSession.setFormLoginBodyParameters(true);
                    this.responseCode = 302;
                    this.httpRequest.getResponse().getHeaders().addHeader(HeaderNames.response_header_location_, url.getBytes());
                    this.httpRequest.getResponse().sendResponse(this.responseCode);
                    return true;
                }
            }
        }
        return false;
    }

    public HttpSession getHttpSession() {
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
        }
        return applicationSession;
    }

    public String getParameter(String key) {
        String[] allValues = this.getHttpParameterValues(key);
        if (allValues != null && allValues.length > 0) {
            return allValues[0];
        }
        return null;
    }

    private char[] getParameterCharArray(String key) {
        String[] allValues = this.getHttpParameterValues(key);
        if (allValues != null && allValues.length > 0 && allValues[0] != null) {
            return allValues[0].toCharArray();
        }
        return null;
    }

    private void parseParameters() {
        this.parametersParsed = true;
        try {
            WebParseUtils.parseParameters(this.parameters, this.httpRequest, this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            this.logWarning("Can't parse the parameters of the request. Incorrect encoding specified in it: " + this.characterEncoding + ". ", e);
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        new String(buffer, enc);
        this.characterEncoding = enc;
    }

    private String getNameBasic(String decoded) {
        if (decoded == null) {
            return null;
        }
        int ddInd = decoded.indexOf(58);
        if (ddInd == -1) {
            return null;
        }
        return decoded.substring(0, ddInd);
    }

    private char[] getPasswordBasic(String decoded) {
        if (decoded == null) {
            return null;
        }
        int ddInd = decoded.indexOf(58);
        if (ddInd == -1) {
            return null;
        }
        return decoded.substring(ddInd + 1).toCharArray();
    }

    private String decode(String coded) throws Exception {
        if (coded == null) {
            return null;
        }
        int basicInd = coded.indexOf("Basic");
        if (basicInd == -1) {
            return null;
        }
        int spInd = coded.indexOf(" ", basicInd);
        if (spInd == -1) {
            return null;
        }
        coded = coded.substring(spInd + 1);
        return new String(Base64.decode((byte[])coded.getBytes()));
    }

    private DigestCredentials getDigestCredentials() {
        String authHeader = this.getHttpHeader("Authorization");
        if (authHeader == null || authHeader.indexOf("Digest") == -1) {
            return null;
        }
        DigestCredentials digestCredentials = new DigestCredentials();
        digestCredentials.setURI(this.getClientIp());
        digestCredentials.setDirectivesValues(authHeader);
        digestCredentials.setMethod(new String(this.httpRequest.getRequest().getRequestLine().getMethod()));
        return digestCredentials;
    }

    private void setDigestAuthHeader() {
        ThreadContext localTC = SBasic.threadSystem.getThreadContext();
        SecurityContextObject security = (SecurityContextObject)localTC.getContextObject(localTC.getContextObjectId("security"));
        SecuritySession securitySession = security.getSession();
        if (securitySession == null || securitySession.getSubject() == null) {
            return;
        }
        Iterator<Object> publicCred = securitySession.getSubject().getPublicCredentials().iterator();
        Object cred = null;
        while (publicCred.hasNext()) {
            cred = publicCred.next();
            if (!(cred instanceof DigestAuthenticationInfo)) continue;
            this.httpRequest.getResponse().getHeaders().addHeader(Constants.HEADER_AUTHENTICATION_INFO, cred.toString().getBytes());
        }
    }

    private void setDigestUnAuthHeader() {
        DigestChallenge digestChallenge = new DigestChallenge();
        digestChallenge.setDomain("");
        digestChallenge.setStale(true);
        digestChallenge.setDigestAlgorithm("MD5");
        digestChallenge.setMessageQOP("auth");
        String nonce = DigestChallenge.generateNonce((String)new String(ParseUtils.inetAddressByteToString((byte[])this.httpRequest.getRequest().getClientIP())));
        digestChallenge.setNonce(nonce);
        digestChallenge.setRealm(this.application.getSessionServletContext().getLoginRealmName());
        this.httpRequest.getResponse().getHeaders().addHeader(HeaderNames.response_header_www_authenticate_, digestChallenge.toString().getBytes());
    }

    private String createSessionFormLogin() {
        String res = null;
        String url = this.httpRequest.getRequest().getRequestLine().getFullUrl().toString();
        ApplicationSession applicationSession = (ApplicationSession)this.httpRequest.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = this.application.getSessionServletContext().createSession(this.httpRequest);
            res = applicationSession.getId();
        }
        applicationSession.putSecurityValue("j_security_check", this.application.getSessionServletContext().encodeURL(url, this.httpRequest.getRequestPathMappings().getAliasName(), this.httpRequest, applicationSession));
        MessageBytes paramBody = this.httpRequest.getRequestParametersBody();
        if (paramBody != null) {
            try {
                HashMapObjectObject parameters = new HashMapObjectObject(8);
                String characterEncoding = null;
                characterEncoding = WebParseUtils.parseEncoding(this.httpRequest);
                if (characterEncoding == null || characterEncoding.equals("")) {
                    characterEncoding = "ISO-8859-1";
                }
                WebParseUtils.parseQueryString(parameters, paramBody.getBytes(), characterEncoding);
                applicationSession.putSecurityValue("j_request_parameters", parameters);
            }
            catch (UnsupportedEncodingException e) {
                Log.getCategory(2).logWarning(this.currentLocation, "Illegal character encoding " + this.characterEncoding + " found into the client request.", e, this.application.getAliasName());
            }
        }
        return res;
    }

    private void logWarning(String msg, Throwable t) {
        Log.getCategory(2).logWarning(this.currentLocation, msg, t, this.application.getAliasName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

