/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security;

import com.sap.engine.lib.security.PasswordChangeCallback;
import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.services.servlets_jsp.security.HttpCallbackHandler;
import com.sap.engine.services.servlets_jsp.security.HttpRequestClientInfo;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnsupportedCallbackException;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class HttpCallbackHandlerImpl
implements HttpCallbackHandler {
    public static final String AUTH_METHOD = "auth_method";
    private HttpRequestClientInfo clientInfo = null;

    public HttpCallbackHandlerImpl(HttpRequestClientInfo info) {
        this.clientInfo = info;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            this.setCallback(callbacks[i]);
            ++i;
        }
    }

    private void setCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof NameCallback) {
            this.setCallback((NameCallback)callback);
        } else if (callback instanceof PasswordChangeCallback) {
            this.setCallback((PasswordChangeCallback)callback);
        } else if (callback instanceof PasswordCallback) {
            this.setCallback((PasswordCallback)callback);
        } else if (callback instanceof HttpGetterCallback) {
            this.setCallback((HttpGetterCallback)callback);
        } else if (callback instanceof HttpSetterCallback) {
            this.setCallback((HttpSetterCallback)callback);
        }
    }

    private void setCallback(HttpGetterCallback callback) throws UnsupportedCallbackException {
        byte type = callback.getType();
        if (4 == type) {
            callback.setValue((Object)this.clientInfo.getCertificateChain());
        } else if (2 == type) {
            callback.setValue((Object)this.clientInfo.getHttpCookie(callback.getName()));
        } else if (1 == type) {
            callback.setValue((Object)this.clientInfo.getHttpHeader(callback.getName()));
        } else if (3 == type) {
            callback.setValue((Object)this.clientInfo.getHttpParameterValues(callback.getName()));
        } else if (5 == type) {
            callback.setValue((Object)this.clientInfo.getClientIp());
        } else if (6 == type) {
            callback.setValue((Object)this.clientInfo.getMethod());
        } else if (7 == type) {
            callback.setValue((Object)new Boolean(this.clientInfo.isSecure()));
        } else if (9 == callback.getType()) {
            callback.setValue((Object)this.clientInfo.getBody());
        } else if (10 == type) {
            callback.setValue(this.clientInfo.getSessionAttribute(callback.getName()));
        } else if (11 == type) {
            callback.setValue((Object)this.clientInfo.getSessionAttributesNames());
        } else {
            throw new WebUnsupportedCallbackException(WebUnsupportedCallbackException.UNSUPPORTED_CALLBACK_CONSTANT, new Object[]{String.valueOf(type)}, (Callback)callback);
        }
    }

    private void setCallback(HttpSetterCallback callback) throws UnsupportedCallbackException {
        if (2 == callback.getType()) {
            this.clientInfo.addResponseCookie(callback.getName(), (String)callback.getValue());
        } else if (1 == callback.getType()) {
            this.clientInfo.addResponseHeader(callback.getName(), (String)callback.getValue());
        } else if (14 == callback.getType()) {
            this.clientInfo.setResponseHeader(callback.getName(), (String)callback.getValue());
        } else if (8 == callback.getType()) {
            this.clientInfo.setResponseStatusCode(new Integer((String)callback.getValue()));
        } else if (9 == callback.getType()) {
            this.clientInfo.setHttpBody(((String)callback.getValue()).getBytes());
        } else if (10 == callback.getType()) {
            this.clientInfo.setSessionAttribute(callback.getName(), callback.getValue());
        } else if (12 == callback.getType()) {
            this.clientInfo.removeSessionAttribute(callback.getName());
        } else if (13 == callback.getType()) {
            this.clientInfo.setRequestAttribute(callback.getName(), callback.getValue());
        } else if (15 == callback.getType()) {
            this.clientInfo.removeRequestHeader(callback.getName(), (String)callback.getValue());
        } else {
            throw new WebUnsupportedCallbackException(WebUnsupportedCallbackException.UNSUPPORTED_CALLBACK_CONSTANT, new Object[]{String.valueOf(callback.getType())}, (Callback)callback);
        }
    }

    private void setCallback(NameCallback callback) {
        callback.setName(this.clientInfo.getUserName());
    }

    private void setCallback(PasswordCallback callback) {
        callback.setPassword(this.clientInfo.getPassword());
    }

    private void setCallback(PasswordChangeCallback callback) {
        callback.setPassword(this.clientInfo.getNewPassword());
    }
}

