/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.context;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.httpserver.lib.RequestPathMappings;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterMapping;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import java.util.Enumeration;

public class WebMappings {
    private HashMapObjectObject exactMap = new HashMapObjectObject();
    private HashMapObjectObject pathMap = new HashMapObjectObject();
    private HashMapObjectObject extMap = new HashMapObjectObject();
    private ArrayObject errorCode = new ArrayObject();
    private ArrayObject errorException = new ArrayObject();
    private FilterMapping[] filterMapping = null;
    private MessageBytes servletMappedSlashStar = new MessageBytes("".getBytes());
    private boolean defaultServlet = false;
    private MessageBytes defaultServletName = null;
    private ClassLoader appClassLoader = null;

    public WebMappings(ClassLoader appClassLoader) {
        this.appClassLoader = appClassLoader;
    }

    public void addMapping(String servletMap, String servletName) {
        if (!(servletMap.startsWith("/") || servletMap.equals("") || servletMap.startsWith("*.") || servletMap.endsWith("/*"))) {
            servletMap = "/" + servletMap;
        }
        MessageBytes MBservletMap = new MessageBytes(servletMap.getBytes());
        MessageBytes MBservletName = new MessageBytes(servletName.getBytes());
        if (MBservletMap.startsWith("/") && MBservletMap.endsWith("/*")) {
            this.pathMap.put((Object)MBservletMap, (Object)MBservletName);
            if (MBservletMap.equals("/*")) {
                this.servletMappedSlashStar = MBservletName;
            }
            return;
        }
        if (MBservletMap.equals("/")) {
            this.defaultServlet = true;
            this.defaultServletName = MBservletName;
            return;
        }
        if (MBservletMap.startsWith("*.")) {
            MBservletMap = new MessageBytes(MBservletMap.getBytes(1, MBservletMap.length() - 1));
            this.extMap.put((Object)MBservletMap, (Object)MBservletName);
            return;
        }
        if (MBservletMap.endsWith("/*")) {
            MBservletMap.appendBefore("/".getBytes());
            this.exactMap.put((Object)MBservletMap, (Object)MBservletName);
            return;
        }
        this.exactMap.put((Object)MBservletMap, (Object)MBservletName);
    }

    void addFilterMapping(FilterMapping[] fMappings) {
        if (fMappings == null) {
            return;
        }
        if (this.filterMapping == null) {
            this.filterMapping = new FilterMapping[fMappings.length];
            System.arraycopy(fMappings, 0, this.filterMapping, 0, fMappings.length);
        } else {
            FilterMapping[] newFMappings = new FilterMapping[this.filterMapping.length + fMappings.length];
            System.arraycopy(this.filterMapping, 0, newFMappings, 0, this.filterMapping.length);
            System.arraycopy(fMappings, 0, newFMappings, this.filterMapping.length, fMappings.length);
            this.filterMapping = newFMappings;
        }
    }

    void addErrorPageForException(ErrorPage errorPage) {
        Class<?> exceptionClassToAdd;
        try {
            String exceptionTypeToAdd = (String)errorPage.getValue();
            exceptionClassToAdd = this.appClassLoader.loadClass(exceptionTypeToAdd);
        }
        catch (ClassNotFoundException cnfe) {
            Log.getCategory(1).logWarning(ApplicationContext.currentLocation, "Problem in <error-page> declaration", cnfe, "");
            return;
        }
        int size = this.errorException.size();
        int i = 0;
        while (i < size) {
            block6: {
                Class<?> exceptionClass;
                try {
                    String exceptionType = (String)((ErrorPage)this.errorException.elementAt(i)).getValue();
                    exceptionClass = this.appClassLoader.loadClass(exceptionType);
                }
                catch (ClassNotFoundException cnfe) {
                    Log.getCategory(1).logWarning(ApplicationContext.currentLocation, "This must not happen.", cnfe, "");
                    break block6;
                }
                if (exceptionClass.isAssignableFrom(exceptionClassToAdd)) {
                    this.errorException.add(i, (Object)errorPage);
                    return;
                }
            }
            ++i;
        }
        this.errorException.add((Object)errorPage);
    }

    void initErrorPages(ErrorPage[] errorPage) {
        String string = "";
        if (errorPage != null) {
            int i = 0;
            while (i < errorPage.length) {
                Object obj = errorPage[i].getValue();
                if (obj != null && obj.getClass() != null && obj.getClass().isInstance(string)) {
                    this.addErrorPageForException(errorPage[i]);
                } else {
                    this.errorCode.addElement((Object)errorPage[i]);
                }
                ++i;
            }
        }
    }

    public MessageBytes getServletMappedSlashStar() {
        return this.servletMappedSlashStar;
    }

    public void doMapCheck(MessageBytes requestURI, RequestPathMappings pathMappings, boolean withNoDefaultServlet) {
        MessageBytes temp = this.checkExactPath(requestURI);
        if (temp != null) {
            pathMappings.setServletName(temp);
            return;
        }
        this.checkPath(requestURI, pathMappings, withNoDefaultServlet);
        if (pathMappings.getServletName() == null) {
            temp = this.checkExtension(requestURI);
            if (temp != null) {
                pathMappings.setServletName(temp);
            } else if (this.defaultServletName != null) {
                pathMappings.setServletName(this.defaultServletName);
                pathMappings.setServletPath(requestURI.toString());
            }
        }
    }

    public String getExceptionErrorPage(Throwable ex) {
        int i = 0;
        while (i < this.errorException.size()) {
            try {
                ErrorPage er = (ErrorPage)this.errorException.elementAt(i);
                if (this.appClassLoader.loadClass((String)er.getValue()).isAssignableFrom(ex.getClass())) {
                    return er.getLocation();
                }
            }
            catch (ClassNotFoundException e) {
                Log.getCategory(1).logWarning(ApplicationContext.currentLocation, "Can't load the the exception of the error page.", e, "");
            }
            catch (NoClassDefFoundError e) {
                Log.getCategory(1).logWarning(ApplicationContext.currentLocation, "Can't load the the exception of the error page.", e, "");
            }
            ++i;
        }
        return null;
    }

    public String[] getFilters(String requestPath, MessageBytes servletName) {
        if (this.filterMapping == null || this.filterMapping.length == 0) {
            return null;
        }
        ArrayObject filters = new ArrayObject();
        int i = 0;
        while (i < this.filterMapping.length) {
            if (this.filterMapping[i].getURLPattern() != null && WebMappings.checkFilterMap(this.filterMapping[i].getURLPattern(), requestPath)) {
                filters.add((Object)this.filterMapping[i].getFilterName());
            }
            ++i;
        }
        if (servletName != null) {
            int i2 = 0;
            while (i2 < this.filterMapping.length) {
                if (servletName.equals(this.filterMapping[i2].getServletName())) {
                    filters.add((Object)this.filterMapping[i2].getFilterName());
                }
                ++i2;
            }
        }
        if (filters.size() > 0) {
            String[] res = new String[filters.size()];
            int i3 = 0;
            while (i3 < res.length) {
                res[i3] = (String)filters.elementAt(i3);
                ++i3;
            }
            return res;
        }
        return null;
    }

    public String getErrorCodeErrorPage(int code) {
        int i = 0;
        while (i < this.errorCode.size()) {
            ErrorPage er = (ErrorPage)this.errorCode.elementAt(i);
            int errorCode = (Integer)er.getValue();
            if (errorCode == code) {
                return er.getLocation();
            }
            ++i;
        }
        return null;
    }

    private void checkPath(MessageBytes requestURI, RequestPathMappings pathMappings, boolean checkPathNoDefaultServlet) {
        MessageBytes s = null;
        MessageBytes ss = null;
        MessageBytes maxS = null;
        MessageBytes maxSS = null;
        Enumeration enumeration = this.pathMap.keys();
        while (enumeration.hasMoreElements()) {
            s = (MessageBytes)enumeration.nextElement();
            if (checkPathNoDefaultServlet && this.defaultServlet && s.equals("/*")) continue;
            ss = new MessageBytes(s.getBytes(0, s.length() - 1));
            if (requestURI.startsWith(ss)) {
                if (maxSS != null && ss.length() <= maxSS.length()) continue;
                maxS = s;
                ss.setLength(ss.length() - 1);
                maxSS = ss;
                continue;
            }
            ss.setLength(ss.length() - 1);
            if (!requestURI.equals(ss) || maxSS != null && ss.length() <= maxSS.length()) continue;
            maxS = s;
            maxSS = ss;
        }
        if (maxSS != null) {
            pathMappings.setServletName((MessageBytes)this.pathMap.get(maxS));
            pathMappings.setServletPath(maxSS.toString());
        }
    }

    private MessageBytes checkExactPath(MessageBytes _filename) {
        Object obj = this.exactMap.get((Object)_filename);
        if (obj != null) {
            return (MessageBytes)obj;
        }
        return null;
    }

    private MessageBytes checkExtension(MessageBytes _filename) {
        Object obj = null;
        obj = this.extMap.get((Object)(_filename = _filename.lastIndexOf('.') != -1 ? new MessageBytes(_filename.getBytes(_filename.lastIndexOf('.'))) : new MessageBytes(_filename.getBytes())));
        if (obj != null) {
            return (MessageBytes)obj;
        }
        return null;
    }

    private static boolean checkFilterMap(String testPath, String requestPath) {
        int period;
        int slash;
        if (requestPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            String comparePath = requestPath;
            while (true) {
                if (testPath.equals(comparePath + "/*")) {
                    return true;
                }
                if (testPath.equals(comparePath + "*")) {
                    return true;
                }
                int slash2 = comparePath.lastIndexOf("/");
                if (slash2 < 0) break;
                comparePath = comparePath.substring(0, slash2);
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            slash = requestPath.lastIndexOf("/");
            period = requestPath.lastIndexOf(".");
            if (slash >= 0 && period > slash) {
                return testPath.equals("*." + requestPath.substring(period + 1));
            }
        }
        if (testPath.startsWith(".")) {
            slash = requestPath.lastIndexOf("/");
            period = requestPath.lastIndexOf(".");
            if (slash >= 0 && period > slash) {
                return testPath.equals("." + requestPath.substring(period + 1));
            }
        }
        return false;
    }
}

