/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.context;

import com.sap.engine.lib.util.ConcurrentHashMapObjectLong;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.ServletNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebResourceAccessor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebServletException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnavailableException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.runtime.FilterConfigImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.ServletConfigImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ConnectionEventListener;
import com.sap.engine.services.servlets_jsp.server.runtime.context.WebApplicationConfig;
import com.sap.engine.services.servlets_jsp.server.security.PrivilegedActionImpl;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.HttpJspPage;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;

public class WebComponents {
    private String aliasName = null;
    private ApplicationContext servletContext = null;
    private HashMapObjectObject servlets = new HashMapObjectObject();
    private HashMapObjectObject servletsByClass = new HashMapObjectObject();
    private HashMapObjectObject jsps = new HashMapObjectObject();
    private HashMapObjectObject filters = new HashMapObjectObject();
    private Vector jspServletsNames = new Vector();
    private ConcurrentHashMapObjectObject tagLibDescriptors = new ConcurrentHashMapObjectObject();
    private ConcurrentHashMapObjectObject tagLibraryValidators = new ConcurrentHashMapObjectObject();
    private ServletContextListener[] servletContextListeners = null;
    private ServletContextAttributeListener[] servletContextAttributeListeners = null;
    private HttpSessionAttributeListener[] httpSessionAttributeListeners = null;
    private HttpSessionListener[] httpSessionListeners = null;
    private ConnectionEventListener[] connectionListeners = null;
    private HashMapObjectObject jspMap = new HashMapObjectObject();
    private HashMapObjectObject servletArgs = new HashMapObjectObject();
    private HashMapObjectObject servletClasses = new HashMapObjectObject();
    private HashMapObjectObject filterClasses = new HashMapObjectObject();
    private HashMapObjectObject filterParams = new HashMapObjectObject();
    private ConcurrentHashMapObjectLong unavailableServlets = new ConcurrentHashMapObjectLong();
    private ConcurrentHashMapObjectLong unavailableJSPs = new ConcurrentHashMapObjectLong();
    private ConcurrentHashMapObjectLong unavailableFilters = new ConcurrentHashMapObjectLong();
    private ClassLoader applicationClassLoader = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebComponents == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebComponents = WebComponents.class$("com.sap.engine.services.servlets_jsp.server.runtime.context.WebComponents")) : class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebComponents));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebComponents;

    public WebComponents(String aliasName, ApplicationContext servletContext, ClassLoader applicationClassLoader) {
        this.aliasName = aliasName;
        this.servletContext = servletContext;
        this.applicationClassLoader = applicationClassLoader;
    }

    void init(WebApplicationConfig webApplicationConfig) {
        int i;
        Object[] keys;
        if (this.servletArgs.size() == 0) {
            this.servletArgs = webApplicationConfig.getServletArguments();
        } else {
            HashMapObjectObject servletArgsTmp = webApplicationConfig.getServletArguments();
            if (servletArgsTmp != null) {
                keys = servletArgsTmp.getAllKeys();
                i = 0;
                while (keys != null && i < keys.length) {
                    this.servletArgs.put(keys[i], servletArgsTmp.get(keys[i]));
                    ++i;
                }
            }
        }
        if (this.servletClasses.size() == 0) {
            this.servletClasses = webApplicationConfig.getServletClasses();
        } else {
            HashMapObjectObject servletClassesTmp = webApplicationConfig.getServletClasses();
            if (servletClassesTmp != null) {
                keys = servletClassesTmp.getAllKeys();
                i = 0;
                while (keys != null && i < keys.length) {
                    this.servletClasses.put(keys[i], servletClassesTmp.get(keys[i]));
                    ++i;
                }
            }
        }
    }

    public Vector addServlet(String servletName, String servletClass, boolean isJsp) {
        this.servletClasses.put((Object)servletName, (Object)servletClass);
        if (isJsp) {
            this.jspServletsNames.add(servletName);
        }
        Vector<LocalizableTextFormatter> warnings = new Vector<LocalizableTextFormatter>();
        Servlet srvlt = null;
        try {
            srvlt = (Servlet)this.applicationClassLoader.loadClass(servletClass).newInstance();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logWarning(this.currentLocation, "Error can't load Servlet " + servletClass, e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_LOAD_SERVLET_ERROR_IS, new Object[]{servletClass, e.toString()}));
        }
        if (srvlt == null) {
            this.addServlet(servletName);
            return warnings;
        }
        Hashtable initParameters = (Hashtable)this.servletArgs.get((Object)servletName);
        ServletConfigImpl sci = new ServletConfigImpl(this.servletContext.getServletContext(), servletName);
        sci.setInitParameters(initParameters);
        try {
            Log.getLocation(3).traceInfo("Initializing a servlet <" + servletClass + "> !", this.aliasName);
            Subject subject = this.servletContext.getSubject(servletName);
            if (subject == null) {
                srvlt.init((ServletConfig)sci);
            } else {
                Subject.doAs(subject, new PrivilegedActionImpl(srvlt, sci));
            }
            this.servlets.put((Object)servletName, (Object)srvlt);
        }
        catch (UnavailableException e) {
            this.setServletUnavailable(servletName, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of servlet <" + servletName + "> failed!", e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.INITIALIZATION_OF_SERVLET_FAILED_PLEASE_CHECK_INIT_METHOD_OF_SERVLET_ERROR_IS, new Object[]{servletName, e.toString()}));
            this.addServlet(servletName);
        }
        catch (PrivilegedActionException ex) {
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of servlet <" + servletName + "> with a run-as identity failed!", ex, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.ERROR_OCCURED_WHILE_SERVLET_IS_INIT_WITH_RUN_AS_IDENTITY_ERROR_IS, new Object[]{servletName, ex.toString()}));
            this.addServlet(servletName);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of servlet <" + servletName + "> failed!", e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.INITIALIZATION_OF_SERVLET_FAILED_PLEASE_CHECK_INIT_METHOD_OF_SERVLET_ERROR_IS, new Object[]{servletName, e.toString()}));
            this.addServlet(servletName);
        }
        return warnings;
    }

    public void addJsp(String name, String isJsp) {
        this.jspMap.put((Object)name, (Object)isJsp);
    }

    public Vector addFilter(String filterName, String filterClassName, HashMapObjectObject params) {
        Class<?> clasFilter = null;
        Filter filter = null;
        Vector<LocalizableTextFormatter> warnings = new Vector<LocalizableTextFormatter>();
        this.filterClasses.put((Object)filterName, (Object)filterClassName);
        this.filterParams.put((Object)filterName, (Object)params);
        try {
            clasFilter = this.applicationClassLoader.loadClass(filterClassName);
            filter = (Filter)clasFilter.newInstance();
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(this.currentLocation, "Can not load filter < " + filterName + " >", e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_LOAD_FILTER, new Object[]{filterName, e.toString()}));
            return warnings;
        }
        try {
            Log.getLocation(3).traceInfo("Initializing a filter <" + filterName + "> !", this.aliasName);
            filter.init((FilterConfig)new FilterConfigImpl(filterName, filter, this.servletContext.getServletContext(), params));
            this.filters.put((Object)filterName, (Object)filter);
        }
        catch (UnavailableException e) {
            this.setFilterUnavailable(filterName, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of filter <" + filterName + "> failed!", e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.INITIALIZATION_OF_FILTER_FAILED_PLEASE_CHECK_INIT_METHOD_OF_FILTER_ERROR_IS, new Object[]{filterName, e.toString()}));
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of filter <" + filterName + "> failed!", e, this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.INITIALIZATION_OF_FILTER_FAILED_PLEASE_CHECK_INIT_METHOD_OF_FILTER_ERROR_IS, new Object[]{filterName, e.toString()}));
        }
        return warnings;
    }

    public Vector addListener(Object obj) {
        Vector<LocalizableTextFormatter> warnings = new Vector<LocalizableTextFormatter>();
        boolean listenerClassFound = false;
        if (obj instanceof ServletContextListener) {
            listenerClassFound = true;
            this.addListener((ServletContextListener)obj);
        }
        if (obj instanceof ServletContextAttributeListener) {
            listenerClassFound = true;
            this.addListener((ServletContextAttributeListener)obj);
        }
        if (obj instanceof HttpSessionAttributeListener) {
            listenerClassFound = true;
            this.addListener((HttpSessionAttributeListener)obj);
        }
        if (obj instanceof HttpSessionListener) {
            listenerClassFound = true;
            this.addListener((HttpSessionListener)obj);
        }
        if (obj instanceof EventListener) {
            Method[] methods = obj.getClass().getMethods();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (method.getName().equals("connectionClosed")) {
                    listenerClassFound = true;
                    this.addListener((EventListener)obj, method);
                    break;
                }
                ++i;
            }
        }
        if (!listenerClassFound) {
            Log.getCategory(1).logWarning(this.currentLocation, "Unknown listener registered " + obj.getClass() + ".", new WebIllegalArgumentException("servlet_jsp_0211", new Object[]{obj.getClass()}), this.aliasName);
            warnings.add(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNSUPPORTED_LISTENER_CLASS, new Object[]{obj.getClass()}));
        }
        return warnings;
    }

    public void addTagLibraryInfo(String uri, TagLibraryInfo tli) {
        this.tagLibDescriptors.put((Object)uri, (Object)tli);
    }

    public void addTagLibraryValidator(String uri, TagLibraryValidator tagLibraryValidator) {
        this.tagLibraryValidators.put((Object)uri, (Object)tagLibraryValidator);
    }

    public Servlet getServlet(String name) throws ServletException, ServletNotFoundException {
        HashMapObjectObject hashMapObjectObject = this.servlets;
        synchronized (hashMapObjectObject) {
            Servlet servlet = null;
            try {
                servlet = (Servlet)this.servlets.get((Object)name);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (servlet != null) {
                Servlet e = servlet;
                return e;
            }
            if (this.unavailableServlets.containsKey((Object)name)) {
                try {
                    long unavailableTime = this.unavailableServlets.get((Object)name) - System.currentTimeMillis();
                    if (unavailableTime > 0L || this.unavailableServlets.get((Object)name) == -1L) {
                        throw new WebUnavailableException("servlet_jsp_0046", (int)(unavailableTime / 1000L), new Object[]{name});
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            String className = (String)this.servletClasses.get((Object)name);
            Hashtable initParameters = (Hashtable)this.servletArgs.get((Object)name);
            if (className == null) {
                throw new ServletNotFoundException(ServletNotFoundException.Requested_resource_not_found, new Object[]{this.aliasName + "/servlet/" + name});
            }
            try {
                servlet = (Servlet)this.applicationClassLoader.loadClass(className).newInstance();
            }
            catch (InstantiationException ie) {
                throw new WebServletException("servlet_jsp_0038", new Object[]{this.aliasName, name}, ie);
            }
            catch (IllegalAccessException ie) {
                throw new WebServletException("servlet_jsp_0038", new Object[]{this.aliasName, name}, ie);
            }
            catch (ClassNotFoundException ie) {
                throw new ServletNotFoundException(ServletNotFoundException.Requested_resource_not_found, new Object[]{this.aliasName + "/servlet/" + name});
            }
            catch (NoClassDefFoundError ie) {
                throw new ServletNotFoundException("servlet_jsp_0287", new Object[]{this.aliasName + "/servlet/" + name});
            }
            ServletConfigImpl sci = new ServletConfigImpl(this.servletContext.getServletContext(), name);
            sci.setInitParameters(initParameters);
            try {
                Log.getLocation(3).traceInfo("Initializing a servlet <" + className + "> !", this.aliasName);
                Subject subject = this.servletContext.getSubject(name);
                if (subject == null) {
                    servlet.init((ServletConfig)sci);
                } else {
                    Subject.doAs(subject, new PrivilegedActionImpl(servlet, sci));
                }
            }
            catch (UnavailableException ue) {
                Log.getCategory(1).logWarning(this.currentLocation, "Can't init Servlet " + name, ue, this.aliasName);
                if (ue.isPermanent()) {
                    this.unavailableServlets.put((Object)name, -1L);
                } else {
                    this.unavailableServlets.put((Object)name, System.currentTimeMillis() + (long)(ue.getUnavailableSeconds() * 1000));
                }
                throw ue;
            }
            catch (PrivilegedActionException ex) {
                Log.getCategory(1).logWarning(this.currentLocation, "Initialization of servlet < " + name + " > with a run-as identity failed!", ex, this.aliasName);
                throw new WebServletException("servlet_jsp_0158", new Object[]{name}, ex);
            }
            this.servlets.put((Object)name, (Object)servlet);
            this.unavailableServlets.remove((Object)name);
            Servlet servlet2 = servlet;
            return servlet2;
        }
    }

    public Servlet getServletByClass(String className) throws ServletException, ServletNotFoundException {
        HashMapObjectObject hashMapObjectObject = this.servletsByClass;
        synchronized (hashMapObjectObject) {
            Servlet servlet = null;
            try {
                servlet = (Servlet)this.servletsByClass.get((Object)className);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (servlet != null) {
                Servlet e = servlet;
                return e;
            }
            if (this.unavailableServlets.containsKey((Object)className)) {
                try {
                    long unavailableTime = this.unavailableServlets.get((Object)className) - System.currentTimeMillis();
                    if (unavailableTime > 0L || this.unavailableServlets.get((Object)className) == -1L) {
                        throw new WebUnavailableException("servlet_jsp_0046", (int)(unavailableTime / 1000L), new Object[]{className});
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            try {
                servlet = (Servlet)this.applicationClassLoader.loadClass(className).newInstance();
            }
            catch (InstantiationException ie) {
                throw new WebServletException("servlet_jsp_0038", new Object[]{this.aliasName, className}, ie);
            }
            catch (IllegalAccessException ie) {
                throw new WebServletException("servlet_jsp_0038", new Object[]{this.aliasName, className}, ie);
            }
            catch (ClassNotFoundException ie) {
                throw new ServletNotFoundException(ServletNotFoundException.Requested_resource_not_found, new Object[]{this.aliasName + "/servlet/" + className});
            }
            catch (NoClassDefFoundError ie) {
                throw new ServletNotFoundException("servlet_jsp_0287", new Object[]{this.aliasName + "/servlet/" + className});
            }
            ServletConfigImpl sci = new ServletConfigImpl(this.servletContext.getServletContext(), className);
            try {
                Log.getLocation(3).traceInfo("Initializing a servlet <" + className + "> !", this.aliasName);
                servlet.init((ServletConfig)sci);
            }
            catch (UnavailableException ue) {
                Log.getCategory(1).logWarning(this.currentLocation, "Can't init Servlet " + className, ue, this.aliasName);
                if (ue.isPermanent()) {
                    this.unavailableServlets.put((Object)className, -1L);
                } else {
                    this.unavailableServlets.put((Object)className, System.currentTimeMillis() + (long)(ue.getUnavailableSeconds() * 1000));
                }
                throw new WebUnavailableException("servlet_jsp_0046", ue.getUnavailableSeconds(), new Object[]{className}, ue);
            }
            this.servletsByClass.put((Object)className, (Object)servlet);
            this.unavailableServlets.remove((Object)className);
            Servlet servlet2 = servlet;
            return servlet2;
        }
    }

    public boolean containsServletByClass(String name) {
        HashMapObjectObject hashMapObjectObject = this.servletsByClass;
        synchronized (hashMapObjectObject) {
            boolean bl = this.servletsByClass.get((Object)name) instanceof Servlet;
            return bl;
        }
    }

    public String getJspFile(String name) {
        return (String)this.jspMap.get((Object)name);
    }

    public Enumeration getJspServletsNames() {
        return this.jspServletsNames.elements();
    }

    public Enumeration getFiltersNames() {
        return this.filters.keys();
    }

    public Enumeration getListenersNames() {
        Vector<String> allListeners = new Vector<String>();
        String name = null;
        int i = 0;
        while (this.servletContextListeners != null && i < this.servletContextListeners.length) {
            name = this.servletContextListeners[i].getClass().toString();
            allListeners.add(name.substring(name.indexOf(" ") + 1));
            ++i;
        }
        int i2 = 0;
        while (this.servletContextAttributeListeners != null && i2 < this.servletContextAttributeListeners.length) {
            name = this.servletContextAttributeListeners[i2].getClass().toString();
            allListeners.add(name.substring(name.indexOf(" ") + 1));
            ++i2;
        }
        int i3 = 0;
        while (this.httpSessionAttributeListeners != null && i3 < this.httpSessionAttributeListeners.length) {
            name = this.httpSessionAttributeListeners[i3].getClass().toString();
            allListeners.add(name.substring(name.indexOf(" ") + 1));
            ++i3;
        }
        int i4 = 0;
        while (this.httpSessionListeners != null && i4 < this.httpSessionListeners.length) {
            name = this.httpSessionListeners[i4].getClass().toString();
            allListeners.add(name.substring(name.indexOf(" ") + 1));
            ++i4;
        }
        int i5 = 0;
        while (this.connectionListeners != null && i5 < this.connectionListeners.length) {
            name = this.connectionListeners[i5].getClass().toString();
            allListeners.add(name.substring(name.indexOf(" ") + 1));
            ++i5;
        }
        return allListeners.elements();
    }

    public HttpJspPage getJSP(String className, String url) {
        HashMapObjectObject hashMapObjectObject = this.jsps;
        synchronized (hashMapObjectObject) {
            Enumeration en;
            HttpJspPage jsp_ = (HttpJspPage)this.jsps.get((Object)className);
            if (jsp_ != null) {
                HttpJspPage httpJspPage = jsp_;
                return httpJspPage;
            }
            try {
                jsp_ = (HttpJspPage)this.applicationClassLoader.loadClass(className).newInstance();
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable a) {
                Log.getCategory(1).logWarning(this.currentLocation, "Can't load the JSP Page " + className, a, this.aliasName);
                HttpJspPage httpJspPage = null;
                return httpJspPage;
            }
            Hashtable initParameters = (Hashtable)this.servletArgs.get((Object)"jsp");
            ServletConfigImpl sci = new ServletConfigImpl(this.servletContext.getServletContext(), className);
            if (url != null && this.servletArgs.get((Object)url) != null) {
                Hashtable ht = (Hashtable)this.servletArgs.get((Object)url);
                en = initParameters.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    ht.put(key, initParameters.get(key));
                }
                sci.setInitParameters(ht);
            } else {
                sci.setInitParameters(initParameters);
            }
            try {
                Log.getLocation(3).traceInfo("Initializing a JSP servlet <" + className + "> !", this.aliasName);
                Subject subject = this.servletContext.getSubject(className);
                if (subject == null) {
                    jsp_.init((ServletConfig)sci);
                } else {
                    Subject.doAs(subject, new PrivilegedActionImpl((Servlet)jsp_, sci));
                }
            }
            catch (PrivilegedActionException pe) {
                Log.getCategory(1).logWarning(this.currentLocation, "Cannot init JSP Page " + className + " while starting with privilaged action.", pe, this.aliasName);
                en = null;
                return en;
            }
            catch (ThreadDeath tde) {
                throw tde;
            }
            catch (OutOfMemoryError o) {
                throw o;
            }
            catch (Throwable a) {
                Log.getCategory(1).logWarning(this.currentLocation, "Can't init JSP Page " + className, a, this.aliasName);
                HttpJspPage httpJspPage = null;
                return httpJspPage;
            }
            this.unavailableJSPs.remove((Object)jsp_);
            this.jsps.put((Object)className, (Object)jsp_);
            HttpJspPage httpJspPage = jsp_;
            return httpJspPage;
        }
    }

    Filter getFilter(String name) {
        HashMapObjectObject hashMapObjectObject = this.filters;
        synchronized (hashMapObjectObject) {
            Filter f = (Filter)this.filters.get((Object)name);
            if (f != null) {
                Filter filter = f;
                return filter;
            }
            try {
                if (this.isUnavailableFilter(name) && this.getUnavailableFilterSeconds(name) > System.currentTimeMillis()) {
                    Filter filter = null;
                    return filter;
                }
            }
            catch (NoSuchElementException ne) {
                // empty catch block
            }
            Filter filter = f = this.reinstantiateFilter(name);
            return filter;
        }
    }

    public TagLibraryInfo getTagLibraryInfo(String uri) {
        return (TagLibraryInfo)this.tagLibDescriptors.get((Object)uri);
    }

    public TagLibraryValidator getTagLibraryValidator(String uri) {
        return (TagLibraryValidator)this.tagLibraryValidators.get((Object)uri);
    }

    public ConcurrentHashMapObjectObject getTagLibDescriptors() {
        return this.tagLibDescriptors;
    }

    public Filter reinstantiateFilter(String name) {
        String filterClass = (String)this.filterClasses.get((Object)name);
        Filter filter = null;
        try {
            Class<?> clasFilter = this.applicationClassLoader.loadClass(filterClass);
            filter = (Filter)clasFilter.newInstance();
            Log.getLocation(3).traceInfo("Initializing a filter <" + filterClass + "> !", this.aliasName);
            filter.init((FilterConfig)new FilterConfigImpl(name, filter, this.servletContext.getServletContext(), (HashMapObjectObject)this.filterParams.get((Object)name)));
        }
        catch (UnavailableException e) {
            this.setFilterUnavailable(name, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of filter <" + name + "> failed!", e, this.aliasName);
            return null;
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logWarning(this.currentLocation, "Initialization of filter <" + name + "> failed!", e, this.aliasName);
            return null;
        }
        this.filters.put((Object)name, (Object)filter);
        this.unavailableFilters.remove((Object)name);
        return filter;
    }

    public Enumeration getServletNames() {
        Vector<String> allServlets = new Vector<String>();
        HashMapObjectObject hashMapObjectObject = this.servlets;
        synchronized (hashMapObjectObject) {
            Enumeration en = this.servlets.keys();
            while (en.hasMoreElements()) {
                String servletName = (String)en.nextElement();
                if (this.jspServletsNames.contains(servletName)) continue;
                allServlets.add(servletName);
            }
        }
        HashMapObjectObject hashMapObjectObject2 = this.servletsByClass;
        synchronized (hashMapObjectObject2) {
            Enumeration en = this.servletsByClass.keys();
            while (en.hasMoreElements()) {
                allServlets.add((String)en.nextElement());
            }
        }
        return allServlets.elements();
    }

    public Enumeration getJspNames() {
        HashMapObjectObject hashMapObjectObject = this.jsps;
        synchronized (hashMapObjectObject) {
            Enumeration enumeration = this.jsps.keys();
            return enumeration;
        }
    }

    public void setServletUnavailable(String name, long time) {
        this.unavailableServlets.put((Object)name, time);
    }

    public void setJspUnavailable(String name, long time) {
        this.unavailableJSPs.put((Object)name, time);
    }

    private void setFilterUnavailable(String name, long time) {
        this.unavailableFilters.put((Object)name, time);
    }

    public boolean isUnavailableServlet(String servletName) {
        return this.unavailableServlets.containsKey((Object)servletName);
    }

    public boolean isUnavailableJsp(String jspName) {
        return this.unavailableJSPs.containsKey((Object)jspName);
    }

    public boolean isUnavailableFilter(String filterName) {
        return this.unavailableFilters.containsKey((Object)filterName);
    }

    public long getUnavailableServletSeconds(String servletName) {
        return this.unavailableServlets.get((Object)servletName);
    }

    public long getUnavailableJspSeconds(String jspName) {
        return this.unavailableJSPs.get((Object)jspName);
    }

    public long getUnavailableFilterSeconds(String filterName) {
        return this.unavailableFilters.get((Object)filterName);
    }

    public void destroyServlets() {
        HashMapObjectObject hashMapObjectObject = this.servlets;
        synchronized (hashMapObjectObject) {
            Object[] keys = this.servlets.getAllKeys();
            int i = 0;
            while (i < keys.length) {
                try {
                    Object o = this.servlets.get(keys[i]);
                    if (o instanceof Servlet) {
                        Servlet s = (Servlet)o;
                        Log.getLocation(3).traceInfo("Destroying a servlet <" + keys[i] + "> !", this.aliasName);
                        Subject subject = this.servletContext.getSubject((String)keys[i]);
                        if (subject == null) {
                            s.destroy();
                        } else {
                            Subject.doAs(subject, new PrivilegedActionImpl(s));
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logWarning(this.currentLocation, "Error while destroing servlet < " + keys[i] + " >", e, this.aliasName);
                }
                ++i;
            }
        }
        HashMapObjectObject hashMapObjectObject2 = this.servletsByClass;
        synchronized (hashMapObjectObject2) {
            Object[] keys = this.servletsByClass.getAllKeys();
            int i = 0;
            while (i < keys.length) {
                try {
                    Object o = this.servletsByClass.get(keys[i]);
                    if (o instanceof Servlet) {
                        Servlet s = (Servlet)o;
                        Log.getLocation(3).traceInfo("Destroying a servlet <" + keys[i] + "> !", this.aliasName);
                        Subject subject = this.servletContext.getSubject((String)keys[i]);
                        if (subject == null) {
                            s.destroy();
                        } else {
                            Subject.doAs(subject, new PrivilegedActionImpl(s));
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logWarning(this.currentLocation, "Error while destroing servlet < " + keys[i] + " >", e, this.aliasName);
                }
                ++i;
            }
        }
    }

    public void destroyJsps() {
        HashMapObjectObject hashMapObjectObject = this.jsps;
        synchronized (hashMapObjectObject) {
            Object[] keys = this.jsps.getAllKeys();
            int i = 0;
            while (i < keys.length) {
                try {
                    HttpJspPage s = (HttpJspPage)this.jsps.get(keys[i]);
                    Log.getLocation(3).traceInfo("Destroying a JSP servlet <" + keys[i] + "> !", this.aliasName);
                    Subject subject = this.servletContext.getSubject((String)keys[i]);
                    if (subject == null) {
                        s.destroy();
                    } else {
                        Subject.doAs(subject, new PrivilegedActionImpl((Servlet)s));
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logWarning(this.currentLocation, "Error while destroing JSP Pages!", e, this.aliasName);
                }
                ++i;
            }
        }
    }

    public void destroyFilters() {
        HashMapObjectObject hashMapObjectObject = this.filters;
        synchronized (hashMapObjectObject) {
            Enumeration en = this.filters.elements();
            while (en.hasMoreElements()) {
                Filter f = (Filter)en.nextElement();
                Log.getLocation(3).traceInfo("Destroying a filter <" + f.getClass().getName() + "> !", this.aliasName);
                f.destroy();
            }
        }
    }

    public void addServlet(String name) {
        HashMapObjectObject hashMapObjectObject = this.servlets;
        synchronized (hashMapObjectObject) {
            this.servlets.put((Object)name, (Object)"");
        }
    }

    public void addServletByClass(String name) {
        HashMapObjectObject hashMapObjectObject = this.servletsByClass;
        synchronized (hashMapObjectObject) {
            this.servletsByClass.put((Object)name, (Object)"");
        }
    }

    boolean containsServlet(String name) {
        HashMapObjectObject hashMapObjectObject = this.servlets;
        synchronized (hashMapObjectObject) {
            boolean bl = this.servlets.containsKey((Object)name);
            return bl;
        }
    }

    boolean containsJsp(String name) {
        HashMapObjectObject hashMapObjectObject = this.jsps;
        synchronized (hashMapObjectObject) {
            boolean bl = this.jsps.containsKey((Object)name);
            return bl;
        }
    }

    public boolean hasTagLibraryValidators() {
        return this.tagLibraryValidators.size() > 0;
    }

    ServletContextListener[] getServletContextListeners() {
        return this.servletContextListeners;
    }

    ServletContextAttributeListener[] getServletContextAttributeListeners() {
        return this.servletContextAttributeListeners;
    }

    HttpSessionListener[] getHttpSessionListeners() {
        return this.httpSessionListeners;
    }

    HttpSessionAttributeListener[] getHttpSessionAttributeListeners() {
        return this.httpSessionAttributeListeners;
    }

    ConnectionEventListener[] getConnectionEventListeners() {
        return this.connectionListeners;
    }

    private void addListener(ServletContextListener servletContextListener) {
        if (this.servletContextListeners == null) {
            this.servletContextListeners = new ServletContextListener[]{servletContextListener};
        } else {
            ServletContextListener[] newListeners = new ServletContextListener[this.servletContextListeners.length + 1];
            System.arraycopy(this.servletContextListeners, 0, newListeners, 0, this.servletContextListeners.length);
            newListeners[this.servletContextListeners.length] = servletContextListener;
            this.servletContextListeners = newListeners;
        }
    }

    private void addListener(ServletContextAttributeListener listener) {
        if (this.servletContextAttributeListeners == null) {
            this.servletContextAttributeListeners = new ServletContextAttributeListener[]{listener};
        } else {
            ServletContextAttributeListener[] newListeners = new ServletContextAttributeListener[this.servletContextAttributeListeners.length + 1];
            System.arraycopy(this.servletContextAttributeListeners, 0, newListeners, 0, this.servletContextAttributeListeners.length);
            newListeners[this.servletContextAttributeListeners.length] = listener;
            this.servletContextAttributeListeners = newListeners;
        }
    }

    private void addListener(HttpSessionAttributeListener listener) {
        if (this.httpSessionAttributeListeners == null) {
            this.httpSessionAttributeListeners = new HttpSessionAttributeListener[]{listener};
        } else {
            HttpSessionAttributeListener[] newListeners = new HttpSessionAttributeListener[this.httpSessionAttributeListeners.length + 1];
            System.arraycopy(this.httpSessionAttributeListeners, 0, newListeners, 0, this.httpSessionAttributeListeners.length);
            newListeners[this.httpSessionAttributeListeners.length] = listener;
            this.httpSessionAttributeListeners = newListeners;
        }
    }

    private void addListener(HttpSessionListener listener) {
        if (this.httpSessionListeners == null) {
            this.httpSessionListeners = new HttpSessionListener[]{listener};
        } else {
            HttpSessionListener[] newListeners = new HttpSessionListener[this.httpSessionListeners.length + 1];
            System.arraycopy(this.httpSessionListeners, 0, newListeners, 0, this.httpSessionListeners.length);
            newListeners[this.httpSessionListeners.length] = listener;
            this.httpSessionListeners = newListeners;
        }
    }

    private void addListener(EventListener listener, Method method) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ConnectionEventListener[]{new ConnectionEventListener(listener, method)};
        } else {
            ConnectionEventListener[] newListeners = new ConnectionEventListener[this.connectionListeners.length + 1];
            System.arraycopy(this.connectionListeners, 0, newListeners, 0, this.connectionListeners.length);
            newListeners[this.connectionListeners.length] = new ConnectionEventListener(listener, method);
            this.connectionListeners = newListeners;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

