/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.lib.CookieUtils;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.protocol.HeaderNames;
import com.sap.engine.services.httpserver.lib.protocol.HeaderValues;
import com.sap.engine.services.httpserver.lib.protocol.Methods;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.InternalOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class ServletOutputStreamImpl
extends ServletOutputStream {
    private HttpServletResponseFacade response;
    private InternalOutputStream internalStream = new InternalOutputStream();
    private byte[] buffer;
    private int bufferCount;
    private int totalCount;
    protected boolean committed;
    private boolean closed;
    protected boolean committedForError = false;
    private int bufferSize = 4096;
    private boolean isError = false;
    protected boolean useChunking = false;
    private boolean setContentLengthInFlush = false;
    private boolean empty = false;
    private boolean markClosed = false;
    private boolean chunkFinished = false;
    private byte[] chunkHeadersBuffer = new byte[10];

    public ServletOutputStreamImpl(HttpServletResponseFacade response) {
        this.response = response;
        this.buffer = new byte[this.bufferSize];
        this.committed = false;
        this.closed = false;
        this.isError = false;
    }

    public void init() {
        if (SBasic.webContainerProperties.chunkResponseEnabled() && !this.isHead()) {
            HttpParameters httpParams = this.response.getHttpParameters();
            if (httpParams != null) {
                this.useChunking = httpParams.getResponse().isPersistentConnection() && httpParams.getRequest().getRequestLine().getHttpMajorVersion() > 0 && httpParams.getRequest().getRequestLine().getHttpMinorVersion() > 0;
            }
        } else {
            this.useChunking = false;
        }
    }

    protected void markClosed() {
        this.response.getHttpParameters().setResponseLength(this.totalCount);
        this.markClosed = true;
    }

    public int setBufferSize(int bufSize) {
        if (this.bufferSize != bufSize) {
            this.bufferSize = bufSize;
            this.buffer = new byte[this.bufferSize];
        }
        return this.bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void write(int i) throws IOException {
        if (this.response.isSentError()) {
            return;
        }
        if (this.closed) {
            throw new WebIOException("servlet_jsp_0024");
        }
        if (this.bufferCount >= this.buffer.length) {
            ((OutputStream)((Object)this)).write(new byte[]{(byte)i});
            return;
        }
        this.buffer[this.bufferCount] = (byte)i;
        ++this.bufferCount;
        ++this.totalCount;
        if (this.bufferCount >= this.buffer.length) {
            this.setContentLengthInFlush = false;
            this.flush();
        }
        if (this.response.getContentLength() > 0 && this.response.getContentLength() <= this.totalCount) {
            this.close();
            return;
        }
    }

    public void write(byte[] abyte0, int i, int j) throws IOException {
        if (this.response.isSentError()) {
            return;
        }
        if (this.closed) {
            throw new WebIOException("servlet_jsp_0024");
        }
        if (j < 0) {
            throw new WebIllegalArgumentException("servlet_jsp_0005");
        }
        if (this.response.getContentLength() > 0 && this.response.getContentLength() < this.totalCount + j) {
            j = this.response.getContentLength() - this.totalCount;
        }
        this.totalCount += j;
        if (j >= this.buffer.length) {
            if (!this.committed) {
                this.insertStatusLine();
                this.committed = true;
                this.committedForError = true;
            }
            this.setContentLengthInFlush = false;
            this.flush();
            if (!this.isHead() && !this.empty) {
                if (this.useChunking) {
                    this.chunkResponse(abyte0, i, j);
                } else {
                    this.internalStream.write(abyte0, i, j);
                }
            }
            this.flush();
        } else {
            if (j >= this.buffer.length - this.bufferCount) {
                this.setContentLengthInFlush = false;
                this.flush();
            }
            System.arraycopy(abyte0, i, this.buffer, this.bufferCount, j);
            this.bufferCount += j;
        }
        if (this.response.getContentLength() > 0 && this.response.getContentLength() <= this.totalCount) {
            this.close();
            return;
        }
    }

    private void insertStatusLine() throws IOException {
        int contLen;
        if (this.response.getHttpParameters().getRequest().getRequestLine().isSimpleRequest()) {
            return;
        }
        this.response.getHttpParameters().getRequest().getBody();
        this.response.headers.putDateHeader(HeaderNames.entity_header_date_);
        if (this.useChunking) {
            this.response.headers.putHeader(HeaderNames.hop_header_transfer_encoding_, HeaderValues.chunked_);
        } else if (!this.response.containsHeader("Content-Length")) {
            this.response.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.close_);
        }
        if (SBasic.webContainerProperties.headerForNoCompression() != null && SBasic.webContainerProperties.headerForNoCompression().length() != 0) {
            this.response.removeHeader(SBasic.webContainerProperties.headerForNoCompression());
        }
        if (SBasic.webContainerProperties.headerForCompression() != null && SBasic.webContainerProperties.headerForCompression().length() != 0) {
            this.response.removeHeader(SBasic.webContainerProperties.headerForCompression());
        }
        if (this.response.headers.containsHeader("Content-Encoding")) {
            this.response.getHttpParameters().setAlertMessage(null);
        } else if (this.response.headers.containsHeader("Transfer-Encoding")) {
            this.response.getHttpParameters().setAlertMessage(null);
        } else {
            byte[] contentType = this.response.headers.getHeader(HeaderNames.entity_header_content_type_);
            if (contentType == null || !ByteArrayUtils.startsWith((byte[])contentType, (byte[])HeaderValues.text_html_)) {
                this.response.getHttpParameters().setAlertMessage(null);
            }
        }
        this.internalStream.write(Constants.HTTP_11);
        if (ResponseCodes.status_code_byte[this.response.status] == null) {
            ResponseCodes.status_code_byte[this.response.status] = (" " + this.response.status).getBytes();
        }
        this.internalStream.write(ResponseCodes.status_code_byte[this.response.status]);
        this.internalStream.write(32);
        if (this.response.statusSrc != null) {
            char[] pic = this.response.statusSrc.toCharArray();
            byte[] pib = new byte[pic.length];
            int i = 0;
            while (i < pib.length) {
                pib[i] = (byte)pic[i];
                ++i;
            }
            this.internalStream.write(pib);
        }
        this.internalStream.write(13);
        this.internalStream.write(10);
        if (this.response.getHttpParameters().getAlertMessage() != null && (contLen = this.response.headers.getIntHeader("Content-Length")) != -1) {
            this.response.setContentLength(contLen + this.response.getHttpParameters().getAlertMessage().length);
        }
        if (this.response.headers.getHeader(HeaderNames.hop_header_connection_) == null && (this.response.getHttpParameters().getRequest().getRequestLine().getHttpMajorVersion() == 0 || this.response.getHttpParameters().getRequest().getRequestLine().getHttpMajorVersion() == 1 && this.response.getHttpParameters().getRequest().getRequestLine().getHttpMinorVersion() == 0)) {
            this.response.headers.putHeader(HeaderNames.hop_header_connection_, HeaderValues.keep_alive_);
        }
        this.response.headers.write((OutputStream)this.internalStream);
        if (this.response.cookies != null) {
            this.internalStream.write(CookieUtils.getAllCookieHeaders((ArrayObject)this.response.cookies));
        }
        this.internalStream.write(13);
        this.internalStream.write(10);
        this.response.getHttpParameters().getResponse().setResponseCode(this.response.status);
    }

    public void flush() throws IOException {
        if (this.isError || this.response.isSentError()) {
            return;
        }
        if (!this.committed && this.markClosed) {
            this.setContentLengthInFlush();
        }
        if (this.setContentLengthInFlush && this.response.getHttpParameters().getResponse().isPersistentConnection()) {
            this.useChunking = false;
            if (this.isHead()) {
                if (!this.response.headers.containsHeader("Content-Length")) {
                    this.response.headers.putIntHeader(HeaderNames.entity_header_content_length_, this.totalCount);
                }
            } else if (this.empty) {
                this.response.headers.putIntHeader(HeaderNames.entity_header_content_length_, 0);
                this.response.headers.removeHeader("Content-Encoding");
            } else {
                this.response.headers.putIntHeader(HeaderNames.entity_header_content_length_, this.totalCount);
            }
            this.setContentLengthInFlush = false;
        }
        if (this.bufferCount <= 0 && this.internalStream.size() <= 0) {
            if (this.bufferCount == 0 && this.internalStream.size() == 0 && !this.committed) {
                this.insertStatusLine();
                this.ensureClientAvailable();
                this.response.getHttpParameters().getResponse().sendResponse(this.internalStream.getMessage(), 0, this.internalStream.size());
                this.committed = true;
                this.internalStream.reset();
                return;
            }
            if (!this.closed || !this.useChunking) {
                return;
            }
        }
        if (!this.committed) {
            this.insertStatusLine();
            this.committed = true;
        }
        if (this.bufferCount > 0 && !this.isHead() && !this.empty) {
            if (this.useChunking) {
                this.chunkResponse();
            } else {
                this.internalStream.write(this.buffer, 0, this.bufferCount);
            }
        }
        if (this.closed && this.useChunking && !this.chunkFinished) {
            this.internalStream.write(Constants.FINAL_CHUNK, 0, Constants.FINAL_CHUNK.length);
            this.chunkFinished = true;
        }
        if (this.internalStream.size() > 0) {
            this.ensureClientAvailable();
            this.response.getHttpParameters().getResponse().sendResponse(this.internalStream.getMessage(), 0, this.internalStream.size());
            this.internalStream.reset();
        }
        this.bufferCount = 0;
    }

    public void setContentLengthInFlush() {
        if (!this.committed) {
            this.setContentLengthInFlush = true;
        }
    }

    public void setEmpty() {
        this.empty = true;
    }

    private void chunkResponse() {
        Ascii.hexIntToAsciiArr((int)this.bufferCount, (InternalOutputStream)this.internalStream, (byte[])this.chunkHeadersBuffer);
        this.internalStream.write(Constants.CRLF);
        this.internalStream.write(this.buffer, 0, this.bufferCount);
        this.internalStream.write(Constants.CRLF);
    }

    private void chunkResponse(byte[] chunk, int i, int j) {
        Ascii.hexIntToAsciiArr((int)j, (InternalOutputStream)this.internalStream, (byte[])this.chunkHeadersBuffer);
        this.internalStream.write(Constants.CRLF);
        this.internalStream.write(chunk, i, j);
        this.internalStream.write(Constants.CRLF);
    }

    public void setConnectionType() {
        String connectionHeader = this.response.getHeader("Connection");
        if (connectionHeader != null && connectionHeader.equalsIgnoreCase("close")) {
            this.response.getHttpParameters().getResponse().setPersistentConnection(false);
        } else if (!this.useChunking && !this.response.containsHeader("Content-Length")) {
            this.response.getHttpParameters().getResponse().setPersistentConnection(false);
        }
    }

    public void reset() {
        this.committed = false;
        this.committedForError = false;
        this.closed = false;
        this.totalCount = 0;
        this.bufferCount = 0;
        this.useChunking = false;
        this.empty = false;
        this.markClosed = false;
        if (this.bufferSize != 4096) {
            this.bufferSize = 4096;
            this.buffer = new byte[4096];
        }
        this.setContentLengthInFlush = false;
        this.chunkFinished = false;
        this.internalStream.reset();
    }

    public void clear() {
        this.closed = false;
        this.totalCount = 0;
        this.bufferCount = 0;
        this.empty = false;
        this.markClosed = false;
        this.chunkFinished = false;
        this.internalStream.reset();
    }

    public void close() throws IOException {
        this.closed = true;
        this.markClosed();
        this.flush();
    }

    public boolean isWritenAnything() {
        return this.bufferCount > 0 || this.committed;
    }

    public void setIsError(boolean is) {
        this.isError = is;
    }

    private boolean isHead() {
        byte[] command = this.response.getHttpParameters().getRequest().getRequestLine().getMethod();
        if (command.length != Methods._HEAD.length) {
            return false;
        }
        int i = 0;
        while (i < Methods._HEAD.length) {
            if (command[i] != Methods._HEAD[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void ensureClientAvailable() throws IOException {
        int clentId = this.response.getHttpParameters().getRequest().getClientId();
        if (clentId != -1 && SBasic.getClosedConectionArray().contains(clentId)) {
            throw new WebIOException("servlet_jsp_0018");
        }
    }
}

