/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.client;

import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIllegalArgumentException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class PrintWriterImpl
extends PrintWriter {
    private static final Location CURRENT_LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$runtime$client$PrintWriterImpl == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$client$PrintWriterImpl = PrintWriterImpl.class$("com.sap.engine.services.servlets_jsp.server.runtime.client.PrintWriterImpl")) : class$com$sap$engine$services$servlets_jsp$server$runtime$client$PrintWriterImpl));
    private static final String ATTEMPT_TO_WRITE_AFTER_STREAM_IS_CLOSED = "Attempt to write after the stream had been closed";
    private static final String ERROR_WHILE_CLOSING_THE_STREAM = "Error while closing the stream";
    private OutputStream outStream = null;
    private String encoding = "ISO-8859-1";
    private int bufferSize = 0;
    private int written = 0;
    private int flushed = 0;
    private boolean closed = false;
    private int contentLength = -1;
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$client$PrintWriterImpl;

    public PrintWriterImpl(OutputStream out, int bufferSize) {
        super(out);
        this.bufferSize = bufferSize;
        this.outStream = out;
        this.initOut();
    }

    private void initOut() {
        OutputStreamWriter outputStreamWriter = null;
        if (this.encoding != null) {
            try {
                outputStreamWriter = new OutputStreamWriter(this.outStream, this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                outputStreamWriter = new OutputStreamWriter(this.outStream);
            }
        } else {
            outputStreamWriter = new OutputStreamWriter(this.outStream);
        }
        this.out = outputStreamWriter;
    }

    public void init(String encoding, int buffSize) {
        this.closed = false;
        this.bufferSize = buffSize;
        if (encoding == null) {
            if (this.encoding != null) {
                this.encoding = encoding;
                this.initOut();
            }
        } else if (!encoding.equals(this.encoding)) {
            this.encoding = encoding;
            this.initOut();
        }
    }

    public void write(int c) {
        if (this.closed) {
            Log.getCategory(2).logWarning(CURRENT_LOCATION, ATTEMPT_TO_WRITE_AFTER_STREAM_IS_CLOSED, null);
            return;
        }
        super.write(c);
        ++this.written;
        this.checkFlush();
        this.checkClose();
    }

    public void write(char[] buf, int off, int len) {
        if (this.closed) {
            Log.getCategory(2).logWarning(CURRENT_LOCATION, ATTEMPT_TO_WRITE_AFTER_STREAM_IS_CLOSED, null);
            return;
        }
        if (len < 0 || len + off > buf.length || off < 0) {
            throw new WebIllegalArgumentException("servlet_jsp_0004");
        }
        if (this.contentLength > 0 && this.contentLength < this.flushed + this.written + len) {
            len = this.contentLength - this.flushed - this.written;
        }
        super.write(buf, off, len);
        this.written += len;
        this.checkFlush();
        this.checkClose();
    }

    public void write(String s, int off, int len) {
        if (this.closed) {
            Log.getCategory(2).logWarning(CURRENT_LOCATION, ATTEMPT_TO_WRITE_AFTER_STREAM_IS_CLOSED, null);
            return;
        }
        if (len < 0 || len + off > s.length() || off < 0) {
            throw new WebIllegalArgumentException("servlet_jsp_0004");
        }
        if (this.contentLength > 0 && this.contentLength < this.flushed + this.written + len) {
            len = this.contentLength - this.flushed - this.written;
        }
        super.write(s, off, len);
        this.written += len;
        this.checkFlush();
        this.checkClose();
    }

    public void println() {
        if (this.closed) {
            Log.getCategory(2).logWarning(CURRENT_LOCATION, ATTEMPT_TO_WRITE_AFTER_STREAM_IS_CLOSED, null);
            return;
        }
        super.println();
        this.written += Constants.lineSeparator.length();
        this.checkFlush();
        this.checkClose();
    }

    public void close() {
        this.flush();
        try {
            this.outStream.close();
        }
        catch (IOException t) {
            Log.getCategory(2).logWarning(CURRENT_LOCATION, ERROR_WHILE_CLOSING_THE_STREAM, null);
        }
        this.closed = true;
    }

    public void flush() {
        if (this.closed) {
            // empty if block
        }
        super.flush();
    }

    public void reset() {
        this.written = 0;
        this.flushed = 0;
        this.contentLength = -1;
        this.initOut();
    }

    public void resetInternal() {
        this.bufferSize = 0;
        this.written = 0;
        this.flushed = 0;
        this.contentLength = -1;
    }

    public boolean isWrittenAnything() {
        return this.written != 0;
    }

    public void setBufferSize(int bufferSize) {
        if (this.bufferSize != bufferSize) {
            this.bufferSize = bufferSize;
        }
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    private void checkFlush() {
        if (this.written >= this.bufferSize) {
            this.flush();
            this.flushed += this.written;
            this.written = 0;
        }
    }

    private void checkClose() {
        if (this.contentLength > 0 && this.contentLength <= this.flushed + this.written) {
            this.close();
            return;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

